# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class VpnClientConnectionHealth(Model):
    """VpnClientConnectionHealth properties.

    Variables are only populated by the server, and will be ignored when
    sending a request.

    :ivar total_ingress_bytes_transferred: Total of the Ingress Bytes
     Transferred in this P2S Vpn connection
    :vartype total_ingress_bytes_transferred: long
    :ivar total_egress_bytes_transferred: Total of the Egress Bytes
     Transferred in this connection
    :vartype total_egress_bytes_transferred: long
    :param vpn_client_connections_count: The total of p2s vpn clients
     connected at this time to this P2SVpnGateway.
    :type vpn_client_connections_count: int
    :param allocated_ip_addresses: List of allocated ip addresses to the
     connected p2s vpn clients.
    :type allocated_ip_addresses: list[str]
    """

    _validation = {
        'total_ingress_bytes_transferred': {'readonly': True},
        'total_egress_bytes_transferred': {'readonly': True},
    }

    _attribute_map = {
        'total_ingress_bytes_transferred': {'key': 'totalIngressBytesTransferred', 'type': 'long'},
        'total_egress_bytes_transferred': {'key': 'totalEgressBytesTransferred', 'type': 'long'},
        'vpn_client_connections_count': {'key': 'vpnClientConnectionsCount', 'type': 'int'},
        'allocated_ip_addresses': {'key': 'allocatedIpAddresses', 'type': '[str]'},
    }

    def __init__(self, **kwargs):
        super(VpnClientConnectionHealth, self).__init__(**kwargs)
        self.total_ingress_bytes_transferred = None
        self.total_egress_bytes_transferred = None
        self.vpn_client_connections_count = kwargs.get('vpn_client_connections_count', None)
        self.allocated_ip_addresses = kwargs.get('allocated_ip_addresses', None)
