# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .artifact_content_properties_definition_py3 import ArtifactContentPropertiesDefinition


class AssemblyProperties(ArtifactContentPropertiesDefinition):
    """The assembly properties definition.

    All required parameters must be populated in order to send to Azure.

    :param created_time: The artifact creation time.
    :type created_time: datetime
    :param changed_time: The artifact changed time.
    :type changed_time: datetime
    :param metadata:
    :type metadata: object
    :param content:
    :type content: object
    :param content_type: The content type.
    :type content_type: str
    :param content_link: The content link.
    :type content_link: ~azure.mgmt.logic.models.ContentLink
    :param assembly_name: Required. The assembly name.
    :type assembly_name: str
    :param assembly_version: The assembly version.
    :type assembly_version: str
    :param assembly_culture: The assembly culture.
    :type assembly_culture: str
    :param assembly_public_key_token: The assembly public key token.
    :type assembly_public_key_token: str
    """

    _validation = {
        'assembly_name': {'required': True},
    }

    _attribute_map = {
        'created_time': {'key': 'createdTime', 'type': 'iso-8601'},
        'changed_time': {'key': 'changedTime', 'type': 'iso-8601'},
        'metadata': {'key': 'metadata', 'type': 'object'},
        'content': {'key': 'content', 'type': 'object'},
        'content_type': {'key': 'contentType', 'type': 'str'},
        'content_link': {'key': 'contentLink', 'type': 'ContentLink'},
        'assembly_name': {'key': 'assemblyName', 'type': 'str'},
        'assembly_version': {'key': 'assemblyVersion', 'type': 'str'},
        'assembly_culture': {'key': 'assemblyCulture', 'type': 'str'},
        'assembly_public_key_token': {'key': 'assemblyPublicKeyToken', 'type': 'str'},
    }

    def __init__(self, *, assembly_name: str, created_time=None, changed_time=None, metadata=None, content=None, content_type: str=None, content_link=None, assembly_version: str=None, assembly_culture: str=None, assembly_public_key_token: str=None, **kwargs) -> None:
        super(AssemblyProperties, self).__init__(created_time=created_time, changed_time=changed_time, metadata=metadata, content=content, content_type=content_type, content_link=content_link, **kwargs)
        self.assembly_name = assembly_name
        self.assembly_version = assembly_version
        self.assembly_culture = assembly_culture
        self.assembly_public_key_token = assembly_public_key_token
