# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class CapabilitiesResult(Model):
    """The Get Capabilities operation response.

    :param versions: The version capability.
    :type versions: dict[str, ~azure.mgmt.hdinsight.models.VersionsCapability]
    :param regions: The virtual machine size compatibilty features.
    :type regions: dict[str, ~azure.mgmt.hdinsight.models.RegionsCapability]
    :param vm_sizes: The virtual machine sizes.
    :type vm_sizes: dict[str, ~azure.mgmt.hdinsight.models.VmSizesCapability]
    :param vm_size_filters: The virtual machine size compatibilty filters.
    :type vm_size_filters:
     list[~azure.mgmt.hdinsight.models.VmSizeCompatibilityFilter]
    :param features: The capabilty features.
    :type features: list[str]
    :param quota: The quota capability.
    :type quota: ~azure.mgmt.hdinsight.models.QuotaCapability
    """

    _attribute_map = {
        'versions': {'key': 'versions', 'type': '{VersionsCapability}'},
        'regions': {'key': 'regions', 'type': '{RegionsCapability}'},
        'vm_sizes': {'key': 'vmSizes', 'type': '{VmSizesCapability}'},
        'vm_size_filters': {'key': 'vmSize_filters', 'type': '[VmSizeCompatibilityFilter]'},
        'features': {'key': 'features', 'type': '[str]'},
        'quota': {'key': 'quota', 'type': 'QuotaCapability'},
    }

    def __init__(self, **kwargs):
        super(CapabilitiesResult, self).__init__(**kwargs)
        self.versions = kwargs.get('versions', None)
        self.regions = kwargs.get('regions', None)
        self.vm_sizes = kwargs.get('vm_sizes', None)
        self.vm_size_filters = kwargs.get('vm_size_filters', None)
        self.features = kwargs.get('features', None)
        self.quota = kwargs.get('quota', None)
