/*
 * Copyright (c) 2002-2015 JGoodies Software GmbH. All Rights Reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 *  o Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 *
 *  o Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 *  o Neither the name of JGoodies Software GmbH nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

package com.jgoodies.binding.binder;

import static com.jgoodies.common.base.Preconditions.checkNotNull;

import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JTextField;



/**
 * Holds an Action that can be bound to buttons and text fields.
 *
 * @author Karsten Lentzsch
 *
 * @since 2.3
 * 
 * @deprecated Replaced by the event handler classes in the
 *    JGoodies Smart Client's Sandbox
 */
@Deprecated
public class ActionBindingBuilderImpl implements ActionBindingBuilder {


    private final Action action;


    // Instance Creation ******************************************************

    /**
     * Creates an ActionBindingBuilderImpl for the given action.
     *
     * @param action   the Action that can be bound to buttons and text fields
     * @throws NullPointerException if {@code action} is {@code null}
     */
    public ActionBindingBuilderImpl(Action action) {
        this.action = checkNotNull(action, "The Action must not be null.");
    }


    // ActionBindingBuilder Implementation ************************************

    @Override
	public void to(AbstractButton button) {
        button.setAction(action);
    }


    @Override
    public void to(JComboBox comboBox) {
        comboBox.setAction(action);
    }


    @Override
	public void to(JTextField textField) {
        textField.setAction(action);
    }



}

