/*
 * Decompiled with CFR 0.152.
 */
package org.cojen.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeSet;
import org.cojen.classfile.Attribute;
import org.cojen.classfile.ConstantPool;
import org.cojen.classfile.FixedLocation;
import org.cojen.classfile.Location;

public class LineNumberTableAttr
extends Attribute {
    private List mEntries = new ArrayList();
    private boolean mClean = false;

    public LineNumberTableAttr(ConstantPool cp) {
        super(cp, "LineNumberTable");
    }

    public LineNumberTableAttr(ConstantPool cp, String name) {
        super(cp, name);
    }

    public LineNumberTableAttr(ConstantPool cp, String name, int length, DataInput din) throws IOException {
        super(cp, name);
        int size = din.readUnsignedShort();
        for (int i = 0; i < size; ++i) {
            int start_pc = din.readUnsignedShort();
            int line_number = din.readUnsignedShort();
            try {
                this.addEntry(new FixedLocation(start_pc), line_number);
                continue;
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
    }

    public int getLineNumber(Location start) {
        this.clean();
        int index = Collections.binarySearch(this.mEntries, new Entry(start, 0));
        if (index < 0 && (index = -index - 2) < 0) {
            return -1;
        }
        return ((Entry)this.mEntries.get((int)index)).mLineNumber;
    }

    public void addEntry(Location start, int line_number) throws IllegalArgumentException {
        if (line_number < 0 || line_number > 65535) {
            throw new IllegalArgumentException("Value for line number out of valid range: " + line_number);
        }
        this.mEntries.add(new Entry(start, line_number));
        this.mClean = false;
    }

    public int getLength() {
        this.clean();
        return 2 + 4 * this.mEntries.size();
    }

    public void writeDataTo(DataOutput dout) throws IOException {
        int size = this.mEntries.size();
        dout.writeShort(size);
        for (int i = 0; i < size; ++i) {
            Entry entry = (Entry)this.mEntries.get(i);
            int start_pc = entry.mStart.getLocation();
            if (start_pc < 0 || start_pc > 65535) {
                throw new IllegalStateException("Value for line number table entry start PC out of valid range: " + start_pc);
            }
            dout.writeShort(start_pc);
            dout.writeShort(entry.mLineNumber);
        }
    }

    private void clean() {
        if (!this.mClean) {
            this.mClean = true;
            TreeSet reduced = new TreeSet();
            int i = this.mEntries.size();
            while (--i >= 0) {
                reduced.add(this.mEntries.get(i));
            }
            this.mEntries = new ArrayList(reduced);
        }
    }

    private static class Entry
    implements Comparable {
        public final Location mStart;
        public final int mLineNumber;

        public Entry(Location start, int line_number) {
            this.mStart = start;
            this.mLineNumber = line_number;
        }

        public int compareTo(Object other) {
            int thatLoc;
            int thisLoc = this.mStart.getLocation();
            if (thisLoc < (thatLoc = ((Entry)other).mStart.getLocation())) {
                return -1;
            }
            if (thisLoc > thatLoc) {
                return 1;
            }
            return 0;
        }

        public boolean equals(Object other) {
            if (other instanceof Entry) {
                return this.mStart.getLocation() == ((Entry)other).mStart.getLocation();
            }
            return false;
        }

        public String toString() {
            return "start_pc=" + this.mStart.getLocation() + " => " + "line_number=" + this.mLineNumber;
        }
    }
}

