; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -instsimplify < %s | FileCheck %s

declare float @llvm.copysign.f32(float, float)
declare double @llvm.copysign.f64(double, double)
declare bfloat @llvm.copysign.bf16(bfloat, bfloat)
declare fp128 @llvm.copysign.f128(fp128, fp128)
declare ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128, ppc_fp128)

define float @f32_01() {
; CHECK-LABEL: @f32_01(
; CHECK-NEXT:    ret float -1.000000e+00
;
  %x = call float @llvm.copysign.f32(float 1.0, float -2.0)
  ret float %x
}

define float @f32_02() {
; CHECK-LABEL: @f32_02(
; CHECK-NEXT:    ret float 2.000000e+00
;
  %x = call float @llvm.copysign.f32(float -2.0, float 1.0)
  ret float %x
}

define float @f32_03() {
; CHECK-LABEL: @f32_03(
; CHECK-NEXT:    ret float -2.000000e+00
;
  %x = call float @llvm.copysign.f32(float -2.0, float -1.0)
  ret float %x
}

define double @f64_01() {
; CHECK-LABEL: @f64_01(
; CHECK-NEXT:    ret double -1.000000e+00
;
  %x = call double @llvm.copysign.f64(double 1.0, double -2.0)
  ret double %x
}

define double @f64_02() {
; CHECK-LABEL: @f64_02(
; CHECK-NEXT:    ret double 1.000000e+00
;
  %x = call double @llvm.copysign.f64(double -1.0, double 2.0)
  ret double %x
}

define double @f64_03() {
; CHECK-LABEL: @f64_03(
; CHECK-NEXT:    ret double -1.000000e+00
;
  %x = call double @llvm.copysign.f64(double -1.0, double -2.0)
  ret double %x
}

define bfloat @bf16_01() {
; CHECK-LABEL: @bf16_01(
; CHECK-NEXT:    ret bfloat 0xRBF80
;
  %x = call bfloat @llvm.copysign.bf16(bfloat 1.0, bfloat -2.0)
  ret bfloat %x
}

define bfloat @bf16_02() {
; CHECK-LABEL: @bf16_02(
; CHECK-NEXT:    ret bfloat 0xR4000
;
  %x = call bfloat @llvm.copysign.bf16(bfloat -2.0, bfloat 1.0)
  ret bfloat %x
}

define bfloat @bf16_03() {
; CHECK-LABEL: @bf16_03(
; CHECK-NEXT:    ret bfloat 0xRC000
;
  %x = call bfloat @llvm.copysign.bf16(bfloat -2.0, bfloat -1.0)
  ret bfloat %x
}

define fp128 @f128_01() {
; CHECK-LABEL: @f128_01(
; CHECK-NEXT:    ret fp128 0xL00000000000000008000000000000001
;
  %x = call fp128 @llvm.copysign.f128(fp128 0xL00000000000000000000000000000001, fp128 0xL00000000000000008000000000000002)
  ret fp128 %x
}

define fp128 @f128_02() {
; CHECK-LABEL: @f128_02(
; CHECK-NEXT:    ret fp128 0xL00000000000000000000000000000003
;
  %x = call fp128 @llvm.copysign.f128(fp128 0xL00000000000000008000000000000003, fp128 0xL00000000000000000000000000000004)
  ret fp128 %x
}

define fp128 @f128_03() {
; CHECK-LABEL: @f128_03(
; CHECK-NEXT:    ret fp128 0xL00000000000000008000000000000005
;
  %x = call fp128 @llvm.copysign.f128(fp128 0xL00000000000000008000000000000005, fp128 0xL00000000000000008000000000000006)
  ret fp128 %x
}

define ppc_fp128 @ppc128_01() {
; CHECK-LABEL: @ppc128_01(
; CHECK-NEXT:    ret ppc_fp128 0xM80000000000000008000000000000001
;
  %x = call ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128 0xM00000000000000000000000000000001, ppc_fp128 0xM80000000000000000000000000000002)
  ret ppc_fp128 %x
}

define ppc_fp128 @ppc128_02() {
; CHECK-LABEL: @ppc128_02(
; CHECK-NEXT:    ret ppc_fp128 0xM00000000000000008000000000000003
;
  %x = call ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128 0xM80000000000000000000000000000003, ppc_fp128 0xM00000000000000000000000000000004)
  ret ppc_fp128 %x
}

define ppc_fp128 @ppc128_03() {
; CHECK-LABEL: @ppc128_03(
; CHECK-NEXT:    ret ppc_fp128 0xM80000000000000000000000000000005
;
  %x = call ppc_fp128 @llvm.copysign.ppcf128(ppc_fp128 0xM80000000000000000000000000000005, ppc_fp128 0xM80000000000000000000000000000006)
  ret ppc_fp128 %x
}
