/* Manager.c generated by valac 0.34.4, the Vala compiler
 * generated from Manager.vala, do not modify */

/*
 * Copyright (C) 2008,2009 Sebastian Pölsterl
 *
 * This file is part of GNOME DVB Daemon.
 *
 * GNOME DVB Daemon is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * GNOME DVB Daemon is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNOME DVB Daemon.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gudev/gudev.h>
#include <gst/rtsp-server/rtsp-server.h>


#define DVB_TYPE_ID_BUS_MANAGER (dvb_id_bus_manager_get_type ())
#define DVB_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManager))
#define DVB_IS_ID_BUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_MANAGER))
#define DVB_ID_BUS_MANAGER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_MANAGER, DVBIDBusManagerIface))

typedef struct _DVBIDBusManager DVBIDBusManager;
typedef struct _DVBIDBusManagerIface DVBIDBusManagerIface;

#define DVB_TYPE_ID_BUS_MANAGER_PROXY (dvb_id_bus_manager_proxy_get_type ())

#define DVB_TYPE_ADAPTER_TYPE (dvb_adapter_type_get_type ())

#define DVB_TYPE_CHANNEL_GROUP_INFO (dvb_channel_group_info_get_type ())
typedef struct _DVBChannelGroupInfo DVBChannelGroupInfo;

#define DVB_TYPE_ADAPTER_INFO (dvb_adapter_info_get_type ())
typedef struct _DVBAdapterInfo DVBAdapterInfo;

#define DVB_TYPE_MANAGER (dvb_manager_get_type ())
#define DVB_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MANAGER, DVBManager))
#define DVB_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MANAGER, DVBManagerClass))
#define DVB_IS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MANAGER))
#define DVB_IS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MANAGER))
#define DVB_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MANAGER, DVBManagerClass))

typedef struct _DVBManager DVBManager;
typedef struct _DVBManagerClass DVBManagerClass;
typedef struct _DVBManagerPrivate DVBManagerPrivate;

#define DVB_MANAGER_TYPE_SCANNER_DATA (dvb_manager_scanner_data_get_type ())
#define DVB_MANAGER_SCANNER_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerData))
#define DVB_MANAGER_SCANNER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerDataClass))
#define DVB_MANAGER_IS_SCANNER_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_MANAGER_TYPE_SCANNER_DATA))
#define DVB_MANAGER_IS_SCANNER_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_MANAGER_TYPE_SCANNER_DATA))
#define DVB_MANAGER_SCANNER_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerDataClass))

typedef struct _DVBManagerScannerData DVBManagerScannerData;
typedef struct _DVBManagerScannerDataClass DVBManagerScannerDataClass;

#define DVB_TYPE_DEVICE_GROUP (dvb_device_group_get_type ())
#define DVB_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup))
#define DVB_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))
#define DVB_IS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE_GROUP))
#define DVB_IS_DEVICE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE_GROUP))
#define DVB_DEVICE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE_GROUP, DVBDeviceGroupClass))

typedef struct _DVBDeviceGroup DVBDeviceGroup;
typedef struct _DVBDeviceGroupClass DVBDeviceGroupClass;

#define DVB_TYPE_DEVICE (dvb_device_get_type ())
#define DVB_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_DEVICE, DVBDevice))
#define DVB_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_DEVICE, DVBDeviceClass))
#define DVB_IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_DEVICE))
#define DVB_IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_DEVICE))
#define DVB_DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_DEVICE, DVBDeviceClass))

typedef struct _DVBDevice DVBDevice;
typedef struct _DVBDeviceClass DVBDeviceClass;

#define DVB_LOGGING_TYPE_LOGGER (dvb_logging_logger_get_type ())
#define DVB_LOGGING_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLogger))
#define DVB_LOGGING_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))
#define DVB_LOGGING_IS_LOGGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_IS_LOGGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOGGER))
#define DVB_LOGGING_LOGGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOGGER, DVBLoggingLoggerClass))

typedef struct _DVBLoggingLogger DVBLoggingLogger;
typedef struct _DVBLoggingLoggerClass DVBLoggingLoggerClass;

#define DVB_LOGGING_TYPE_LOG_MANAGER (dvb_logging_log_manager_get_type ())
#define DVB_LOGGING_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManager))
#define DVB_LOGGING_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))
#define DVB_LOGGING_IS_LOG_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_IS_LOG_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_LOGGING_TYPE_LOG_MANAGER))
#define DVB_LOGGING_LOG_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_LOGGING_TYPE_LOG_MANAGER, DVBLoggingLogManagerClass))

typedef struct _DVBLoggingLogManager DVBLoggingLogManager;
typedef struct _DVBLoggingLogManagerClass DVBLoggingLogManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _DVBManagerScannerDataPrivate DVBManagerScannerDataPrivate;

#define DVB_TYPE_SCANNER (dvb_scanner_get_type ())
#define DVB_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_SCANNER, DVBScanner))
#define DVB_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_SCANNER, DVBScannerClass))
#define DVB_IS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_SCANNER))
#define DVB_IS_SCANNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_SCANNER))
#define DVB_SCANNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_SCANNER, DVBScannerClass))

typedef struct _DVBScanner DVBScanner;
typedef struct _DVBScannerClass DVBScannerClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define DVB_TYPE_ID_BUS_SCANNER (dvb_id_bus_scanner_get_type ())
#define DVB_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner))
#define DVB_IS_ID_BUS_SCANNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_SCANNER))
#define DVB_ID_BUS_SCANNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScannerIface))

typedef struct _DVBIDBusScanner DVBIDBusScanner;
typedef struct _DVBIDBusScannerIface DVBIDBusScannerIface;

#define DVB_TYPE_ID_BUS_SCANNER_PROXY (dvb_id_bus_scanner_proxy_get_type ())

#define DVB_TYPE_FACTORY (dvb_factory_get_type ())
#define DVB_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_FACTORY, DVBFactory))
#define DVB_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_FACTORY, DVBFactoryClass))
#define DVB_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_FACTORY))
#define DVB_IS_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_FACTORY))
#define DVB_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_FACTORY, DVBFactoryClass))

typedef struct _DVBFactory DVBFactory;
typedef struct _DVBFactoryClass DVBFactoryClass;

#define DVB_DATABASE_TYPE_CONFIG_STORE (dvb_database_config_store_get_type ())
#define DVB_DATABASE_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStore))
#define DVB_DATABASE_IS_CONFIG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE))
#define DVB_DATABASE_CONFIG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_CONFIG_STORE, DVBdatabaseConfigStoreIface))

typedef struct _DVBdatabaseConfigStore DVBdatabaseConfigStore;
typedef struct _DVBdatabaseConfigStoreIface DVBdatabaseConfigStoreIface;

#define DVB_TYPE_CHANNEL_GROUP (dvb_channel_group_get_type ())
#define DVB_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroup))
#define DVB_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))
#define DVB_IS_CHANNEL_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_GROUP))
#define DVB_IS_CHANNEL_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_GROUP))
#define DVB_CHANNEL_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_GROUP, DVBChannelGroupClass))

typedef struct _DVBChannelGroup DVBChannelGroup;
typedef struct _DVBChannelGroupClass DVBChannelGroupClass;

#define DVB_TYPE_CHANNEL (dvb_channel_get_type ())
#define DVB_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL, DVBChannel))
#define DVB_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL, DVBChannelClass))
#define DVB_IS_CHANNEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL))
#define DVB_IS_CHANNEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL))
#define DVB_CHANNEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL, DVBChannelClass))

typedef struct _DVBChannel DVBChannel;
typedef struct _DVBChannelClass DVBChannelClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define DVB_TYPE_ID_BUS_DEVICE_GROUP (dvb_id_bus_device_group_get_type ())
#define DVB_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroup))
#define DVB_IS_ID_BUS_DEVICE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP))
#define DVB_ID_BUS_DEVICE_GROUP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_TYPE_ID_BUS_DEVICE_GROUP, DVBIDBusDeviceGroupIface))

typedef struct _DVBIDBusDeviceGroup DVBIDBusDeviceGroup;
typedef struct _DVBIDBusDeviceGroupIface DVBIDBusDeviceGroupIface;

#define DVB_TYPE_ID_BUS_DEVICE_GROUP_PROXY (dvb_id_bus_device_group_proxy_get_type ())
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define DVB_TYPE_CHANNEL_LIST (dvb_channel_list_get_type ())
#define DVB_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelList))
#define DVB_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))
#define DVB_IS_CHANNEL_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_CHANNEL_LIST))
#define DVB_IS_CHANNEL_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_CHANNEL_LIST))
#define DVB_CHANNEL_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_CHANNEL_LIST, DVBChannelListClass))

typedef struct _DVBChannelList DVBChannelList;
typedef struct _DVBChannelListClass DVBChannelListClass;

#define DVB_DATABASE_TYPE_TIMERS_STORE (dvb_database_timers_store_get_type ())
#define DVB_DATABASE_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStore))
#define DVB_DATABASE_IS_TIMERS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE))
#define DVB_DATABASE_TIMERS_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_TIMERS_STORE, DVBdatabaseTimersStoreIface))

typedef struct _DVBdatabaseTimersStore DVBdatabaseTimersStore;
typedef struct _DVBdatabaseTimersStoreIface DVBdatabaseTimersStoreIface;

#define DVB_TYPE_TIMER (dvb_timer_get_type ())
#define DVB_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_TIMER, DVBTimer))
#define DVB_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_TIMER, DVBTimerClass))
#define DVB_IS_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_TIMER))
#define DVB_IS_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_TIMER))
#define DVB_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_TIMER, DVBTimerClass))

typedef struct _DVBTimer DVBTimer;
typedef struct _DVBTimerClass DVBTimerClass;

#define DVB_TYPE_RECORDER (dvb_recorder_get_type ())
#define DVB_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDER, DVBRecorder))
#define DVB_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDER, DVBRecorderClass))
#define DVB_IS_RECORDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDER))
#define DVB_IS_RECORDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDER))
#define DVB_RECORDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDER, DVBRecorderClass))

typedef struct _DVBRecorder DVBRecorder;
typedef struct _DVBRecorderClass DVBRecorderClass;

#define DVB_TYPE_RECORDINGS_STORE (dvb_recordings_store_get_type ())
#define DVB_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStore))
#define DVB_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))
#define DVB_IS_RECORDINGS_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_RECORDINGS_STORE))
#define DVB_IS_RECORDINGS_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_RECORDINGS_STORE))
#define DVB_RECORDINGS_STORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_RECORDINGS_STORE, DVBRecordingsStoreClass))

typedef struct _DVBRecordingsStore DVBRecordingsStore;
typedef struct _DVBRecordingsStoreClass DVBRecordingsStoreClass;

#define DVB_TYPE_MEDIA_FACTORY (dvb_media_factory_get_type ())
#define DVB_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactory))
#define DVB_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))
#define DVB_IS_MEDIA_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_MEDIA_FACTORY))
#define DVB_IS_MEDIA_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_MEDIA_FACTORY))
#define DVB_MEDIA_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_MEDIA_FACTORY, DVBMediaFactoryClass))

typedef struct _DVBMediaFactory DVBMediaFactory;
typedef struct _DVBMediaFactoryClass DVBMediaFactoryClass;

#define DVB_DATABASE_TYPE_EPG_STORE (dvb_database_epg_store_get_type ())
#define DVB_DATABASE_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStore))
#define DVB_DATABASE_IS_EPG_STORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_DATABASE_TYPE_EPG_STORE))
#define DVB_DATABASE_EPG_STORE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), DVB_DATABASE_TYPE_EPG_STORE, DVBdatabaseEPGStoreIface))

typedef struct _DVBdatabaseEPGStore DVBdatabaseEPGStore;
typedef struct _DVBdatabaseEPGStoreIface DVBdatabaseEPGStoreIface;

#define DVB_TYPE_EVENT (dvb_event_get_type ())
#define DVB_EVENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), DVB_TYPE_EVENT, DVBEvent))
#define DVB_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), DVB_TYPE_EVENT, DVBEventClass))
#define DVB_IS_EVENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), DVB_TYPE_EVENT))
#define DVB_IS_EVENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), DVB_TYPE_EVENT))
#define DVB_EVENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), DVB_TYPE_EVENT, DVBEventClass))

typedef struct _DVBEvent DVBEvent;
typedef struct _DVBEventClass DVBEventClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))

typedef enum  {
	DVB_ADAPTER_TYPE_UNKNOWN,
	DVB_ADAPTER_TYPE_TERRESTRIAL,
	DVB_ADAPTER_TYPE_SATELLITE,
	DVB_ADAPTER_TYPE_CABLE
} DVBAdapterType;

struct _DVBChannelGroupInfo {
	gint id;
	gchar* name;
};

struct _DVBAdapterInfo {
	gchar* name;
	gboolean type_t;
	gboolean type_s;
	gboolean type_c;
};

struct _DVBIDBusManagerIface {
	GTypeInterface parent_iface;
	gboolean (*GetScannerForDevice) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
	char** (*GetRegisteredDeviceGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetDeviceGroup) (DVBIDBusManager* self, guint group_id, char** opath, GError** error);
	gboolean (*AddDeviceToNewGroup) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
	gboolean (*GetNameOfRegisteredDevice) (DVBIDBusManager* self, guint adapter, guint frontend, gchar** name, GError** error);
	gint (*GetDeviceGroupSize) (DVBIDBusManager* self, GError** error);
	DVBChannelGroupInfo* (*GetChannelGroups) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*AddChannelGroup) (DVBIDBusManager* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*RemoveChannelGroup) (DVBIDBusManager* self, gint channel_group_id, GError** error);
	GHashTable** (*GetDevices) (DVBIDBusManager* self, int* result_length1, GError** error);
	gboolean (*GetAdapterInfo) (DVBIDBusManager* self, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
};

struct _DVBManager {
	GObject parent_instance;
	DVBManagerPrivate * priv;
};

struct _DVBManagerClass {
	GObjectClass parent_class;
};

struct _DVBManagerPrivate {
	GeeHashMap* scanners;
	GRecMutex __lock_scanners;
	GeeHashMap* groups;
	GRecMutex __lock_groups;
	GeeArrayList* devices;
	GRecMutex __lock_devices;
	guint device_group_counter;
	GUdevClient* udev_client;
};

struct _DVBManagerScannerData {
	GObject parent_instance;
	DVBManagerScannerDataPrivate * priv;
	DVBScanner* scanner;
	gulong signal_id;
};

struct _DVBManagerScannerDataClass {
	GObjectClass parent_class;
};

struct _DVBIDBusScannerIface {
	GTypeInterface parent_iface;
	void (*Run) (DVBIDBusScanner* self, GError** error);
	void (*Destroy) (DVBIDBusScanner* self, GError** error);
	gboolean (*WriteAllChannelsToFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
	gboolean (*WriteChannelsToFile) (DVBIDBusScanner* self, guint* channel_sids, int channel_sids_length1, const gchar* path, GError** error);
	gboolean (*AddScanningData) (DVBIDBusScanner* self, GHashTable* data, GError** error);
	gboolean (*AddScanningDataFromFile) (DVBIDBusScanner* self, const gchar* path, GError** error);
};

typedef enum  {
	DVB_DATABASE_SQL_ERROR_ERROR,
	DVB_DATABASE_SQL_ERROR_INTERNAL,
	DVB_DATABASE_SQL_ERROR_PERM,
	DVB_DATABASE_SQL_ERROR_ABORT,
	DVB_DATABASE_SQL_ERROR_BUSY,
	DVB_DATABASE_SQL_ERROR_LOCKED,
	DVB_DATABASE_SQL_ERROR_NOMEM,
	DVB_DATABASE_SQL_ERROR_READONLY,
	DVB_DATABASE_SQL_ERROR_INTERRUPT,
	DVB_DATABASE_SQL_ERROR_IOERR,
	DVB_DATABASE_SQL_ERROR_CORRUPT,
	DVB_DATABASE_SQL_ERROR_NOTFOUND,
	DVB_DATABASE_SQL_ERROR_FULL,
	DVB_DATABASE_SQL_ERROR_CANTOPEN,
	DVB_DATABASE_SQL_ERROR_PROTOCOL,
	DVB_DATABASE_SQL_ERROR_EMPTY,
	DVB_DATABASE_SQL_ERROR_SCHEMA,
	DVB_DATABASE_SQL_ERROR_TOOBIG,
	DVB_DATABASE_SQL_ERROR_CONSTRAINT,
	DVB_DATABASE_SQL_ERROR_MISMATCH,
	DVB_DATABASE_SQL_ERROR_MISUSE,
	DVB_DATABASE_SQL_ERROR_NOLFS,
	DVB_DATABASE_SQL_ERROR_AUTH,
	DVB_DATABASE_SQL_ERROR_FORMAT,
	DVB_DATABASE_SQL_ERROR_RANGE,
	DVB_DATABASE_SQL_ERROR_NOTADB
} DVBdatabaseSqlError;
#define DVB_DATABASE_SQL_ERROR dvb_database_sql_error_quark ()
struct _DVBdatabaseConfigStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_device_groups) (DVBdatabaseConfigStore* self, GError** error);
	DVBDeviceGroup* (*get_device_group) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_last_device) (DVBdatabaseConfigStore* self, guint group_id, GError** error);
	gboolean (*is_group_member) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* group, GError** error);
	gboolean (*add_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
	gboolean (*remove_device_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*add_device_to_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*remove_device_from_group) (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*update_from_group) (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
	gboolean (*get_parent_groups) (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint** group_ids, int* group_ids_length1, GError** error);
	gboolean (*add_channel_group) (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
	gboolean (*remove_channel_group) (DVBdatabaseConfigStore* self, gint group_id, GError** error);
	GeeList* (*get_channel_groups) (DVBdatabaseConfigStore* self, GError** error);
	GeeList* (*get_channels_of_group) (DVBdatabaseConfigStore* self, guint dev_group_id, gint channel_group_id, GError** error);
	gboolean (*add_channel_to_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
	gboolean (*remove_channel_from_group) (DVBdatabaseConfigStore* self, DVBChannel* channel, gint group_id, GError** error);
};

struct _DVBIDBusDeviceGroupIface {
	GTypeInterface parent_iface;
	DVBAdapterType (*GetType) (DVBIDBusDeviceGroup* self, GError** error);
	char* (*GetRecorder) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*AddDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	gboolean (*RemoveDevice) (DVBIDBusDeviceGroup* self, guint adapter, guint frontend, GError** error);
	char* (*GetChannelList) (DVBIDBusDeviceGroup* self, GError** error);
	gchar* (*GetName) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetName) (DVBIDBusDeviceGroup* self, const gchar* name, GError** error);
	gchar** (*GetMembers) (DVBIDBusDeviceGroup* self, int* result_length1, GError** error);
	gboolean (*GetSchedule) (DVBIDBusDeviceGroup* self, guint channel_sid, char** opath, GError** error);
	gchar* (*GetRecordingsDirectory) (DVBIDBusDeviceGroup* self, GError** error);
	gboolean (*SetRecordingsDirectory) (DVBIDBusDeviceGroup* self, const gchar* location, GError** error);
};

struct _DVBdatabaseTimersStoreIface {
	GTypeInterface parent_iface;
	GeeList* (*get_all_timers_of_device_group) (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
	gboolean (*add_timer_to_device_group) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_timer_from_device_group) (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
	gboolean (*remove_all_timers_from_device_group) (DVBdatabaseTimersStore* self, guint group_id, GError** error);
	gboolean (*update_timer) (DVBdatabaseTimersStore* self, DVBTimer* timer, DVBDeviceGroup* dev, GError** error);
};

struct _DVBdatabaseEPGStoreIface {
	GTypeInterface parent_iface;
	gboolean (*add_or_update_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	DVBEvent* (*get_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_event) (DVBdatabaseEPGStore* self, guint event_id, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_older_than) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	gboolean (*contains_event) (DVBdatabaseEPGStore* self, DVBEvent* event, guint channel_sid, guint group_id, GError** error);
	GeeList* (*get_events) (DVBdatabaseEPGStore* self, guint channel_sid, guint group_id, GError** error);
	gboolean (*remove_events_of_group) (DVBdatabaseEPGStore* self, guint group_id, GError** error);
};


static gpointer dvb_manager_parent_class = NULL;
static DVBLoggingLogger* dvb_manager_log;
static DVBLoggingLogger* dvb_manager_log = NULL;
static DVBManager* dvb_manager_instance;
static DVBManager* dvb_manager_instance = NULL;
static GRecMutex dvb_manager_instance_mutex;
static GRecMutex dvb_manager_instance_mutex = {0};
extern GDBusConnection* main_conn;
extern GstRTSPServer* dvb_rtsp_server_server;
static gpointer dvb_manager_scanner_data_parent_class = NULL;
static DVBIDBusManagerIface* dvb_manager_dvb_id_bus_manager_parent_iface = NULL;

GType dvb_id_bus_manager_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_manager_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_adapter_type_get_type (void) G_GNUC_CONST;
GType dvb_channel_group_info_get_type (void) G_GNUC_CONST;
DVBChannelGroupInfo* dvb_channel_group_info_dup (const DVBChannelGroupInfo* self);
void dvb_channel_group_info_free (DVBChannelGroupInfo* self);
void dvb_channel_group_info_copy (const DVBChannelGroupInfo* self, DVBChannelGroupInfo* dest);
void dvb_channel_group_info_destroy (DVBChannelGroupInfo* self);
GType dvb_adapter_info_get_type (void) G_GNUC_CONST;
DVBAdapterInfo* dvb_adapter_info_dup (const DVBAdapterInfo* self);
void dvb_adapter_info_free (DVBAdapterInfo* self);
void dvb_adapter_info_copy (const DVBAdapterInfo* self, DVBAdapterInfo* dest);
void dvb_adapter_info_destroy (DVBAdapterInfo* self);
GType dvb_id_bus_manager_get_type (void) G_GNUC_CONST;
GType dvb_manager_get_type (void) G_GNUC_CONST;
static GType dvb_manager_scanner_data_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
GType dvb_device_group_get_type (void) G_GNUC_CONST;
GType dvb_device_get_type (void) G_GNUC_CONST;
#define DVB_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), DVB_TYPE_MANAGER, DVBManagerPrivate))
enum  {
	DVB_MANAGER_DUMMY_PROPERTY,
	DVB_MANAGER_DEVICE_GROUPS,
	DVB_MANAGER_DEVS
};
GType dvb_logging_logger_get_type (void) G_GNUC_CONST;
GType dvb_logging_log_manager_get_type (void) G_GNUC_CONST;
DVBLoggingLogManager* dvb_logging_log_manager_getLogManager (void);
DVBLoggingLogger* dvb_logging_log_manager_getDefaultLogger (DVBLoggingLogManager* self);
DVBManager* dvb_manager_get_instance (void);
DVBManager* dvb_manager_new (void);
DVBManager* dvb_manager_construct (GType object_type);
void dvb_manager_shutdown (void);
void dvb_logging_logger_debug (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_scanner_get_type (void) G_GNUC_CONST;
void dvb_scanner_do_destroy (DVBScanner* self);
void dvb_device_group_destroy (DVBDeviceGroup* self);
static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error);
#define DVB_CONSTANTS_DBUS_SCANNER_PATH "/org/gnome/DVB/Scanner/%d/%d"
DVBDevice* dvb_manager_get_device (DVBManager* self, guint adapter, guint frontend);
static DVBDeviceGroup** dvb_manager_get_device_groups_of_device (DVBManager* self, DVBDevice* device, int* result_length1);
void dvb_device_group_stop_epg_scanner (DVBDeviceGroup* self);
static DVBManagerScannerData* dvb_manager_scanner_data_new (void);
static DVBManagerScannerData* dvb_manager_scanner_data_construct (GType object_type);
DVBScanner* dvb_scanner_new (DVBDevice* device, DVBAdapterType type);
DVBScanner* dvb_scanner_construct (GType object_type, DVBDevice* device, DVBAdapterType type);
void dvb_utils_dbus_register_object (GType t_type, GBoxedCopyFunc t_dup_func, GDestroyNotify t_destroy_func, GDBusConnection* conn, const gchar* object_path, gconstpointer obj);
GType dvb_id_bus_scanner_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_scanner_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_scanner_get_type (void) G_GNUC_CONST;
static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner);
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self);
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error);
#define DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH "/org/gnome/DVB/DeviceGroup/%u"
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error);
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error);
gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device, DVBAdapterType type);
DVBDeviceGroup* dvb_device_group_new (guint id, GFile* channels_conf, GFile* recordings_dir, DVBAdapterType type, gboolean with_epg_scanner);
DVBDeviceGroup* dvb_device_group_construct (GType object_type, guint id, GFile* channels_conf, GFile* recordings_dir, DVBAdapterType type, gboolean with_epg_scanner);
void dvb_device_group_set_Name (DVBDeviceGroup* self, const gchar* value);
gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup, gboolean store);
gboolean dvb_device_group_add (DVBDeviceGroup* self, DVBDevice* device);
DVBFactory* dvb_factory_new (void);
DVBFactory* dvb_factory_construct (GType object_type);
GType dvb_factory_get_type (void) G_GNUC_CONST;
GQuark dvb_database_sql_error_quark (void);
GType dvb_channel_group_get_type (void) G_GNUC_CONST;
GType dvb_channel_get_type (void) G_GNUC_CONST;
GType dvb_database_config_store_get_type (void) G_GNUC_CONST;
DVBdatabaseConfigStore* dvb_factory_get_config_store (DVBFactory* self);
gboolean dvb_database_config_store_add_device_to_group (DVBdatabaseConfigStore* self, DVBDevice* dev, DVBDeviceGroup* devgroup, GError** error);
void dvb_logging_logger_error (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_id_bus_device_group_proxy_get_type (void) G_GNUC_CONST;
guint dvb_id_bus_device_group_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType dvb_id_bus_device_group_get_type (void) G_GNUC_CONST;
void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group);
void dvb_device_group_start_epg_scanner (DVBDeviceGroup* self);
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error);
const gchar* dvb_device_get_Name (DVBDevice* self);
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error);
static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error);
GeeList* dvb_database_config_store_get_channel_groups (DVBdatabaseConfigStore* self, GError** error);
gint dvb_channel_group_get_id (DVBChannelGroup* self);
const gchar* dvb_channel_group_get_name (DVBChannelGroup* self);
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length);
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error);
gboolean dvb_database_config_store_add_channel_group (DVBdatabaseConfigStore* self, const gchar* name, gint* channel_group_id, GError** error);
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error);
gboolean dvb_database_config_store_remove_channel_group (DVBdatabaseConfigStore* self, gint group_id, GError** error);
static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error);
guint dvb_device_get_Adapter (DVBDevice* self);
guint dvb_device_get_Frontend (DVBDevice* self);
static gboolean dvb_manager_real_GetAdapterInfo (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error);
gboolean dvb_device_isTerrestrial (DVBDevice* self);
gboolean dvb_device_isSatellite (DVBDevice* self);
gboolean dvb_device_isCable (DVBDevice* self);
guint dvb_device_group_get_Id (DVBDeviceGroup* self);
gint dvb_device_group_get_size (DVBDeviceGroup* self);
DVBAdapterType dvb_device_group_get_Type (DVBDeviceGroup* self);
void dvb_logging_logger_warning (DVBLoggingLogger* self, const gchar* format, ...);
gboolean dvb_database_config_store_add_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* dev_group, GError** error);
static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend);
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self);
gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group, gboolean store);
void dvb_logging_logger_info (DVBLoggingLogger* self, const gchar* format, ...);
GType dvb_channel_list_get_type (void) G_GNUC_CONST;
DVBChannelList* dvb_device_group_get_Channels (DVBDeviceGroup* self);
void dvb_channel_list_load (DVBChannelList* self, DVBAdapterType type, GError** error);
void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group);
GType dvb_timer_get_type (void) G_GNUC_CONST;
GType dvb_database_timers_store_get_type (void) G_GNUC_CONST;
DVBdatabaseTimersStore* dvb_factory_get_timers_store (DVBFactory* self);
GeeList* dvb_database_timers_store_get_all_timers_of_device_group (DVBdatabaseTimersStore* self, DVBDeviceGroup* dev, GError** error);
GType dvb_recorder_get_type (void) G_GNUC_CONST;
DVBRecorder* dvb_device_group_get_recorder (DVBDeviceGroup* self);
guint32 dvb_timer_get_Id (DVBTimer* self);
gboolean dvb_recorder_add_timer (DVBRecorder* self, DVBTimer* new_timer, guint32* timer_id);
gboolean dvb_database_timers_store_remove_timer_from_device_group (DVBdatabaseTimersStore* self, guint timer_id, DVBDeviceGroup* dev, GError** error);
GType dvb_recordings_store_get_type (void) G_GNUC_CONST;
DVBRecordingsStore* dvb_recordings_store_get_instance (void);
void dvb_recordings_store_update_last_id (DVBRecordingsStore* self, guint32 new_last_id);
GType dvb_media_factory_get_type (void) G_GNUC_CONST;
DVBMediaFactory* dvb_media_factory_new (void);
DVBMediaFactory* dvb_media_factory_construct (GType object_type);
guint dvb_channel_get_Sid (DVBChannel* self);
DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id);
gboolean dvb_device_group_contains (DVBDeviceGroup* self, DVBDevice* device);
DVBDevice* dvb_scanner_get_Device (DVBScanner* self);
gboolean dvb_database_config_store_is_last_device (DVBdatabaseConfigStore* self, guint group_id, GError** error);
gboolean dvb_database_config_store_remove_device_group (DVBdatabaseConfigStore* self, DVBDeviceGroup* devgroup, GError** error);
gpointer dvb_event_ref (gpointer instance);
void dvb_event_unref (gpointer instance);
GParamSpec* dvb_param_spec_event (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void dvb_value_set_event (GValue* value, gpointer v_object);
void dvb_value_take_event (GValue* value, gpointer v_object);
gpointer dvb_value_get_event (const GValue* value);
GType dvb_event_get_type (void) G_GNUC_CONST;
GType dvb_database_epg_store_get_type (void) G_GNUC_CONST;
DVBdatabaseEPGStore* dvb_factory_get_epg_store (DVBFactory* self);
gboolean dvb_database_epg_store_remove_events_of_group (DVBdatabaseEPGStore* self, guint group_id, GError** error);
gboolean dvb_database_timers_store_remove_all_timers_from_device_group (DVBdatabaseTimersStore* self, guint group_id, GError** error);
static DVBDeviceGroup* dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id);
DVBDeviceGroup* dvb_database_config_store_get_device_group (DVBdatabaseConfigStore* self, guint group_id, GError** error);
static void dvb_manager_first_add_device (DVBManager* self, GUdevDevice* device);
DVBDevice* dvb_device_new_with_udev (GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend);
DVBDevice* dvb_device_construct_with_udev (GType object_type, GUdevDevice* device, const gchar* dev_file, guint adapter, guint frontend);
static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device);
gboolean dvb_database_config_store_get_parent_groups (DVBdatabaseConfigStore* self, guint adapter, guint frontend, guint** group_ids, int* group_ids_length1, GError** error);
gboolean dvb_device_group_remove (DVBDeviceGroup* self, DVBDevice* device);
GeeCollection* dvb_manager_get_device_groups (DVBManager* self);
GeeArrayList* dvb_manager_get_devs (DVBManager* self);
static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
enum  {
	DVB_MANAGER_SCANNER_DATA_DUMMY_PROPERTY
};
static void dvb_manager_scanner_data_finalize (GObject* obj);
static void dvb_manager_finalize (GObject* obj);
static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* DVB_MANAGER_UDEV_SUBSYSTEMS[2] = {"dvb", NULL};

DVBManager* dvb_manager_get_instance (void) {
	DVBManager* result = NULL;
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp2_ = NULL;
	g_rec_mutex_lock (&dvb_manager_instance_mutex);
	_tmp0_ = dvb_manager_instance;
	if (_tmp0_ == NULL) {
		DVBManager* _tmp1_ = NULL;
		_tmp1_ = dvb_manager_new ();
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = _tmp1_;
	}
	g_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_tmp2_ = dvb_manager_instance;
	result = _tmp2_;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void dvb_manager_shutdown (void) {
	DVBManager* m = NULL;
	DVBManager* _tmp0_ = NULL;
	DVBManager* _tmp1_ = NULL;
	DVBManager* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_rec_mutex_lock (&dvb_manager_instance_mutex);
	_tmp0_ = dvb_manager_instance;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	m = _tmp1_;
	_tmp2_ = dvb_manager_instance;
	if (_tmp2_ != NULL) {
		DVBManager* _tmp3_ = NULL;
		_tmp3_ = m;
		_g_object_unref0 (_tmp3_->priv->udev_client);
		_tmp3_->priv->udev_client = NULL;
		{
			DVBManager* _tmp4_ = NULL;
			GeeHashMap* _tmp5_ = NULL;
			_tmp4_ = m;
			_tmp5_ = _tmp4_->priv->scanners;
			g_rec_mutex_lock (&_tmp4_->priv->__lock_scanners);
			{
				DVBManager* _tmp24_ = NULL;
				GeeHashMap* _tmp25_ = NULL;
				{
					GeeIterator* _data_it = NULL;
					DVBManager* _tmp6_ = NULL;
					GeeHashMap* _tmp7_ = NULL;
					GeeCollection* _tmp8_ = NULL;
					GeeCollection* _tmp9_ = NULL;
					GeeCollection* _tmp10_ = NULL;
					GeeIterator* _tmp11_ = NULL;
					GeeIterator* _tmp12_ = NULL;
					_tmp6_ = m;
					_tmp7_ = _tmp6_->priv->scanners;
					_tmp8_ = gee_abstract_map_get_values ((GeeMap*) _tmp7_);
					_tmp9_ = _tmp8_;
					_tmp10_ = _tmp9_;
					_tmp11_ = gee_iterable_iterator ((GeeIterable*) _tmp10_);
					_tmp12_ = _tmp11_;
					_g_object_unref0 (_tmp10_);
					_data_it = _tmp12_;
					while (TRUE) {
						GeeIterator* _tmp13_ = NULL;
						gboolean _tmp14_ = FALSE;
						DVBManagerScannerData* data = NULL;
						GeeIterator* _tmp15_ = NULL;
						gpointer _tmp16_ = NULL;
						DVBLoggingLogger* _tmp17_ = NULL;
						DVBManagerScannerData* _tmp18_ = NULL;
						DVBScanner* _tmp19_ = NULL;
						DVBManagerScannerData* _tmp20_ = NULL;
						gulong _tmp21_ = 0UL;
						DVBManagerScannerData* _tmp22_ = NULL;
						DVBScanner* _tmp23_ = NULL;
						_tmp13_ = _data_it;
						_tmp14_ = gee_iterator_next (_tmp13_);
						if (!_tmp14_) {
							break;
						}
						_tmp15_ = _data_it;
						_tmp16_ = gee_iterator_get (_tmp15_);
						data = (DVBManagerScannerData*) _tmp16_;
						_tmp17_ = dvb_manager_log;
						dvb_logging_logger_debug (_tmp17_, "Manager.vala:95: Stopping scanner");
						_tmp18_ = data;
						_tmp19_ = _tmp18_->scanner;
						_tmp20_ = data;
						_tmp21_ = _tmp20_->signal_id;
						g_signal_handler_disconnect ((GObject*) _tmp19_, _tmp21_);
						_tmp22_ = data;
						_tmp23_ = _tmp22_->scanner;
						dvb_scanner_do_destroy (_tmp23_);
						_g_object_unref0 (data);
					}
					_g_object_unref0 (_data_it);
				}
				_tmp24_ = m;
				_tmp25_ = _tmp24_->priv->scanners;
				gee_abstract_map_clear ((GeeAbstractMap*) _tmp25_);
			}
			__finally84:
			{
				DVBManager* _tmp26_ = NULL;
				GeeHashMap* _tmp27_ = NULL;
				_tmp26_ = m;
				_tmp27_ = _tmp26_->priv->scanners;
				g_rec_mutex_unlock (&_tmp26_->priv->__lock_scanners);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			DVBManager* _tmp28_ = NULL;
			GeeArrayList* _tmp29_ = NULL;
			_tmp28_ = m;
			_tmp29_ = _tmp28_->priv->devices;
			g_rec_mutex_lock (&_tmp28_->priv->__lock_devices);
			{
				DVBManager* _tmp30_ = NULL;
				GeeArrayList* _tmp31_ = NULL;
				_tmp30_ = m;
				_tmp31_ = _tmp30_->priv->devices;
				gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp31_);
			}
			__finally85:
			{
				DVBManager* _tmp32_ = NULL;
				GeeArrayList* _tmp33_ = NULL;
				_tmp32_ = m;
				_tmp33_ = _tmp32_->priv->devices;
				g_rec_mutex_unlock (&_tmp32_->priv->__lock_devices);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		{
			DVBManager* _tmp34_ = NULL;
			GeeHashMap* _tmp35_ = NULL;
			_tmp34_ = m;
			_tmp35_ = _tmp34_->priv->groups;
			g_rec_mutex_lock (&_tmp34_->priv->__lock_groups);
			{
				DVBManager* _tmp48_ = NULL;
				GeeHashMap* _tmp49_ = NULL;
				{
					GeeIterator* _devgrp_it = NULL;
					DVBManager* _tmp36_ = NULL;
					GeeHashMap* _tmp37_ = NULL;
					GeeCollection* _tmp38_ = NULL;
					GeeCollection* _tmp39_ = NULL;
					GeeCollection* _tmp40_ = NULL;
					GeeIterator* _tmp41_ = NULL;
					GeeIterator* _tmp42_ = NULL;
					_tmp36_ = m;
					_tmp37_ = _tmp36_->priv->groups;
					_tmp38_ = gee_abstract_map_get_values ((GeeMap*) _tmp37_);
					_tmp39_ = _tmp38_;
					_tmp40_ = _tmp39_;
					_tmp41_ = gee_iterable_iterator ((GeeIterable*) _tmp40_);
					_tmp42_ = _tmp41_;
					_g_object_unref0 (_tmp40_);
					_devgrp_it = _tmp42_;
					while (TRUE) {
						GeeIterator* _tmp43_ = NULL;
						gboolean _tmp44_ = FALSE;
						DVBDeviceGroup* devgrp = NULL;
						GeeIterator* _tmp45_ = NULL;
						gpointer _tmp46_ = NULL;
						DVBDeviceGroup* _tmp47_ = NULL;
						_tmp43_ = _devgrp_it;
						_tmp44_ = gee_iterator_next (_tmp43_);
						if (!_tmp44_) {
							break;
						}
						_tmp45_ = _devgrp_it;
						_tmp46_ = gee_iterator_get (_tmp45_);
						devgrp = (DVBDeviceGroup*) _tmp46_;
						_tmp47_ = devgrp;
						dvb_device_group_destroy (_tmp47_);
						_g_object_unref0 (devgrp);
					}
					_g_object_unref0 (_devgrp_it);
				}
				_tmp48_ = m;
				_tmp49_ = _tmp48_->priv->groups;
				gee_abstract_map_clear ((GeeAbstractMap*) _tmp49_);
			}
			__finally86:
			{
				DVBManager* _tmp50_ = NULL;
				GeeHashMap* _tmp51_ = NULL;
				_tmp50_ = m;
				_tmp51_ = _tmp50_->priv->groups;
				g_rec_mutex_unlock (&_tmp50_->priv->__lock_groups);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (m);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_g_object_unref0 (dvb_manager_instance);
		dvb_manager_instance = NULL;
	}
	g_rec_mutex_unlock (&dvb_manager_instance_mutex);
	_g_object_unref0 (m);
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @type: the type to scanned
         * @opath: Object path of the scanner service
         * @dbusiface: DBus interface of the scanner service
         * @returns: TRUE on success
         *
         * Get the object path of the channel scanner for this device.
         */
static void _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed (DVBScanner* _sender, gpointer self) {
	dvb_manager_on_scanner_destroyed ((DVBManager*) self, _sender);
}


static gboolean dvb_manager_real_GetScannerForDevice (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterType type, char** opath, gchar** dbusiface, GError** error) {
	DVBManager * self;
	char* _vala_opath = NULL;
	gchar* _vala_dbusiface = NULL;
	gboolean result = FALSE;
	gchar* path = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	char* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	DVBDevice* device = NULL;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	DVBDevice* _tmp8_ = NULL;
	DVBDevice* _tmp9_ = NULL;
	gchar* _tmp10_ = NULL;
	DVBDeviceGroup** groups = NULL;
	DVBDevice* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	DVBDeviceGroup** _tmp13_ = NULL;
	gint groups_length1 = 0;
	gint _groups_size_ = 0;
	DVBDeviceGroup** _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, _tmp0_, _tmp1_);
	path = _tmp2_;
	_tmp3_ = path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_vala_opath);
	_vala_opath = _tmp4_;
	_tmp5_ = g_strdup ("");
	_g_free0 (_vala_dbusiface);
	_vala_dbusiface = _tmp5_;
	_tmp6_ = adapter;
	_tmp7_ = frontend;
	_tmp8_ = dvb_manager_get_device (self, _tmp6_, _tmp7_);
	device = _tmp8_;
	_tmp9_ = device;
	if (_tmp9_ == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		_g_free0 (path);
		if (opath) {
			*opath = _vala_opath;
		} else {
			_g_free0 (_vala_opath);
		}
		if (dbusiface) {
			*dbusiface = _vala_dbusiface;
		} else {
			_g_free0 (_vala_dbusiface);
		}
		return result;
	}
	_tmp10_ = g_strdup ("org.gnome.DVB.Scanner");
	_g_free0 (_vala_dbusiface);
	_vala_dbusiface = _tmp10_;
	_tmp11_ = device;
	_tmp13_ = dvb_manager_get_device_groups_of_device (self, _tmp11_, &_tmp12_);
	groups = _tmp13_;
	groups_length1 = _tmp12_;
	_groups_size_ = groups_length1;
	_tmp14_ = groups;
	_tmp14__length1 = groups_length1;
	{
		DVBDeviceGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp14_;
		group_collection_length1 = _tmp14__length1;
		for (group_it = 0; group_it < _tmp14__length1; group_it = group_it + 1) {
			DVBDeviceGroup* _tmp15_ = NULL;
			DVBDeviceGroup* group = NULL;
			_tmp15_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp15_;
			{
				DVBDeviceGroup* _tmp16_ = NULL;
				_tmp16_ = group;
				dvb_device_group_stop_epg_scanner (_tmp16_);
				_g_object_unref0 (group);
			}
		}
	}
	{
		GeeHashMap* _tmp17_ = NULL;
		_tmp17_ = self->priv->scanners;
		g_rec_mutex_lock (&self->priv->__lock_scanners);
		{
			GeeHashMap* _tmp18_ = NULL;
			const gchar* _tmp19_ = NULL;
			gboolean _tmp20_ = FALSE;
			_tmp18_ = self->priv->scanners;
			_tmp19_ = path;
			_tmp20_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp18_, _tmp19_);
			if (!_tmp20_) {
				DVBManagerScannerData* data = NULL;
				DVBManagerScannerData* _tmp21_ = NULL;
				DVBManagerScannerData* _tmp22_ = NULL;
				DVBDevice* _tmp23_ = NULL;
				DVBAdapterType _tmp24_ = 0;
				DVBScanner* _tmp25_ = NULL;
				GDBusConnection* _tmp26_ = NULL;
				const gchar* _tmp27_ = NULL;
				DVBManagerScannerData* _tmp28_ = NULL;
				DVBScanner* _tmp29_ = NULL;
				DVBManagerScannerData* _tmp30_ = NULL;
				DVBManagerScannerData* _tmp31_ = NULL;
				DVBScanner* _tmp32_ = NULL;
				gulong _tmp33_ = 0UL;
				GeeHashMap* _tmp34_ = NULL;
				const gchar* _tmp35_ = NULL;
				DVBManagerScannerData* _tmp36_ = NULL;
				DVBLoggingLogger* _tmp37_ = NULL;
				guint _tmp38_ = 0U;
				guint _tmp39_ = 0U;
				const gchar* _tmp40_ = NULL;
				_tmp21_ = dvb_manager_scanner_data_new ();
				data = _tmp21_;
				_tmp22_ = data;
				_tmp23_ = device;
				_tmp24_ = type;
				_tmp25_ = dvb_scanner_new (_tmp23_, _tmp24_);
				_g_object_unref0 (_tmp22_->scanner);
				_tmp22_->scanner = _tmp25_;
				_tmp26_ = main_conn;
				_tmp27_ = path;
				_tmp28_ = data;
				_tmp29_ = _tmp28_->scanner;
				dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_SCANNER, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp26_, _tmp27_, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, DVB_TYPE_ID_BUS_SCANNER, DVBIDBusScanner));
				_tmp30_ = data;
				_tmp31_ = data;
				_tmp32_ = _tmp31_->scanner;
				_tmp33_ = g_signal_connect_object (_tmp32_, "destroyed", (GCallback) _dvb_manager_on_scanner_destroyed_dvb_scanner_destroyed, self, 0);
				_tmp30_->signal_id = _tmp33_;
				_tmp34_ = self->priv->scanners;
				_tmp35_ = path;
				_tmp36_ = data;
				gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, _tmp35_, _tmp36_);
				_tmp37_ = dvb_manager_log;
				_tmp38_ = adapter;
				_tmp39_ = frontend;
				_tmp40_ = _vala_dbusiface;
				dvb_logging_logger_debug (_tmp37_, "Manager.vala:161: Created new Scanner D-Bus service for adapter %u, fr" \
"ontend %u (%s)", _tmp38_, _tmp39_, _tmp40_);
				_g_object_unref0 (data);
			}
		}
		__finally87:
		{
			GeeHashMap* _tmp41_ = NULL;
			_tmp41_ = self->priv->scanners;
			g_rec_mutex_unlock (&self->priv->__lock_scanners);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_object_unref0 (device);
				_g_free0 (path);
				return FALSE;
			} else {
				groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_object_unref), NULL);
				_g_object_unref0 (device);
				_g_free0 (path);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = TRUE;
	groups = (_vala_array_free (groups, groups_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_object_unref0 (device);
	_g_free0 (path);
	if (opath) {
		*opath = _vala_opath;
	} else {
		_g_free0 (_vala_opath);
	}
	if (dbusiface) {
		*dbusiface = _vala_dbusiface;
	} else {
		_g_free0 (_vala_dbusiface);
	}
	return result;
}


/**
         * @group_id: A group ID
         * @path: Device group's DBus path
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_GetDeviceGroup (DVBIDBusManager* base, guint group_id, char** opath, GError** error) {
	DVBManager * self;
	char* _vala_opath = NULL;
	gboolean result = FALSE;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->groups;
			_tmp2_ = group_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				guint _tmp4_ = 0U;
				gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				char* _tmp7_ = NULL;
				_tmp4_ = group_id;
				_tmp5_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp4_);
				_tmp6_ = _tmp5_;
				_tmp7_ = g_strdup (_tmp6_);
				_g_free0 (_vala_opath);
				_vala_opath = _tmp7_;
				_g_free0 (_tmp6_);
				ret = TRUE;
			} else {
				char* _tmp8_ = NULL;
				_tmp8_ = g_strdup ("");
				_g_free0 (_vala_opath);
				_vala_opath = _tmp8_;
				ret = FALSE;
			}
		}
		__finally88:
		{
			GeeHashMap* _tmp9_ = NULL;
			_tmp9_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				return FALSE;
			} else {
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	result = ret;
	if (opath) {
		*opath = _vala_opath;
	} else {
		_g_free0 (_vala_opath);
	}
	return result;
}


/**
         * @returns: Device groups' DBus path
         */
static char** dvb_manager_real_GetRegisteredDeviceGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	char** result = NULL;
	char** devs = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	char** _tmp3_ = NULL;
	gint devs_length1 = 0;
	gint _devs_size_ = 0;
	DVBLoggingLogger* _tmp4_ = NULL;
	GeeHashMap* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	gint i = 0;
	char** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->groups;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (char*, _tmp2_ + 1);
	devs = _tmp3_;
	devs_length1 = _tmp2_;
	_devs_size_ = devs_length1;
	_tmp4_ = dvb_manager_log;
	_tmp5_ = self->priv->groups;
	_tmp6_ = gee_abstract_map_get_size ((GeeMap*) _tmp5_);
	_tmp7_ = _tmp6_;
	dvb_logging_logger_debug (_tmp4_, "Manager.vala:196: %d", _tmp7_);
	i = 0;
	{
		GeeHashMap* _tmp8_ = NULL;
		_tmp8_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			{
				GeeIterator* _key_it = NULL;
				GeeHashMap* _tmp9_ = NULL;
				GeeSet* _tmp10_ = NULL;
				GeeSet* _tmp11_ = NULL;
				GeeSet* _tmp12_ = NULL;
				GeeIterator* _tmp13_ = NULL;
				GeeIterator* _tmp14_ = NULL;
				_tmp9_ = self->priv->groups;
				_tmp10_ = gee_abstract_map_get_keys ((GeeMap*) _tmp9_);
				_tmp11_ = _tmp10_;
				_tmp12_ = _tmp11_;
				_tmp13_ = gee_iterable_iterator ((GeeIterable*) _tmp12_);
				_tmp14_ = _tmp13_;
				_g_object_unref0 (_tmp12_);
				_key_it = _tmp14_;
				while (TRUE) {
					GeeIterator* _tmp15_ = NULL;
					gboolean _tmp16_ = FALSE;
					guint key = 0U;
					GeeIterator* _tmp17_ = NULL;
					gpointer _tmp18_ = NULL;
					char** _tmp19_ = NULL;
					gint _tmp19__length1 = 0;
					gint _tmp20_ = 0;
					guint _tmp21_ = 0U;
					gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					char* _tmp24_ = NULL;
					char* _tmp25_ = NULL;
					gint _tmp26_ = 0;
					_tmp15_ = _key_it;
					_tmp16_ = gee_iterator_next (_tmp15_);
					if (!_tmp16_) {
						break;
					}
					_tmp17_ = _key_it;
					_tmp18_ = gee_iterator_get (_tmp17_);
					key = (guint) ((guintptr) _tmp18_);
					_tmp19_ = devs;
					_tmp19__length1 = devs_length1;
					_tmp20_ = i;
					_tmp21_ = key;
					_tmp22_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp21_);
					_tmp23_ = _tmp22_;
					_tmp24_ = g_strdup (_tmp23_);
					_g_free0 (_tmp19_[_tmp20_]);
					_tmp19_[_tmp20_] = _tmp24_;
					_tmp25_ = _tmp19_[_tmp20_];
					_g_free0 (_tmp23_);
					_tmp26_ = i;
					i = _tmp26_ + 1;
				}
				_g_object_unref0 (_key_it);
			}
		}
		__finally89:
		{
			GeeHashMap* _tmp27_ = NULL;
			_tmp27_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				return NULL;
			} else {
				devs = (_vala_array_free (devs, devs_length1, (GDestroyNotify) g_free), NULL);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return NULL;
			}
		}
	}
	_tmp28_ = devs;
	_tmp28__length1 = devs_length1;
	if (result_length1) {
		*result_length1 = _tmp28__length1;
	}
	result = _tmp28_;
	return result;
}


/**
         * @adapter: Number of the device's adapter
         * @frontend: Number of the device's frontend
         * @type: type of the new group
         * @channels_conf: Path to channels.conf for this device
         * @recordings_dir: Path where the recordings should be stored
         * @name: Name of group
         * @returns: TRUE when the device has been registered successfully
         *
         * Creates a new DeviceGroup and new DVB device whereas the
         * DVB device is the reference device of this group (i.e.
         * all other devices of this group will inherit the settings
         * of the reference device).
         */
static gboolean dvb_manager_real_AddDeviceToNewGroup (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterType type, const gchar* channels_conf, const gchar* recordings_dir, const gchar* name, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	GFile* chan_file = NULL;
	const gchar* _tmp0_ = NULL;
	GFile* _tmp1_ = NULL;
	GFile* rec_dir = NULL;
	const gchar* _tmp2_ = NULL;
	GFile* _tmp3_ = NULL;
	DVBDevice* device = NULL;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	DVBDevice* _tmp6_ = NULL;
	DVBDevice* _tmp7_ = NULL;
	DVBDevice* _tmp8_ = NULL;
	DVBAdapterType _tmp9_ = 0;
	gboolean _tmp10_ = FALSE;
	guint _tmp11_ = 0U;
	DVBDeviceGroup* devgroup = NULL;
	guint _tmp12_ = 0U;
	GFile* _tmp13_ = NULL;
	GFile* _tmp14_ = NULL;
	DVBAdapterType _tmp15_ = 0;
	DVBDeviceGroup* _tmp16_ = NULL;
	DVBDeviceGroup* _tmp17_ = NULL;
	DVBDeviceGroup* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	DVBDeviceGroup* _tmp20_ = NULL;
	guint _tmp21_ = 0U;
	DVBDeviceGroup* _tmp22_ = NULL;
	DVBDevice* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	DVBDeviceGroup* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	guint _tmp36_ = 0U;
	DVBDeviceGroup* _tmp37_ = NULL;
	DVBDeviceGroup* _tmp38_ = NULL;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (channels_conf != NULL, FALSE);
	g_return_val_if_fail (recordings_dir != NULL, FALSE);
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = channels_conf;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	chan_file = _tmp1_;
	_tmp2_ = recordings_dir;
	_tmp3_ = g_file_new_for_path (_tmp2_);
	rec_dir = _tmp3_;
	_tmp4_ = adapter;
	_tmp5_ = frontend;
	_tmp6_ = dvb_manager_get_device (self, _tmp4_, _tmp5_);
	device = _tmp6_;
	_tmp7_ = device;
	if (_tmp7_ == NULL) {
		result = FALSE;
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	_tmp8_ = device;
	_tmp9_ = type;
	_tmp10_ = dvb_manager_device_is_in_any_group (self, _tmp8_, _tmp9_);
	if (_tmp10_) {
		result = FALSE;
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	_tmp11_ = self->priv->device_group_counter;
	self->priv->device_group_counter = _tmp11_ + 1;
	_tmp12_ = self->priv->device_group_counter;
	_tmp13_ = chan_file;
	_tmp14_ = rec_dir;
	_tmp15_ = type;
	_tmp16_ = dvb_device_group_new (_tmp12_, _tmp13_, _tmp14_, _tmp15_, TRUE);
	devgroup = _tmp16_;
	_tmp17_ = devgroup;
	if (_tmp17_ == NULL) {
		result = FALSE;
		_g_object_unref0 (devgroup);
		_g_object_unref0 (device);
		_g_object_unref0 (rec_dir);
		_g_object_unref0 (chan_file);
		return result;
	}
	_tmp18_ = devgroup;
	_tmp19_ = name;
	dvb_device_group_set_Name (_tmp18_, _tmp19_);
	_tmp20_ = devgroup;
	dvb_manager_add_device_group (self, _tmp20_, TRUE);
	_tmp21_ = self->priv->device_group_counter;
	g_signal_emit_by_name ((DVBIDBusManager*) self, "group-added", _tmp21_);
	_tmp22_ = devgroup;
	_tmp23_ = device;
	_tmp24_ = dvb_device_group_add (_tmp22_, _tmp23_);
	if (_tmp24_) {
		{
			DVBFactory* _tmp25_ = NULL;
			DVBFactory* _tmp26_ = NULL;
			DVBdatabaseConfigStore* _tmp27_ = NULL;
			DVBdatabaseConfigStore* _tmp28_ = NULL;
			DVBDevice* _tmp29_ = NULL;
			DVBDeviceGroup* _tmp30_ = NULL;
			_tmp25_ = dvb_factory_new ();
			_tmp26_ = _tmp25_;
			_tmp27_ = dvb_factory_get_config_store (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = device;
			_tmp30_ = devgroup;
			dvb_database_config_store_add_device_to_group (_tmp28_, _tmp29_, _tmp30_, &_inner_error_);
			_g_object_unref0 (_tmp28_);
			_g_object_unref0 (_tmp26_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch90_dvb_database_sql_error;
				}
				_g_object_unref0 (devgroup);
				_g_object_unref0 (device);
				_g_object_unref0 (rec_dir);
				_g_object_unref0 (chan_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally90;
		__catch90_dvb_database_sql_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp31_ = NULL;
			GError* _tmp32_ = NULL;
			const gchar* _tmp33_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp31_ = dvb_manager_log;
			_tmp32_ = e;
			_tmp33_ = _tmp32_->message;
			dvb_logging_logger_error (_tmp31_, "Manager.vala:251: %s", _tmp33_);
			result = FALSE;
			_g_error_free0 (e);
			_g_object_unref0 (devgroup);
			_g_object_unref0 (device);
			_g_object_unref0 (rec_dir);
			_g_object_unref0 (chan_file);
			return result;
		}
		__finally90:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_DBUS_ERROR) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (devgroup);
				_g_object_unref0 (device);
				_g_object_unref0 (rec_dir);
				_g_object_unref0 (chan_file);
				return FALSE;
			} else {
				_g_object_unref0 (devgroup);
				_g_object_unref0 (device);
				_g_object_unref0 (rec_dir);
				_g_object_unref0 (chan_file);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
	}
	_tmp34_ = devgroup;
	_tmp35_ = adapter;
	_tmp36_ = frontend;
	g_signal_emit_by_name ((DVBIDBusDeviceGroup*) _tmp34_, "device-added", _tmp35_, _tmp36_);
	_tmp37_ = devgroup;
	dvb_manager_restore_device_group_and_timers (self, _tmp37_);
	_tmp38_ = devgroup;
	dvb_device_group_start_epg_scanner (_tmp38_);
	result = TRUE;
	_g_object_unref0 (devgroup);
	_g_object_unref0 (device);
	_g_object_unref0 (rec_dir);
	_g_object_unref0 (chan_file);
	return result;
}


/**
         * @adapter: Adapter of device
         * @frontend: Frontend of device
         * @name: The name of the device or "Unknown"
         * @returns: TRUE on success
         *
         * The device must be part of group, otherwise "Unknown"
         * is returned.
         */
static gboolean dvb_manager_real_GetNameOfRegisteredDevice (DVBIDBusManager* base, guint adapter, guint frontend, gchar** name, GError** error) {
	DVBManager * self;
	gchar* _vala_name = NULL;
	gboolean result = FALSE;
	DVBDevice* dev = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* _tmp3_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_manager_get_device (self, _tmp0_, _tmp1_);
	dev = _tmp2_;
	_tmp3_ = dev;
	if (_tmp3_ == NULL) {
		gchar* _tmp4_ = NULL;
		_tmp4_ = g_strdup ("");
		_g_free0 (_vala_name);
		_vala_name = _tmp4_;
		result = FALSE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	} else {
		DVBDevice* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp5_ = dev;
		_tmp6_ = dvb_device_get_Name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (_vala_name);
		_vala_name = _tmp8_;
		result = TRUE;
		_g_object_unref0 (dev);
		if (name) {
			*name = _vala_name;
		} else {
			_g_free0 (_vala_name);
		}
		return result;
	}
	_g_object_unref0 (dev);
	if (name) {
		*name = _vala_name;
	} else {
		_g_free0 (_vala_name);
	}
}


/**
         * @returns: the numner of configured device groups
         */
static gint dvb_manager_real_GetDeviceGroupSize (DVBIDBusManager* base, GError** error) {
	DVBManager * self;
	gint result = 0;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->groups;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


/**
         * @returns: ID and name of each channel group
         */
static void _vala_DVBChannelGroupInfo_array_free (DVBChannelGroupInfo* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			dvb_channel_group_info_destroy (&array[i]);
		}
	}
	g_free (array);
}


static DVBChannelGroupInfo* dvb_manager_real_GetChannelGroups (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	DVBChannelGroupInfo* result = NULL;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	GeeList* groups = NULL;
	DVBChannelGroupInfo* arr = NULL;
	GeeList* _tmp13_ = NULL;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	DVBChannelGroupInfo* _tmp16_ = NULL;
	gint arr_length1 = 0;
	gint _arr_size_ = 0;
	DVBChannelGroupInfo* _tmp39_ = NULL;
	gint _tmp39__length1 = 0;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		GeeList* _tmp4_ = NULL;
		DVBdatabaseConfigStore* _tmp5_ = NULL;
		GeeList* _tmp6_ = NULL;
		GeeList* _tmp7_ = NULL;
		_tmp5_ = config;
		_tmp6_ = dvb_database_config_store_get_channel_groups (_tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch91_dvb_database_sql_error;
			}
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp7_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (groups);
		groups = _tmp7_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally91;
	__catch91_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		DVBChannelGroupInfo* _tmp11_ = NULL;
		DVBChannelGroupInfo* _tmp12_ = NULL;
		gint _tmp12__length1 = 0;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = dvb_manager_log;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp8_, "Manager.vala:305: %s", _tmp10_);
		_tmp11_ = g_new0 (DVBChannelGroupInfo, 0);
		_tmp12_ = _tmp11_;
		_tmp12__length1 = 0;
		if (result_length1) {
			*result_length1 = _tmp12__length1;
		}
		result = _tmp12_;
		_g_error_free0 (e);
		_g_object_unref0 (groups);
		_g_object_unref0 (config);
		return result;
	}
	__finally91:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			return NULL;
		} else {
			_g_object_unref0 (groups);
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp13_ = groups;
	_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_new0 (DVBChannelGroupInfo, _tmp15_);
	arr = _tmp16_;
	arr_length1 = _tmp15_;
	_arr_size_ = arr_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp17_ = FALSE;
			_tmp17_ = TRUE;
			while (TRUE) {
				gint _tmp19_ = 0;
				DVBChannelGroupInfo* _tmp20_ = NULL;
				gint _tmp20__length1 = 0;
				DVBChannelGroup* cg = NULL;
				GeeList* _tmp21_ = NULL;
				gint _tmp22_ = 0;
				gpointer _tmp23_ = NULL;
				DVBChannelGroupInfo* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				gint _tmp25_ = 0;
				DVBChannelGroupInfo _tmp26_ = {0};
				DVBChannelGroupInfo _tmp27_ = {0};
				DVBChannelGroupInfo* _tmp28_ = NULL;
				gint _tmp28__length1 = 0;
				gint _tmp29_ = 0;
				DVBChannelGroup* _tmp30_ = NULL;
				gint _tmp31_ = 0;
				gint _tmp32_ = 0;
				DVBChannelGroupInfo* _tmp33_ = NULL;
				gint _tmp33__length1 = 0;
				gint _tmp34_ = 0;
				DVBChannelGroup* _tmp35_ = NULL;
				const gchar* _tmp36_ = NULL;
				const gchar* _tmp37_ = NULL;
				gchar* _tmp38_ = NULL;
				if (!_tmp17_) {
					gint _tmp18_ = 0;
					_tmp18_ = i;
					i = _tmp18_ + 1;
				}
				_tmp17_ = FALSE;
				_tmp19_ = i;
				_tmp20_ = arr;
				_tmp20__length1 = arr_length1;
				if (!(_tmp19_ < _tmp20__length1)) {
					break;
				}
				_tmp21_ = groups;
				_tmp22_ = i;
				_tmp23_ = gee_list_get (_tmp21_, _tmp22_);
				cg = (DVBChannelGroup*) _tmp23_;
				_tmp24_ = arr;
				_tmp24__length1 = arr_length1;
				_tmp25_ = i;
				memset (&_tmp26_, 0, sizeof (DVBChannelGroupInfo));
				dvb_channel_group_info_destroy (&_tmp24_[_tmp25_]);
				_tmp24_[_tmp25_] = _tmp26_;
				_tmp27_ = _tmp24_[_tmp25_];
				_tmp28_ = arr;
				_tmp28__length1 = arr_length1;
				_tmp29_ = i;
				_tmp30_ = cg;
				_tmp31_ = dvb_channel_group_get_id (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp28_[_tmp29_].id = _tmp32_;
				_tmp33_ = arr;
				_tmp33__length1 = arr_length1;
				_tmp34_ = i;
				_tmp35_ = cg;
				_tmp36_ = dvb_channel_group_get_name (_tmp35_);
				_tmp37_ = _tmp36_;
				_tmp38_ = g_strdup (_tmp37_);
				_g_free0 (_tmp33_[_tmp34_].name);
				_tmp33_[_tmp34_].name = _tmp38_;
				_g_object_unref0 (cg);
			}
		}
	}
	_tmp39_ = arr;
	_tmp39__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp39__length1;
	}
	result = _tmp39_;
	_g_object_unref0 (groups);
	_g_object_unref0 (config);
	return result;
}


/**
         * @name: Name of the new group
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_AddChannelGroup (DVBIDBusManager* base, const gchar* name, gint* channel_group_id, GError** error) {
	DVBManager * self;
	gint _vala_channel_group_id = 0;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	g_return_val_if_fail (name != NULL, FALSE);
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_ = NULL;
		gint _tmp6_ = 0;
		gboolean _tmp7_ = FALSE;
		_tmp5_ = name;
		_tmp7_ = dvb_database_config_store_add_channel_group (config, _tmp5_, &_tmp6_, &_inner_error_);
		_vala_channel_group_id = _tmp6_;
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch92_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp4_;
	}
	goto __finally92;
	__catch92_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp8_ = NULL;
		GError* _tmp9_ = NULL;
		const gchar* _tmp10_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp8_ = dvb_manager_log;
		_tmp9_ = e;
		_tmp10_ = _tmp9_->message;
		dvb_logging_logger_error (_tmp8_, "Manager.vala:328: %s", _tmp10_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally92:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	if (channel_group_id) {
		*channel_group_id = _vala_channel_group_id;
	}
	return result;
}


/**
         * @channel_group_id: ID of the ChannelGroup
         * @returns: TRUE on success
         */
static gboolean dvb_manager_real_RemoveChannelGroup (DVBIDBusManager* base, gint channel_group_id, GError** error) {
	DVBManager * self;
	gboolean result = FALSE;
	DVBdatabaseConfigStore* config = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	gboolean ret = FALSE;
	GError * _inner_error_ = NULL;
	self = (DVBManager*) base;
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config = _tmp3_;
	{
		gboolean _tmp4_ = FALSE;
		gint _tmp5_ = 0;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = channel_group_id;
		_tmp6_ = dvb_database_config_store_remove_channel_group (config, _tmp5_, &_inner_error_);
		_tmp4_ = _tmp6_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch93_dvb_database_sql_error;
			}
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		ret = _tmp4_;
	}
	goto __finally93;
	__catch93_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp7_ = NULL;
		GError* _tmp8_ = NULL;
		const gchar* _tmp9_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = dvb_manager_log;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		dvb_logging_logger_error (_tmp7_, "Manager.vala:344: %s", _tmp9_);
		ret = FALSE;
		_g_error_free0 (e);
	}
	__finally93:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		if (_inner_error_->domain == G_DBUS_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (config);
			return FALSE;
		} else {
			_g_object_unref0 (config);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = ret;
	_g_object_unref0 (config);
	return result;
}


/**
         * @returns: informations about all connected
         * devices retrieved via udev
         */
static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


static GHashTable** dvb_manager_real_GetDevices (DVBIDBusManager* base, int* result_length1, GError** error) {
	DVBManager * self;
	GHashTable** result = NULL;
	GHashTable** arr = NULL;
	GeeArrayList* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	GHashTable** _tmp3_ = NULL;
	gint arr_length1 = 0;
	gint _arr_size_ = 0;
	GHashTable** _tmp32_ = NULL;
	gint _tmp32__length1 = 0;
	self = (DVBManager*) base;
	_tmp0_ = self->priv->devices;
	_tmp1_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (GHashTable*, _tmp2_ + 1);
	arr = _tmp3_;
	arr_length1 = _tmp2_;
	_arr_size_ = arr_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				GeeArrayList* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				DVBDevice* dev = NULL;
				GeeArrayList* _tmp10_ = NULL;
				gint _tmp11_ = 0;
				gpointer _tmp12_ = NULL;
				GHashTable* map = NULL;
				GHashFunc _tmp13_ = NULL;
				GEqualFunc _tmp14_ = NULL;
				GDestroyNotify _tmp15_ = NULL;
				GDestroyNotify _tmp16_ = NULL;
				GHashTable* _tmp17_ = NULL;
				GHashTable* _tmp18_ = NULL;
				gchar* _tmp19_ = NULL;
				DVBDevice* _tmp20_ = NULL;
				guint _tmp21_ = 0U;
				guint _tmp22_ = 0U;
				DVBDevice* _tmp23_ = NULL;
				guint _tmp24_ = 0U;
				guint _tmp25_ = 0U;
				gchar* _tmp26_ = NULL;
				GHashTable** _tmp27_ = NULL;
				gint _tmp27__length1 = 0;
				gint _tmp28_ = 0;
				GHashTable* _tmp29_ = NULL;
				GHashTable* _tmp30_ = NULL;
				GHashTable* _tmp31_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				_tmp7_ = self->priv->devices;
				_tmp8_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp7_);
				_tmp9_ = _tmp8_;
				if (!(_tmp6_ < _tmp9_)) {
					break;
				}
				_tmp10_ = self->priv->devices;
				_tmp11_ = i;
				_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp10_, _tmp11_);
				dev = (DVBDevice*) _tmp12_;
				_tmp13_ = g_str_hash;
				_tmp14_ = g_str_equal;
				_tmp15_ = g_free;
				_tmp16_ = g_free;
				_tmp17_ = g_hash_table_new_full (_tmp13_, _tmp14_, _tmp15_, _tmp16_);
				map = _tmp17_;
				_tmp18_ = map;
				_tmp19_ = g_strdup ("device_file");
				_tmp20_ = dev;
				_tmp21_ = dvb_device_get_Adapter (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = dev;
				_tmp24_ = dvb_device_get_Frontend (_tmp23_);
				_tmp25_ = _tmp24_;
				_tmp26_ = g_strdup_printf ("/dev/dvb/adapter%u/frontend%u", _tmp22_, _tmp25_);
				g_hash_table_insert (_tmp18_, _tmp19_, _tmp26_);
				_tmp27_ = arr;
				_tmp27__length1 = arr_length1;
				_tmp28_ = i;
				_tmp29_ = map;
				_tmp30_ = _g_hash_table_ref0 (_tmp29_);
				_g_hash_table_unref0 (_tmp27_[_tmp28_]);
				_tmp27_[_tmp28_] = _tmp30_;
				_tmp31_ = _tmp27_[_tmp28_];
				_g_hash_table_unref0 (map);
				_g_object_unref0 (dev);
			}
		}
	}
	_tmp32_ = arr;
	_tmp32__length1 = arr_length1;
	if (result_length1) {
		*result_length1 = _tmp32__length1;
	}
	result = _tmp32_;
	return result;
}


/**
         * @adapter: the adapter
         * @frontend: the frontend
         * @info: return the AdapterInfo structure
         * @returns: #false if device cannot found, otherwise #true
         */
static gboolean dvb_manager_real_GetAdapterInfo (DVBIDBusManager* base, guint adapter, guint frontend, DVBAdapterInfo* info, GError** error) {
	DVBManager * self;
	DVBAdapterInfo _vala_info = {0};
	gboolean result = FALSE;
	DVBDevice* dev = NULL;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	DVBDevice* _tmp2_ = NULL;
	DVBDevice* _tmp3_ = NULL;
	DVBDevice* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	DVBDevice* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	DVBDevice* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	DVBDevice* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	self = (DVBManager*) base;
	dvb_adapter_info_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (DVBAdapterInfo));
	_tmp0_ = adapter;
	_tmp1_ = frontend;
	_tmp2_ = dvb_manager_get_device (self, _tmp0_, _tmp1_);
	dev = _tmp2_;
	_tmp3_ = dev;
	if (_tmp3_ == NULL) {
		result = FALSE;
		_g_object_unref0 (dev);
		if (info) {
			*info = _vala_info;
		} else {
			dvb_adapter_info_destroy (&_vala_info);
		}
		return result;
	}
	_tmp4_ = dev;
	_tmp5_ = dvb_device_get_Name (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 (_vala_info.name);
	_vala_info.name = _tmp7_;
	_tmp8_ = dev;
	_tmp9_ = dvb_device_isTerrestrial (_tmp8_);
	_vala_info.type_t = _tmp9_;
	_tmp10_ = dev;
	_tmp11_ = dvb_device_isSatellite (_tmp10_);
	_vala_info.type_s = _tmp11_;
	_tmp12_ = dev;
	_tmp13_ = dvb_device_isCable (_tmp12_);
	_vala_info.type_c = _tmp13_;
	result = TRUE;
	_g_object_unref0 (dev);
	if (info) {
		*info = _vala_info;
	} else {
		dvb_adapter_info_destroy (&_vala_info);
	}
	return result;
}


/**
         * @returns: Whether the device has been added successfully
         *
         * Register device, create Recorder and ChannelList D-Bus service
         */
static void _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed (DVBIDBusDeviceGroup* _sender, guint adapter, guint frontend, gpointer self) {
	dvb_manager_on_device_removed_from_group ((DVBManager*) self, _sender, adapter, frontend);
}


gboolean dvb_manager_add_device_group (DVBManager* self, DVBDeviceGroup* devgroup, gboolean store) {
	gboolean result = FALSE;
	guint group_id = 0U;
	DVBDeviceGroup* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	DVBLoggingLogger* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	DVBDeviceGroup* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	DVBDeviceGroup* _tmp8_ = NULL;
	DVBAdapterType _tmp9_ = 0;
	DVBAdapterType _tmp10_ = 0;
	gboolean _tmp20_ = FALSE;
	DVBDeviceGroup* _tmp29_ = NULL;
	gchar* path = NULL;
	guint _tmp30_ = 0U;
	gchar* _tmp31_ = NULL;
	GDBusConnection* _tmp32_ = NULL;
	const gchar* _tmp33_ = NULL;
	DVBDeviceGroup* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	guint _tmp36_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (devgroup != NULL, FALSE);
	_tmp0_ = devgroup;
	_tmp1_ = dvb_device_group_get_Id (_tmp0_);
	_tmp2_ = _tmp1_;
	group_id = _tmp2_;
	_tmp3_ = dvb_manager_log;
	_tmp4_ = group_id;
	_tmp5_ = devgroup;
	_tmp6_ = dvb_device_group_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	dvb_logging_logger_debug (_tmp3_, "Manager.vala:397: Adding device group %u with %d devices", _tmp4_, _tmp7_);
	_tmp8_ = devgroup;
	_tmp9_ = dvb_device_group_get_Type (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_ == DVB_ADAPTER_TYPE_UNKNOWN) {
		DVBLoggingLogger* _tmp11_ = NULL;
		DVBDeviceGroup* _tmp12_ = NULL;
		guint _tmp13_ = 0U;
		guint _tmp14_ = 0U;
		_tmp11_ = dvb_manager_log;
		_tmp12_ = devgroup;
		_tmp13_ = dvb_device_group_get_Id (_tmp12_);
		_tmp14_ = _tmp13_;
		dvb_logging_logger_warning (_tmp11_, "Manager.vala:401: Not adding device group %u of unknown type", _tmp14_);
		result = FALSE;
		return result;
	}
	{
		GeeHashMap* _tmp15_ = NULL;
		_tmp15_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			GeeHashMap* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			DVBDeviceGroup* _tmp18_ = NULL;
			_tmp16_ = self->priv->groups;
			_tmp17_ = group_id;
			_tmp18_ = devgroup;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp16_, (gpointer) ((guintptr) _tmp17_), _tmp18_);
		}
		__finally94:
		{
			GeeHashMap* _tmp19_ = NULL;
			_tmp19_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp20_ = store;
	if (_tmp20_) {
		{
			DVBFactory* _tmp21_ = NULL;
			DVBFactory* _tmp22_ = NULL;
			DVBdatabaseConfigStore* _tmp23_ = NULL;
			DVBdatabaseConfigStore* _tmp24_ = NULL;
			DVBDeviceGroup* _tmp25_ = NULL;
			_tmp21_ = dvb_factory_new ();
			_tmp22_ = _tmp21_;
			_tmp23_ = dvb_factory_get_config_store (_tmp22_);
			_tmp24_ = _tmp23_;
			_tmp25_ = devgroup;
			dvb_database_config_store_add_device_group (_tmp24_, _tmp25_, &_inner_error_);
			_g_object_unref0 (_tmp24_);
			_g_object_unref0 (_tmp22_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch95_dvb_database_sql_error;
				}
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return FALSE;
			}
		}
		goto __finally95;
		__catch95_dvb_database_sql_error:
		{
			GError* e = NULL;
			DVBLoggingLogger* _tmp26_ = NULL;
			GError* _tmp27_ = NULL;
			const gchar* _tmp28_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp26_ = dvb_manager_log;
			_tmp27_ = e;
			_tmp28_ = _tmp27_->message;
			dvb_logging_logger_error (_tmp26_, "Manager.vala:413: %s", _tmp28_);
			result = FALSE;
			_g_error_free0 (e);
			return result;
		}
		__finally95:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	_tmp29_ = devgroup;
	g_signal_connect_object ((DVBIDBusDeviceGroup*) _tmp29_, "device-removed", (GCallback) _dvb_manager_on_device_removed_from_group_dvb_id_bus_device_group_device_removed, self, 0);
	_tmp30_ = group_id;
	_tmp31_ = g_strdup_printf (DVB_CONSTANTS_DBUS_DEVICE_GROUP_PATH, _tmp30_);
	path = _tmp31_;
	_tmp32_ = main_conn;
	_tmp33_ = path;
	_tmp34_ = devgroup;
	dvb_utils_dbus_register_object (DVB_TYPE_ID_BUS_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp32_, _tmp33_, (DVBIDBusDeviceGroup*) _tmp34_);
	_tmp35_ = group_id;
	_tmp36_ = self->priv->device_group_counter;
	if (_tmp35_ > _tmp36_) {
		guint _tmp37_ = 0U;
		_tmp37_ = group_id;
		self->priv->device_group_counter = _tmp37_;
	}
	result = TRUE;
	_g_free0 (path);
	return result;
}


gboolean dvb_manager_restore_device_group (DVBManager* self, DVBDeviceGroup* device_group, gboolean store) {
	gboolean result = FALSE;
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	DVBDeviceGroup* _tmp13_ = NULL;
	gboolean _tmp14_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device_group != NULL, FALSE);
	_tmp0_ = dvb_manager_log;
	_tmp1_ = device_group;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	dvb_logging_logger_info (_tmp0_, "Manager.vala:430: Restoring group %u", _tmp3_);
	{
		DVBDeviceGroup* _tmp4_ = NULL;
		DVBChannelList* _tmp5_ = NULL;
		DVBChannelList* _tmp6_ = NULL;
		DVBDeviceGroup* _tmp7_ = NULL;
		DVBAdapterType _tmp8_ = 0;
		DVBAdapterType _tmp9_ = 0;
		_tmp4_ = device_group;
		_tmp5_ = dvb_device_group_get_Channels (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = device_group;
		_tmp8_ = dvb_device_group_get_Type (_tmp7_);
		_tmp9_ = _tmp8_;
		dvb_channel_list_load (_tmp6_, _tmp9_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch96_g_error;
		}
	}
	goto __finally96;
	__catch96_g_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp10_ = NULL;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp10_ = dvb_manager_log;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp10_, "Manager.vala:435: Error reading channels from file: %s", _tmp12_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally96:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return FALSE;
	}
	_tmp13_ = device_group;
	_tmp14_ = dvb_manager_add_device_group (self, _tmp13_, FALSE);
	result = _tmp14_;
	return result;
}


void dvb_manager_restore_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	DVBLoggingLogger* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	DVBdatabaseTimersStore* timers_store = NULL;
	DVBFactory* _tmp4_ = NULL;
	DVBFactory* _tmp5_ = NULL;
	DVBdatabaseTimersStore* _tmp6_ = NULL;
	DVBdatabaseTimersStore* _tmp7_ = NULL;
	GeeList* timers = NULL;
	guint32 max_id = 0U;
	DVBRecorder* rec = NULL;
	DVBDeviceGroup* _tmp19_ = NULL;
	DVBRecorder* _tmp20_ = NULL;
	DVBRecorder* _tmp21_ = NULL;
	DVBRecorder* _tmp22_ = NULL;
	DVBRecordingsStore* recstore = NULL;
	DVBRecordingsStore* _tmp53_ = NULL;
	DVBRecordingsStore* _tmp54_ = NULL;
	DVBRecordingsStore* _tmp55_ = NULL;
	guint32 _tmp56_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = dvb_manager_log;
	_tmp1_ = device_group;
	_tmp2_ = dvb_device_group_get_Id (_tmp1_);
	_tmp3_ = _tmp2_;
	dvb_logging_logger_info (_tmp0_, "Manager.vala:443: Restoring timers of device group %u", _tmp3_);
	_tmp4_ = dvb_factory_new ();
	_tmp5_ = _tmp4_;
	_tmp6_ = dvb_factory_get_timers_store (_tmp5_);
	_tmp7_ = _tmp6_;
	_g_object_unref0 (_tmp5_);
	timers_store = _tmp7_;
	{
		GeeList* _tmp8_ = NULL;
		DVBdatabaseTimersStore* _tmp9_ = NULL;
		DVBDeviceGroup* _tmp10_ = NULL;
		GeeList* _tmp11_ = NULL;
		GeeList* _tmp12_ = NULL;
		_tmp9_ = timers_store;
		_tmp10_ = device_group;
		_tmp11_ = dvb_database_timers_store_get_all_timers_of_device_group (_tmp9_, _tmp10_, &_inner_error_);
		_tmp8_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch97_dvb_database_sql_error;
			}
			_g_object_unref0 (timers);
			_g_object_unref0 (timers_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp12_ = _tmp8_;
		_tmp8_ = NULL;
		_g_object_unref0 (timers);
		timers = _tmp12_;
		_g_object_unref0 (_tmp8_);
	}
	goto __finally97;
	__catch97_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp13_ = NULL;
		DVBDeviceGroup* _tmp14_ = NULL;
		guint _tmp15_ = 0U;
		guint _tmp16_ = 0U;
		GError* _tmp17_ = NULL;
		const gchar* _tmp18_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp13_ = dvb_manager_log;
		_tmp14_ = device_group;
		_tmp15_ = dvb_device_group_get_Id (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		dvb_logging_logger_error (_tmp13_, "Manager.vala:451: Failed retrieving timers of group %u: %s", _tmp16_, _tmp18_);
		_g_error_free0 (e);
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		return;
	}
	__finally97:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (timers);
		_g_object_unref0 (timers_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	max_id = (guint32) 0;
	_tmp19_ = device_group;
	_tmp20_ = dvb_device_group_get_recorder (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = _g_object_ref0 (_tmp21_);
	rec = _tmp22_;
	{
		GeeList* _t_list = NULL;
		GeeList* _tmp23_ = NULL;
		GeeList* _tmp24_ = NULL;
		gint _t_size = 0;
		GeeList* _tmp25_ = NULL;
		gint _tmp26_ = 0;
		gint _tmp27_ = 0;
		gint _t_index = 0;
		_tmp23_ = timers;
		_tmp24_ = _g_object_ref0 (_tmp23_);
		_t_list = _tmp24_;
		_tmp25_ = _t_list;
		_tmp26_ = gee_collection_get_size ((GeeCollection*) _tmp25_);
		_tmp27_ = _tmp26_;
		_t_size = _tmp27_;
		_t_index = -1;
		while (TRUE) {
			gint _tmp28_ = 0;
			gint _tmp29_ = 0;
			gint _tmp30_ = 0;
			DVBTimer* t = NULL;
			GeeList* _tmp31_ = NULL;
			gint _tmp32_ = 0;
			gpointer _tmp33_ = NULL;
			DVBTimer* _tmp34_ = NULL;
			guint32 _tmp35_ = 0U;
			guint32 _tmp36_ = 0U;
			guint32 _tmp37_ = 0U;
			guint32 rec_id = 0U;
			DVBRecorder* _tmp41_ = NULL;
			DVBTimer* _tmp42_ = NULL;
			guint32 _tmp43_ = 0U;
			gboolean _tmp44_ = FALSE;
			_tmp28_ = _t_index;
			_t_index = _tmp28_ + 1;
			_tmp29_ = _t_index;
			_tmp30_ = _t_size;
			if (!(_tmp29_ < _tmp30_)) {
				break;
			}
			_tmp31_ = _t_list;
			_tmp32_ = _t_index;
			_tmp33_ = gee_list_get (_tmp31_, _tmp32_);
			t = (DVBTimer*) _tmp33_;
			_tmp34_ = t;
			_tmp35_ = dvb_timer_get_Id (_tmp34_);
			_tmp36_ = _tmp35_;
			_tmp37_ = max_id;
			if (_tmp36_ > _tmp37_) {
				DVBTimer* _tmp38_ = NULL;
				guint32 _tmp39_ = 0U;
				guint32 _tmp40_ = 0U;
				_tmp38_ = t;
				_tmp39_ = dvb_timer_get_Id (_tmp38_);
				_tmp40_ = _tmp39_;
				max_id = _tmp40_;
			}
			_tmp41_ = rec;
			_tmp42_ = t;
			_tmp44_ = dvb_recorder_add_timer (_tmp41_, _tmp42_, &_tmp43_);
			rec_id = _tmp43_;
			if (!_tmp44_) {
				{
					DVBdatabaseTimersStore* _tmp45_ = NULL;
					DVBTimer* _tmp46_ = NULL;
					guint32 _tmp47_ = 0U;
					guint32 _tmp48_ = 0U;
					DVBDeviceGroup* _tmp49_ = NULL;
					_tmp45_ = timers_store;
					_tmp46_ = t;
					_tmp47_ = dvb_timer_get_Id (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = device_group;
					dvb_database_timers_store_remove_timer_from_device_group (_tmp45_, (guint) _tmp48_, _tmp49_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch98_dvb_database_sql_error;
						}
						_g_object_unref0 (t);
						_g_object_unref0 (_t_list);
						_g_object_unref0 (rec);
						_g_object_unref0 (timers);
						_g_object_unref0 (timers_store);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally98;
				__catch98_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp50_ = NULL;
					GError* _tmp51_ = NULL;
					const gchar* _tmp52_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp50_ = dvb_manager_log;
					_tmp51_ = e;
					_tmp52_ = _tmp51_->message;
					dvb_logging_logger_error (_tmp50_, "Manager.vala:465: Failed removing timer: %s", _tmp52_);
					_g_error_free0 (e);
				}
				__finally98:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (t);
					_g_object_unref0 (_t_list);
					_g_object_unref0 (rec);
					_g_object_unref0 (timers);
					_g_object_unref0 (timers_store);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_g_object_unref0 (t);
		}
		_g_object_unref0 (_t_list);
	}
	_tmp53_ = dvb_recordings_store_get_instance ();
	_tmp54_ = _g_object_ref0 (_tmp53_);
	recstore = _tmp54_;
	_tmp55_ = recstore;
	_tmp56_ = max_id;
	dvb_recordings_store_update_last_id (_tmp55_, _tmp56_);
	_g_object_unref0 (recstore);
	_g_object_unref0 (rec);
	_g_object_unref0 (timers);
	_g_object_unref0 (timers_store);
}


void dvb_manager_restore_device_group_and_timers (DVBManager* self, DVBDeviceGroup* device_group) {
	DVBDeviceGroup* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	DVBLoggingLogger* _tmp3_ = NULL;
	GstRTSPMountPoints* points = NULL;
	GstRTSPServer* _tmp4_ = NULL;
	GstRTSPMountPoints* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device_group != NULL);
	_tmp0_ = device_group;
	_tmp1_ = dvb_manager_restore_device_group (self, _tmp0_, TRUE);
	if (_tmp1_) {
		DVBDeviceGroup* _tmp2_ = NULL;
		_tmp2_ = device_group;
		dvb_manager_restore_timers (self, _tmp2_);
	}
	_tmp3_ = dvb_manager_log;
	dvb_logging_logger_debug (_tmp3_, "Manager.vala:478: add media factory");
	_tmp4_ = dvb_rtsp_server_server;
	_tmp5_ = gst_rtsp_server_get_mount_points (_tmp4_);
	points = _tmp5_;
	{
		GeeIterator* _channel_it = NULL;
		DVBDeviceGroup* _tmp6_ = NULL;
		DVBChannelList* _tmp7_ = NULL;
		DVBChannelList* _tmp8_ = NULL;
		GeeIterator* _tmp9_ = NULL;
		_tmp6_ = device_group;
		_tmp7_ = dvb_device_group_get_Channels (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
		_channel_it = _tmp9_;
		while (TRUE) {
			GeeIterator* _tmp10_ = NULL;
			gboolean _tmp11_ = FALSE;
			DVBChannel* channel = NULL;
			GeeIterator* _tmp12_ = NULL;
			gpointer _tmp13_ = NULL;
			DVBMediaFactory* factory = NULL;
			DVBMediaFactory* _tmp14_ = NULL;
			GstRTSPMountPoints* _tmp15_ = NULL;
			DVBDeviceGroup* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			guint _tmp18_ = 0U;
			DVBChannel* _tmp19_ = NULL;
			guint _tmp20_ = 0U;
			guint _tmp21_ = 0U;
			gchar* _tmp22_ = NULL;
			gchar* _tmp23_ = NULL;
			DVBMediaFactory* _tmp24_ = NULL;
			GstRTSPMediaFactory* _tmp25_ = NULL;
			_tmp10_ = _channel_it;
			_tmp11_ = gee_iterator_next (_tmp10_);
			if (!_tmp11_) {
				break;
			}
			_tmp12_ = _channel_it;
			_tmp13_ = gee_iterator_get (_tmp12_);
			channel = (DVBChannel*) _tmp13_;
			_tmp14_ = dvb_media_factory_new ();
			factory = _tmp14_;
			_tmp15_ = points;
			_tmp16_ = device_group;
			_tmp17_ = dvb_device_group_get_Id (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = channel;
			_tmp20_ = dvb_channel_get_Sid (_tmp19_);
			_tmp21_ = _tmp20_;
			_tmp22_ = g_strdup_printf ("/%u/%u", _tmp18_, _tmp21_);
			_tmp23_ = _tmp22_;
			_tmp24_ = factory;
			_tmp25_ = _g_object_ref0 ((GstRTSPMediaFactory*) _tmp24_);
			gst_rtsp_mount_points_add_factory (_tmp15_, _tmp23_, _tmp25_);
			_g_free0 (_tmp23_);
			_g_object_unref0 (factory);
			_g_object_unref0 (channel);
		}
		_g_object_unref0 (_channel_it);
	}
	_g_object_unref0 (points);
}


DVBDeviceGroup* dvb_manager_get_device_group_if_exists (DVBManager* self, guint group_id) {
	DVBDeviceGroup* result = NULL;
	DVBDeviceGroup* _result_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = NULL;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			GeeHashMap* _tmp1_ = NULL;
			guint _tmp2_ = 0U;
			gboolean _tmp3_ = FALSE;
			_tmp1_ = self->priv->groups;
			_tmp2_ = group_id;
			_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp1_, (gpointer) ((guintptr) _tmp2_));
			if (_tmp3_) {
				GeeHashMap* _tmp4_ = NULL;
				guint _tmp5_ = 0U;
				gpointer _tmp6_ = NULL;
				_tmp4_ = self->priv->groups;
				_tmp5_ = group_id;
				_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, (gpointer) ((guintptr) _tmp5_));
				_g_object_unref0 (_result_);
				_result_ = (DVBDeviceGroup*) _tmp6_;
			}
		}
		__finally99:
		{
			GeeHashMap* _tmp7_ = NULL;
			_tmp7_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (_result_);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _result_;
	return result;
}


gboolean dvb_manager_device_is_in_any_group (DVBManager* self, DVBDevice* device, DVBAdapterType type) {
	gboolean result = FALSE;
	gboolean _result_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (device != NULL, FALSE);
	_result_ = FALSE;
	{
		GeeHashMap* _tmp0_ = NULL;
		_tmp0_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			{
				GeeIterator* _group_id_it = NULL;
				GeeHashMap* _tmp1_ = NULL;
				GeeSet* _tmp2_ = NULL;
				GeeSet* _tmp3_ = NULL;
				GeeSet* _tmp4_ = NULL;
				GeeIterator* _tmp5_ = NULL;
				GeeIterator* _tmp6_ = NULL;
				_tmp1_ = self->priv->groups;
				_tmp2_ = gee_abstract_map_get_keys ((GeeMap*) _tmp1_);
				_tmp3_ = _tmp2_;
				_tmp4_ = _tmp3_;
				_tmp5_ = gee_iterable_iterator ((GeeIterable*) _tmp4_);
				_tmp6_ = _tmp5_;
				_g_object_unref0 (_tmp4_);
				_group_id_it = _tmp6_;
				while (TRUE) {
					GeeIterator* _tmp7_ = NULL;
					gboolean _tmp8_ = FALSE;
					guint group_id = 0U;
					GeeIterator* _tmp9_ = NULL;
					gpointer _tmp10_ = NULL;
					DVBDeviceGroup* devgroup = NULL;
					GeeHashMap* _tmp11_ = NULL;
					guint _tmp12_ = 0U;
					gpointer _tmp13_ = NULL;
					gboolean _tmp14_ = FALSE;
					DVBDeviceGroup* _tmp15_ = NULL;
					DVBDevice* _tmp16_ = NULL;
					gboolean _tmp17_ = FALSE;
					_tmp7_ = _group_id_it;
					_tmp8_ = gee_iterator_next (_tmp7_);
					if (!_tmp8_) {
						break;
					}
					_tmp9_ = _group_id_it;
					_tmp10_ = gee_iterator_get (_tmp9_);
					group_id = (guint) ((guintptr) _tmp10_);
					_tmp11_ = self->priv->groups;
					_tmp12_ = group_id;
					_tmp13_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp11_, (gpointer) ((guintptr) _tmp12_));
					devgroup = (DVBDeviceGroup*) _tmp13_;
					_tmp15_ = devgroup;
					_tmp16_ = device;
					_tmp17_ = dvb_device_group_contains (_tmp15_, _tmp16_);
					if (_tmp17_) {
						DVBDeviceGroup* _tmp18_ = NULL;
						DVBAdapterType _tmp19_ = 0;
						DVBAdapterType _tmp20_ = 0;
						DVBAdapterType _tmp21_ = 0;
						_tmp18_ = devgroup;
						_tmp19_ = dvb_device_group_get_Type (_tmp18_);
						_tmp20_ = _tmp19_;
						_tmp21_ = type;
						_tmp14_ = _tmp20_ == _tmp21_;
					} else {
						_tmp14_ = FALSE;
					}
					if (_tmp14_) {
						_result_ = TRUE;
						_g_object_unref0 (devgroup);
						break;
					}
					_g_object_unref0 (devgroup);
				}
				_g_object_unref0 (_group_id_it);
			}
		}
		__finally100:
		{
			GeeHashMap* _tmp22_ = NULL;
			_tmp22_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
	}
	result = _result_;
	return result;
}


DVBDevice* dvb_manager_get_device (DVBManager* self, guint adapter, guint frontend) {
	DVBDevice* result = NULL;
	DVBDevice* ret = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	ret = NULL;
	{
		GeeArrayList* _tmp0_ = NULL;
		_tmp0_ = self->priv->devices;
		g_rec_mutex_lock (&self->priv->__lock_devices);
		{
			{
				GeeArrayList* _d_list = NULL;
				GeeArrayList* _tmp1_ = NULL;
				GeeArrayList* _tmp2_ = NULL;
				gint _d_size = 0;
				GeeArrayList* _tmp3_ = NULL;
				gint _tmp4_ = 0;
				gint _tmp5_ = 0;
				gint _d_index = 0;
				_tmp1_ = self->priv->devices;
				_tmp2_ = _g_object_ref0 (_tmp1_);
				_d_list = _tmp2_;
				_tmp3_ = _d_list;
				_tmp4_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp3_);
				_tmp5_ = _tmp4_;
				_d_size = _tmp5_;
				_d_index = -1;
				while (TRUE) {
					gint _tmp6_ = 0;
					gint _tmp7_ = 0;
					gint _tmp8_ = 0;
					DVBDevice* d = NULL;
					GeeArrayList* _tmp9_ = NULL;
					gint _tmp10_ = 0;
					gpointer _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					DVBDevice* _tmp13_ = NULL;
					guint _tmp14_ = 0U;
					guint _tmp15_ = 0U;
					guint _tmp16_ = 0U;
					_tmp6_ = _d_index;
					_d_index = _tmp6_ + 1;
					_tmp7_ = _d_index;
					_tmp8_ = _d_size;
					if (!(_tmp7_ < _tmp8_)) {
						break;
					}
					_tmp9_ = _d_list;
					_tmp10_ = _d_index;
					_tmp11_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _tmp10_);
					d = (DVBDevice*) _tmp11_;
					_tmp13_ = d;
					_tmp14_ = dvb_device_get_Adapter (_tmp13_);
					_tmp15_ = _tmp14_;
					_tmp16_ = adapter;
					if (_tmp15_ == _tmp16_) {
						DVBDevice* _tmp17_ = NULL;
						guint _tmp18_ = 0U;
						guint _tmp19_ = 0U;
						guint _tmp20_ = 0U;
						_tmp17_ = d;
						_tmp18_ = dvb_device_get_Frontend (_tmp17_);
						_tmp19_ = _tmp18_;
						_tmp20_ = frontend;
						_tmp12_ = _tmp19_ == _tmp20_;
					} else {
						_tmp12_ = FALSE;
					}
					if (_tmp12_) {
						DVBDevice* _tmp21_ = NULL;
						DVBDevice* _tmp22_ = NULL;
						_tmp21_ = d;
						_tmp22_ = _g_object_ref0 (_tmp21_);
						_g_object_unref0 (ret);
						ret = _tmp22_;
						_g_object_unref0 (d);
						break;
					}
					_g_object_unref0 (d);
				}
				_g_object_unref0 (_d_list);
			}
		}
		__finally101:
		{
			GeeArrayList* _tmp23_ = NULL;
			_tmp23_ = self->priv->devices;
			g_rec_mutex_unlock (&self->priv->__lock_devices);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (ret);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = ret;
	return result;
}


static void dvb_manager_on_scanner_destroyed (DVBManager* self, DVBScanner* scanner) {
	guint adapter = 0U;
	DVBScanner* _tmp0_ = NULL;
	DVBDevice* _tmp1_ = NULL;
	DVBDevice* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint frontend = 0U;
	DVBScanner* _tmp5_ = NULL;
	DVBDevice* _tmp6_ = NULL;
	DVBDevice* _tmp7_ = NULL;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	gchar* path = NULL;
	gchar* _tmp10_ = NULL;
	DVBLoggingLogger* _tmp14_ = NULL;
	DVBDeviceGroup** devgroups = NULL;
	DVBScanner* _tmp15_ = NULL;
	DVBDevice* _tmp16_ = NULL;
	DVBDevice* _tmp17_ = NULL;
	gint _tmp18_ = 0;
	DVBDeviceGroup** _tmp19_ = NULL;
	gint devgroups_length1 = 0;
	gint _devgroups_size_ = 0;
	DVBDeviceGroup** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (scanner != NULL);
	_tmp0_ = scanner;
	_tmp1_ = dvb_scanner_get_Device (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = dvb_device_get_Adapter (_tmp2_);
	_tmp4_ = _tmp3_;
	adapter = _tmp4_;
	_tmp5_ = scanner;
	_tmp6_ = dvb_scanner_get_Device (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = dvb_device_get_Frontend (_tmp7_);
	_tmp9_ = _tmp8_;
	frontend = _tmp9_;
	_tmp10_ = g_strdup_printf (DVB_CONSTANTS_DBUS_SCANNER_PATH, adapter, frontend);
	path = _tmp10_;
	{
		GeeHashMap* _tmp11_ = NULL;
		_tmp11_ = self->priv->scanners;
		g_rec_mutex_lock (&self->priv->__lock_scanners);
		{
			GeeHashMap* _tmp12_ = NULL;
			_tmp12_ = self->priv->scanners;
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp12_, path, NULL);
		}
		__finally102:
		{
			GeeHashMap* _tmp13_ = NULL;
			_tmp13_ = self->priv->scanners;
			g_rec_mutex_unlock (&self->priv->__lock_scanners);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (path);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	_tmp14_ = dvb_manager_log;
	dvb_logging_logger_debug (_tmp14_, "Manager.vala:531: Destroying scanner for adapter %u, frontend %u (%s)", adapter, frontend, path);
	_tmp15_ = scanner;
	_tmp16_ = dvb_scanner_get_Device (_tmp15_);
	_tmp17_ = _tmp16_;
	_tmp19_ = dvb_manager_get_device_groups_of_device (self, _tmp17_, &_tmp18_);
	devgroups = _tmp19_;
	devgroups_length1 = _tmp18_;
	_devgroups_size_ = devgroups_length1;
	_tmp20_ = devgroups;
	_tmp20__length1 = devgroups_length1;
	{
		DVBDeviceGroup** group_collection = NULL;
		gint group_collection_length1 = 0;
		gint _group_collection_size_ = 0;
		gint group_it = 0;
		group_collection = _tmp20_;
		group_collection_length1 = _tmp20__length1;
		for (group_it = 0; group_it < _tmp20__length1; group_it = group_it + 1) {
			DVBDeviceGroup* _tmp21_ = NULL;
			DVBDeviceGroup* group = NULL;
			_tmp21_ = _g_object_ref0 (group_collection[group_it]);
			group = _tmp21_;
			{
				DVBDeviceGroup* _tmp22_ = NULL;
				_tmp22_ = group;
				if (_tmp22_ != NULL) {
					DVBDeviceGroup* _tmp23_ = NULL;
					_tmp23_ = group;
					dvb_device_group_start_epg_scanner (_tmp23_);
				}
				_g_object_unref0 (group);
			}
		}
	}
	devgroups = (_vala_array_free (devgroups, devgroups_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_free0 (path);
}


static DVBDeviceGroup** dvb_manager_get_device_groups_of_device (DVBManager* self, DVBDevice* device, int* result_length1) {
	DVBDeviceGroup** result = NULL;
	DVBDeviceGroup** ret = NULL;
	GeeHashMap* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	DVBDeviceGroup** _tmp3_ = NULL;
	gint ret_length1 = 0;
	gint _ret_size_ = 0;
	DVBDeviceGroup** _tmp28_ = NULL;
	gint _tmp28__length1 = 0;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (device != NULL, NULL);
	_tmp0_ = self->priv->groups;
	_tmp1_ = gee_abstract_map_get_size ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_new0 (DVBDeviceGroup*, _tmp2_ + 1);
	ret = _tmp3_;
	ret_length1 = _tmp2_;
	_ret_size_ = ret_length1;
	{
		GeeHashMap* _tmp4_ = NULL;
		_tmp4_ = self->priv->groups;
		g_rec_mutex_lock (&self->priv->__lock_groups);
		{
			guint i = 0U;
			i = (guint) 0;
			{
				GeeIterator* _group_id_it = NULL;
				GeeHashMap* _tmp5_ = NULL;
				GeeSet* _tmp6_ = NULL;
				GeeSet* _tmp7_ = NULL;
				GeeSet* _tmp8_ = NULL;
				GeeIterator* _tmp9_ = NULL;
				GeeIterator* _tmp10_ = NULL;
				_tmp5_ = self->priv->groups;
				_tmp6_ = gee_abstract_map_get_keys ((GeeMap*) _tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = _tmp7_;
				_tmp9_ = gee_iterable_iterator ((GeeIterable*) _tmp8_);
				_tmp10_ = _tmp9_;
				_g_object_unref0 (_tmp8_);
				_group_id_it = _tmp10_;
				while (TRUE) {
					GeeIterator* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					guint group_id = 0U;
					GeeIterator* _tmp13_ = NULL;
					gpointer _tmp14_ = NULL;
					DVBDeviceGroup* devgroup = NULL;
					GeeHashMap* _tmp15_ = NULL;
					guint _tmp16_ = 0U;
					gpointer _tmp17_ = NULL;
					DVBDeviceGroup* _tmp18_ = NULL;
					DVBDevice* _tmp19_ = NULL;
					gboolean _tmp20_ = FALSE;
					_tmp11_ = _group_id_it;
					_tmp12_ = gee_iterator_next (_tmp11_);
					if (!_tmp12_) {
						break;
					}
					_tmp13_ = _group_id_it;
					_tmp14_ = gee_iterator_get (_tmp13_);
					group_id = (guint) ((guintptr) _tmp14_);
					_tmp15_ = self->priv->groups;
					_tmp16_ = group_id;
					_tmp17_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp15_, (gpointer) ((guintptr) _tmp16_));
					devgroup = (DVBDeviceGroup*) _tmp17_;
					_tmp18_ = devgroup;
					_tmp19_ = device;
					_tmp20_ = dvb_device_group_contains (_tmp18_, _tmp19_);
					if (_tmp20_) {
						DVBDeviceGroup** _tmp21_ = NULL;
						gint _tmp21__length1 = 0;
						guint _tmp22_ = 0U;
						DVBDeviceGroup* _tmp23_ = NULL;
						DVBDeviceGroup* _tmp24_ = NULL;
						DVBDeviceGroup* _tmp25_ = NULL;
						guint _tmp26_ = 0U;
						_tmp21_ = ret;
						_tmp21__length1 = ret_length1;
						_tmp22_ = i;
						_tmp23_ = devgroup;
						_tmp24_ = _g_object_ref0 (_tmp23_);
						_g_object_unref0 (_tmp21_[_tmp22_]);
						_tmp21_[_tmp22_] = _tmp24_;
						_tmp25_ = _tmp21_[_tmp22_];
						_tmp26_ = i;
						i = _tmp26_ + 1;
					}
					_g_object_unref0 (devgroup);
				}
				_g_object_unref0 (_group_id_it);
			}
		}
		__finally103:
		{
			GeeHashMap* _tmp27_ = NULL;
			_tmp27_ = self->priv->groups;
			g_rec_mutex_unlock (&self->priv->__lock_groups);
		}
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			ret = (_vala_array_free (ret, ret_length1, (GDestroyNotify) g_object_unref), NULL);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp28_ = ret;
	_tmp28__length1 = ret_length1;
	if (result_length1) {
		*result_length1 = _tmp28__length1;
	}
	result = _tmp28_;
	return result;
}


static void dvb_manager_on_device_removed_from_group (DVBManager* self, DVBIDBusDeviceGroup* idevgroup, guint adapter, guint frontend) {
	DVBDeviceGroup* devgroup = NULL;
	DVBIDBusDeviceGroup* _tmp0_ = NULL;
	DVBDeviceGroup* _tmp1_ = NULL;
	guint group_id = 0U;
	DVBDeviceGroup* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	DVBDeviceGroup* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	gint _tmp7_ = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (idevgroup != NULL);
	_tmp0_ = idevgroup;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, DVB_TYPE_DEVICE_GROUP, DVBDeviceGroup));
	devgroup = _tmp1_;
	_tmp2_ = devgroup;
	_tmp3_ = dvb_device_group_get_Id (_tmp2_);
	_tmp4_ = _tmp3_;
	group_id = _tmp4_;
	_tmp5_ = devgroup;
	_tmp6_ = dvb_device_group_get_size (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_ == 0) {
		gboolean success = FALSE;
		gboolean _tmp13_ = FALSE;
		{
			GeeHashMap* _tmp8_ = NULL;
			_tmp8_ = self->priv->groups;
			g_rec_mutex_lock (&self->priv->__lock_groups);
			{
				GeeHashMap* _tmp9_ = NULL;
				guint _tmp10_ = 0U;
				gboolean _tmp11_ = FALSE;
				_tmp9_ = self->priv->groups;
				_tmp10_ = group_id;
				_tmp11_ = gee_abstract_map_unset ((GeeAbstractMap*) _tmp9_, (gpointer) ((guintptr) _tmp10_), NULL);
				success = _tmp11_;
			}
			__finally104:
			{
				GeeHashMap* _tmp12_ = NULL;
				_tmp12_ = self->priv->groups;
				g_rec_mutex_unlock (&self->priv->__lock_groups);
			}
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
		}
		_tmp13_ = success;
		if (_tmp13_) {
			gboolean lastest = FALSE;
			gboolean _tmp25_ = FALSE;
			DVBDeviceGroup* _tmp67_ = NULL;
			guint _tmp68_ = 0U;
			lastest = FALSE;
			{
				gboolean _tmp14_ = FALSE;
				DVBFactory* _tmp15_ = NULL;
				DVBFactory* _tmp16_ = NULL;
				DVBdatabaseConfigStore* _tmp17_ = NULL;
				DVBdatabaseConfigStore* _tmp18_ = NULL;
				guint _tmp19_ = 0U;
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				_tmp15_ = dvb_factory_new ();
				_tmp16_ = _tmp15_;
				_tmp17_ = dvb_factory_get_config_store (_tmp16_);
				_tmp18_ = _tmp17_;
				_tmp19_ = group_id;
				_tmp20_ = dvb_database_config_store_is_last_device (_tmp18_, _tmp19_, &_inner_error_);
				_tmp21_ = _tmp20_;
				_g_object_unref0 (_tmp18_);
				_g_object_unref0 (_tmp16_);
				_tmp14_ = _tmp21_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
						goto __catch105_dvb_database_sql_error;
					}
					_g_object_unref0 (devgroup);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				lastest = _tmp14_;
			}
			goto __finally105;
			__catch105_dvb_database_sql_error:
			{
				GError* e = NULL;
				DVBLoggingLogger* _tmp22_ = NULL;
				GError* _tmp23_ = NULL;
				const gchar* _tmp24_ = NULL;
				e = _inner_error_;
				_inner_error_ = NULL;
				_tmp22_ = dvb_manager_log;
				_tmp23_ = e;
				_tmp24_ = _tmp23_->message;
				dvb_logging_logger_error (_tmp22_, "Manager.vala:571: %s", _tmp24_);
				_g_error_free0 (e);
			}
			__finally105:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (devgroup);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			_tmp25_ = lastest;
			if (_tmp25_) {
				GstRTSPMountPoints* points = NULL;
				GstRTSPServer* _tmp26_ = NULL;
				GstRTSPMountPoints* _tmp27_ = NULL;
				_tmp26_ = dvb_rtsp_server_server;
				_tmp27_ = gst_rtsp_server_get_mount_points (_tmp26_);
				points = _tmp27_;
				{
					GeeIterator* _channel_it = NULL;
					DVBDeviceGroup* _tmp28_ = NULL;
					DVBChannelList* _tmp29_ = NULL;
					DVBChannelList* _tmp30_ = NULL;
					GeeIterator* _tmp31_ = NULL;
					_tmp28_ = devgroup;
					_tmp29_ = dvb_device_group_get_Channels (_tmp28_);
					_tmp30_ = _tmp29_;
					_tmp31_ = gee_iterable_iterator ((GeeIterable*) _tmp30_);
					_channel_it = _tmp31_;
					while (TRUE) {
						GeeIterator* _tmp32_ = NULL;
						gboolean _tmp33_ = FALSE;
						DVBChannel* channel = NULL;
						GeeIterator* _tmp34_ = NULL;
						gpointer _tmp35_ = NULL;
						GstRTSPMountPoints* _tmp36_ = NULL;
						DVBDeviceGroup* _tmp37_ = NULL;
						guint _tmp38_ = 0U;
						guint _tmp39_ = 0U;
						DVBChannel* _tmp40_ = NULL;
						guint _tmp41_ = 0U;
						guint _tmp42_ = 0U;
						gchar* _tmp43_ = NULL;
						gchar* _tmp44_ = NULL;
						_tmp32_ = _channel_it;
						_tmp33_ = gee_iterator_next (_tmp32_);
						if (!_tmp33_) {
							break;
						}
						_tmp34_ = _channel_it;
						_tmp35_ = gee_iterator_get (_tmp34_);
						channel = (DVBChannel*) _tmp35_;
						_tmp36_ = points;
						_tmp37_ = devgroup;
						_tmp38_ = dvb_device_group_get_Id (_tmp37_);
						_tmp39_ = _tmp38_;
						_tmp40_ = channel;
						_tmp41_ = dvb_channel_get_Sid (_tmp40_);
						_tmp42_ = _tmp41_;
						_tmp43_ = g_strdup_printf ("/%u/%u", _tmp39_, _tmp42_);
						_tmp44_ = _tmp43_;
						gst_rtsp_mount_points_remove_factory (_tmp36_, _tmp44_);
						_g_free0 (_tmp44_);
						_g_object_unref0 (channel);
					}
					_g_object_unref0 (_channel_it);
				}
				{
					DVBFactory* _tmp45_ = NULL;
					DVBFactory* _tmp46_ = NULL;
					DVBdatabaseConfigStore* _tmp47_ = NULL;
					DVBdatabaseConfigStore* _tmp48_ = NULL;
					DVBDeviceGroup* _tmp49_ = NULL;
					DVBFactory* _tmp50_ = NULL;
					DVBFactory* _tmp51_ = NULL;
					DVBdatabaseEPGStore* _tmp52_ = NULL;
					DVBdatabaseEPGStore* _tmp53_ = NULL;
					DVBDeviceGroup* _tmp54_ = NULL;
					guint _tmp55_ = 0U;
					guint _tmp56_ = 0U;
					DVBFactory* _tmp57_ = NULL;
					DVBFactory* _tmp58_ = NULL;
					DVBdatabaseTimersStore* _tmp59_ = NULL;
					DVBdatabaseTimersStore* _tmp60_ = NULL;
					DVBDeviceGroup* _tmp61_ = NULL;
					guint _tmp62_ = 0U;
					guint _tmp63_ = 0U;
					_tmp45_ = dvb_factory_new ();
					_tmp46_ = _tmp45_;
					_tmp47_ = dvb_factory_get_config_store (_tmp46_);
					_tmp48_ = _tmp47_;
					_tmp49_ = devgroup;
					dvb_database_config_store_remove_device_group (_tmp48_, _tmp49_, &_inner_error_);
					_g_object_unref0 (_tmp48_);
					_g_object_unref0 (_tmp46_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch106_dvb_database_sql_error;
						}
						_g_object_unref0 (points);
						_g_object_unref0 (devgroup);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp50_ = dvb_factory_new ();
					_tmp51_ = _tmp50_;
					_tmp52_ = dvb_factory_get_epg_store (_tmp51_);
					_tmp53_ = _tmp52_;
					_tmp54_ = devgroup;
					_tmp55_ = dvb_device_group_get_Id (_tmp54_);
					_tmp56_ = _tmp55_;
					dvb_database_epg_store_remove_events_of_group (_tmp53_, _tmp56_, &_inner_error_);
					_g_object_unref0 (_tmp53_);
					_g_object_unref0 (_tmp51_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch106_dvb_database_sql_error;
						}
						_g_object_unref0 (points);
						_g_object_unref0 (devgroup);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp57_ = dvb_factory_new ();
					_tmp58_ = _tmp57_;
					_tmp59_ = dvb_factory_get_timers_store (_tmp58_);
					_tmp60_ = _tmp59_;
					_tmp61_ = devgroup;
					_tmp62_ = dvb_device_group_get_Id (_tmp61_);
					_tmp63_ = _tmp62_;
					dvb_database_timers_store_remove_all_timers_from_device_group (_tmp60_, _tmp63_, &_inner_error_);
					_g_object_unref0 (_tmp60_);
					_g_object_unref0 (_tmp58_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
							goto __catch106_dvb_database_sql_error;
						}
						_g_object_unref0 (points);
						_g_object_unref0 (devgroup);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				goto __finally106;
				__catch106_dvb_database_sql_error:
				{
					GError* e = NULL;
					DVBLoggingLogger* _tmp64_ = NULL;
					GError* _tmp65_ = NULL;
					const gchar* _tmp66_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp64_ = dvb_manager_log;
					_tmp65_ = e;
					_tmp66_ = _tmp65_->message;
					dvb_logging_logger_error (_tmp64_, "Manager.vala:590: %s", _tmp66_);
					_g_error_free0 (e);
				}
				__finally106:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (points);
					_g_object_unref0 (devgroup);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				_g_object_unref0 (points);
			}
			_tmp67_ = devgroup;
			dvb_device_group_destroy (_tmp67_);
			_tmp68_ = group_id;
			g_signal_emit_by_name ((DVBIDBusManager*) self, "group-removed", _tmp68_);
		}
	}
	_g_object_unref0 (devgroup);
}


static DVBDeviceGroup* dvb_manager_create_device_group_by_id (DVBManager* self, guint group_id) {
	DVBDeviceGroup* result = NULL;
	DVBdatabaseConfigStore* config_store = NULL;
	DVBFactory* _tmp0_ = NULL;
	DVBFactory* _tmp1_ = NULL;
	DVBdatabaseConfigStore* _tmp2_ = NULL;
	DVBdatabaseConfigStore* _tmp3_ = NULL;
	DVBDeviceGroup* group = NULL;
	DVBDeviceGroup* _tmp13_ = NULL;
	DVBDeviceGroup* _tmp15_ = NULL;
	DVBDeviceGroup* _tmp16_ = NULL;
	DVBDeviceGroup* _tmp17_ = NULL;
	guint _tmp18_ = 0U;
	guint _tmp19_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = dvb_factory_new ();
	_tmp1_ = _tmp0_;
	_tmp2_ = dvb_factory_get_config_store (_tmp1_);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (_tmp1_);
	config_store = _tmp3_;
	group = NULL;
	{
		DVBDeviceGroup* _tmp4_ = NULL;
		DVBdatabaseConfigStore* _tmp5_ = NULL;
		guint _tmp6_ = 0U;
		DVBDeviceGroup* _tmp7_ = NULL;
		DVBDeviceGroup* _tmp8_ = NULL;
		_tmp5_ = config_store;
		_tmp6_ = group_id;
		_tmp7_ = dvb_database_config_store_get_device_group (_tmp5_, _tmp6_, &_inner_error_);
		_tmp4_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
				goto __catch107_dvb_database_sql_error;
			}
			_g_object_unref0 (group);
			_g_object_unref0 (config_store);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp8_ = _tmp4_;
		_tmp4_ = NULL;
		_g_object_unref0 (group);
		group = _tmp8_;
		_g_object_unref0 (_tmp4_);
	}
	goto __finally107;
	__catch107_dvb_database_sql_error:
	{
		GError* e = NULL;
		DVBLoggingLogger* _tmp9_ = NULL;
		guint _tmp10_ = 0U;
		GError* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp9_ = dvb_manager_log;
		_tmp10_ = group_id;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		dvb_logging_logger_error (_tmp9_, "Manager.vala:607: Error restoring group %u: %s", _tmp10_, _tmp12_);
		result = group;
		_g_error_free0 (e);
		_g_object_unref0 (config_store);
		return result;
	}
	__finally107:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (group);
		_g_object_unref0 (config_store);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp13_ = group;
	if (_tmp13_ == NULL) {
		DVBLoggingLogger* _tmp14_ = NULL;
		_tmp14_ = dvb_manager_log;
		dvb_logging_logger_debug (_tmp14_, "Manager.vala:612: device group is null");
	}
	_tmp15_ = group;
	dvb_manager_add_device_group (self, _tmp15_, FALSE);
	_tmp16_ = group;
	dvb_manager_restore_device_group_and_timers (self, _tmp16_);
	_tmp17_ = group;
	_tmp18_ = dvb_device_group_get_Id (_tmp17_);
	_tmp19_ = _tmp18_;
	g_signal_emit_by_name ((DVBIDBusManager*) self, "group-added", _tmp19_);
	result = group;
	_g_object_unref0 (config_store);
	return result;
}


static void dvb_manager_first_add_device (DVBManager* self, GUdevDevice* device) {
	gchar* dev_file = NULL;
	GUdevDevice* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	GUdevDevice* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	guint adapter = 0U;
	GUdevDevice* _tmp5_ = NULL;
	guint64 _tmp6_ = 0ULL;
	guint frontend = 0U;
	GUdevDevice* _tmp7_ = NULL;
	guint64 _tmp8_ = 0ULL;
	DVBDevice* dvb_device = NULL;
	GUdevDevice* _tmp9_ = NULL;
	const gchar* _tmp10_ = NULL;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	DVBDevice* _tmp13_ = NULL;
	GeeArrayList* _tmp14_ = NULL;
	DVBDevice* _tmp15_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (device != NULL);
	_tmp0_ = device;
	_tmp1_ = g_udev_device_get_device_file (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	dev_file = _tmp2_;
	_tmp3_ = device;
	_tmp4_ = g_udev_device_get_property (_tmp3_, "DVB_DEVICE_TYPE");
	if (g_strcmp0 (_tmp4_, "frontend") != 0) {
		_g_free0 (dev_file);
		return;
	}
	_tmp5_ = device;
	_tmp6_ = g_udev_device_get_property_as_uint64 (_tmp5_, "DVB_ADAPTER_NUM");
	adapter = (guint) _tmp6_;
	_tmp7_ = device;
	_tmp8_ = g_udev_device_get_property_as_uint64 (_tmp7_, "DVB_DEVICE_NUM");
	frontend = (guint) _tmp8_;
	_tmp9_ = device;
	_tmp10_ = dev_file;
	_tmp11_ = adapter;
	_tmp12_ = frontend;
	_tmp13_ = dvb_device_new_with_udev (_tmp9_, _tmp10_, _tmp11_, _tmp12_);
	dvb_device = _tmp13_;
	_tmp14_ = self->priv->devices;
	_tmp15_ = dvb_device;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp14_, _tmp15_);
	_g_object_unref0 (dvb_device);
	_g_free0 (dev_file);
}


static void dvb_manager_on_udev_event (DVBManager* self, const gchar* action, GUdevDevice* device) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (action != NULL);
	g_return_if_fail (device != NULL);
	_tmp1_ = action;
	if (g_strcmp0 (_tmp1_, "add") == 0) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = action;
		_tmp0_ = g_strcmp0 (_tmp2_, "remove") == 0;
	}
	if (_tmp0_) {
		gchar* dev_file = NULL;
		GUdevDevice* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		gchar* _tmp5_ = NULL;
		GUdevDevice* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		guint adapter = 0U;
		GUdevDevice* _tmp8_ = NULL;
		guint64 _tmp9_ = 0ULL;
		guint frontend = 0U;
		GUdevDevice* _tmp10_ = NULL;
		guint64 _tmp11_ = 0ULL;
		guint* group_ids = NULL;
		gint group_ids_length1 = 0;
		gint _group_ids_size_ = 0;
		gboolean found = FALSE;
		DVBdatabaseConfigStore* config_store = NULL;
		DVBFactory* _tmp12_ = NULL;
		DVBFactory* _tmp13_ = NULL;
		DVBdatabaseConfigStore* _tmp14_ = NULL;
		DVBdatabaseConfigStore* _tmp15_ = NULL;
		DVBLoggingLogger* _tmp25_ = NULL;
		const gchar* _tmp26_ = NULL;
		const gchar* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		const gchar* _tmp39_ = NULL;
		DVBLoggingLogger* _tmp99_ = NULL;
		GeeArrayList* _tmp100_ = NULL;
		gint _tmp101_ = 0;
		gint _tmp102_ = 0;
		gboolean _tmp103_ = FALSE;
		_tmp3_ = device;
		_tmp4_ = g_udev_device_get_device_file (_tmp3_);
		_tmp5_ = g_strdup (_tmp4_);
		dev_file = _tmp5_;
		_tmp6_ = device;
		_tmp7_ = g_udev_device_get_property (_tmp6_, "DVB_DEVICE_TYPE");
		if (g_strcmp0 (_tmp7_, "frontend") != 0) {
			_g_free0 (dev_file);
			return;
		}
		_tmp8_ = device;
		_tmp9_ = g_udev_device_get_property_as_uint64 (_tmp8_, "DVB_ADAPTER_NUM");
		adapter = (guint) _tmp9_;
		_tmp10_ = device;
		_tmp11_ = g_udev_device_get_property_as_uint64 (_tmp10_, "DVB_DEVICE_NUM");
		frontend = (guint) _tmp11_;
		found = FALSE;
		_tmp12_ = dvb_factory_new ();
		_tmp13_ = _tmp12_;
		_tmp14_ = dvb_factory_get_config_store (_tmp13_);
		_tmp15_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		config_store = _tmp15_;
		{
			gboolean _tmp16_ = FALSE;
			DVBdatabaseConfigStore* _tmp17_ = NULL;
			guint _tmp18_ = 0U;
			guint _tmp19_ = 0U;
			guint* _tmp20_ = NULL;
			gint _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			_tmp17_ = config_store;
			_tmp18_ = adapter;
			_tmp19_ = frontend;
			_tmp22_ = dvb_database_config_store_get_parent_groups (_tmp17_, _tmp18_, _tmp19_, &_tmp20_, &_tmp21_, &_inner_error_);
			group_ids = (g_free (group_ids), NULL);
			group_ids = _tmp20_;
			group_ids_length1 = _tmp21_;
			_group_ids_size_ = group_ids_length1;
			_tmp16_ = _tmp22_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				if (_inner_error_->domain == DVB_DATABASE_SQL_ERROR) {
					goto __catch108_dvb_database_sql_error;
				}
				_g_object_unref0 (config_store);
				group_ids = (g_free (group_ids), NULL);
				_g_free0 (dev_file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return;
			}
			found = _tmp16_;
		}
		goto __finally108;
		__catch108_dvb_database_sql_error:
		{
			GError* e = NULL;
			GError* _tmp23_ = NULL;
			const gchar* _tmp24_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp23_ = e;
			_tmp24_ = _tmp23_->message;
			g_critical ("Manager.vala:651: %s", _tmp24_);
			_g_error_free0 (e);
		}
		__finally108:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (config_store);
			group_ids = (g_free (group_ids), NULL);
			_g_free0 (dev_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp25_ = dvb_manager_log;
		_tmp26_ = action;
		_tmp27_ = dev_file;
		dvb_logging_logger_debug (_tmp25_, "Manager.vala:654: %s device %s", _tmp26_, _tmp27_);
		_tmp28_ = found;
		if (_tmp28_) {
			guint* _tmp29_ = NULL;
			gint _tmp29__length1 = 0;
			_tmp29_ = group_ids;
			_tmp29__length1 = group_ids_length1;
			{
				guint* group_id_collection = NULL;
				gint group_id_collection_length1 = 0;
				gint _group_id_collection_size_ = 0;
				gint group_id_it = 0;
				group_id_collection = _tmp29_;
				group_id_collection_length1 = _tmp29__length1;
				for (group_id_it = 0; group_id_it < _tmp29__length1; group_id_it = group_id_it + 1) {
					guint group_id = 0U;
					group_id = group_id_collection[group_id_it];
					{
						DVBLoggingLogger* _tmp30_ = NULL;
						guint _tmp31_ = 0U;
						DVBDeviceGroup* group = NULL;
						guint _tmp32_ = 0U;
						DVBDeviceGroup* _tmp33_ = NULL;
						DVBDeviceGroup* _tmp34_ = NULL;
						DVBDeviceGroup* _tmp37_ = NULL;
						_tmp30_ = dvb_manager_log;
						_tmp31_ = group_id;
						dvb_logging_logger_debug (_tmp30_, "Manager.vala:658: DeviceGroup ID: %u", _tmp31_);
						_tmp32_ = group_id;
						_tmp33_ = dvb_manager_get_device_group_if_exists (self, _tmp32_);
						group = _tmp33_;
						_tmp34_ = group;
						if (_tmp34_ == NULL) {
							guint _tmp35_ = 0U;
							DVBDeviceGroup* _tmp36_ = NULL;
							_tmp35_ = group_id;
							_tmp36_ = dvb_manager_create_device_group_by_id (self, _tmp35_);
							_g_object_unref0 (group);
							group = _tmp36_;
						}
						_tmp37_ = group;
						if (_tmp37_ != NULL) {
							DVBDeviceGroup* _tmp38_ = NULL;
							_tmp38_ = group;
							dvb_device_group_stop_epg_scanner (_tmp38_);
						}
						_g_object_unref0 (group);
					}
				}
			}
		}
		_tmp39_ = action;
		if (g_strcmp0 (_tmp39_, "add") == 0) {
			DVBDevice* dvb_device = NULL;
			GUdevDevice* _tmp40_ = NULL;
			const gchar* _tmp41_ = NULL;
			guint _tmp42_ = 0U;
			guint _tmp43_ = 0U;
			DVBDevice* _tmp44_ = NULL;
			GeeArrayList* _tmp45_ = NULL;
			DVBDevice* _tmp46_ = NULL;
			gboolean _tmp47_ = FALSE;
			_tmp40_ = device;
			_tmp41_ = dev_file;
			_tmp42_ = adapter;
			_tmp43_ = frontend;
			_tmp44_ = dvb_device_new_with_udev (_tmp40_, _tmp41_, _tmp42_, _tmp43_);
			dvb_device = _tmp44_;
			_tmp45_ = self->priv->devices;
			_tmp46_ = dvb_device;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp45_, _tmp46_);
			_tmp47_ = found;
			if (_tmp47_) {
				guint* _tmp48_ = NULL;
				gint _tmp48__length1 = 0;
				_tmp48_ = group_ids;
				_tmp48__length1 = group_ids_length1;
				{
					guint* group_id_collection = NULL;
					gint group_id_collection_length1 = 0;
					gint _group_id_collection_size_ = 0;
					gint group_id_it = 0;
					group_id_collection = _tmp48_;
					group_id_collection_length1 = _tmp48__length1;
					for (group_id_it = 0; group_id_it < _tmp48__length1; group_id_it = group_id_it + 1) {
						guint group_id = 0U;
						group_id = group_id_collection[group_id_it];
						{
							DVBDeviceGroup* group = NULL;
							guint _tmp49_ = 0U;
							DVBDeviceGroup* _tmp50_ = NULL;
							DVBDeviceGroup* _tmp51_ = NULL;
							_tmp49_ = group_id;
							_tmp50_ = dvb_manager_get_device_group_if_exists (self, _tmp49_);
							group = _tmp50_;
							_tmp51_ = group;
							if (_tmp51_ != NULL) {
								DVBDeviceGroup* _tmp52_ = NULL;
								DVBDevice* _tmp53_ = NULL;
								gboolean _tmp54_ = FALSE;
								_tmp52_ = group;
								_tmp53_ = dvb_device;
								_tmp54_ = dvb_device_group_add (_tmp52_, _tmp53_);
								if (_tmp54_) {
									DVBDeviceGroup* _tmp55_ = NULL;
									DVBDevice* _tmp56_ = NULL;
									guint _tmp57_ = 0U;
									guint _tmp58_ = 0U;
									DVBDevice* _tmp59_ = NULL;
									guint _tmp60_ = 0U;
									guint _tmp61_ = 0U;
									_tmp55_ = group;
									_tmp56_ = dvb_device;
									_tmp57_ = dvb_device_get_Adapter (_tmp56_);
									_tmp58_ = _tmp57_;
									_tmp59_ = dvb_device;
									_tmp60_ = dvb_device_get_Frontend (_tmp59_);
									_tmp61_ = _tmp60_;
									g_signal_emit_by_name ((DVBIDBusDeviceGroup*) _tmp55_, "device-added", _tmp58_, _tmp61_);
								}
							}
							_g_object_unref0 (group);
						}
					}
				}
			}
			_g_object_unref0 (dvb_device);
		} else {
			{
				GeeArrayList* _d_list = NULL;
				GeeArrayList* _tmp62_ = NULL;
				GeeArrayList* _tmp63_ = NULL;
				gint _d_size = 0;
				GeeArrayList* _tmp64_ = NULL;
				gint _tmp65_ = 0;
				gint _tmp66_ = 0;
				gint _d_index = 0;
				_tmp62_ = self->priv->devices;
				_tmp63_ = _g_object_ref0 (_tmp62_);
				_d_list = _tmp63_;
				_tmp64_ = _d_list;
				_tmp65_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp64_);
				_tmp66_ = _tmp65_;
				_d_size = _tmp66_;
				_d_index = -1;
				while (TRUE) {
					gint _tmp67_ = 0;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					DVBDevice* d = NULL;
					GeeArrayList* _tmp70_ = NULL;
					gint _tmp71_ = 0;
					gpointer _tmp72_ = NULL;
					gboolean _tmp73_ = FALSE;
					DVBDevice* _tmp74_ = NULL;
					guint _tmp75_ = 0U;
					guint _tmp76_ = 0U;
					guint _tmp77_ = 0U;
					gboolean _tmp84_ = FALSE;
					_tmp67_ = _d_index;
					_d_index = _tmp67_ + 1;
					_tmp68_ = _d_index;
					_tmp69_ = _d_size;
					if (!(_tmp68_ < _tmp69_)) {
						break;
					}
					_tmp70_ = _d_list;
					_tmp71_ = _d_index;
					_tmp72_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, _tmp71_);
					d = (DVBDevice*) _tmp72_;
					_tmp74_ = d;
					_tmp75_ = dvb_device_get_Frontend (_tmp74_);
					_tmp76_ = _tmp75_;
					_tmp77_ = frontend;
					if (_tmp76_ == _tmp77_) {
						DVBDevice* _tmp78_ = NULL;
						guint _tmp79_ = 0U;
						guint _tmp80_ = 0U;
						guint _tmp81_ = 0U;
						_tmp78_ = d;
						_tmp79_ = dvb_device_get_Adapter (_tmp78_);
						_tmp80_ = _tmp79_;
						_tmp81_ = adapter;
						_tmp73_ = _tmp80_ == _tmp81_;
					} else {
						_tmp73_ = FALSE;
					}
					if (_tmp73_) {
						GeeArrayList* _tmp82_ = NULL;
						DVBDevice* _tmp83_ = NULL;
						_tmp82_ = self->priv->devices;
						_tmp83_ = d;
						gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp82_, _tmp83_);
					}
					_tmp84_ = found;
					if (_tmp84_) {
						guint* _tmp85_ = NULL;
						gint _tmp85__length1 = 0;
						_tmp85_ = group_ids;
						_tmp85__length1 = group_ids_length1;
						{
							guint* group_id_collection = NULL;
							gint group_id_collection_length1 = 0;
							gint _group_id_collection_size_ = 0;
							gint group_id_it = 0;
							group_id_collection = _tmp85_;
							group_id_collection_length1 = _tmp85__length1;
							for (group_id_it = 0; group_id_it < _tmp85__length1; group_id_it = group_id_it + 1) {
								guint group_id = 0U;
								group_id = group_id_collection[group_id_it];
								{
									DVBDeviceGroup* group = NULL;
									guint _tmp86_ = 0U;
									DVBDeviceGroup* _tmp87_ = NULL;
									DVBDeviceGroup* _tmp88_ = NULL;
									_tmp86_ = group_id;
									_tmp87_ = dvb_manager_get_device_group_if_exists (self, _tmp86_);
									group = _tmp87_;
									_tmp88_ = group;
									if (_tmp88_ != NULL) {
										DVBDeviceGroup* _tmp89_ = NULL;
										DVBDevice* _tmp90_ = NULL;
										gboolean _tmp91_ = FALSE;
										_tmp89_ = group;
										_tmp90_ = d;
										_tmp91_ = dvb_device_group_remove (_tmp89_, _tmp90_);
										if (_tmp91_) {
											DVBDeviceGroup* _tmp92_ = NULL;
											DVBDevice* _tmp93_ = NULL;
											guint _tmp94_ = 0U;
											guint _tmp95_ = 0U;
											DVBDevice* _tmp96_ = NULL;
											guint _tmp97_ = 0U;
											guint _tmp98_ = 0U;
											_tmp92_ = group;
											_tmp93_ = d;
											_tmp94_ = dvb_device_get_Adapter (_tmp93_);
											_tmp95_ = _tmp94_;
											_tmp96_ = d;
											_tmp97_ = dvb_device_get_Frontend (_tmp96_);
											_tmp98_ = _tmp97_;
											g_signal_emit_by_name ((DVBIDBusDeviceGroup*) _tmp92_, "device-removed", _tmp95_, _tmp98_);
										}
									}
									_g_object_unref0 (group);
								}
							}
						}
					}
					_g_object_unref0 (d);
				}
				_g_object_unref0 (_d_list);
			}
		}
		_tmp99_ = dvb_manager_log;
		_tmp100_ = self->priv->devices;
		_tmp101_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp100_);
		_tmp102_ = _tmp101_;
		dvb_logging_logger_debug (_tmp99_, "Manager.vala:706: Numbers of devices %u", (guint) _tmp102_);
		_tmp103_ = found;
		if (_tmp103_) {
			guint* _tmp104_ = NULL;
			gint _tmp104__length1 = 0;
			_tmp104_ = group_ids;
			_tmp104__length1 = group_ids_length1;
			{
				guint* group_id_collection = NULL;
				gint group_id_collection_length1 = 0;
				gint _group_id_collection_size_ = 0;
				gint group_id_it = 0;
				group_id_collection = _tmp104_;
				group_id_collection_length1 = _tmp104__length1;
				for (group_id_it = 0; group_id_it < _tmp104__length1; group_id_it = group_id_it + 1) {
					guint group_id = 0U;
					group_id = group_id_collection[group_id_it];
					{
						DVBDeviceGroup* group = NULL;
						guint _tmp105_ = 0U;
						DVBDeviceGroup* _tmp106_ = NULL;
						DVBDeviceGroup* _tmp107_ = NULL;
						_tmp105_ = group_id;
						_tmp106_ = dvb_manager_get_device_group_if_exists (self, _tmp105_);
						group = _tmp106_;
						_tmp107_ = group;
						if (_tmp107_ != NULL) {
							DVBDeviceGroup* _tmp108_ = NULL;
							_tmp108_ = group;
							dvb_device_group_start_epg_scanner (_tmp108_);
						}
						_g_object_unref0 (group);
					}
				}
			}
		}
		_g_object_unref0 (config_store);
		group_ids = (g_free (group_ids), NULL);
		_g_free0 (dev_file);
	}
}


DVBManager* dvb_manager_construct (GType object_type) {
	DVBManager * self = NULL;
	self = (DVBManager*) g_object_new (object_type, NULL);
	return self;
}


DVBManager* dvb_manager_new (void) {
	return dvb_manager_construct (DVB_TYPE_MANAGER);
}


GeeCollection* dvb_manager_get_device_groups (DVBManager* self) {
	GeeCollection* result;
	GeeHashMap* _tmp0_ = NULL;
	GeeCollection* _tmp1_ = NULL;
	GeeCollection* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->groups;
	_tmp1_ = gee_abstract_map_get_values ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}


GeeArrayList* dvb_manager_get_devs (DVBManager* self) {
	GeeArrayList* result;
	GeeArrayList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->devices;
	result = _tmp0_;
	return result;
}


static void _dvb_manager_on_udev_event_g_udev_client_uevent (GUdevClient* _sender, const gchar* action, GUdevDevice* device, gpointer self) {
	dvb_manager_on_udev_event ((DVBManager*) self, action, device);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static GObject * dvb_manager_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	DVBManager * self;
	void* _tmp0_ = NULL;
	GDestroyNotify _tmp1_ = NULL;
	GeeHashDataFunc _tmp2_ = NULL;
	void* _tmp3_ = NULL;
	GDestroyNotify _tmp4_ = NULL;
	GeeEqualDataFunc _tmp5_ = NULL;
	void* _tmp6_ = NULL;
	GDestroyNotify _tmp7_ = NULL;
	GeeEqualDataFunc _tmp8_ = NULL;
	GeeHashMap* _tmp9_ = NULL;
	GeeHashMap* _tmp10_ = NULL;
	GeeArrayList* _tmp11_ = NULL;
	GUdevClient* _tmp12_ = NULL;
	GUdevClient* _tmp13_ = NULL;
	GList* devs = NULL;
	GUdevClient* _tmp14_ = NULL;
	GList* _tmp15_ = NULL;
	GList* _tmp16_ = NULL;
	parent_class = G_OBJECT_CLASS (dvb_manager_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_MANAGER, DVBManager);
	_tmp2_ = gee_functions_get_hash_func_for (G_TYPE_STRING, &_tmp0_, &_tmp1_);
	_tmp5_ = gee_functions_get_equal_func_for (G_TYPE_STRING, &_tmp3_, &_tmp4_);
	_tmp8_ = gee_functions_get_equal_func_for (DVB_MANAGER_TYPE_SCANNER_DATA, &_tmp6_, &_tmp7_);
	_tmp9_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, DVB_MANAGER_TYPE_SCANNER_DATA, (GBoxedCopyFunc) g_object_ref, g_object_unref, _tmp2_, _tmp0_, _tmp1_, _tmp5_, _tmp3_, _tmp4_, _tmp8_, _tmp6_, _tmp7_);
	_g_object_unref0 (self->priv->scanners);
	self->priv->scanners = _tmp9_;
	_tmp10_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, DVB_TYPE_DEVICE_GROUP, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->groups);
	self->priv->groups = _tmp10_;
	_tmp11_ = gee_array_list_new (DVB_TYPE_DEVICE, (GBoxedCopyFunc) g_object_ref, g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->devices);
	self->priv->devices = _tmp11_;
	self->priv->device_group_counter = (guint) 0;
	_tmp12_ = g_udev_client_new (DVB_MANAGER_UDEV_SUBSYSTEMS);
	_g_object_unref0 (self->priv->udev_client);
	self->priv->udev_client = _tmp12_;
	_tmp13_ = self->priv->udev_client;
	g_signal_connect_object (_tmp13_, "uevent", (GCallback) _dvb_manager_on_udev_event_g_udev_client_uevent, self, 0);
	_tmp14_ = self->priv->udev_client;
	_tmp15_ = g_udev_client_query_by_subsystem (_tmp14_, "dvb");
	devs = _tmp15_;
	_tmp16_ = devs;
	{
		GList* dev_collection = NULL;
		GList* dev_it = NULL;
		dev_collection = _tmp16_;
		for (dev_it = dev_collection; dev_it != NULL; dev_it = dev_it->next) {
			GUdevDevice* _tmp17_ = NULL;
			GUdevDevice* dev = NULL;
			_tmp17_ = _g_object_ref0 ((GUdevDevice*) dev_it->data);
			dev = _tmp17_;
			{
				GUdevDevice* _tmp18_ = NULL;
				_tmp18_ = dev;
				dvb_manager_first_add_device (self, _tmp18_);
				_g_object_unref0 (dev);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (devs);
	return obj;
}


static DVBManagerScannerData* dvb_manager_scanner_data_construct (GType object_type) {
	DVBManagerScannerData * self = NULL;
	self = (DVBManagerScannerData*) g_object_new (object_type, NULL);
	return self;
}


static DVBManagerScannerData* dvb_manager_scanner_data_new (void) {
	return dvb_manager_scanner_data_construct (DVB_MANAGER_TYPE_SCANNER_DATA);
}


static void dvb_manager_scanner_data_class_init (DVBManagerScannerDataClass * klass) {
	dvb_manager_scanner_data_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_scanner_data_finalize;
}


static void dvb_manager_scanner_data_instance_init (DVBManagerScannerData * self) {
}


static void dvb_manager_scanner_data_finalize (GObject* obj) {
	DVBManagerScannerData * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_MANAGER_TYPE_SCANNER_DATA, DVBManagerScannerData);
	_g_object_unref0 (self->scanner);
	G_OBJECT_CLASS (dvb_manager_scanner_data_parent_class)->finalize (obj);
}


static GType dvb_manager_scanner_data_get_type (void) {
	static volatile gsize dvb_manager_scanner_data_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_manager_scanner_data_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerScannerDataClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_scanner_data_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManagerScannerData), 0, (GInstanceInitFunc) dvb_manager_scanner_data_instance_init, NULL };
		GType dvb_manager_scanner_data_type_id;
		dvb_manager_scanner_data_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManagerScannerData", &g_define_type_info, 0);
		g_once_init_leave (&dvb_manager_scanner_data_type_id__volatile, dvb_manager_scanner_data_type_id);
	}
	return dvb_manager_scanner_data_type_id__volatile;
}


static void dvb_manager_class_init (DVBManagerClass * klass) {
	DVBLoggingLogManager* _tmp0_ = NULL;
	DVBLoggingLogger* _tmp1_ = NULL;
	dvb_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DVBManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_dvb_manager_get_property;
	G_OBJECT_CLASS (klass)->constructor = dvb_manager_constructor;
	G_OBJECT_CLASS (klass)->finalize = dvb_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MANAGER_DEVICE_GROUPS, g_param_spec_object ("device-groups", "device-groups", "device-groups", GEE_TYPE_COLLECTION, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), DVB_MANAGER_DEVS, g_param_spec_object ("devs", "devs", "devs", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	_tmp0_ = dvb_logging_log_manager_getLogManager ();
	_tmp1_ = dvb_logging_log_manager_getDefaultLogger (_tmp0_);
	dvb_manager_log = _tmp1_;
	g_rec_mutex_init (&dvb_manager_instance_mutex);
	dvb_manager_instance_mutex = dvb_manager_instance_mutex;
}


static void dvb_manager_dvb_id_bus_manager_interface_init (DVBIDBusManagerIface * iface) {
	dvb_manager_dvb_id_bus_manager_parent_iface = g_type_interface_peek_parent (iface);
	iface->GetScannerForDevice = (gboolean (*)(DVBIDBusManager*, guint, guint, DVBAdapterType, char**, gchar**, GError**)) dvb_manager_real_GetScannerForDevice;
	iface->GetDeviceGroup = (gboolean (*)(DVBIDBusManager*, guint, char**, GError**)) dvb_manager_real_GetDeviceGroup;
	iface->GetRegisteredDeviceGroups = (char** (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetRegisteredDeviceGroups;
	iface->AddDeviceToNewGroup = (gboolean (*)(DVBIDBusManager*, guint, guint, DVBAdapterType, const gchar*, const gchar*, const gchar*, GError**)) dvb_manager_real_AddDeviceToNewGroup;
	iface->GetNameOfRegisteredDevice = (gboolean (*)(DVBIDBusManager*, guint, guint, gchar**, GError**)) dvb_manager_real_GetNameOfRegisteredDevice;
	iface->GetDeviceGroupSize = (gint (*)(DVBIDBusManager*, GError**)) dvb_manager_real_GetDeviceGroupSize;
	iface->GetChannelGroups = (DVBChannelGroupInfo* (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetChannelGroups;
	iface->AddChannelGroup = (gboolean (*)(DVBIDBusManager*, const gchar*, gint*, GError**)) dvb_manager_real_AddChannelGroup;
	iface->RemoveChannelGroup = (gboolean (*)(DVBIDBusManager*, gint, GError**)) dvb_manager_real_RemoveChannelGroup;
	iface->GetDevices = (GHashTable** (*)(DVBIDBusManager*, int*, GError**)) dvb_manager_real_GetDevices;
	iface->GetAdapterInfo = (gboolean (*)(DVBIDBusManager*, guint, guint, DVBAdapterInfo*, GError**)) dvb_manager_real_GetAdapterInfo;
}


static void dvb_manager_instance_init (DVBManager * self) {
	self->priv = DVB_MANAGER_GET_PRIVATE (self);
	g_rec_mutex_init (&self->priv->__lock_scanners);
	g_rec_mutex_init (&self->priv->__lock_groups);
	g_rec_mutex_init (&self->priv->__lock_devices);
}


static void dvb_manager_finalize (GObject* obj) {
	DVBManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, DVB_TYPE_MANAGER, DVBManager);
	g_rec_mutex_clear (&self->priv->__lock_scanners);
	_g_object_unref0 (self->priv->scanners);
	g_rec_mutex_clear (&self->priv->__lock_groups);
	_g_object_unref0 (self->priv->groups);
	g_rec_mutex_clear (&self->priv->__lock_devices);
	_g_object_unref0 (self->priv->devices);
	_g_object_unref0 (self->priv->udev_client);
	G_OBJECT_CLASS (dvb_manager_parent_class)->finalize (obj);
}


GType dvb_manager_get_type (void) {
	static volatile gsize dvb_manager_type_id__volatile = 0;
	if (g_once_init_enter (&dvb_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DVBManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dvb_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DVBManager), 0, (GInstanceInitFunc) dvb_manager_instance_init, NULL };
		static const GInterfaceInfo dvb_id_bus_manager_info = { (GInterfaceInitFunc) dvb_manager_dvb_id_bus_manager_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType dvb_manager_type_id;
		dvb_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "DVBManager", &g_define_type_info, 0);
		g_type_add_interface_static (dvb_manager_type_id, DVB_TYPE_ID_BUS_MANAGER, &dvb_id_bus_manager_info);
		g_once_init_leave (&dvb_manager_type_id__volatile, dvb_manager_type_id);
	}
	return dvb_manager_type_id__volatile;
}


static void _vala_dvb_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	DVBManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, DVB_TYPE_MANAGER, DVBManager);
	switch (property_id) {
		case DVB_MANAGER_DEVICE_GROUPS:
		g_value_take_object (value, dvb_manager_get_device_groups (self));
		break;
		case DVB_MANAGER_DEVS:
		g_value_set_object (value, dvb_manager_get_devs (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



