package peripherals

import (
	"reflect"

	"pkg.deepin.io/daemon/sync/infrastructure/utils"
	. "pkg.deepin.io/daemon/sync/modules/model"
)

type Mouse struct {
	NaturalScroll bool `json:"natural_scroll"`
}
type Touchpad struct {
	NaturalScroll bool `json:"natural_scroll"`
}

type Data struct {
	Version  string    `json:"version"`
	Mouse    *Mouse    `json:"mouse"`
	Touchpad *Touchpad `json:"touchpad"`
}

const (
	Name = "peripherals"
)

func (core *Data) Name() string {
	return Name
}

func (core *Data) Model() interface{} {
	return &Data{}
}

func (core *Data) ToIFC(v interface{}) DataIFC {
	return v.(*Data)
}

func (core *Data) Equal(target DataIFC) bool {
	info := target.(*Data)
	return reflect.DeepEqual(core, info)
}

func (core *Data) GenCache(DataIFC) DataIFC {
	return core
}

func (core *Data) Merge(current, cache DataIFC) {
	curInfo := current.(*Data)
	cacheInfo := cache.(*Data)
	utils.MergeBool(&core.Mouse.NaturalScroll, curInfo.Mouse.NaturalScroll,
		cacheInfo.Mouse.NaturalScroll)
	utils.MergeBool(&core.Touchpad.NaturalScroll, curInfo.Touchpad.NaturalScroll,
		cacheInfo.Touchpad.NaturalScroll)
}
