package utils

import (
	"testing"
)

func TestStrInList(t *testing.T) {
	var list = []string{"abc", "xyz", "123"}
	if StrInList("", list) {
		panic("Function error")
	}
	if !StrInList("123", list) {
		panic("Function error")
	}
	if StrInList("123", nil) {
		panic("Function error")
	}
}

func TestStrvEqual(t *testing.T) {
	var list = []string{"abc", "xyz", "123"}
	var list2 = []string{"abc", "123", "xyz"}
	if StrvEqual(list2, list, false) {
		panic("Function error")
	}
	if !StrvEqual(list2, list, true) {
		panic("Function error")
	}
	if StrvEqual([]string{"abc"}, list, true) {
		panic("Function error")
	}
	if StrvEqual(nil, list, true) {
		panic("Function error")
	}
}

func TestTrimFileURI(t *testing.T) {
	if TrimFileURI("file:///usr") != "/usr" {
		panic("Function error")
	}
	if TrimFileURI("/usr") != "/usr" {
		panic("Function error")
	}
}
