package storage

import (
	"os"
)

const (
	API           = "https://sync.deepinid.deepin.com/api/v1"
	DEEPINID_API  = "https://api.deepinid.deepin.com/v1"
	AuthToken     = "Access-Token"
	AuthMachineID = "X-Machine-ID"
)

func SyncServerAPI() string {
	return getServerAPI("DEEPIN_SYNC_SERVER_API", API)
}

func DeepinIDServerAPI() string {
	return getServerAPI("DEEPIN_DEEPINID_SERVER_API", DEEPINID_API)
}

func getServerAPI(env, value string) string {
	api := os.Getenv(env)
	if len(api) == 0 {
		api = value
	}
	return api
}
