package main

import (
	"fmt"
	"io/ioutil"
	"os"
	"path/filepath"
	"strconv"
)

const (
	tokenFilePath   = ".config/deepin/deepin-sync-daemon/token"
	machineFilePath = ".config/deepin/deepin-sync-daemon/machine_data"

	lastSyncTimePrefix = ".cache/deepin/deepin-sync-daemon"
)

func loadMachineData() ([]byte, error) {
	filename := filepath.Join(os.Getenv("HOME"), machineFilePath)
	return ioutil.ReadFile(filename)
}

func saveMachineData(data []byte) error {
	filename := filepath.Join(os.Getenv("HOME"), machineFilePath)
	err := ensureParentDirExists(filename)
	if err != nil {
		return err
	}
	return ioutil.WriteFile(filename, data, 0644)
}

func getLastSyncTime(uid int64) (int64, error) {
	filename := filepath.Join(os.Getenv("HOME"), lastSyncTimePrefix,
		fmt.Sprintf("%d_last_sync_time", uid))
	data, err := ioutil.ReadFile(filename)
	if err != nil {
		return 0, err
	}
	return strconv.ParseInt(string(data), 10, 64)
}

func setLastSyncTime(uid, timestamp int64) error {
	filename := filepath.Join(os.Getenv("HOME"), lastSyncTimePrefix,
		fmt.Sprintf("%d_last_sync_time", uid))
	err := ensureParentDirExists(filename)
	if err != nil {
		return err
	}
	return ioutil.WriteFile(filename, []byte(fmt.Sprint(timestamp)), 0644)
}

func ensureParentDirExists(filename string) error {
	return os.MkdirAll(filepath.Dir(filename), 0755)
}
