#include "tui.h"
#include "util.h"
#include <dialog.h>

extern menu_item_t tui_all_menu[];
extern tui_cfg g_cfg;

void init_tui_dialog() {
    dialog_vars.nocancel = true;
    dialog_state.use_shadow = false;
    if (g_cfg.b_debug)
        dlg_trace("/tmp/tui_dlg_trace.log");
}

int create_menu(const menu_args *arg) {    
    int i = 0,item_num = 0,ret = TERROR,ret1;
    char **items = NULL;

    if (!arg)
        return TERROR;
    for (i=0;i<MAX_ITEMS_NUM;i++) {
        if (arg->menus[i] == 0)
            break;
    }
    if (i==0)
        return TERROR;
    item_num = i;
    items = malloc(item_num*2*sizeof(char*));
    if (!items)
        return TERROR;
    memset(items,0,item_num*2*sizeof(char*));
    for (i=0;i<item_num;i++) {
        items[i*2]=malloc(8);
        items[i*2+1]=malloc(MAX_ITEM_NAME_LEN);
        if (!items[i*2] || !items[i*2+1])
            goto fail;
        sprintf(items[i*2],"%d",i+1);
        strncpy(items[i*2+1],tui_all_menu[arg->menus[i]].item_str,MAX_ITEM_NAME_LEN);
    }
    
    init_dialog(stdin, stdout);
    dlg_clr_result();
    ret1 = dialog_menu(arg->title, arg->content, arg->height, arg->width, 
        arg->menu_height, item_num, items);
    end_dialog();    

    if (dialog_vars.input_result)        
        sscanf(dialog_vars.input_result,"%d",&ret);
    TUI_LOG(("menu result %s ret: %d\n",dialog_vars.input_result,ret));
    if (ret1 == DLG_EXIT_ESC)
        ret = DLG_EXIT_ESC;
    else if (ret<1 || ret>item_num)
        ret = TERROR;
    else
        ret = arg->menus[ret-1];

fail:
    for (i=0;i<item_num*2;i++) {
        if (items[i])
            free(items[i]);
    }
    free(items);
    return ret;
}

int create_yesno(const char *title,const char *content,int height,
        int width,char *yes_l,char *no_l) {
    int ret=TERROR;
    char *yes_bak,*no_bak;

    if (yes_l) {
        yes_bak = dialog_vars.yes_label;
        dialog_vars.yes_label = yes_l;
    }
    if (no_l) {
        no_bak = dialog_vars.no_label;
        dialog_vars.no_label = no_l;
    }
    init_dialog(stdin, stdout);
    dlg_clr_result();
    ret = dialog_yesno(title, content, height, width);
    end_dialog();
    TUI_LOG(("yesno ret %d\n",ret));
    if (yes_l)
        dialog_vars.yes_label = yes_bak;
    if (no_l)
        dialog_vars.no_label = no_bak;
    
    return ret;
}

int create_infobox(const char *title,const char *content,int height,int width) {
    int ret=TERROR;

    init_dialog(stdin, stdout);
    dlg_clr_result();
    ret = dialog_msgbox(title, content, height, width,0);
    TUI_LOG(("infobox ret %d\n",ret));
    
    return ret;
}

void end_infobox() {
    end_dialog();
}