/* yForth? - A Forth interpreter written in ANSI C
 * Copyright (C) 2012 Luca Padovani
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * ------------------------------------------------------------------------
 * Module name:     block.h
 * Abstract:        Block word set header file
 */

#ifdef DECLARE_WORDS
#	ifdef PROTOTYPES
#		undef PROTOTYPES
#	endif
#	undef __BLOCK_H__
#else
#	ifndef PROTOTYPES
#		define PROTOTYPES
#	endif
#endif

#ifndef __BLOCK_H__
#define __BLOCK_H__

#include "yforth.h"
#include "macro.h"

/**************************************************************************/
/* VARIABLES **************************************************************/
/**************************************************************************/

#ifdef PROTOTYPES

struct _block_data {                /* Entry in the table of blocks */
    UCell block_no;                 /* Block number */
    Cell dirty;                     /* Block updated */
};

struct _block_buffer {              /* Simply an array of Char */
	Char buffer[BLOCK_SIZE];
};

extern FILE *block_file;

extern struct _block_data *block_data;
extern struct _block_buffer *block_buffer;

extern UCell current_block;

#endif

variable(UCell, b_l_k,						"blk")

/**************************************************************************/
/* PROTOTYPES *************************************************************/
/**************************************************************************/

code(block,					"block",					0)
code(buffer,				"buffer",					0)
code(flush,					"flush",					0)
code(load,					"load",						0)
code(save_buffers,			"save-buffers",				0)
code(update,				"update",					0)

#ifdef PROTOTYPES

/**************************************************************************/
/* AUXILIARY FUNCTIONS PROTOTYPES *****************************************/
/**************************************************************************/

int search_block(UCell block_no);
int allocate_block(UCell block_no, int load);
void load_block(UCell block_no, int b);
void save_block(int b);
int open_block_file(char *name);
void close_block_file(void);

#endif

#endif

