/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix;

import cds.healpix.BaseHash;
import cds.healpix.BaseHashes;
import cds.healpix.CompassPoint;
import cds.healpix.FlatHashList;
import cds.healpix.HashComputer;
import cds.healpix.Healpix;
import cds.healpix.HealpixNested;
import cds.healpix.NeighbourList;
import cds.healpix.NeighbourSelector;
import cds.healpix.VerticesAndPathComputer;
import cds.healpix.common.math.FastMath;
import cds.healpix.common.math.HackersDelight;
import cds.healpix.common.math.Math;
import cds.healpix.fillingcurve.FillingCurve2D;
import cds.healpix.fillingcurve.FillingCurve2DType;
import java.util.EnumMap;
import java.util.EnumSet;

public final class HealpixNestedFast
implements HashComputer,
VerticesAndPathComputer,
NeighbourSelector {
    public static final byte[][] D0H_NEIGHBOURS = new byte[][]{{1, 2, 3, 4, 5, 8}, {0, 2, 3, 5, 6, 9}, {0, 1, 3, 6, 7, 10}, {0, 1, 2, 4, 7, 11}, {0, 3, 5, 7, 8, 11}, {0, 1, 4, 6, 8, 9}, {1, 2, 5, 7, 9, 10}, {2, 3, 4, 6, 10, 11}, {0, 4, 5, 9, 10, 11}, {1, 5, 6, 8, 10, 11}, {2, 6, 7, 8, 9, 11}, {3, 4, 7, 8, 9, 10}};
    public static final byte[][][] NEIGHBOURS = new byte[12][][];
    private final int depth;
    private final int twiceDepth;
    private final int nside;
    private final int twiceNside;
    private final long halfNside4IEEEdouble;
    private final double halfNside;
    private final double oneOverNside;
    private final double piOverFourNside;
    private final int nsideRemainderMask;
    private final long nHash;
    private final int modNsideMask;
    private final long d0Mask;
    private final long xyMask;
    private final long xMask;
    private final long yMask;
    private final FillingCurve2D fc;

    public HealpixNestedFast(int depth, FillingCurve2DType fillingCurveType) {
        this.depth = depth;
        this.nside = Healpix.nside(this.depth);
        this.twiceNside = this.nside << 1;
        this.halfNside4IEEEdouble = Healpix.halfNside4IEEEdouble(depth);
        this.halfNside = this.nside >> 1;
        this.oneOverNside = 1.0 / (double)this.nside;
        this.piOverFourNside = 0.7853981633974483 * this.oneOverNside;
        this.twiceDepth = this.depth << 1;
        this.nsideRemainderMask = this.nside - 1;
        this.nHash = Healpix.nHash(this.depth);
        this.d0Mask = 15L << this.twiceDepth;
        this.xyMask = (1L << this.twiceDepth) - 1L;
        this.xMask = 0x5555555555555555L >>> 64 - this.twiceDepth;
        this.yMask = -6148914691236517206L >>> 64 - this.twiceDepth;
        this.modNsideMask = this.nside - 1;
        this.fc = fillingCurveType.get(depth);
    }

    @Override
    public int depth() {
        return this.depth;
    }

    @Override
    public long hash(double lonRad, double latRad) {
        long d0h;
        int j;
        int i;
        Healpix.checkLatitude(latRad);
        double absLon = HackersDelight.fromBits(HackersDelight.toBits(lonRad) & Long.MAX_VALUE);
        assert (0.0 <= absLon && absLon <= 62.83185307179586) : absLon;
        long signLat = HackersDelight.toBits(latRad);
        assert (latRad == HackersDelight.fromBits(signLat));
        double absLat = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
        assert (0.0 <= absLat && absLat <= 1.5707963267948966);
        assert ((signLat &= Long.MIN_VALUE) == 0L || signLat == Long.MIN_VALUE);
        double x = 1.2732395447351628 * absLon;
        int xfloor = (int)x;
        assert (-1.0 <= (x -= (double)(xfloor | 1)) && x <= 1.0);
        if (lonRad < 0.0) {
            x = -x;
            xfloor = 7 - (xfloor & 7);
        }
        if (absLat <= Healpix.TRANSITION_LATITUDE) {
            double y = FastMath.sinQ(absLat, 0.0);
            assert (0.0 <= y && y <= 0.6666666666666666);
            assert ((y *= 1.5) <= 1.0);
            y = HackersDelight.fromBits(signLat | HackersDelight.toBits(y));
            assert (-1.0 <= y && y <= 1.0);
            assert (1.0 <= (y += 2.0) && y <= 3.0);
            i = (int)HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(y + x));
            assert (0 <= i && i <= 2 * this.nside);
            if (i == this.twiceNside) {
                --i;
            }
            j = (int)HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(y - x));
            assert (0 <= j && j <= 2 * this.nside);
            if (j == this.twiceNside) {
                --j;
            }
            int id0c = i >>> this.depth;
            assert (id0c == 0 || id0c == 1);
            int jd0c = j >>> this.depth;
            assert (jd0c == 0 || jd0c == 1);
            int zeroOr1 = id0c ^ jd0c;
            assert (zeroOr1 == 0 || zeroOr1 == 1);
            int zeroOr4Or8 = 2 >>> id0c + jd0c << 2;
            assert (zeroOr4Or8 == 0 || zeroOr4Or8 == 4 || zeroOr4Or8 == 8);
            d0h = zeroOr4Or8 | (xfloor + zeroOr1 & 7) >> 1;
            assert (0L <= d0h && d0h < 12L);
            assert (0 <= (i &= this.nsideRemainderMask) && i < this.nside);
            assert (0 <= (j &= this.nsideRemainderMask) && j < this.nside);
        } else {
            double y = Math.SQRT6 * FastMath.cosQ(0.5 * absLat + 0.7853981633974483);
            assert (0.0 <= y && y < 1.0);
            assert (-1.0 <= (x *= y) && x <= 1.0);
            d0h = (xfloor & 7) >> 1;
            i = (int)HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(x + y));
            assert (0 <= i && i < this.nside);
            j = (int)HackersDelight.fromBits(this.halfNside4IEEEdouble + HackersDelight.toBits(y - x));
            assert (0 <= j && j < this.nside);
            if (signLat == 0L) {
                xfloor = i;
                i = this.nsideRemainderMask - j;
                assert (0 <= i && i < this.nside);
                j = this.nsideRemainderMask - xfloor;
                assert (0 <= j && j < this.nside);
            } else assert (8L <= (d0h |= 8L) && d0h < 12L);
        }
        return d0h << this.twiceDepth | this.fc.ij2hash(i, j);
    }

    @Override
    public double[] center(long hash) {
        double[] resultLonLat = new double[2];
        this.center(hash, resultLonLat);
        return resultLonLat;
    }

    @Override
    public void center(long hash, double[] resultLonLat) {
        this.checkHashRange(hash);
        int d0h = (int)(hash >> this.twiceDepth);
        assert (0 <= d0h && d0h < 12);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        assert (0 <= iInD0h && iInD0h < this.nside);
        int jInD0h = this.fc.ij2j(hash);
        assert (0 <= jInD0h && jInD0h < this.nside);
        int lInD0h = iInD0h - jInD0h;
        assert (-this.nside < lInD0h && lInD0h < this.nside);
        int hInD0h = iInD0h + jInD0h - this.modNsideMask;
        assert (-this.nside < hInD0h && hInD0h < this.nside);
        int d0hBy4Quotient = d0h >> 2;
        assert (0 <= d0hBy4Quotient && d0hBy4Quotient <= 2);
        int d0hMod4 = d0h & 3;
        assert (0 <= d0hMod4 && d0hMod4 <= 3);
        int hD0h = 1 - d0hBy4Quotient;
        assert (-1 <= hD0h && hD0h <= 1);
        int lD0h = d0hMod4 << 1 | hD0h & 1;
        assert (hD0h == 0 && lD0h == 0 || lD0h == 2 || lD0h == 4 || lD0h == 6 || hD0h != 0 && lD0h == 1 || lD0h == 3 || lD0h == 5 || lD0h == 7);
        double lon = (double)lInD0h * this.oneOverNside;
        assert (-1.0 < lon && lon < 1.0);
        double lat = (double)hInD0h * this.oneOverNside;
        assert (-1.0 < lat && lat < 1.0);
        if (d0h < 4 && hInD0h > 0 || d0h > 7 && hInD0h < 0) {
            long signLat = HackersDelight.toBits(lat);
            assert (lat == HackersDelight.fromBits(signLat));
            lat = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
            assert (0.0 < lat && lat < 1.0);
            assert ((signLat &= Long.MIN_VALUE) == 0L || signLat == Long.MIN_VALUE);
            lat = 1.0 - lat;
            assert (0.0 < lat && lat < 1.0);
            assert (-1.0 < (lon /= lat) && lon < 1.0);
            assert (0.0 < (lat *= 0.408248290463863) && lat < 0.408248290463863);
            lat = 2.0 * FastMath.acos(lat) - 1.5707963267948966;
            assert (Healpix.TRANSITION_LATITUDE < lat && lat <= 1.5707963267948966);
            lat = HackersDelight.fromBits(signLat | HackersDelight.toBits(lat));
        } else {
            lat += (double)hD0h;
            lat = FastMath.asin(lat * 0.6666666666666666);
            assert (0 <= (lD0h |= (lInD0h & Integer.MIN_VALUE) >>> 24 + d0h & 8) && lD0h <= 8);
        }
        lon += (double)lD0h;
        resultLonLat[0] = lon *= 0.7853981633974483;
        resultLonLat[1] = lat;
    }

    @Override
    public double[] vertex(long hash, CompassPoint.Cardinal cardinalPoint) {
        double[] resultLonLat = new double[2];
        this.vertex(hash, cardinalPoint, resultLonLat);
        return resultLonLat;
    }

    @Override
    public void vertex(long hash, CompassPoint.Cardinal vertexDirection, double[] resultLonLat) {
        this.checkHashRange(hash);
        int d0h = (int)(hash >> this.twiceDepth);
        assert (0 <= d0h && d0h < 12);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        assert (0 <= iInD0h && iInD0h < this.nside);
        int jInD0h = this.fc.ij2j(hash);
        assert (0 <= jInD0h && jInD0h < this.nside);
        int lInD0h = iInD0h - jInD0h;
        assert (-this.nside < lInD0h && lInD0h < this.nside);
        int hInD0h = iInD0h + jInD0h - this.modNsideMask;
        assert (-this.nside < hInD0h && hInD0h < this.nside);
        int d0hBy4Quotient = d0h >> 2;
        assert (0 <= d0hBy4Quotient && d0hBy4Quotient <= 2);
        int d0hMod4 = d0h & 3;
        assert (0 <= d0hMod4 && d0hMod4 <= 3);
        int hD0h = 1 - d0hBy4Quotient;
        assert (-1 <= hD0h && hD0h <= 1);
        int lD0h = d0hMod4 << 1 | hD0h & 1;
        assert (hD0h == 0 && lD0h == 0 || lD0h == 2 || lD0h == 4 || lD0h == 6 || hD0h != 0 && lD0h == 1 || lD0h == 3 || lD0h == 5 || lD0h == 7);
        double lon = (double)lInD0h * this.oneOverNside;
        assert (-1.0 < lon && lon < 1.0);
        double lat = (double)hInD0h * this.oneOverNside;
        assert (-1.0 < lat && lat < 1.0);
        assert (-1.0 <= (lon += vertexDirection.timeXOffset(this.oneOverNside)) && lon <= 1.0);
        assert (-1.0 <= (lat += vertexDirection.timeYOffset(this.oneOverNside)) && lat <= 1.0);
        if (d0h < 4 && lat > 0.0 || d0h > 7 && lat < 0.0) {
            long signLat = HackersDelight.toBits(lat);
            assert (lat == HackersDelight.fromBits(signLat));
            lat = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
            assert (0.0 <= lat && lat <= 1.0) : lat;
            assert ((signLat &= Long.MIN_VALUE) == 0L || signLat == Long.MIN_VALUE);
            lat = 1.0 - lat;
            assert (0.0 <= lat && lat <= 1.0);
            if (lat > 1.0E-13) assert (-1.0 <= (lon /= lat) && lon <= 1.0) : lon;
            lat = HackersDelight.fromBits(signLat | HackersDelight.toBits(2.0 * FastMath.acos(lat * 0.408248290463863) - 1.5707963267948966));
        } else {
            lat = FastMath.asin((lat + (double)hD0h) * 0.6666666666666666);
            assert (0 <= (lD0h |= (lInD0h & Integer.MIN_VALUE) >>> 24 + d0h & 8) && lD0h <= 8);
        }
        resultLonLat[0] = (lon += (double)lD0h) == 8.0 ? 0.0 : (lon < 0.0 ? lon + 8.0 : lon) * 0.7853981633974483;
        resultLonLat[1] = lat;
        assert (0.0 <= resultLonLat[0] && resultLonLat[0] < java.lang.Math.PI * 2);
        assert (-1.5707963267948966 <= resultLonLat[1] && resultLonLat[1] <= 1.5707963267948966);
    }

    @Override
    public EnumMap<CompassPoint.Cardinal, double[]> vertices(long hash, EnumSet<CompassPoint.Cardinal> cardinalPoints) {
        EnumMap<CompassPoint.Cardinal, double[]> verticesMap = new EnumMap<CompassPoint.Cardinal, double[]>(CompassPoint.Cardinal.class);
        for (CompassPoint.Cardinal c : cardinalPoints) {
            double[] resultLonLat = new double[2];
            verticesMap.put(c, resultLonLat);
        }
        this.vertices(hash, verticesMap);
        return verticesMap;
    }

    @Override
    public void vertices(long hash, EnumMap<CompassPoint.Cardinal, double[]> cardinalPoints) {
        this.checkHashRange(hash);
        int d0h = (int)(hash >> this.twiceDepth);
        assert (0 <= d0h && d0h < 12);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        assert (0 <= iInD0h && iInD0h < this.nside);
        int jInD0h = this.fc.ij2j(hash);
        assert (0 <= jInD0h && jInD0h < this.nside);
        int lInD0h = iInD0h - jInD0h;
        assert (-this.nside < lInD0h && lInD0h < this.nside);
        int hInD0h = iInD0h + jInD0h - this.modNsideMask;
        assert (-this.nside < hInD0h && hInD0h < this.nside);
        int d0hBy4Quotient = d0h >> 2;
        assert (0 <= d0hBy4Quotient && d0hBy4Quotient <= 2);
        int d0hMod4 = d0h & 3;
        assert (0 <= d0hMod4 && d0hMod4 <= 3);
        int hD0h = 1 - d0hBy4Quotient;
        assert (-1 <= hD0h && hD0h <= 1);
        int lD0h = d0hMod4 << 1 | hD0h & 1;
        assert (hD0h == 0 && lD0h == 0 || lD0h == 2 || lD0h == 4 || lD0h == 6 || hD0h != 0 && lD0h == 1 || lD0h == 3 || lD0h == 5 || lD0h == 7);
        double lon = (double)lInD0h * this.oneOverNside;
        assert (-1.0 < lon && lon < 1.0);
        double lat = (double)hInD0h * this.oneOverNside;
        assert (-1.0 < lat && lat < 1.0);
        double[] east = cardinalPoints.get((Object)CompassPoint.Cardinal.E);
        double[] west = cardinalPoints.get((Object)CompassPoint.Cardinal.W);
        double[] north = cardinalPoints.get((Object)CompassPoint.Cardinal.N);
        double[] south = cardinalPoints.get((Object)CompassPoint.Cardinal.S);
        if (d0h < 4 && hInD0h > 0 || d0h > 7 && hInD0h < 0) {
            if (east != null || west != null) {
                double latEW = lat;
                long signLat = HackersDelight.toBits(latEW);
                latEW = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
                double c = 1.0 - latEW;
                latEW = 2.0 * FastMath.acos(c * 0.408248290463863) - 1.5707963267948966;
                latEW = HackersDelight.fromBits((signLat &= Long.MIN_VALUE) | HackersDelight.toBits(latEW));
                if (east != null) {
                    east[0] = ((lon + this.oneOverNside) / c + (double)lD0h) * 0.7853981633974483;
                    east[1] = latEW;
                }
                if (west != null) {
                    west[0] = ((lon - this.oneOverNside) / c + (double)lD0h) * 0.7853981633974483;
                    west[1] = latEW;
                }
            }
            if (north != null) {
                double latN = lat + this.oneOverNside;
                double lonN = lon;
                long signLat = HackersDelight.toBits(latN);
                latN = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
                latN = 1.0 - latN;
                north[0] = ((lonN /= latN) + (double)lD0h) * 0.7853981633974483;
                north[1] = HackersDelight.fromBits((signLat &= Long.MIN_VALUE) | HackersDelight.toBits(2.0 * FastMath.acos(latN * 0.408248290463863) - 1.5707963267948966));
            }
            if (south != null) {
                double latS = lat - this.oneOverNside;
                double lonS = lon;
                long signLat = HackersDelight.toBits(latS);
                latS = HackersDelight.fromBits(signLat & Long.MAX_VALUE);
                latS = 1.0 - latS;
                south[0] = ((lonS /= latS) + (double)lD0h) * 0.7853981633974483;
                south[1] = HackersDelight.fromBits((signLat &= Long.MIN_VALUE) | HackersDelight.toBits(2.0 * FastMath.acos(latS * 0.408248290463863) - 1.5707963267948966));
            }
        } else {
            assert (0 <= (lD0h |= (lInD0h & Integer.MIN_VALUE) >>> 24 + d0h & 8) && lD0h <= 8);
            if (east != null || west != null) {
                double latEW = FastMath.asin((lat + (double)hD0h) * 0.6666666666666666);
                if (east != null) {
                    east[0] = (lon + (double)lD0h + this.oneOverNside) * 0.7853981633974483;
                    east[1] = latEW;
                }
                if (west != null) {
                    west[0] = (lon + (double)lD0h - this.oneOverNside) * 0.7853981633974483;
                    west[1] = latEW;
                }
            }
            if (north != null || south != null) {
                lon += (double)lD0h;
                lon *= 0.7853981633974483;
                if (north != null) {
                    north[0] = lon;
                    north[1] = FastMath.asin((lat + (double)hD0h + this.oneOverNside) * 0.6666666666666666);
                }
                if (south != null) {
                    south[0] = lon;
                    south[1] = FastMath.asin((lat + (double)hD0h - this.oneOverNside) * 0.6666666666666666);
                }
            }
        }
    }

    @Override
    public double[][] pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments) {
        int resultSize = isToVertexIncluded ? nSegments + 1 : nSegments;
        double[][] pathPoints = new double[resultSize][];
        this.pathAlongCellSide(hash, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints);
        return pathPoints;
    }

    @Override
    public void pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints) {
        this.pathAlongCellSide(hash, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, 0);
    }

    @Override
    public double[][] pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide) {
        double[][] pathPoints = new double[nSegmentsBySide << 2][];
        this.pathAlongCellEdge(hash, startingVertex, clockwiseDirection, nSegmentsBySide, pathPoints);
        return pathPoints;
    }

    @Override
    public void pathAlongCellEdge(long hash, CompassPoint.Cardinal startingVertex, boolean clockwiseDirection, int nSegmentsBySide, double[][] pathPoints) {
        CompassPoint.Cardinal vertex4;
        CompassPoint.Cardinal vertex3;
        CompassPoint.Cardinal vertex2;
        this.checkHashRange(hash);
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        int jInD0h = this.fc.ij2j(hash);
        int lInD0h = iInD0h - jInD0h;
        int hInD0h = iInD0h + jInD0h - this.modNsideMask;
        int d0hBy4Quotient = d0h >> 2;
        int d0hMod4 = d0h & 3;
        int hD0h = 1 - d0hBy4Quotient;
        int lD0h = d0hMod4 << 1 | hD0h & 1;
        double lonC = (double)lInD0h * this.oneOverNside;
        double latC = (double)hInD0h * this.oneOverNside;
        CompassPoint.Cardinal vertex1 = startingVertex;
        if (clockwiseDirection) {
            vertex2 = startingVertex.nextClockwise();
            vertex3 = vertex2.nextClockwise();
            vertex4 = vertex3.nextClockwise();
        } else {
            vertex2 = startingVertex.nextCounterClockwise();
            vertex3 = vertex2.nextCounterClockwise();
            vertex4 = vertex3.nextCounterClockwise();
        }
        if (d0h < 4 && hInD0h > 0 || d0h > 7 && hInD0h < 0) {
            this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex1, vertex2, false, nSegmentsBySide, pathPoints, 0);
            this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex2, vertex3, false, nSegmentsBySide, pathPoints, nSegmentsBySide);
            this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex3, vertex4, false, nSegmentsBySide, pathPoints, nSegmentsBySide << 1);
            this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex4, vertex1, false, nSegmentsBySide, pathPoints, (nSegmentsBySide << 2) - nSegmentsBySide);
        } else if (d0h < 4 && hInD0h == 0 || d0h > 7 && hInD0h == 0) {
            if (d0h > 7 != (vertex1 == CompassPoint.Cardinal.N || vertex2 == CompassPoint.Cardinal.N)) {
                this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex1, vertex2, false, nSegmentsBySide, pathPoints, 0);
            } else {
                this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex1, vertex2, false, nSegmentsBySide, pathPoints, 0);
            }
            if (d0h > 7 != (vertex2 == CompassPoint.Cardinal.N || vertex3 == CompassPoint.Cardinal.N)) {
                this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex2, vertex3, false, nSegmentsBySide, pathPoints, nSegmentsBySide);
            } else {
                this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex2, vertex3, false, nSegmentsBySide, pathPoints, nSegmentsBySide);
            }
            if (d0h > 7 != (vertex3 == CompassPoint.Cardinal.N || vertex4 == CompassPoint.Cardinal.N)) {
                this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex3, vertex4, false, nSegmentsBySide, pathPoints, nSegmentsBySide << 1);
            } else {
                this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex3, vertex4, false, nSegmentsBySide, pathPoints, nSegmentsBySide << 1);
            }
            if (d0h > 7 != (vertex4 == CompassPoint.Cardinal.N || vertex1 == CompassPoint.Cardinal.N)) {
                this.pathAlongCellSidePolarCap(lonC, latC, lD0h, vertex4, vertex1, false, nSegmentsBySide, pathPoints, (nSegmentsBySide << 2) - nSegmentsBySide);
            } else {
                this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex4, vertex1, false, nSegmentsBySide, pathPoints, (nSegmentsBySide << 2) - nSegmentsBySide);
            }
        } else {
            this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex1, vertex2, false, nSegmentsBySide, pathPoints, 0);
            this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex2, vertex3, false, nSegmentsBySide, pathPoints, nSegmentsBySide);
            this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex3, vertex4, false, nSegmentsBySide, pathPoints, nSegmentsBySide << 1);
            this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, vertex4, vertex1, false, nSegmentsBySide, pathPoints, (nSegmentsBySide << 2) - nSegmentsBySide);
        }
    }

    private void pathAlongCellSide(long hash, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints, int fromPathPointsIndex) {
        this.checkHashRange(hash);
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        int jInD0h = this.fc.ij2j(hash);
        int lInD0h = iInD0h - jInD0h;
        int hInD0h = iInD0h + jInD0h - this.modNsideMask;
        int d0hBy4Quotient = d0h >> 2;
        int d0hMod4 = d0h & 3;
        int hD0h = 1 - d0hBy4Quotient;
        int lD0h = d0hMod4 << 1 | hD0h & 1;
        double lonC = (double)lInD0h * this.oneOverNside;
        double latC = (double)hInD0h * this.oneOverNside;
        if (d0h < 4 && hInD0h > 0 || d0h > 7 && hInD0h < 0) {
            this.pathAlongCellSidePolarCap(lonC, latC, lD0h, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, fromPathPointsIndex);
        } else if (d0h < 4 && hInD0h == 0 || d0h > 7 && hInD0h == 0) {
            if (d0h > 7 != (fromVertex == CompassPoint.Cardinal.N || toVertex == CompassPoint.Cardinal.N)) {
                this.pathAlongCellSidePolarCap(lonC, latC, lD0h, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, fromPathPointsIndex);
            } else {
                this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, fromPathPointsIndex);
            }
        } else {
            this.pathAlongCellSideEquatRegion(lonC, latC, lD0h, d0h, hD0h, lInD0h, fromVertex, toVertex, isToVertexIncluded, nSegments, pathPoints, fromPathPointsIndex);
        }
    }

    private void pathAlongCellSidePolarCap(double lonC, double latC, int lD0h, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints, int fromPathPointsIndex) {
        int resultSize = isToVertexIncluded ? nSegments + 1 : nSegments;
        double fromOffsetX = fromVertex.timeXOffset(this.oneOverNside);
        double fromOffsetY = fromVertex.timeYOffset(this.oneOverNside);
        double stepX = (toVertex.timeXOffset(this.oneOverNside) - fromOffsetX) / (double)nSegments;
        double stepY = (toVertex.timeYOffset(this.oneOverNside) - fromOffsetY) / (double)nSegments;
        long signLat = latC == 0.0 ? (toVertex == CompassPoint.Cardinal.S || fromVertex == CompassPoint.Cardinal.S ? Long.MIN_VALUE : 0L) : HackersDelight.toBits(latC) & Long.MIN_VALUE;
        for (int i = 0; i < resultSize; ++i) {
            double[] pathPoint = new double[2];
            double lon = lonC + fromOffsetX + (double)i * stepX;
            double lat = latC + fromOffsetY + (double)i * stepY;
            lat = HackersDelight.fromBits(HackersDelight.toBits(lat) & Long.MAX_VALUE);
            if ((lat = 1.0 - lat) > 1.0E-13) {
                lon /= lat;
            }
            lat = HackersDelight.fromBits(signLat | HackersDelight.toBits(2.0 * FastMath.acos(lat * 0.408248290463863) - 1.5707963267948966));
            pathPoint[0] = (lon + (double)lD0h) * 0.7853981633974483;
            pathPoint[1] = lat;
            pathPoints[i + fromPathPointsIndex] = pathPoint;
        }
    }

    private void pathAlongCellSideEquatRegion(double lonC, double latC, int lD0h, int d0h, int hD0h, int lInD0h, CompassPoint.Cardinal fromVertex, CompassPoint.Cardinal toVertex, boolean isToVertexIncluded, int nSegments, double[][] pathPoints, int fromPathPointsIndex) {
        int resultSize = isToVertexIncluded ? nSegments + 1 : nSegments;
        double fromOffsetX = fromVertex.timeXOffset(this.oneOverNside);
        double fromOffsetY = fromVertex.timeYOffset(this.oneOverNside);
        double stepX = (toVertex.timeXOffset(this.oneOverNside) - fromOffsetX) / (double)nSegments;
        double stepY = (toVertex.timeYOffset(this.oneOverNside) - fromOffsetY) / (double)nSegments;
        lD0h |= (lInD0h & Integer.MIN_VALUE) >>> 24 + d0h & 8;
        for (int i = 0; i < resultSize; ++i) {
            double[] pathPoint = new double[2];
            double lon = lonC + fromOffsetX + (double)i * stepX;
            double lat = latC + fromOffsetY + (double)i * stepY;
            lat = FastMath.asin((lat + (double)hD0h) * 0.6666666666666666);
            pathPoint[0] = (lon + (double)lD0h) * 0.7853981633974483;
            pathPoint[1] = lat;
            pathPoints[i + fromPathPointsIndex] = pathPoint;
        }
    }

    private static byte[][] createNorhtPolarCapNeighbours(int d0h) {
        assert (0 <= d0h && d0h < 4) : "d0h: " + d0h;
        byte offset = (byte)d0h;
        assert (0 <= offset && offset <= 3) : "Offset: " + offset;
        int x = -1;
        return HealpixNestedFast.createNeighbours(offset, (byte)(4 + offset), (byte)(1 + offset & 3), (byte)(5 + offset & 7 | 4), (byte)(8 + offset), (byte)-1, (byte)(3 + offset & 3), (byte)-1, (byte)(2 + offset & 3));
    }

    private static final byte[][] createEquatorialRegionNeighbours(int d0h) {
        assert (4 <= d0h && d0h <= 7) : "d0h: " + d0h;
        byte offset = (byte)(d0h - 4);
        assert (0 <= offset && offset <= 3) : "Offset: " + offset;
        int x = -1;
        return HealpixNestedFast.createNeighbours((byte)d0h, (byte)(11 + offset & 0xB), offset, (byte)(8 + offset), (byte)-1, (byte)(5 + offset & 7 | 4), (byte)(3 + offset & 3), (byte)(7 + offset & 7 | 4), (byte)-1);
    }

    private static byte[][] createSouthPolarCapNeighbours(int d0h) {
        assert (8 <= d0h && d0h < 12) : "d0h: " + d0h;
        byte offset = (byte)(d0h - 8);
        assert (0 <= offset && offset <= 3) : "Offset: " + offset;
        int x = -1;
        return HealpixNestedFast.createNeighbours((byte)d0h, (byte)(11 + offset & 0xB), (byte)(5 + offset & 7 | 4), (byte)(9 + offset & 0xB), (byte)(10 + offset & 0xB), (byte)-1, (byte)(4 + offset), (byte)-1, offset);
    }

    private static final byte[][] createNeighbours(byte c, byte sw, byte ne, byte se, byte s, byte e, byte nw, byte w, byte n) {
        return new byte[][]{{s, se, e, sw, ne, w, nw, n}, {sw, c, c, sw, c, sw, c, c}, {c, c, ne, c, ne, c, c, ne}, {se, se, se, c, c, c, c, c}, {s, se, se, sw, c, sw, c, c}, {se, se, e, c, ne, c, c, ne}, {c, c, c, c, c, nw, nw, nw}, {sw, c, c, sw, c, w, nw, nw}, {c, c, ne, c, ne, nw, nw, n}};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final byte[] getNeighbours(int d0h, int k) {
        if (NEIGHBOURS[d0h] != null) return NEIGHBOURS[d0h][k];
        byte[][][] byArray = NEIGHBOURS;
        synchronized (NEIGHBOURS) {
            if (NEIGHBOURS[d0h] != null) return NEIGHBOURS[d0h][k];
            HealpixNestedFast.NEIGHBOURS[d0h] = d0h < 4 ? HealpixNestedFast.createNorhtPolarCapNeighbours(d0h) : (d0h < 8 ? HealpixNestedFast.createEquatorialRegionNeighbours(d0h) : HealpixNestedFast.createSouthPolarCapNeighbours(d0h));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return NEIGHBOURS[d0h][k];
        }
    }

    private static void copyD0hNeig(int d0h, FlatHashList neighbours) {
        byte[] a = D0H_NEIGHBOURS[d0h];
        neighbours.hList[0] = a[0];
        neighbours.hList[1] = a[1];
        neighbours.hList[2] = a[2];
        neighbours.hList[3] = a[3];
        neighbours.hList[4] = a[4];
        neighbours.hList[5] = a[5];
        neighbours.size = 6;
    }

    @Override
    public void neighbours(long hash, FlatHashList neighbours) {
        int d0h = (int)(hash >>> this.twiceDepth);
        assert (0 <= d0h && d0h < 12);
        if (this.depth == 0) {
            HealpixNestedFast.copyD0hNeig(d0h, neighbours);
            return;
        }
        long d0hFull = hash & this.d0Mask;
        long xFull = hash & this.xMask;
        long yFull = hash & this.yMask;
        hash = this.fc.hash2ij(hash & this.xyMask);
        int x = this.fc.ij2i(hash);
        assert (0 <= x && x < this.nside) : "x: " + x;
        int y = this.fc.ij2j(hash);
        assert (0 <= y && y < this.nside) : "y: " + y;
        int i = x - 1 >>> 31;
        assert ((i |= x + 1 >> this.depth << 1) == 0 || i == 1 || i == 2) : "i: " + i;
        int j = y - 1 >>> 31;
        assert ((j |= y + 1 >> this.depth << 1) == 0 || j == 1 || j == 2) : "j: " + j;
        hash = this.fc.ij2hash(x - 1 & this.modNsideMask, y - 1 & this.modNsideMask);
        long xm1Full = hash & this.xMask;
        long ym1Full = hash & this.yMask;
        hash = this.fc.ij2hash(x + 1 & this.modNsideMask, y + 1 & this.modNsideMask);
        long xp1Full = hash & this.xMask;
        long yp1Full = hash & this.yMask;
        if (i == 0 && j == 0) {
            neighbours.hList[0] = d0hFull | ym1Full | xm1Full;
            neighbours.hList[1] = d0hFull | ym1Full | xFull;
            neighbours.hList[2] = d0hFull | ym1Full | xp1Full;
            neighbours.hList[3] = d0hFull | yFull | xm1Full;
            neighbours.hList[4] = d0hFull | yFull | xp1Full;
            neighbours.hList[5] = d0hFull | yp1Full | xm1Full;
            neighbours.hList[6] = d0hFull | yp1Full | xFull;
            neighbours.hList[7] = d0hFull | yp1Full | xp1Full;
            neighbours.size = 8;
        } else if (d0h < 4) {
            int k = (j << 1) + j + i;
            assert (0 < k && k < 9) : "k: " + k;
            byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
            int l = 0;
            switch (k) {
                case 1: 
                case 3: 
                case 4: {
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full | xp1Full;
                    break;
                }
                case 2: {
                    assert (x == this.nside - 1);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | this.yMask | ym1Full >>> 1;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | this.yMask | yFull >>> 1;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | this.yMask | yp1Full >> 1;
                    break;
                }
                case 5: {
                    assert (x == this.nside - 1 && y == 0);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (ym1Full == this.yMask && yFull == 0L && yp1Full == 2L);
                    assert (yp1Full >> 1 == 1L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | this.yMask;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | this.yMask | 1L;
                    break;
                }
                case 6: {
                    assert (y == this.nside - 1);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | xm1Full << 1 | this.xMask;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | xFull << 1 | this.xMask;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | xp1Full << 1 | this.xMask;
                    break;
                }
                case 7: {
                    assert (x == 0 && y == this.nside - 1);
                    assert (xFull == 0L && xm1Full == this.xMask);
                    assert (xp1Full << 1 == 2L);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | 2L | xm1Full;
                    break;
                }
                case 8: {
                    assert (x == this.nside - 1 && y == this.nside - 1);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    assert (yFull >>> 1 == xFull && xFull << 1 == yFull);
                    assert (xm1Full << 1 == ym1Full && ym1Full >>> 1 == xm1Full);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | this.xyMask;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | this.xyMask;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | this.xyMask;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            neighbours.size = l;
        } else if (d0h > 7) {
            int k = j * 3 + i;
            assert (0 < k && k < 9) : "k: " + k;
            byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
            int l = 0;
            switch (k) {
                case 2: 
                case 6: 
                case 8: {
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full | xp1Full;
                    break;
                }
                case 1: {
                    assert (x == 0 && xFull == 0L);
                    assert (xm1Full == this.xMask && xp1Full == 1L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full >> 1;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull >> 1;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full >> 1;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full | xp1Full;
                    break;
                }
                case 3: {
                    assert (y == 0 && yFull == 0L);
                    assert (ym1Full == this.yMask && yp1Full == 2L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | xm1Full << 1;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | xFull << 1;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | xp1Full << 1;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full | xp1Full;
                    break;
                }
                case 4: {
                    assert (x == 0 && y == 0 && xFull == 0L && yFull == 0L);
                    assert (xm1Full == this.xMask && xp1Full == 1L);
                    assert (ym1Full == this.yMask && yp1Full == 2L);
                    assert (yp1Full >> 1 == xp1Full);
                    assert ((xp1Full | yp1Full) == 3L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | yp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | 3L;
                    break;
                }
                case 5: {
                    assert (x == this.nside - 1 && y == 0);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (ym1Full == this.yMask && yFull == 0L && yp1Full == 2L) : (ym1Full == this.yMask) + " " + (yFull == 0L) + " " + (yp1Full == 1L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | xm1Full << 1;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | this.yMask;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth;
                    neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full;
                    break;
                }
                case 7: {
                    assert (x == 0 && y == this.nside - 1);
                    assert (xFull == 0L && xm1Full == this.xMask);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    assert (xp1Full << 1 == 2L);
                    neighbours.hList[l++] = (long)d0hneigs[0] << this.twiceDepth | ym1Full >> 1;
                    neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                    neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                    neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
                    neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth;
                    neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | xp1Full;
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            neighbours.size = l;
        } else {
            int k = j * 3 + i;
            assert (0 < k && k < 9) : "k: " + k;
            byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
            neighbours.hList[0] = (long)d0hneigs[0] << this.twiceDepth | ym1Full | xm1Full;
            int l = k == 4 ? 0 : 1;
            neighbours.hList[l++] = (long)d0hneigs[1] << this.twiceDepth | ym1Full | xFull;
            neighbours.hList[l++] = (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
            neighbours.hList[l++] = (long)d0hneigs[3] << this.twiceDepth | yFull | xm1Full;
            neighbours.hList[l++] = (long)d0hneigs[4] << this.twiceDepth | yFull | xp1Full;
            neighbours.hList[l++] = (long)d0hneigs[5] << this.twiceDepth | yp1Full | xm1Full;
            neighbours.hList[l++] = (long)d0hneigs[6] << this.twiceDepth | yp1Full | xFull;
            neighbours.hList[l++] = (long)d0hneigs[7] << this.twiceDepth | yp1Full | xp1Full;
            neighbours.size = l -= k >> 3;
        }
    }

    @Override
    public long neighbour(long hash, CompassPoint.MainWind direction) {
        int d0h = (int)(hash >>> this.twiceDepth);
        assert (0 <= d0h && d0h < 12);
        if (this.depth == 0) {
            byte[] d0hNeig = HealpixNestedFast.getNeighbours(d0h, 0);
            switch (direction) {
                case S: {
                    return d0hNeig[0];
                }
                case SE: {
                    return d0hNeig[1];
                }
                case E: {
                    return d0hNeig[2];
                }
                case SW: {
                    return d0hNeig[3];
                }
                case NE: {
                    return d0hNeig[4];
                }
                case W: {
                    return d0hNeig[5];
                }
                case NW: {
                    return d0hNeig[6];
                }
                case N: {
                    return d0hNeig[7];
                }
            }
            throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
        }
        long d0hFull = hash & this.d0Mask;
        long xFull = hash & this.xMask;
        long yFull = hash & this.yMask;
        hash = this.fc.hash2ij(hash & this.xyMask);
        int x = this.fc.ij2i(hash);
        assert (0 <= x && x < this.nside);
        int y = this.fc.ij2j(hash);
        assert (0 <= y && y < this.nside);
        int i = x - 1 >>> 31;
        assert ((i |= x + 1 >> this.depth << 1) == 0 || i == 1 || i == 2) : "i: " + i;
        int j = y - 1 >>> 31;
        assert ((j |= y + 1 >> this.depth << 1) == 0 || j == 1 || j == 2) : "j: " + j;
        hash = this.fc.ij2hash(x - 1 & this.modNsideMask, y - 1 & this.modNsideMask);
        long xm1Full = hash & this.xMask;
        long ym1Full = hash & this.yMask;
        hash = this.fc.ij2hash(x + 1 & this.modNsideMask, y + 1 & this.modNsideMask);
        long xp1Full = hash & this.xMask;
        long yp1Full = hash & this.yMask;
        if (i == 0 && j == 0) {
            switch (direction) {
                case S: {
                    return HealpixNested.bits2hash(d0hFull, ym1Full, xm1Full);
                }
                case SE: {
                    return HealpixNested.bits2hash(d0hFull, ym1Full, xFull);
                }
                case E: {
                    return HealpixNested.bits2hash(d0hFull, ym1Full, xp1Full);
                }
                case SW: {
                    return HealpixNested.bits2hash(d0hFull, yFull, xm1Full);
                }
                case NE: {
                    return HealpixNested.bits2hash(d0hFull, yFull, xp1Full);
                }
                case W: {
                    return HealpixNested.bits2hash(d0hFull, yp1Full, xm1Full);
                }
                case NW: {
                    return HealpixNested.bits2hash(d0hFull, yp1Full, xFull);
                }
                case N: {
                    return HealpixNested.bits2hash(d0hFull, yp1Full, xp1Full);
                }
            }
            throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
        }
        if (d0h < 4) {
            int k = (j << 1) + j + i;
            assert (0 < k && k < 9) : "k: " + k;
            byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
            switch (k) {
                case 1: 
                case 3: 
                case 4: {
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, yp1Full, xp1Full);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 2: {
                    assert (x == this.nside - 1);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, this.yMask, ym1Full >>> 1);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, this.yMask, yFull >>> 1);
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, this.yMask, yp1Full >> 1);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 5: {
                    assert (x == this.nside - 1 && y == 0);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (ym1Full == this.yMask && yFull == 0L && yp1Full == 2L);
                    assert (yp1Full >> 1 == 1L);
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return -1L;
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                        }
                        case NE: {
                            return (long)d0hneigs[4] << this.twiceDepth | this.yMask;
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, this.yMask, 1L);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 6: {
                    assert (y == this.nside - 1);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, xm1Full << 1, this.xMask);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, xFull << 1, this.xMask);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, xp1Full << 1, this.xMask);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 7: {
                    assert (x == 0 && y == this.nside - 1);
                    assert (xFull == 0L && xm1Full == this.xMask);
                    assert (xp1Full << 1 == 2L);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return -1L;
                        }
                        case NW: {
                            return (long)d0hneigs[6] << this.twiceDepth | xm1Full;
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, 2L, xm1Full);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 8: {
                    assert (x == this.nside - 1 && y == this.nside - 1);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    assert (yFull >>> 1 == xFull && xFull << 1 == yFull);
                    assert (xm1Full << 1 == ym1Full && ym1Full >>> 1 == xm1Full);
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, yFull, xm1Full);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return (long)d0hneigs[4] << this.twiceDepth | this.xyMask;
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, ym1Full, xFull);
                        }
                        case NW: {
                            return (long)d0hneigs[6] << this.twiceDepth | this.xyMask;
                        }
                        case N: {
                            return (long)d0hneigs[7] << this.twiceDepth | this.xyMask;
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
            }
            throw new IllegalArgumentException("Wrong k: " + k);
        }
        if (d0h > 7) {
            int k = j * 3 + i;
            assert (0 < k && k < 9) : "k: " + k;
            byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
            switch (k) {
                case 2: 
                case 6: 
                case 8: {
                    switch (direction) {
                        case S: {
                            return HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
                        }
                        case SE: {
                            return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
                        }
                        case SW: {
                            return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, yp1Full, xp1Full);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 1: {
                    assert (x == 0 && xFull == 0L);
                    assert (xm1Full == this.xMask && xp1Full == 1L);
                    switch (direction) {
                        case S: {
                            return (long)d0hneigs[0] << this.twiceDepth | ym1Full >> 1;
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                        }
                        case E: {
                            return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth | yFull >> 1;
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return (long)d0hneigs[5] << this.twiceDepth | yp1Full >> 1;
                        }
                        case NW: {
                            return (long)d0hneigs[6] << this.twiceDepth | yp1Full;
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, yp1Full, xp1Full);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 3: {
                    assert (y == 0 && yFull == 0L);
                    assert (ym1Full == this.yMask && yp1Full == 2L);
                    switch (direction) {
                        case S: {
                            return (long)d0hneigs[0] << this.twiceDepth | xm1Full << 1;
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth | xFull << 1;
                        }
                        case E: {
                            return (long)d0hneigs[2] << this.twiceDepth | xp1Full << 1;
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                        }
                        case NE: {
                            return (long)d0hneigs[4] << this.twiceDepth | xp1Full;
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, yp1Full, xp1Full);
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 4: {
                    assert (x == 0 && y == 0 && xFull == 0L && yFull == 0L);
                    assert (xm1Full == this.xMask && xp1Full == 1L);
                    assert (ym1Full == this.yMask && yp1Full == 2L);
                    assert (yp1Full >> 1 == xp1Full);
                    assert ((xp1Full | yp1Full) == 3L);
                    switch (direction) {
                        case S: {
                            return (long)d0hneigs[0] << this.twiceDepth;
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth;
                        }
                        case E: {
                            return (long)d0hneigs[2] << this.twiceDepth | yp1Full;
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth;
                        }
                        case NE: {
                            return (long)d0hneigs[4] << this.twiceDepth | xp1Full;
                        }
                        case W: {
                            return (long)d0hneigs[5] << this.twiceDepth | xp1Full;
                        }
                        case NW: {
                            return (long)d0hneigs[6] << this.twiceDepth | yp1Full;
                        }
                        case N: {
                            return (long)d0hneigs[7] << this.twiceDepth | 3L;
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 5: {
                    assert (x == this.nside - 1 && y == 0);
                    assert (xFull == this.xMask && xp1Full == 0L);
                    assert (ym1Full == this.yMask && yFull == 0L && yp1Full == 2L) : (ym1Full == this.yMask) + " " + (yFull == 0L) + " " + (yp1Full == 1L);
                    switch (direction) {
                        case S: {
                            return (long)d0hneigs[0] << this.twiceDepth | xm1Full << 1;
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth | this.yMask;
                        }
                        case E: {
                            return -1L;
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                        }
                        case NE: {
                            return (long)d0hneigs[4] << this.twiceDepth;
                        }
                        case W: {
                            return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
                        }
                        case NW: {
                            return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
                        }
                        case N: {
                            return (long)d0hneigs[7] << this.twiceDepth | yp1Full;
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
                case 7: {
                    assert (x == 0 && y == this.nside - 1);
                    assert (xFull == 0L && xm1Full == this.xMask);
                    assert (yFull == this.yMask && yp1Full == 0L);
                    assert (xp1Full << 1 == 2L);
                    switch (direction) {
                        case S: {
                            return (long)d0hneigs[0] << this.twiceDepth | ym1Full >> 1;
                        }
                        case SE: {
                            return (long)d0hneigs[1] << this.twiceDepth | ym1Full;
                        }
                        case E: {
                            return (long)d0hneigs[2] << this.twiceDepth | ym1Full | xp1Full;
                        }
                        case SW: {
                            return (long)d0hneigs[3] << this.twiceDepth | xm1Full;
                        }
                        case NE: {
                            return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
                        }
                        case W: {
                            return -1L;
                        }
                        case NW: {
                            return (long)d0hneigs[6] << this.twiceDepth;
                        }
                        case N: {
                            return (long)d0hneigs[7] << this.twiceDepth | xp1Full;
                        }
                    }
                    throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
                }
            }
            throw new IllegalArgumentException("Wrong k: " + k);
        }
        int k = j * 3 + i;
        assert (0 < k && k < 9) : "k: " + k;
        byte[] d0hneigs = HealpixNestedFast.getNeighbours(d0h, k);
        switch (direction) {
            case S: {
                return k == 4 ? -1L : HealpixNested.bits2hash((long)d0hneigs[0] << this.twiceDepth, ym1Full, xm1Full);
            }
            case SE: {
                return HealpixNested.bits2hash((long)d0hneigs[1] << this.twiceDepth, ym1Full, xFull);
            }
            case E: {
                return HealpixNested.bits2hash((long)d0hneigs[2] << this.twiceDepth, ym1Full, xp1Full);
            }
            case SW: {
                return HealpixNested.bits2hash((long)d0hneigs[3] << this.twiceDepth, yFull, xm1Full);
            }
            case NE: {
                return HealpixNested.bits2hash((long)d0hneigs[4] << this.twiceDepth, yFull, xp1Full);
            }
            case W: {
                return HealpixNested.bits2hash((long)d0hneigs[5] << this.twiceDepth, yp1Full, xm1Full);
            }
            case NW: {
                return HealpixNested.bits2hash((long)d0hneigs[6] << this.twiceDepth, yp1Full, xFull);
            }
            case N: {
                return k == 8 ? -1L : HealpixNested.bits2hash((long)d0hneigs[7] << this.twiceDepth, yp1Full, xp1Full);
            }
        }
        throw new IllegalArgumentException("Wrong direction: " + (Object)((Object)direction));
    }

    @Override
    public NeighbourList neighbours(long hash) {
        NeighbourList result = new NeighbourList(this.depth);
        this.neighbours(hash, result);
        return result;
    }

    @Override
    public NeighbourList neighbours(long hash, EnumSet<CompassPoint.MainWind> directions) {
        NeighbourList result = new NeighbourList(this.depth);
        this.neighbours(hash, directions, result);
        return result;
    }

    @Override
    public void neighbours(long hash, NeighbourList result) {
        this.checkHashRange(hash);
        result.clear();
        long d0hBits = hash & this.d0Mask;
        long iInD0hBits = hash & this.xMask;
        long jInD0hBits = hash & this.yMask;
        if (this.isInBasePixelBorderFromBits(iInD0hBits, jInD0hBits)) {
            this.edgePixelNeighbours(hash, result);
        } else {
            this.innerPixelNeighbours(d0hBits, iInD0hBits, jInD0hBits, result);
        }
    }

    @Override
    public void neighbours(long hash, EnumSet<CompassPoint.MainWind> directions, NeighbourList result) {
        this.checkHashRange(hash);
        long d0hBits = hash & this.d0Mask;
        long iInD0hBits = hash & this.xMask;
        long jInD0hBits = hash & this.yMask;
        result.clear();
        if (this.isInBasePixelBorderFromBits(iInD0hBits, jInD0hBits)) {
            this.edgePixelNeighbours(hash, directions, result);
        } else {
            this.innerPixelNeighbours(d0hBits, iInD0hBits, jInD0hBits, directions, result);
        }
    }

    @Override
    public FlatHashList internalEdges(long hash, int toEdgeDeltaDepth) {
        assert (1 < toEdgeDeltaDepth && toEdgeDeltaDepth < 30);
        int n = (1 << toEdgeDeltaDepth) - 1 << 2;
        FlatHashList result = new FlatHashList(this.depth + toEdgeDeltaDepth, n);
        this.internalEdges(hash, toEdgeDeltaDepth, result);
        return result;
    }

    @Override
    public void internalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        long xMaskDD = HealpixNestedFast.xMask(toEdgeDeltaDepth);
        long yMaskDD = HealpixNestedFast.yMask(toEdgeDeltaDepth);
        hash <<= toEdgeDeltaDepth << 1;
        assert (toEdgeDeltaDepth << 1 == 2 * toEdgeDeltaDepth);
        int am1 = (1 << toEdgeDeltaDepth) - 1;
        assert ((double)(1 << toEdgeDeltaDepth) == Math.pow(2.0, toEdgeDeltaDepth));
        int k1 = am1;
        int k2 = am1 << 1;
        int k3 = am1 << 2;
        result.hList[0] = hash;
        result.hList[k1++] = hash | xMaskDD;
        result.hList[k2] = hash | yMaskDD | xMaskDD;
        k2 += k1;
        result.hList[--k2] = hash | yMaskDD;
        for (int k0 = 1; k0 < am1; ++k0) {
            long kx = this.fc.i02hash(k0);
            long ky = kx << 1;
            result.hList[k0] = hash | kx;
            result.hList[k1++] = hash | ky | xMaskDD;
            result.hList[--k2] = hash | yMaskDD | kx;
            result.hList[--k3] = hash | ky;
        }
        result.size = am1 << 2;
        assert (result.size == 4 * am1);
    }

    @Override
    public FlatHashList sortedInternalEdges(long hash, int deltaDepth) {
        assert (1 < deltaDepth && deltaDepth < 30);
        int n = (1 << deltaDepth) - 1 << 1;
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, n);
        this.sortedInternalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        long xMaskDD = HealpixNestedFast.xMask(toEdgeDeltaDepth);
        long yMaskDD = HealpixNestedFast.yMask(toEdgeDeltaDepth);
        hash <<= toEdgeDeltaDepth << 1;
        assert (toEdgeDeltaDepth << 1 == 2 * toEdgeDeltaDepth);
        int nSide = 1 << toEdgeDeltaDepth;
        int am1 = nSide - 1;
        int nHalfSide = nSide >>> 1;
        int x = 1;
        int k0 = 0;
        int lim = 2;
        int k1 = 2;
        int k2 = am1 + nHalfSide;
        int k3 = (am1 << 1) + nHalfSide;
        int size = am1 << 2;
        result.hList[k0++] = hash;
        result.hList[k2 - 1] = hash | xMaskDD;
        result.hList[k3 - 1] = hash | yMaskDD;
        result.hList[size - k0] = hash | yMaskDD | xMaskDD;
        while (x < nHalfSide) {
            long xs = this.fc.ij2hash(x++, nSide - x);
            long xn = xs & yMaskDD;
            result.hList[k0++] = hash | (xs &= xMaskDD);
            result.hList[k1++] = hash | xs << 1;
            result.hList[k2++] = hash | xs << 1 | xMaskDD;
            result.hList[k3++] = hash | yMaskDD | xs;
            result.hList[size - k0] = hash | yMaskDD | xn >> 1;
            result.hList[size - k1] = hash | xn | xMaskDD;
            result.hList[size - k2] = hash | xn;
            result.hList[size - k3] = hash | xn >> 1;
            int tmp = x & lim;
            assert (x < lim && tmp == 0 || x == lim && tmp == x);
            k0 += tmp >> 1;
            k1 += tmp;
            assert (x < lim && (tmp -= x) < 0 || x == lim && tmp == 0);
            tmp = 1 >> tmp;
            assert (x < lim && tmp == 0 || x == lim && tmp == 1);
            lim <<= tmp;
        }
        result.size = am1 << 2;
        assert (result.size == 4 * (nSide - 1));
    }

    @Override
    public FlatHashList sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdge(hash, deltaDepth, direction, result);
        return result;
    }

    @Override
    public void sortedInternalEdge(long hash, int deltaDepth, CompassPoint.Ordinal direction, FlatHashList result) {
        direction.orderedInternalEdge(this, hash, deltaDepth, result);
    }

    @Override
    public FlatHashList sortedInternalEdgeSE(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeSE(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeSE(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        for (int x = 0; x < nSide; ++x) {
            result.hList[x] = hash | this.fc.i02hash(x);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeNE(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeNE(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeNE(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        long x = nSide - 1 << 32;
        for (int y = 0; y < nSide; ++y) {
            result.hList[y] = hash | this.fc.xy2hash(x >> 32, y);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeNW(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeNW(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeNW(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        long y = nSide - 1 << 32;
        for (int x = 0; x < nSide; ++x) {
            result.hList[x] = hash | this.fc.xy2hash(x, y >> 32);
        }
        result.size = nSide;
    }

    @Override
    public FlatHashList sortedInternalEdgeSW(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 1 << deltaDepth);
        this.sortedInternalEdgeSW(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedInternalEdgeSW(long hash, int deltaDepth, FlatHashList result) {
        hash <<= deltaDepth << 1;
        int nSide = 1 << deltaDepth;
        for (int y = 0; y < nSide; ++y) {
            result.hList[y] = hash | this.fc.i02hash(y);
        }
        result.size = nSide;
    }

    @Override
    public long internalCorner(long hash, int toEdgeDeltaDepth, CompassPoint.Cardinal direction) {
        return direction.internalCorner(this, hash, toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerN(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedFast.xyMask(toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerS(long hash, int toEdgeDeltaDepth) {
        return hash <<= toEdgeDeltaDepth << 1;
    }

    @Override
    public long internalCornerE(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedFast.yMask(toEdgeDeltaDepth);
    }

    @Override
    public long internalCornerW(long hash, int toEdgeDeltaDepth) {
        return (hash <<= toEdgeDeltaDepth << 1) | HealpixNestedFast.xMask(toEdgeDeltaDepth);
    }

    @Override
    public FlatHashList externalEdges(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 4 + (4 << deltaDepth));
        this.externalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void externalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        this.externalEdges(hash, toEdgeDeltaDepth, result, false);
    }

    @Override
    public FlatHashList sortedExternalEdges(long hash, int deltaDepth) {
        FlatHashList result = new FlatHashList(this.depth + deltaDepth, 4 + (4 << deltaDepth));
        this.sortedExternalEdges(hash, deltaDepth, result);
        return result;
    }

    @Override
    public void sortedExternalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result) {
        this.externalEdges(hash, toEdgeDeltaDepth, result, true);
    }

    private void externalEdges(long hash, int toEdgeDeltaDepth, FlatHashList result, boolean sorted) {
        this.checkHashRange(hash);
        result.clear();
        NeighbourList neihbours = new NeighbourList(this.depth);
        long d0hBits = hash & this.d0Mask;
        long iInD0hBits = hash & this.xMask;
        long jInD0hBits = hash & this.yMask;
        if (this.isInBasePixelBorderFromBits(iInD0hBits, jInD0hBits)) {
            int d0h = (int)(hash >> this.twiceDepth);
            hash = this.fc.hash2ij(hash & this.xyMask);
            BaseHash baseHash = BaseHashes.get(d0h);
            this.edgePixelNeighbours(d0h, this.fc.ij2i(hash), this.fc.ij2j(hash), neihbours);
            if (sorted) {
                neihbours.sortByHashAsc();
            }
            for (int i = 0; i < neihbours.size(); ++i) {
                long neigHash = neihbours.get(i);
                CompassPoint.MainWind neigDirection = neihbours.getDirection(i);
                this.appendSortedInternalEdgeElement(neigHash, toEdgeDeltaDepth, baseHash.getDirectionFromNeighbour(neigDirection), result);
            }
        } else {
            this.innerPixelNeighbours(d0hBits, iInD0hBits, jInD0hBits, neihbours);
            if (sorted) {
                neihbours.sortByHashAsc();
            }
            for (int i = 0; i < neihbours.size(); ++i) {
                long neigHash = neihbours.get(i);
                CompassPoint.MainWind neigDirection = neihbours.getDirection(i);
                this.appendSortedInternalEdgeElement(neigHash, toEdgeDeltaDepth, neigDirection.getOppositeDirection(), result);
            }
        }
    }

    private final void checkHashRange(long hash) {
        if (hash < 0L || this.nHash <= hash) {
            throw new IllegalArgumentException("Hash value " + hash + " must be in [0, " + this.nHash + "[");
        }
    }

    private boolean isInBasePixelBorderFromBits(long iInBasePixelBits, long jInBasePixelBits) {
        return 0L == iInBasePixelBits || iInBasePixelBits == this.xMask || 0L == jInBasePixelBits || jInBasePixelBits == this.yMask;
    }

    private void appendSortedInternalEdgeElement(long hash, int toEdgeDeltaDepth, CompassPoint.MainWind direction, FlatHashList result) {
        if (direction.isCardinal()) {
            result.put(this.internalCorner(hash, toEdgeDeltaDepth, direction.toCardinal()));
        } else if (direction.isOrdinal()) {
            result.put(this.sortedInternalEdge(hash, toEdgeDeltaDepth, direction.toOrdinal()));
        } else {
            throw new IllegalArgumentException("Main wind " + (Object)((Object)direction) + " is neither ordinal not cradinal.");
        }
    }

    private void innerPixelNeighbours(long d0hBits, long iBits, long jBits, NeighbourList result) {
        long ij = this.fc.hash2ij(iBits | jBits);
        int i = this.fc.ij2i(ij);
        int j = this.fc.ij2j(ij);
        ij = this.fc.ij2hash(i - 1, j - 1);
        long jm1Bits = ij & this.yMask;
        long im1Bits = ij & this.xMask;
        ij = this.fc.ij2hash(i + 1, j + 1);
        long jp1Bits = ij & this.yMask;
        long ip1Bits = ij & this.xMask;
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jm1Bits), CompassPoint.MainWind.S);
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jm1Bits), CompassPoint.MainWind.SE);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jm1Bits), CompassPoint.MainWind.E);
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jBits), CompassPoint.MainWind.SW);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jBits), CompassPoint.MainWind.NE);
        result.put(HealpixNested.bits2hash(d0hBits, im1Bits, jp1Bits), CompassPoint.MainWind.W);
        result.put(HealpixNested.bits2hash(d0hBits, iBits, jp1Bits), CompassPoint.MainWind.NW);
        result.put(HealpixNested.bits2hash(d0hBits, ip1Bits, jp1Bits), CompassPoint.MainWind.N);
    }

    private void innerPixelNeighbours(long d0hBits, long iBits, long jBits, EnumSet<CompassPoint.MainWind> directions, NeighbourList result) {
        long ij = this.fc.hash2ij(iBits | jBits);
        int i = this.fc.ij2i(ij);
        int j = this.fc.ij2j(ij);
        ij = this.fc.ij2hash(i - 1, j - 1);
        long jm1Bits = ij & this.yMask;
        long im1Bits = ij & this.xMask;
        ij = this.fc.ij2hash(i + 1, j + 1);
        long jp1Bits = ij & this.yMask;
        long ip1Bits = ij & this.xMask;
        for (CompassPoint.MainWind mw : directions) {
            long nHash = HealpixNested.bits2hash(d0hBits, mw.pickRightSouthToEastLongValue(im1Bits, iBits, ip1Bits), mw.pickRightSouthToWestLongValue(jm1Bits, jBits, jp1Bits));
            HealpixNestedFast.addNeighbour(nHash, CompassPoint.MainWind.SE, result);
        }
    }

    private void edgePixelNeighbours(long hash, NeighbourList result) {
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        this.edgePixelNeighbours(d0h, this.fc.ij2i(hash), this.fc.ij2j(hash), result);
    }

    private void edgePixelNeighbours(int baseCellHash, int iInBaseCell, int jInBaseCell, NeighbourList result) {
        HealpixNestedFast.addNeighbourIfExists(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.S), CompassPoint.MainWind.S, result);
        HealpixNestedFast.addNeighbour(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.SE), CompassPoint.MainWind.SE, result);
        HealpixNestedFast.addNeighbourIfExists(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.E), CompassPoint.MainWind.E, result);
        HealpixNestedFast.addNeighbour(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.SW), CompassPoint.MainWind.SW, result);
        HealpixNestedFast.addNeighbour(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.NE), CompassPoint.MainWind.NE, result);
        HealpixNestedFast.addNeighbourIfExists(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.W), CompassPoint.MainWind.W, result);
        HealpixNestedFast.addNeighbour(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.NW), CompassPoint.MainWind.NW, result);
        HealpixNestedFast.addNeighbourIfExists(this.neighbour(baseCellHash, iInBaseCell, jInBaseCell, CompassPoint.MainWind.N), CompassPoint.MainWind.N, result);
    }

    private void edgePixelNeighbours(long hash, EnumSet<CompassPoint.MainWind> directions, NeighbourList neighbours) {
        int d0h = (int)(hash >> this.twiceDepth);
        hash = this.fc.hash2ij(hash & this.xyMask);
        int iInD0h = this.fc.ij2i(hash);
        int jInD0h = this.fc.ij2j(hash);
        for (CompassPoint.MainWind direction : directions) {
            long neigHash = this.neighbour(d0h, iInD0h, jInD0h, direction);
            HealpixNestedFast.addNeighbourIfExists(neigHash, direction, neighbours);
        }
    }

    private long neighbour(int baseCellHash, int iInBaseCell, int jInBaseCell, CompassPoint.MainWind direction) {
        BaseHash baseHash = BaseHashes.get(baseCellHash);
        CompassPoint.MainWind neigBaseCellDirection = this.getNeighbourBaseCellDirection(iInBaseCell += direction.getOffsetSE(), jInBaseCell += direction.getOffsetSW());
        baseCellHash = iInBaseCell;
        iInBaseCell = baseHash.pickRightIndexOnNeighbourSouthToEastAxis(neigBaseCellDirection, iInBaseCell, jInBaseCell, this.nsideRemainderMask);
        jInBaseCell = baseHash.pickRightIndexOnNeighbourSouthToWestAxis(neigBaseCellDirection, baseCellHash, jInBaseCell, this.nsideRemainderMask);
        baseCellHash = baseHash.getNeighbour(neigBaseCellDirection);
        return (long)baseHash.getValue() << this.twiceDepth | this.fc.ij2hash(iInBaseCell, jInBaseCell);
    }

    private CompassPoint.MainWind getNeighbourBaseCellDirection(int iInBaseCell, int jInBaseCell) {
        int neigBaseCellOffsetSE = this.neighbourBaseCellOffset(iInBaseCell);
        int neigBaseCellOffsetSW = this.neighbourBaseCellOffset(jInBaseCell);
        return CompassPoint.MainWind.getFromOffset(neigBaseCellOffsetSE, neigBaseCellOffsetSW);
    }

    private int neighbourBaseCellOffset(int cooInBaseCell) {
        return cooInBaseCell >> 31 | cooInBaseCell >> this.depth;
    }

    private static void addNeighbour(long neighbourHash, FlatHashList result) {
        result.put(neighbourHash);
    }

    private static void addNeighbour(long neighbourHash, CompassPoint.MainWind direction, NeighbourList neighbours) {
        neighbours.put(neighbourHash, direction);
    }

    private static void addNeighbourIfExists(long neighbourHash, CompassPoint.MainWind direction, NeighbourList neighbours) {
        if (neighbourHash >= 0L) {
            HealpixNestedFast.addNeighbour(neighbourHash, direction, neighbours);
        }
    }

    private static long xMask(int depth) {
        return 0x5555555555555555L >>> 64 - (depth << 1);
    }

    private static long yMask(int depth) {
        return -6148914691236517206L >>> 64 - (depth << 1);
    }

    private static long xyMask(int depth) {
        return -1L >>> 64 - (depth << 1);
    }
}

