# PySNMP SMI module. Autogenerated from smidump -f python WWW-MIB
# by libsmi2pysnmp-0.1.3 at Mon Apr  2 20:39:50 2012,
# Python version sys.version_info(major=2, minor=7, micro=2, releaselevel='final', serial=0)

# Imports

( Integer, ObjectIdentifier, OctetString, ) = mibBuilder.importSymbols("ASN1", "Integer", "ObjectIdentifier", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsIntersection, ConstraintsUnion, SingleValueConstraint, ValueRangeConstraint, ValueSizeConstraint, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsIntersection", "ConstraintsUnion", "SingleValueConstraint", "ValueRangeConstraint", "ValueSizeConstraint")
( ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "ModuleCompliance", "ObjectGroup")
( Bits, Counter32, Counter64, Integer32, Integer32, ModuleIdentity, MibIdentifier, MibScalar, MibTable, MibTableRow, MibTableColumn, TimeTicks, TimeTicks, Unsigned32, mib_2, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "Counter32", "Counter64", "Integer32", "Integer32", "ModuleIdentity", "MibIdentifier", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "TimeTicks", "TimeTicks", "Unsigned32", "mib-2")
( DateAndTime, DisplayString, TextualConvention, TimeInterval, ) = mibBuilder.importSymbols("SNMPv2-TC", "DateAndTime", "DisplayString", "TextualConvention", "TimeInterval")
( Utf8String, ) = mibBuilder.importSymbols("SYSAPPL-MIB", "Utf8String")

# Types

class WwwDocName(TextualConvention, OctetString):
    displayHint = "255a"
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(0,255)
    
class WwwOperStatus(Integer):
    subtypeSpec = Integer.subtypeSpec+SingleValueConstraint(1,2,3,5,4,)
    namedValues = NamedValues(("down", 1), ("running", 2), ("halted", 3), ("congested", 4), ("restarting", 5), )
    
class WwwRequestType(OctetString):
    subtypeSpec = OctetString.subtypeSpec+ValueSizeConstraint(1,40)
    
class WwwResponseType(Integer32):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)
    

# Objects

wwwMIB = ModuleIdentity((1, 3, 6, 1, 2, 1, 65)).setRevisions(("1999-02-25 14:00",))
if mibBuilder.loadTexts: wwwMIB.setOrganization("IETF Application MIB Working Group")
if mibBuilder.loadTexts: wwwMIB.setContactInfo("        Harrie Hazewinkel\n\nPostal: Joint Research Centre of the E.C.\n        via Fermi - Ispra 21020 (VA)\n        Italy\n\n   Tel: +39+(0)332 786322\n   Fax: +39+(0)332 785641\nE-mail: harrie.hazewinkel@jrc.it\n\n        Carl W. Kalbfleisch\n\nPostal: Verio, Inc.\n        1950 Stemmons Freeway\n        Suite 2006\n        Dallas, TX 75207\n        US\n\n   Tel: +1 214 290-8653\n   Fax: +1 214 744-0742\nE-mail: cwk@verio.net\n\n        Juergen Schoenwaelder\n\nPostal: TU Braunschweig\n        Bueltenweg 74/75\n        38106 Braunschweig\n        Germany\n\n   Tel: +49 531 391-3683\n   Fax: +49 531 489-5936\nE-mail: schoenw@ibr.cs.tu-bs.de")
if mibBuilder.loadTexts: wwwMIB.setDescription("This WWW service MIB module is applicable to services\nrealized by a family of 'Document Transfer Protocols'\n(DTP). Examples of DTPs are HTTP and FTP.")
wwwMIBObjects = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1))
wwwService = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 1))
wwwServiceTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 1, 1))
if mibBuilder.loadTexts: wwwServiceTable.setDescription("The table of the WWW services known by the SNMP agent.")
wwwServiceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwServiceEntry.setDescription("Details about a particular WWW service.")
wwwServiceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwServiceIndex.setDescription("An integer used to uniquely identify a WWW service. The\nvalue must be the same as the corresponding value of the\napplSrvIndex defined in the Application Management MIB\n(APPLICATION-MIB) if the applSrvIndex object is available.\nIt might be necessary to manually configure sub-agents in\norder to meet this requirement.")
wwwServiceDescription = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 2), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceDescription.setDescription("Textual description of the WWW service. This shall include\nat least the vendor and version number of the application\nrealizing the WWW service. In a minimal case, this might\nbe the Product Token (see RFC 2068) for the application.")
wwwServiceContact = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 3), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceContact.setDescription("The textual identification of the contact person for this\nservice, together with information on how to contact this\nperson. For instance, this might be a string containing an\nemail address, e.g. '<webmaster@domain.name>'.")
wwwServiceProtocol = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 4), ObjectIdentifier()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceProtocol.setDescription("An identification of the primary protocol in use by this\nservice. For Internet applications, the IANA maintains\na registry of the OIDs which correspond to well-known\napplication protocols.  If the application protocol is not\nlisted in the registry, an OID value of the form\n{applTCPProtoID port} or {applUDPProtoID port} are used for\nTCP-based and UDP-based protocols, respectively. In either\ncase 'port' corresponds to the primary port number being\nused by the protocol.")
wwwServiceName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 5), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceName.setDescription("The fully qualified domain name by which this service is\nknown. This object must contain the virtual host name if\nthe service is realized for a virtual host.")
wwwServiceType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 6), Integer().subtype(subtypeSpec=SingleValueConstraint(3,4,5,2,1,)).subtype(namedValues=NamedValues(("wwwOther", 1), ("wwwServer", 2), ("wwwClient", 3), ("wwwProxy", 4), ("wwwCachingProxy", 5), ))).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceType.setDescription("The application type using or realizing this WWW service.")
wwwServiceStartTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 7), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceStartTime.setDescription("The date and time when this WWW service was last started.\nThe value SHALL be '0000000000000000'H if the last start\ntime of this WWW service is not known.")
wwwServiceOperStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 8), WwwOperStatus()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceOperStatus.setDescription("Indicates the operational status of the WWW service.")
wwwServiceLastChange = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1, 9), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwServiceLastChange.setDescription("The date and time when this WWW service entered its current\noperational state. The value SHALL be '0000000000000000'H if\nthe time of the last state change is not known.")
wwwProtocolStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 2))
wwwSummaryTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 1))
if mibBuilder.loadTexts: wwwSummaryTable.setDescription("The table providing overview statistics for the\nWWW services on this system.")
wwwSummaryEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwSummaryEntry.setDescription("Overview statistics for an individual service.")
wwwSummaryInRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 1), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInRequests.setDescription("The number of requests successfully received.")
wwwSummaryOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutRequests.setDescription("The number of requests generated.")
wwwSummaryInResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInResponses.setDescription("The number of responses successfully received.")
wwwSummaryOutResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 4), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutResponses.setDescription("The number of responses generated.")
wwwSummaryInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 5), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInBytes.setDescription("The number of content bytes received.")
wwwSummaryInLowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryInLowBytes.setDescription("The lowest thirty-two bits of wwwSummaryInBytes.")
wwwSummaryOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 7), Counter64()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutBytes.setDescription("The number of content bytes transmitted.")
wwwSummaryOutLowBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 1, 1, 8), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwSummaryOutLowBytes.setDescription("The lowest thirty-two bits of wwwSummaryOutBytes.")
wwwRequestInTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 2))
if mibBuilder.loadTexts: wwwRequestInTable.setDescription("The table providing detailed statistics for requests\nreceived by WWW services on this system.")
wwwRequestInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwRequestInIndex"))
if mibBuilder.loadTexts: wwwRequestInEntry.setDescription("Request statistics for an individual service.")
wwwRequestInIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 1), WwwRequestType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwRequestInIndex.setDescription("The particular request type the statistics apply to.")
wwwRequestInRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInRequests.setDescription("The number of requests of this type received by this\nWWW service.")
wwwRequestInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInBytes.setDescription("The number of content bytes per request type received\nby this WWW service.")
wwwRequestInLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 2, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestInLastTime.setDescription("The date and time when the last byte of the last complete\nrequest of this type was received by this WWW service. The\nvalue SHALL be '0000000000000000'H if no request of this\ntype has been received yet.")
wwwRequestOutTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 3))
if mibBuilder.loadTexts: wwwRequestOutTable.setDescription("The table providing detailed statistics for requests\ngenerated by the services on this system.")
wwwRequestOutEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwRequestOutIndex"))
if mibBuilder.loadTexts: wwwRequestOutEntry.setDescription("Request statistics for an individual service.")
wwwRequestOutIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 1), WwwRequestType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwRequestOutIndex.setDescription("The particular request type the statistics apply to.")
wwwRequestOutRequests = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutRequests.setDescription("The number of requests of this type generated by this\nWWW service.")
wwwRequestOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutBytes.setDescription("The number of content bytes per requests type generated\nby this WWW service.")
wwwRequestOutLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 3, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwRequestOutLastTime.setDescription("The date and time when the first byte of the last request\nof this type was send by this WWW service. The value SHALL\nbe '0000000000000000'H if no request of this type has been\nsend yet.")
wwwResponseInTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 4))
if mibBuilder.loadTexts: wwwResponseInTable.setDescription("The table providing detailed statistics for responses\nreceived by WWW services on this system.")
wwwResponseInEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwResponseInIndex"))
if mibBuilder.loadTexts: wwwResponseInEntry.setDescription("Response statistics for an individual service.")
wwwResponseInIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 1), WwwResponseType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwResponseInIndex.setDescription("The particular response type the statistics apply to.")
wwwResponseInResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInResponses.setDescription("The number of responses of this type received by this\nWWW service.")
wwwResponseInBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInBytes.setDescription("The number of content bytes per response type received\nby this WWW service.")
wwwResponseInLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 4, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseInLastTime.setDescription("The date and time when the last byte of the last complete\nresponse of this type was received by this WWW service. The\nvalue SHALL be '0000000000000000'H if no response of this\ntype has been received yet.")
wwwResponseOutTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 2, 5))
if mibBuilder.loadTexts: wwwResponseOutTable.setDescription("The table providing detailed statistics for responses\ngenerated by services on this system.")
wwwResponseOutEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwResponseOutIndex"))
if mibBuilder.loadTexts: wwwResponseOutEntry.setDescription("Response statistics for an individual service.")
wwwResponseOutIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 1), WwwResponseType()).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwResponseOutIndex.setDescription("The particular response type the statistics apply to.")
wwwResponseOutResponses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 2), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutResponses.setDescription("The number of responses of this type generated by this\nWWW service.")
wwwResponseOutBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 3), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutBytes.setDescription("The number of content bytes per response type generated\nby this WWW service.")
wwwResponseOutLastTime = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 2, 5, 1, 4), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwResponseOutLastTime.setDescription("The date and time when the first byte of the last response of\nthis type was sent by this WWW service. The value SHALL be\n'0000000000000000'H if response of this type has been send\nyet.")
wwwDocumentStatistics = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 1, 3))
wwwDocCtrlTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 1))
if mibBuilder.loadTexts: wwwDocCtrlTable.setDescription("A table which controls how the MIB implementation\ncollects and maintains document statistics.")
wwwDocCtrlEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"))
if mibBuilder.loadTexts: wwwDocCtrlEntry.setDescription("An entry used to configure the wwwDocLastNTable,\nthe wwwDocBucketTable, the wwwDocAccessTopNTable,\nand the wwwDocBytesTopNTable.")
wwwDocCtrlLastNSize = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 1), Unsigned32().clone(25)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlLastNSize.setDescription("The maximum number of entries in the wwwDocLastNTable.")
wwwDocCtrlLastNLock = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 2), TimeTicks()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlLastNLock.setDescription("This object allows a manager to lock the wwwDocLastNTable\nin order to retrieve the wwwDocLastNTable in a consistent\nstate. The agent is expected to take a snapshot of the\nwwwDocLastNTable when it is locked and to continue updating\nthe real wwwDocLastNTable table so that recent information is\navailable as soon as the wwwDocLastNTable is unlocked again.\n\nSetting this object to a value greater than 0 will lock\nthe table. The timer ticks backwards until it reaches 0.\nThe table unlocks automatically once the timer reaches 0\nand the timer stops ticking.\n\nA manager can increase the timer to request more time to\nread the table. However, any attempt to decrease the timer\nwill fail with an inconsistentValue error. This rule ensures\nthat multiple managers can simultaneously lock and retrieve\nthe wwwDocLastNTable. Note that managers must cooperate in\nusing wwwDocCtrlLastNLock. In particular, a manager MUST not\nkeep the wwwDocLastNTable locked when it is not necessary to\nfinish a retrieval operation.")
wwwDocCtrlBuckets = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 3), Unsigned32().clone(4)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlBuckets.setDescription("The maximum number of buckets maintained by the agent\nbefore the oldest bucket is deleted. The buckets are\nused to populate the wwwDocAccessTopNTable and the\nwwwDocBytesTopNTable. The time interval captured in\neach bucket can be configured by setting the\nwwwDocCtrlBucketTimeInterval object.")
wwwDocCtrlBucketTimeInterval = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 4), TimeInterval().clone('90000')).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlBucketTimeInterval.setDescription("The time interval after which a new bucket is created.\nChanging this object has no effect on existing buckets.")
wwwDocCtrlTopNSize = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 1, 1, 5), Unsigned32().clone(25)).setMaxAccess("readwrite")
if mibBuilder.loadTexts: wwwDocCtrlTopNSize.setDescription("The maximum number of entries shown in the\nwwwDocAccessTopNTable and the wwwDocBytesTopNTable.\nChanging this object has no effect on existing buckets.")
wwwDocLastNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 2))
if mibBuilder.loadTexts: wwwDocLastNTable.setDescription("The table which logs the last N access attempts.")
wwwDocLastNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocLastNIndex"))
if mibBuilder.loadTexts: wwwDocLastNEntry.setDescription("An entry which describes a recent access attempt.")
wwwDocLastNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwDocLastNIndex.setDescription("An arbitrary monotonically increasing integer number used\nfor indexing the wwwDocLastNTable. The first document\naccessed appears in the table with this index value equal\nto one. Each subsequent document is indexed with the next\nsequential index value. The Nth document accessed will be\nindexed by N. This table presents a sliding window of the\nlast wwwDocCtrlLastNSize documents accessed. Thus, entries\nin this table will be indexed by N-wwwDocCtrlLastNSize\nthru N if N > wwwDocCtrlLastNSize and 1 thru N if\nN <= wwwDocCtrlLastNSize.\n\nThe wwwDocCtrlLastNLock attribute can be used to lock\nthis table to allow the manager to read its contents.")
wwwDocLastNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNName.setDescription("The name of the document for which access was attempted.")
wwwDocLastNTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 3), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNTimeStamp.setDescription("The date and time of the last attempt to access this\ndocument.")
wwwDocLastNRequestType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 4), WwwRequestType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNRequestType.setDescription("The protocol request type which was received by the\nserver when this document access was attempted.")
wwwDocLastNResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNResponseType.setDescription("The protocol response type which was sent to the client\nas a result of this attempt to access a document. This\nobject contains the type of the primary response if\nthere were multiple responses to a single request.")
wwwDocLastNStatusMsg = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 6), Utf8String()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNStatusMsg.setDescription("This object contains a human readable description of the\nreason why the wwwDocLastNResponseType was returned to the\nclient. This object defines the implementation-specific\nreason if the value of wwwDocLastNResponseType indicates\nan error. For example, this object can indicate that the\nrequested document could not be transferred due to a\ntimeout condition or the document could not be transferred\nbecause a 'soft link' pointing to the document could not be\nresolved.")
wwwDocLastNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 2, 1, 7), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocLastNBytes.setDescription("The number of content bytes that were returned as a\nresult of this attempt to access a document.")
wwwDocBucketTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 3))
if mibBuilder.loadTexts: wwwDocBucketTable.setDescription("This table provides administrative summary information for\nthe buckets maintained per WWW service.")
wwwDocBucketEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"))
if mibBuilder.loadTexts: wwwDocBucketEntry.setDescription("An entry which describes the parameters associated with a\nparticular bucket.")
wwwDocBucketIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwDocBucketIndex.setDescription("An arbitrary monotonically increasing integer number\nused for indexing the wwwDocBucketTable. The index number\nwraps to 1 whenever the maximum value is reached.")
wwwDocBucketTimeStamp = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 2), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketTimeStamp.setDescription("The date and time when the bucket was made available.")
wwwDocBucketAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketAccesses.setDescription("The total number of access attempts for any document\nprovided by this WWW service during the time interval\nover which this bucket was created.")
wwwDocBucketDocuments = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketDocuments.setDescription("The total number of different documents for which access\nwas attempted this this WWW service during the time interval\nover which this bucket was created.")
wwwDocBucketBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 3, 1, 5), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBucketBytes.setDescription("The total number of content bytes which were transferred\nfrom this WWW service during the time interval over which\nthis bucket was created.")
wwwDocAccessTopNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 4))
if mibBuilder.loadTexts: wwwDocAccessTopNTable.setDescription("The table of the most frequently accessed documents in a\ngiven bucket. This table is sorted by the column\nwwwDocAccessTopNAccesses. Entries having the same number\nof accesses are secondarily sorted by wwwDocAccessTopNBytes.\nEntries with the same number of accesses and the same\nnumber of bytes will have an arbitrary order.")
wwwDocAccessTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"), (0, "WWW-MIB", "wwwDocAccessTopNIndex"))
if mibBuilder.loadTexts: wwwDocAccessTopNEntry.setDescription("An entry in the top N table sorted by document accesses.")
wwwDocAccessTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwDocAccessTopNIndex.setDescription("An arbitrary monotonically increasing integer number\nused for indexing the wwwDocAccessTopNTable. The index is\ninversely correlated to the sorting order of the table. The\ndocument with the highest access count will get the index\nvalue 1.")
wwwDocAccessTopNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNName.setDescription("The name of the document for which access was attempted.")
wwwDocAccessTopNAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNAccesses.setDescription("The total number of access attempts for this document.")
wwwDocAccessTopNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNBytes.setDescription("The total number of content bytes that were transmitted\nas a result of attempts to access this document.")
wwwDocAccessTopNLastResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 4, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocAccessTopNLastResponseType.setDescription("The protocol response type which was sent to the client\nas a result of the last attempt to access this document.\nThis object contains the type of the primary response if\nthere were multiple responses to a single request.")
wwwDocBytesTopNTable = MibTable((1, 3, 6, 1, 2, 1, 65, 1, 3, 5))
if mibBuilder.loadTexts: wwwDocBytesTopNTable.setDescription("The table of the documents which caused most network\ntraffic in a given bucket. This table is sorted by the\ncolumn wwwDocBytesTopNBytes. Entries having the same number\nbytes are secondarily sorted by wwwDocBytesTopNAccesses.\nEntries with the same number of accesses and the same\nnumber of bytes will have an arbitrary order.")
wwwDocBytesTopNEntry = MibTableRow((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1)).setIndexNames((0, "WWW-MIB", "wwwServiceIndex"), (0, "WWW-MIB", "wwwDocBucketIndex"), (0, "WWW-MIB", "wwwDocBytesTopNIndex"))
if mibBuilder.loadTexts: wwwDocBytesTopNEntry.setDescription("An entry in the top N table sorted by network traffic.")
wwwDocBytesTopNIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 1), Unsigned32().subtype(subtypeSpec=ValueRangeConstraint(1, 4294967295))).setMaxAccess("noaccess")
if mibBuilder.loadTexts: wwwDocBytesTopNIndex.setDescription("An arbitrary monotonically increasing integer number\nused for indexing the wwwDocBytesTopNTable. The index is\ninversely correlated to the sorting order of the table. The\ndocument with the highest byte count will get the index\nvalue 1.")
wwwDocBytesTopNName = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 2), WwwDocName()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNName.setDescription("The name of the document for which access was attempted.")
wwwDocBytesTopNAccesses = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 3), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNAccesses.setDescription("The total number of access attempts for this document.")
wwwDocBytesTopNBytes = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 4), Unsigned32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNBytes.setDescription("The total number of content bytes that were transmitted\nas a result of attempts to access this document.")
wwwDocBytesTopNLastResponseType = MibTableColumn((1, 3, 6, 1, 2, 1, 65, 1, 3, 5, 1, 5), WwwResponseType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: wwwDocBytesTopNLastResponseType.setDescription("The protocol response type which was sent to the client\nas a result of the last attempt to access this document.\nThis object contains the type of the primary response if\nthere were multiple responses to a single request.")
wwwMIBConformance = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2))
wwwMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2, 1))
wwwMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 65, 2, 2))

# Augmentions

# Groups

wwwServiceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 1)).setObjects(*(("WWW-MIB", "wwwServiceOperStatus"), ("WWW-MIB", "wwwServiceContact"), ("WWW-MIB", "wwwServiceStartTime"), ("WWW-MIB", "wwwServiceProtocol"), ("WWW-MIB", "wwwServiceName"), ("WWW-MIB", "wwwServiceType"), ("WWW-MIB", "wwwServiceDescription"), ("WWW-MIB", "wwwServiceLastChange"), ) )
if mibBuilder.loadTexts: wwwServiceGroup.setDescription("A collection of objects providing information about\nthe WWW services known by the SNMP agent.")
wwwSummaryGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 2)).setObjects(*(("WWW-MIB", "wwwSummaryOutResponses"), ("WWW-MIB", "wwwSummaryOutLowBytes"), ("WWW-MIB", "wwwSummaryOutBytes"), ("WWW-MIB", "wwwSummaryInBytes"), ("WWW-MIB", "wwwSummaryInLowBytes"), ("WWW-MIB", "wwwSummaryInRequests"), ("WWW-MIB", "wwwSummaryOutRequests"), ("WWW-MIB", "wwwSummaryInResponses"), ) )
if mibBuilder.loadTexts: wwwSummaryGroup.setDescription("A collection of objects providing summary statistics\nabout requests and responses generated and received\nby a WWW service.")
wwwRequestInGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 3)).setObjects(*(("WWW-MIB", "wwwRequestInLastTime"), ("WWW-MIB", "wwwRequestInRequests"), ("WWW-MIB", "wwwRequestInBytes"), ) )
if mibBuilder.loadTexts: wwwRequestInGroup.setDescription("A collection of objects providing detailed statistics\nabout requests received by a WWW service.")
wwwRequestOutGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 4)).setObjects(*(("WWW-MIB", "wwwRequestOutBytes"), ("WWW-MIB", "wwwRequestOutLastTime"), ("WWW-MIB", "wwwRequestOutRequests"), ) )
if mibBuilder.loadTexts: wwwRequestOutGroup.setDescription("A collection of objects providing detailed statistics\nabout requests generated by a WWW service.")
wwwResponseInGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 5)).setObjects(*(("WWW-MIB", "wwwResponseInResponses"), ("WWW-MIB", "wwwResponseInBytes"), ("WWW-MIB", "wwwResponseInLastTime"), ) )
if mibBuilder.loadTexts: wwwResponseInGroup.setDescription("A collection of objects providing detailed statistics\nabout responses received by a WWW service.")
wwwResponseOutGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 6)).setObjects(*(("WWW-MIB", "wwwResponseOutLastTime"), ("WWW-MIB", "wwwResponseOutBytes"), ("WWW-MIB", "wwwResponseOutResponses"), ) )
if mibBuilder.loadTexts: wwwResponseOutGroup.setDescription("A collection of objects providing detailed statistics\nabout responses generated by a WWW service.")
wwwDocumentGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 65, 2, 2, 7)).setObjects(*(("WWW-MIB", "wwwDocLastNRequestType"), ("WWW-MIB", "wwwDocLastNResponseType"), ("WWW-MIB", "wwwDocBytesTopNAccesses"), ("WWW-MIB", "wwwDocLastNStatusMsg"), ("WWW-MIB", "wwwDocBucketDocuments"), ("WWW-MIB", "wwwDocLastNTimeStamp"), ("WWW-MIB", "wwwDocLastNName"), ("WWW-MIB", "wwwDocCtrlLastNSize"), ("WWW-MIB", "wwwDocAccessTopNLastResponseType"), ("WWW-MIB", "wwwDocAccessTopNName"), ("WWW-MIB", "wwwDocBytesTopNLastResponseType"), ("WWW-MIB", "wwwDocLastNBytes"), ("WWW-MIB", "wwwDocCtrlBuckets"), ("WWW-MIB", "wwwDocCtrlTopNSize"), ("WWW-MIB", "wwwDocCtrlBucketTimeInterval"), ("WWW-MIB", "wwwDocBucketAccesses"), ("WWW-MIB", "wwwDocAccessTopNAccesses"), ("WWW-MIB", "wwwDocBytesTopNName"), ("WWW-MIB", "wwwDocCtrlLastNLock"), ("WWW-MIB", "wwwDocAccessTopNBytes"), ("WWW-MIB", "wwwDocBytesTopNBytes"), ("WWW-MIB", "wwwDocBucketTimeStamp"), ("WWW-MIB", "wwwDocBucketBytes"), ) )
if mibBuilder.loadTexts: wwwDocumentGroup.setDescription("A collection of objects providing information about\naccesses to documents.")

# Compliances

wwwMinimalCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 65, 2, 1, 1)).setObjects(*(("WWW-MIB", "wwwSummaryGroup"), ("WWW-MIB", "wwwServiceGroup"), ) )
if mibBuilder.loadTexts: wwwMinimalCompliance.setDescription("The compliance statement for SNMP agents which implement\nthe minimal subset of the WWW-MIB. Implementors might\nchoose this subset for high-performance server where\nfull compliance might be to expensive.")
wwwFullCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 65, 2, 1, 2)).setObjects(*(("WWW-MIB", "wwwSummaryGroup"), ("WWW-MIB", "wwwResponseOutGroup"), ("WWW-MIB", "wwwResponseInGroup"), ("WWW-MIB", "wwwDocumentGroup"), ("WWW-MIB", "wwwRequestOutGroup"), ("WWW-MIB", "wwwServiceGroup"), ("WWW-MIB", "wwwRequestInGroup"), ) )
if mibBuilder.loadTexts: wwwFullCompliance.setDescription("The compliance statement for SNMP agents which implement\nthe full WWW-MIB.")

# Exports

# Module identity
mibBuilder.exportSymbols("WWW-MIB", PYSNMP_MODULE_ID=wwwMIB)

# Types
mibBuilder.exportSymbols("WWW-MIB", WwwDocName=WwwDocName, WwwOperStatus=WwwOperStatus, WwwRequestType=WwwRequestType, WwwResponseType=WwwResponseType)

# Objects
mibBuilder.exportSymbols("WWW-MIB", wwwMIB=wwwMIB, wwwMIBObjects=wwwMIBObjects, wwwService=wwwService, wwwServiceTable=wwwServiceTable, wwwServiceEntry=wwwServiceEntry, wwwServiceIndex=wwwServiceIndex, wwwServiceDescription=wwwServiceDescription, wwwServiceContact=wwwServiceContact, wwwServiceProtocol=wwwServiceProtocol, wwwServiceName=wwwServiceName, wwwServiceType=wwwServiceType, wwwServiceStartTime=wwwServiceStartTime, wwwServiceOperStatus=wwwServiceOperStatus, wwwServiceLastChange=wwwServiceLastChange, wwwProtocolStatistics=wwwProtocolStatistics, wwwSummaryTable=wwwSummaryTable, wwwSummaryEntry=wwwSummaryEntry, wwwSummaryInRequests=wwwSummaryInRequests, wwwSummaryOutRequests=wwwSummaryOutRequests, wwwSummaryInResponses=wwwSummaryInResponses, wwwSummaryOutResponses=wwwSummaryOutResponses, wwwSummaryInBytes=wwwSummaryInBytes, wwwSummaryInLowBytes=wwwSummaryInLowBytes, wwwSummaryOutBytes=wwwSummaryOutBytes, wwwSummaryOutLowBytes=wwwSummaryOutLowBytes, wwwRequestInTable=wwwRequestInTable, wwwRequestInEntry=wwwRequestInEntry, wwwRequestInIndex=wwwRequestInIndex, wwwRequestInRequests=wwwRequestInRequests, wwwRequestInBytes=wwwRequestInBytes, wwwRequestInLastTime=wwwRequestInLastTime, wwwRequestOutTable=wwwRequestOutTable, wwwRequestOutEntry=wwwRequestOutEntry, wwwRequestOutIndex=wwwRequestOutIndex, wwwRequestOutRequests=wwwRequestOutRequests, wwwRequestOutBytes=wwwRequestOutBytes, wwwRequestOutLastTime=wwwRequestOutLastTime, wwwResponseInTable=wwwResponseInTable, wwwResponseInEntry=wwwResponseInEntry, wwwResponseInIndex=wwwResponseInIndex, wwwResponseInResponses=wwwResponseInResponses, wwwResponseInBytes=wwwResponseInBytes, wwwResponseInLastTime=wwwResponseInLastTime, wwwResponseOutTable=wwwResponseOutTable, wwwResponseOutEntry=wwwResponseOutEntry, wwwResponseOutIndex=wwwResponseOutIndex, wwwResponseOutResponses=wwwResponseOutResponses, wwwResponseOutBytes=wwwResponseOutBytes, wwwResponseOutLastTime=wwwResponseOutLastTime, wwwDocumentStatistics=wwwDocumentStatistics, wwwDocCtrlTable=wwwDocCtrlTable, wwwDocCtrlEntry=wwwDocCtrlEntry, wwwDocCtrlLastNSize=wwwDocCtrlLastNSize, wwwDocCtrlLastNLock=wwwDocCtrlLastNLock, wwwDocCtrlBuckets=wwwDocCtrlBuckets, wwwDocCtrlBucketTimeInterval=wwwDocCtrlBucketTimeInterval, wwwDocCtrlTopNSize=wwwDocCtrlTopNSize, wwwDocLastNTable=wwwDocLastNTable, wwwDocLastNEntry=wwwDocLastNEntry, wwwDocLastNIndex=wwwDocLastNIndex, wwwDocLastNName=wwwDocLastNName, wwwDocLastNTimeStamp=wwwDocLastNTimeStamp, wwwDocLastNRequestType=wwwDocLastNRequestType, wwwDocLastNResponseType=wwwDocLastNResponseType, wwwDocLastNStatusMsg=wwwDocLastNStatusMsg, wwwDocLastNBytes=wwwDocLastNBytes, wwwDocBucketTable=wwwDocBucketTable, wwwDocBucketEntry=wwwDocBucketEntry, wwwDocBucketIndex=wwwDocBucketIndex, wwwDocBucketTimeStamp=wwwDocBucketTimeStamp, wwwDocBucketAccesses=wwwDocBucketAccesses, wwwDocBucketDocuments=wwwDocBucketDocuments, wwwDocBucketBytes=wwwDocBucketBytes, wwwDocAccessTopNTable=wwwDocAccessTopNTable, wwwDocAccessTopNEntry=wwwDocAccessTopNEntry, wwwDocAccessTopNIndex=wwwDocAccessTopNIndex, wwwDocAccessTopNName=wwwDocAccessTopNName, wwwDocAccessTopNAccesses=wwwDocAccessTopNAccesses, wwwDocAccessTopNBytes=wwwDocAccessTopNBytes, wwwDocAccessTopNLastResponseType=wwwDocAccessTopNLastResponseType, wwwDocBytesTopNTable=wwwDocBytesTopNTable, wwwDocBytesTopNEntry=wwwDocBytesTopNEntry, wwwDocBytesTopNIndex=wwwDocBytesTopNIndex, wwwDocBytesTopNName=wwwDocBytesTopNName, wwwDocBytesTopNAccesses=wwwDocBytesTopNAccesses, wwwDocBytesTopNBytes=wwwDocBytesTopNBytes, wwwDocBytesTopNLastResponseType=wwwDocBytesTopNLastResponseType, wwwMIBConformance=wwwMIBConformance, wwwMIBCompliances=wwwMIBCompliances, wwwMIBGroups=wwwMIBGroups)

# Groups
mibBuilder.exportSymbols("WWW-MIB", wwwServiceGroup=wwwServiceGroup, wwwSummaryGroup=wwwSummaryGroup, wwwRequestInGroup=wwwRequestInGroup, wwwRequestOutGroup=wwwRequestOutGroup, wwwResponseInGroup=wwwResponseInGroup, wwwResponseOutGroup=wwwResponseOutGroup, wwwDocumentGroup=wwwDocumentGroup)

# Compliances
mibBuilder.exportSymbols("WWW-MIB", wwwMinimalCompliance=wwwMinimalCompliance, wwwFullCompliance=wwwFullCompliance)
