package gift

import (
	"image"
	"testing"
)

func TestPixelate(t *testing.T) {
	testData := []struct {
		desc           string
		size           int
		srcb, dstb     image.Rectangle
		srcPix, dstPix []uint8
	}{
		{
			"pixelate (0)",
			0,
			image.Rect(-1, -1, 4, 2),
			image.Rect(0, 0, 5, 3),
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
		},
		{
			"pixelate (1)",
			1,
			image.Rect(-1, -1, 4, 2),
			image.Rect(0, 0, 5, 3),
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
		},
		{
			"pixelate (2)",
			2,
			image.Rect(-1, -1, 4, 2),
			image.Rect(0, 0, 5, 3),
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
			[]uint8{
				0x54, 0x54, 0x64, 0x64, 0x30,
				0x54, 0x54, 0x64, 0x64, 0x30,
				0x40, 0x40, 0x40, 0x40, 0x00,
			},
		},
		{
			"pixelate (3)",
			3,
			image.Rect(-1, -1, 4, 2),
			image.Rect(0, 0, 5, 3),
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
			[]uint8{
				0x45, 0x45, 0x45, 0x4d, 0x4d,
				0x45, 0x45, 0x45, 0x4d, 0x4d,
				0x45, 0x45, 0x45, 0x4d, 0x4d,
			},
		},
		{
			"pixelate (10)",
			10,
			image.Rect(-1, -1, 4, 2),
			image.Rect(0, 0, 5, 3),
			[]uint8{
				0x00, 0x40, 0x00, 0x40, 0x00,
				0x60, 0xB0, 0xA0, 0xB0, 0x60,
				0x00, 0x80, 0x00, 0x80, 0x00,
			},
			[]uint8{
				0x49, 0x49, 0x49, 0x49, 0x49,
				0x49, 0x49, 0x49, 0x49, 0x49,
				0x49, 0x49, 0x49, 0x49, 0x49,
			},
		},
		{
			"pixelate 0x0",
			3,
			image.Rect(-1, -1, -1, -1),
			image.Rect(0, 0, 0, 0),
			[]uint8{},
			[]uint8{},
		},
	}

	for _, d := range testData {
		src := image.NewGray(d.srcb)
		src.Pix = d.srcPix

		f := Pixelate(d.size)
		dst := image.NewGray(f.Bounds(src.Bounds()))
		f.Draw(dst, src, nil)

		if !checkBoundsAndPix(dst.Bounds(), d.dstb, dst.Pix, d.dstPix) {
			t.Errorf("test [%s] failed: %#v, %#v", d.desc, dst.Bounds(), dst.Pix)
		}
	}
}
