// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package textract

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
)

const opAnalyzeDocument = "AnalyzeDocument"

// AnalyzeDocumentRequest generates a "aws/request.Request" representing the
// client's request for the AnalyzeDocument operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AnalyzeDocument for more information on using the AnalyzeDocument
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AnalyzeDocumentRequest method.
//	req, resp := client.AnalyzeDocumentRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument
func (c *Textract) AnalyzeDocumentRequest(input *AnalyzeDocumentInput) (req *request.Request, output *AnalyzeDocumentOutput) {
	op := &request.Operation{
		Name:       opAnalyzeDocument,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AnalyzeDocumentInput{}
	}

	output = &AnalyzeDocumentOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AnalyzeDocument API operation for Amazon Textract.
//
// Analyzes an input document for relationships between detected items.
//
// The types of information returned are as follows:
//
//   - Form data (key-value pairs). The related information is returned in
//     two Block objects, each of type KEY_VALUE_SET: a KEY Block object and
//     a VALUE Block object. For example, Name: Ana Silva Carolina contains a
//     key and value. Name: is the key. Ana Silva Carolina is the value.
//
//   - Table and table cell data. A TABLE Block object contains information
//     about a detected table. A CELL Block object is returned for each cell
//     in a table.
//
//   - Lines and words of text. A LINE Block object contains one or more WORD
//     Block objects. All lines and words that are detected in the document are
//     returned (including text that doesn't have a relationship with the value
//     of FeatureTypes).
//
//   - Query. A QUERY Block object contains the query text, alias and link
//     to the associated Query results block object.
//
//   - Query Result. A QUERY_RESULT Block object contains the answer to the
//     query and an ID that connects it to the query asked. This Block also contains
//     a confidence score.
//
// Selection elements such as check boxes and option buttons (radio buttons)
// can be detected in form data and in tables. A SELECTION_ELEMENT Block object
// contains information about a selection element, including the selection status.
//
// You can choose which type of analysis to perform by specifying the FeatureTypes
// list.
//
// The output is returned in a list of Block objects.
//
// AnalyzeDocument is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation AnalyzeDocument for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - HumanLoopQuotaExceededException
//     Indicates you have exceeded the maximum number of active human in the loop
//     workflows available
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeDocument
func (c *Textract) AnalyzeDocument(input *AnalyzeDocumentInput) (*AnalyzeDocumentOutput, error) {
	req, out := c.AnalyzeDocumentRequest(input)
	return out, req.Send()
}

// AnalyzeDocumentWithContext is the same as AnalyzeDocument with the addition of
// the ability to pass a context and additional request options.
//
// See AnalyzeDocument for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) AnalyzeDocumentWithContext(ctx aws.Context, input *AnalyzeDocumentInput, opts ...request.Option) (*AnalyzeDocumentOutput, error) {
	req, out := c.AnalyzeDocumentRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAnalyzeExpense = "AnalyzeExpense"

// AnalyzeExpenseRequest generates a "aws/request.Request" representing the
// client's request for the AnalyzeExpense operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AnalyzeExpense for more information on using the AnalyzeExpense
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AnalyzeExpenseRequest method.
//	req, resp := client.AnalyzeExpenseRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeExpense
func (c *Textract) AnalyzeExpenseRequest(input *AnalyzeExpenseInput) (req *request.Request, output *AnalyzeExpenseOutput) {
	op := &request.Operation{
		Name:       opAnalyzeExpense,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AnalyzeExpenseInput{}
	}

	output = &AnalyzeExpenseOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AnalyzeExpense API operation for Amazon Textract.
//
// AnalyzeExpense synchronously analyzes an input document for financially related
// relationships between text.
//
// Information is returned as ExpenseDocuments and seperated as follows:
//
//   - LineItemGroups- A data set containing LineItems which store information
//     about the lines of text, such as an item purchased and its price on a
//     receipt.
//
//   - SummaryFields- Contains all other information a receipt, such as header
//     information or the vendors name.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation AnalyzeExpense for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeExpense
func (c *Textract) AnalyzeExpense(input *AnalyzeExpenseInput) (*AnalyzeExpenseOutput, error) {
	req, out := c.AnalyzeExpenseRequest(input)
	return out, req.Send()
}

// AnalyzeExpenseWithContext is the same as AnalyzeExpense with the addition of
// the ability to pass a context and additional request options.
//
// See AnalyzeExpense for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) AnalyzeExpenseWithContext(ctx aws.Context, input *AnalyzeExpenseInput, opts ...request.Option) (*AnalyzeExpenseOutput, error) {
	req, out := c.AnalyzeExpenseRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAnalyzeID = "AnalyzeID"

// AnalyzeIDRequest generates a "aws/request.Request" representing the
// client's request for the AnalyzeID operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See AnalyzeID for more information on using the AnalyzeID
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the AnalyzeIDRequest method.
//	req, resp := client.AnalyzeIDRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeID
func (c *Textract) AnalyzeIDRequest(input *AnalyzeIDInput) (req *request.Request, output *AnalyzeIDOutput) {
	op := &request.Operation{
		Name:       opAnalyzeID,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AnalyzeIDInput{}
	}

	output = &AnalyzeIDOutput{}
	req = c.newRequest(op, input, output)
	return
}

// AnalyzeID API operation for Amazon Textract.
//
// Analyzes identity documents for relevant information. This information is
// extracted and returned as IdentityDocumentFields, which records both the
// normalized field and value of the extracted text.Unlike other Amazon Textract
// operations, AnalyzeID doesn't return any Geometry data.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation AnalyzeID for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/AnalyzeID
func (c *Textract) AnalyzeID(input *AnalyzeIDInput) (*AnalyzeIDOutput, error) {
	req, out := c.AnalyzeIDRequest(input)
	return out, req.Send()
}

// AnalyzeIDWithContext is the same as AnalyzeID with the addition of
// the ability to pass a context and additional request options.
//
// See AnalyzeID for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) AnalyzeIDWithContext(ctx aws.Context, input *AnalyzeIDInput, opts ...request.Option) (*AnalyzeIDOutput, error) {
	req, out := c.AnalyzeIDRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDetectDocumentText = "DetectDocumentText"

// DetectDocumentTextRequest generates a "aws/request.Request" representing the
// client's request for the DetectDocumentText operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DetectDocumentText for more information on using the DetectDocumentText
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the DetectDocumentTextRequest method.
//	req, resp := client.DetectDocumentTextRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText
func (c *Textract) DetectDocumentTextRequest(input *DetectDocumentTextInput) (req *request.Request, output *DetectDocumentTextOutput) {
	op := &request.Operation{
		Name:       opDetectDocumentText,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DetectDocumentTextInput{}
	}

	output = &DetectDocumentTextOutput{}
	req = c.newRequest(op, input, output)
	return
}

// DetectDocumentText API operation for Amazon Textract.
//
// Detects text in the input document. Amazon Textract can detect lines of text
// and the words that make up a line of text. The input document must be in
// one of the following image formats: JPEG, PNG, PDF, or TIFF. DetectDocumentText
// returns the detected text in an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// DetectDocumentText is a synchronous operation. To analyze documents asynchronously,
// use StartDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation DetectDocumentText for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/DetectDocumentText
func (c *Textract) DetectDocumentText(input *DetectDocumentTextInput) (*DetectDocumentTextOutput, error) {
	req, out := c.DetectDocumentTextRequest(input)
	return out, req.Send()
}

// DetectDocumentTextWithContext is the same as DetectDocumentText with the addition of
// the ability to pass a context and additional request options.
//
// See DetectDocumentText for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) DetectDocumentTextWithContext(ctx aws.Context, input *DetectDocumentTextInput, opts ...request.Option) (*DetectDocumentTextOutput, error) {
	req, out := c.DetectDocumentTextRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentAnalysis = "GetDocumentAnalysis"

// GetDocumentAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentAnalysis for more information on using the GetDocumentAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDocumentAnalysisRequest method.
//	req, resp := client.GetDocumentAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis
func (c *Textract) GetDocumentAnalysisRequest(input *GetDocumentAnalysisInput) (req *request.Request, output *GetDocumentAnalysisOutput) {
	op := &request.Operation{
		Name:       opGetDocumentAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentAnalysisInput{}
	}

	output = &GetDocumentAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentAnalysis API operation for Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that analyzes
// text in a document.
//
// You start asynchronous text analysis by calling StartDocumentAnalysis, which
// returns a job identifier (JobId). When the text analysis operation finishes,
// Amazon Textract publishes a completion status to the Amazon Simple Notification
// Service (Amazon SNS) topic that's registered in the initial call to StartDocumentAnalysis.
// To get the results of the text-detection operation, first check that the
// status value published to the Amazon SNS topic is SUCCEEDED. If so, call
// GetDocumentAnalysis, and pass the job identifier (JobId) from the initial
// call to StartDocumentAnalysis.
//
// GetDocumentAnalysis returns an array of Block objects. The following types
// of information are returned:
//
//   - Form data (key-value pairs). The related information is returned in
//     two Block objects, each of type KEY_VALUE_SET: a KEY Block object and
//     a VALUE Block object. For example, Name: Ana Silva Carolina contains a
//     key and value. Name: is the key. Ana Silva Carolina is the value.
//
//   - Table and table cell data. A TABLE Block object contains information
//     about a detected table. A CELL Block object is returned for each cell
//     in a table.
//
//   - Lines and words of text. A LINE Block object contains one or more WORD
//     Block objects. All lines and words that are detected in the document are
//     returned (including text that doesn't have a relationship with the value
//     of the StartDocumentAnalysis FeatureTypes input parameter).
//
//   - Query. A QUERY Block object contains the query text, alias and link
//     to the associated Query results block object.
//
//   - Query Results. A QUERY_RESULT Block object contains the answer to the
//     query and an ID that connects it to the query asked. This Block also contains
//     a confidence score.
//
// While processing a document with queries, look out for INVALID_REQUEST_PARAMETERS
// output. This indicates that either the per page query limit has been exceeded
// or that the operation is trying to query a page in the document which doesn’t
// exist.
//
// Selection elements such as check boxes and option buttons (radio buttons)
// can be detected in form data and in tables. A SELECTION_ELEMENT Block object
// contains information about a selection element, including the selection status.
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetDocumentAnalysis,
// and populate the NextToken request parameter with the token value that's
// returned from the previous call to GetDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation GetDocumentAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InvalidJobIdException
//     An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentAnalysis
func (c *Textract) GetDocumentAnalysis(input *GetDocumentAnalysisInput) (*GetDocumentAnalysisOutput, error) {
	req, out := c.GetDocumentAnalysisRequest(input)
	return out, req.Send()
}

// GetDocumentAnalysisWithContext is the same as GetDocumentAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) GetDocumentAnalysisWithContext(ctx aws.Context, input *GetDocumentAnalysisInput, opts ...request.Option) (*GetDocumentAnalysisOutput, error) {
	req, out := c.GetDocumentAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDocumentTextDetection = "GetDocumentTextDetection"

// GetDocumentTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the GetDocumentTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDocumentTextDetection for more information on using the GetDocumentTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetDocumentTextDetectionRequest method.
//	req, resp := client.GetDocumentTextDetectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection
func (c *Textract) GetDocumentTextDetectionRequest(input *GetDocumentTextDetectionInput) (req *request.Request, output *GetDocumentTextDetectionOutput) {
	op := &request.Operation{
		Name:       opGetDocumentTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetDocumentTextDetectionInput{}
	}

	output = &GetDocumentTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDocumentTextDetection API operation for Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that detects
// text in a document. Amazon Textract can detect lines of text and the words
// that make up a line of text.
//
// You start asynchronous text detection by calling StartDocumentTextDetection,
// which returns a job identifier (JobId). When the text detection operation
// finishes, Amazon Textract publishes a completion status to the Amazon Simple
// Notification Service (Amazon SNS) topic that's registered in the initial
// call to StartDocumentTextDetection. To get the results of the text-detection
// operation, first check that the status value published to the Amazon SNS
// topic is SUCCEEDED. If so, call GetDocumentTextDetection, and pass the job
// identifier (JobId) from the initial call to StartDocumentTextDetection.
//
// GetDocumentTextDetection returns an array of Block objects.
//
// Each document page has as an associated Block of type PAGE. Each PAGE Block
// object is the parent of LINE Block objects that represent the lines of detected
// text on a page. A LINE Block object is a parent for each word that makes
// up the line. Words are represented by Block objects of type WORD.
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetDocumentTextDetection,
// and populate the NextToken request parameter with the token value that's
// returned from the previous call to GetDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation GetDocumentTextDetection for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InvalidJobIdException
//     An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetDocumentTextDetection
func (c *Textract) GetDocumentTextDetection(input *GetDocumentTextDetectionInput) (*GetDocumentTextDetectionOutput, error) {
	req, out := c.GetDocumentTextDetectionRequest(input)
	return out, req.Send()
}

// GetDocumentTextDetectionWithContext is the same as GetDocumentTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See GetDocumentTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) GetDocumentTextDetectionWithContext(ctx aws.Context, input *GetDocumentTextDetectionInput, opts ...request.Option) (*GetDocumentTextDetectionOutput, error) {
	req, out := c.GetDocumentTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetExpenseAnalysis = "GetExpenseAnalysis"

// GetExpenseAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the GetExpenseAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetExpenseAnalysis for more information on using the GetExpenseAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the GetExpenseAnalysisRequest method.
//	req, resp := client.GetExpenseAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetExpenseAnalysis
func (c *Textract) GetExpenseAnalysisRequest(input *GetExpenseAnalysisInput) (req *request.Request, output *GetExpenseAnalysisOutput) {
	op := &request.Operation{
		Name:       opGetExpenseAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetExpenseAnalysisInput{}
	}

	output = &GetExpenseAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetExpenseAnalysis API operation for Amazon Textract.
//
// Gets the results for an Amazon Textract asynchronous operation that analyzes
// invoices and receipts. Amazon Textract finds contact information, items purchased,
// and vendor name, from input invoices and receipts.
//
// You start asynchronous invoice/receipt analysis by calling StartExpenseAnalysis,
// which returns a job identifier (JobId). Upon completion of the invoice/receipt
// analysis, Amazon Textract publishes the completion status to the Amazon Simple
// Notification Service (Amazon SNS) topic. This topic must be registered in
// the initial call to StartExpenseAnalysis. To get the results of the invoice/receipt
// analysis operation, first ensure that the status value published to the Amazon
// SNS topic is SUCCEEDED. If so, call GetExpenseAnalysis, and pass the job
// identifier (JobId) from the initial call to StartExpenseAnalysis.
//
// Use the MaxResults parameter to limit the number of blocks that are returned.
// If there are more results than specified in MaxResults, the value of NextToken
// in the operation response contains a pagination token for getting the next
// set of results. To get the next page of results, call GetExpenseAnalysis,
// and populate the NextToken request parameter with the token value that's
// returned from the previous call to GetExpenseAnalysis.
//
// For more information, see Analyzing Invoices and Receipts (https://docs.aws.amazon.com/textract/latest/dg/invoices-receipts.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation GetExpenseAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InvalidJobIdException
//     An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/GetExpenseAnalysis
func (c *Textract) GetExpenseAnalysis(input *GetExpenseAnalysisInput) (*GetExpenseAnalysisOutput, error) {
	req, out := c.GetExpenseAnalysisRequest(input)
	return out, req.Send()
}

// GetExpenseAnalysisWithContext is the same as GetExpenseAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See GetExpenseAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) GetExpenseAnalysisWithContext(ctx aws.Context, input *GetExpenseAnalysisInput, opts ...request.Option) (*GetExpenseAnalysisOutput, error) {
	req, out := c.GetExpenseAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDocumentAnalysis = "StartDocumentAnalysis"

// StartDocumentAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentAnalysis for more information on using the StartDocumentAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDocumentAnalysisRequest method.
//	req, resp := client.StartDocumentAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis
func (c *Textract) StartDocumentAnalysisRequest(input *StartDocumentAnalysisInput) (req *request.Request, output *StartDocumentAnalysisOutput) {
	op := &request.Operation{
		Name:       opStartDocumentAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentAnalysisInput{}
	}

	output = &StartDocumentAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentAnalysis API operation for Amazon Textract.
//
// Starts the asynchronous analysis of an input document for relationships between
// detected items such as key-value pairs, tables, and selection elements.
//
// StartDocumentAnalysis can analyze text in documents that are in JPEG, PNG,
// TIFF, and PDF format. The documents are stored in an Amazon S3 bucket. Use
// DocumentLocation to specify the bucket name and file name of the document.
//
// StartDocumentAnalysis returns a job identifier (JobId) that you use to get
// the results of the operation. When text analysis is finished, Amazon Textract
// publishes a completion status to the Amazon Simple Notification Service (Amazon
// SNS) topic that you specify in NotificationChannel. To get the results of
// the text analysis operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. If so, call GetDocumentAnalysis, and
// pass the job identifier (JobId) from the initial call to StartDocumentAnalysis.
//
// For more information, see Document Text Analysis (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-analyzing.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation StartDocumentAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - IdempotentParameterMismatchException
//     A ClientRequestToken input parameter was reused with an operation, but at
//     least one of the other input parameters is different from the previous call
//     to the operation.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - LimitExceededException
//     An Amazon Textract service limit was exceeded. For example, if you start
//     too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
//     for example) raise a LimitExceededException exception (HTTP status code:
//     400) until the number of concurrently running jobs is below the Amazon Textract
//     service limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentAnalysis
func (c *Textract) StartDocumentAnalysis(input *StartDocumentAnalysisInput) (*StartDocumentAnalysisOutput, error) {
	req, out := c.StartDocumentAnalysisRequest(input)
	return out, req.Send()
}

// StartDocumentAnalysisWithContext is the same as StartDocumentAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) StartDocumentAnalysisWithContext(ctx aws.Context, input *StartDocumentAnalysisInput, opts ...request.Option) (*StartDocumentAnalysisOutput, error) {
	req, out := c.StartDocumentAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartDocumentTextDetection = "StartDocumentTextDetection"

// StartDocumentTextDetectionRequest generates a "aws/request.Request" representing the
// client's request for the StartDocumentTextDetection operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartDocumentTextDetection for more information on using the StartDocumentTextDetection
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartDocumentTextDetectionRequest method.
//	req, resp := client.StartDocumentTextDetectionRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection
func (c *Textract) StartDocumentTextDetectionRequest(input *StartDocumentTextDetectionInput) (req *request.Request, output *StartDocumentTextDetectionOutput) {
	op := &request.Operation{
		Name:       opStartDocumentTextDetection,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartDocumentTextDetectionInput{}
	}

	output = &StartDocumentTextDetectionOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartDocumentTextDetection API operation for Amazon Textract.
//
// Starts the asynchronous detection of text in a document. Amazon Textract
// can detect lines of text and the words that make up a line of text.
//
// StartDocumentTextDetection can analyze text in documents that are in JPEG,
// PNG, TIFF, and PDF format. The documents are stored in an Amazon S3 bucket.
// Use DocumentLocation to specify the bucket name and file name of the document.
//
// StartTextDetection returns a job identifier (JobId) that you use to get the
// results of the operation. When text detection is finished, Amazon Textract
// publishes a completion status to the Amazon Simple Notification Service (Amazon
// SNS) topic that you specify in NotificationChannel. To get the results of
// the text detection operation, first check that the status value published
// to the Amazon SNS topic is SUCCEEDED. If so, call GetDocumentTextDetection,
// and pass the job identifier (JobId) from the initial call to StartDocumentTextDetection.
//
// For more information, see Document Text Detection (https://docs.aws.amazon.com/textract/latest/dg/how-it-works-detecting.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation StartDocumentTextDetection for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - IdempotentParameterMismatchException
//     A ClientRequestToken input parameter was reused with an operation, but at
//     least one of the other input parameters is different from the previous call
//     to the operation.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - LimitExceededException
//     An Amazon Textract service limit was exceeded. For example, if you start
//     too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
//     for example) raise a LimitExceededException exception (HTTP status code:
//     400) until the number of concurrently running jobs is below the Amazon Textract
//     service limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartDocumentTextDetection
func (c *Textract) StartDocumentTextDetection(input *StartDocumentTextDetectionInput) (*StartDocumentTextDetectionOutput, error) {
	req, out := c.StartDocumentTextDetectionRequest(input)
	return out, req.Send()
}

// StartDocumentTextDetectionWithContext is the same as StartDocumentTextDetection with the addition of
// the ability to pass a context and additional request options.
//
// See StartDocumentTextDetection for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) StartDocumentTextDetectionWithContext(ctx aws.Context, input *StartDocumentTextDetectionInput, opts ...request.Option) (*StartDocumentTextDetectionOutput, error) {
	req, out := c.StartDocumentTextDetectionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opStartExpenseAnalysis = "StartExpenseAnalysis"

// StartExpenseAnalysisRequest generates a "aws/request.Request" representing the
// client's request for the StartExpenseAnalysis operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See StartExpenseAnalysis for more information on using the StartExpenseAnalysis
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//	// Example sending a request using the StartExpenseAnalysisRequest method.
//	req, resp := client.StartExpenseAnalysisRequest(params)
//
//	err := req.Send()
//	if err == nil { // resp is now filled
//	    fmt.Println(resp)
//	}
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartExpenseAnalysis
func (c *Textract) StartExpenseAnalysisRequest(input *StartExpenseAnalysisInput) (req *request.Request, output *StartExpenseAnalysisOutput) {
	op := &request.Operation{
		Name:       opStartExpenseAnalysis,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &StartExpenseAnalysisInput{}
	}

	output = &StartExpenseAnalysisOutput{}
	req = c.newRequest(op, input, output)
	return
}

// StartExpenseAnalysis API operation for Amazon Textract.
//
// Starts the asynchronous analysis of invoices or receipts for data like contact
// information, items purchased, and vendor names.
//
// StartExpenseAnalysis can analyze text in documents that are in JPEG, PNG,
// and PDF format. The documents must be stored in an Amazon S3 bucket. Use
// the DocumentLocation parameter to specify the name of your S3 bucket and
// the name of the document in that bucket.
//
// StartExpenseAnalysis returns a job identifier (JobId) that you will provide
// to GetExpenseAnalysis to retrieve the results of the operation. When the
// analysis of the input invoices/receipts is finished, Amazon Textract publishes
// a completion status to the Amazon Simple Notification Service (Amazon SNS)
// topic that you provide to the NotificationChannel. To obtain the results
// of the invoice and receipt analysis operation, ensure that the status value
// published to the Amazon SNS topic is SUCCEEDED. If so, call GetExpenseAnalysis,
// and pass the job identifier (JobId) that was returned by your call to StartExpenseAnalysis.
//
// For more information, see Analyzing Invoices and Receipts (https://docs.aws.amazon.com/textract/latest/dg/invoice-receipts.html).
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon Textract's
// API operation StartExpenseAnalysis for usage and error information.
//
// Returned Error Types:
//
//   - InvalidParameterException
//     An input parameter violated a constraint. For example, in synchronous operations,
//     an InvalidParameterException exception occurs when neither of the S3Object
//     or Bytes values are supplied in the Document request parameter. Validate
//     your parameter before calling the API operation again.
//
//   - InvalidS3ObjectException
//     Amazon Textract is unable to access the S3 object that's specified in the
//     request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
//     For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
//
//   - InvalidKMSKeyException
//     Indicates you do not have decrypt permissions with the KMS key entered, or
//     the KMS key was entered incorrectly.
//
//   - UnsupportedDocumentException
//     The format of the input document isn't supported. Documents for operations
//     can be in PNG, JPEG, PDF, or TIFF format.
//
//   - DocumentTooLargeException
//     The document can't be processed because it's too large. The maximum document
//     size for synchronous operations 10 MB. The maximum document size for asynchronous
//     operations is 500 MB for PDF files.
//
//   - BadDocumentException
//     Amazon Textract isn't able to read the document. For more information on
//     the document limits in Amazon Textract, see limits.
//
//   - AccessDeniedException
//     You aren't authorized to perform the action. Use the Amazon Resource Name
//     (ARN) of an authorized user or IAM role to perform the operation.
//
//   - ProvisionedThroughputExceededException
//     The number of requests exceeded your throughput limit. If you want to increase
//     this limit, contact Amazon Textract.
//
//   - InternalServerError
//     Amazon Textract experienced a service issue. Try your call again.
//
//   - IdempotentParameterMismatchException
//     A ClientRequestToken input parameter was reused with an operation, but at
//     least one of the other input parameters is different from the previous call
//     to the operation.
//
//   - ThrottlingException
//     Amazon Textract is temporarily unable to process the request. Try your call
//     again.
//
//   - LimitExceededException
//     An Amazon Textract service limit was exceeded. For example, if you start
//     too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
//     for example) raise a LimitExceededException exception (HTTP status code:
//     400) until the number of concurrently running jobs is below the Amazon Textract
//     service limit.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/textract-2018-06-27/StartExpenseAnalysis
func (c *Textract) StartExpenseAnalysis(input *StartExpenseAnalysisInput) (*StartExpenseAnalysisOutput, error) {
	req, out := c.StartExpenseAnalysisRequest(input)
	return out, req.Send()
}

// StartExpenseAnalysisWithContext is the same as StartExpenseAnalysis with the addition of
// the ability to pass a context and additional request options.
//
// See StartExpenseAnalysis for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *Textract) StartExpenseAnalysisWithContext(ctx aws.Context, input *StartExpenseAnalysisInput, opts ...request.Option) (*StartExpenseAnalysisOutput, error) {
	req, out := c.StartExpenseAnalysisRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You aren't authorized to perform the action. Use the Amazon Resource Name
// (ARN) of an authorized user or IAM role to perform the operation.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type AnalyzeDocumentInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPEG, PNG, PDF, or TIFF format.
	//
	// If you're using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes that are passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`

	// A list of the types of analysis to perform. Add TABLES to the list to return
	// information about the tables that are detected in the input document. Add
	// FORMS to return detected form data. To perform both types of analysis, add
	// TABLES and FORMS to FeatureTypes. All lines and words detected in the document
	// are included in the response (including text that isn't related to the value
	// of FeatureTypes).
	//
	// FeatureTypes is a required field
	FeatureTypes []*string `type:"list" required:"true" enum:"FeatureType"`

	// Sets the configuration for the human in the loop workflow for analyzing documents.
	HumanLoopConfig *HumanLoopConfig `type:"structure"`

	// Contains Queries and the alias for those Queries, as determined by the input.
	QueriesConfig *QueriesConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeDocumentInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeDocumentInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyzeDocumentInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyzeDocumentInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.FeatureTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTypes"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}
	if s.HumanLoopConfig != nil {
		if err := s.HumanLoopConfig.Validate(); err != nil {
			invalidParams.AddNested("HumanLoopConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueriesConfig != nil {
		if err := s.QueriesConfig.Validate(); err != nil {
			invalidParams.AddNested("QueriesConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *AnalyzeDocumentInput) SetDocument(v *Document) *AnalyzeDocumentInput {
	s.Document = v
	return s
}

// SetFeatureTypes sets the FeatureTypes field's value.
func (s *AnalyzeDocumentInput) SetFeatureTypes(v []*string) *AnalyzeDocumentInput {
	s.FeatureTypes = v
	return s
}

// SetHumanLoopConfig sets the HumanLoopConfig field's value.
func (s *AnalyzeDocumentInput) SetHumanLoopConfig(v *HumanLoopConfig) *AnalyzeDocumentInput {
	s.HumanLoopConfig = v
	return s
}

// SetQueriesConfig sets the QueriesConfig field's value.
func (s *AnalyzeDocumentInput) SetQueriesConfig(v *QueriesConfig) *AnalyzeDocumentInput {
	s.QueriesConfig = v
	return s
}

type AnalyzeDocumentOutput struct {
	_ struct{} `type:"structure"`

	// The version of the model used to analyze the document.
	AnalyzeDocumentModelVersion *string `type:"string"`

	// The items that are detected and analyzed by AnalyzeDocument.
	Blocks []*Block `type:"list"`

	// Metadata about the analyzed document. An example is the number of pages.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// Shows the results of the human in the loop evaluation.
	HumanLoopActivationOutput *HumanLoopActivationOutput `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeDocumentOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeDocumentOutput) GoString() string {
	return s.String()
}

// SetAnalyzeDocumentModelVersion sets the AnalyzeDocumentModelVersion field's value.
func (s *AnalyzeDocumentOutput) SetAnalyzeDocumentModelVersion(v string) *AnalyzeDocumentOutput {
	s.AnalyzeDocumentModelVersion = &v
	return s
}

// SetBlocks sets the Blocks field's value.
func (s *AnalyzeDocumentOutput) SetBlocks(v []*Block) *AnalyzeDocumentOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *AnalyzeDocumentOutput) SetDocumentMetadata(v *DocumentMetadata) *AnalyzeDocumentOutput {
	s.DocumentMetadata = v
	return s
}

// SetHumanLoopActivationOutput sets the HumanLoopActivationOutput field's value.
func (s *AnalyzeDocumentOutput) SetHumanLoopActivationOutput(v *HumanLoopActivationOutput) *AnalyzeDocumentOutput {
	s.HumanLoopActivationOutput = v
	return s
}

type AnalyzeExpenseInput struct {
	_ struct{} `type:"structure"`

	// The input document, either as bytes or as an S3 object.
	//
	// You pass image bytes to an Amazon Textract API operation by using the Bytes
	// property. For example, you would use the Bytes property to pass a document
	// loaded from a local file system. Image bytes passed by using the Bytes property
	// must be base64 encoded. Your code might not need to encode document file
	// bytes if you're using an AWS SDK to call Amazon Textract API operations.
	//
	// You pass images stored in an S3 bucket to an Amazon Textract API operation
	// by using the S3Object property. Documents stored in an S3 bucket don't need
	// to be base64 encoded.
	//
	// The AWS Region for the S3 bucket that contains the S3 object must match the
	// AWS Region that you use for Amazon Textract operations.
	//
	// If you use the AWS CLI to call Amazon Textract operations, passing image
	// bytes using the Bytes property isn't supported. You must first upload the
	// document to an Amazon S3 bucket, and then call the operation using the S3Object
	// property.
	//
	// For Amazon Textract to process an S3 object, the user must have permission
	// to access the S3 object.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeExpenseInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeExpenseInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyzeExpenseInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyzeExpenseInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *AnalyzeExpenseInput) SetDocument(v *Document) *AnalyzeExpenseInput {
	s.Document = v
	return s
}

type AnalyzeExpenseOutput struct {
	_ struct{} `type:"structure"`

	// Information about the input document.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The expenses detected by Amazon Textract.
	ExpenseDocuments []*ExpenseDocument `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeExpenseOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeExpenseOutput) GoString() string {
	return s.String()
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *AnalyzeExpenseOutput) SetDocumentMetadata(v *DocumentMetadata) *AnalyzeExpenseOutput {
	s.DocumentMetadata = v
	return s
}

// SetExpenseDocuments sets the ExpenseDocuments field's value.
func (s *AnalyzeExpenseOutput) SetExpenseDocuments(v []*ExpenseDocument) *AnalyzeExpenseOutput {
	s.ExpenseDocuments = v
	return s
}

// Used to contain the information detected by an AnalyzeID operation.
type AnalyzeIDDetections struct {
	_ struct{} `type:"structure"`

	// The confidence score of the detected text.
	Confidence *float64 `type:"float"`

	// Only returned for dates, returns the type of value detected and the date
	// written in a more machine readable way.
	NormalizedValue *NormalizedValue `type:"structure"`

	// Text of either the normalized field or value associated with it.
	//
	// Text is a required field
	Text *string `type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDDetections) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDDetections) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *AnalyzeIDDetections) SetConfidence(v float64) *AnalyzeIDDetections {
	s.Confidence = &v
	return s
}

// SetNormalizedValue sets the NormalizedValue field's value.
func (s *AnalyzeIDDetections) SetNormalizedValue(v *NormalizedValue) *AnalyzeIDDetections {
	s.NormalizedValue = v
	return s
}

// SetText sets the Text field's value.
func (s *AnalyzeIDDetections) SetText(v string) *AnalyzeIDDetections {
	s.Text = &v
	return s
}

type AnalyzeIDInput struct {
	_ struct{} `type:"structure"`

	// The document being passed to AnalyzeID.
	//
	// DocumentPages is a required field
	DocumentPages []*Document `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AnalyzeIDInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AnalyzeIDInput"}
	if s.DocumentPages == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentPages"))
	}
	if s.DocumentPages != nil && len(s.DocumentPages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DocumentPages", 1))
	}
	if s.DocumentPages != nil {
		for i, v := range s.DocumentPages {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "DocumentPages", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocumentPages sets the DocumentPages field's value.
func (s *AnalyzeIDInput) SetDocumentPages(v []*Document) *AnalyzeIDInput {
	s.DocumentPages = v
	return s
}

type AnalyzeIDOutput struct {
	_ struct{} `type:"structure"`

	// The version of the AnalyzeIdentity API being used to process documents.
	AnalyzeIDModelVersion *string `type:"string"`

	// Information about the input document.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The list of documents processed by AnalyzeID. Includes a number denoting
	// their place in the list and the response structure for the document.
	IdentityDocuments []*IdentityDocument `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AnalyzeIDOutput) GoString() string {
	return s.String()
}

// SetAnalyzeIDModelVersion sets the AnalyzeIDModelVersion field's value.
func (s *AnalyzeIDOutput) SetAnalyzeIDModelVersion(v string) *AnalyzeIDOutput {
	s.AnalyzeIDModelVersion = &v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *AnalyzeIDOutput) SetDocumentMetadata(v *DocumentMetadata) *AnalyzeIDOutput {
	s.DocumentMetadata = v
	return s
}

// SetIdentityDocuments sets the IdentityDocuments field's value.
func (s *AnalyzeIDOutput) SetIdentityDocuments(v []*IdentityDocument) *AnalyzeIDOutput {
	s.IdentityDocuments = v
	return s
}

// Amazon Textract isn't able to read the document. For more information on
// the document limits in Amazon Textract, see limits.
type BadDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BadDocumentException) GoString() string {
	return s.String()
}

func newErrorBadDocumentException(v protocol.ResponseMetadata) error {
	return &BadDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *BadDocumentException) Code() string {
	return "BadDocumentException"
}

// Message returns the exception's message.
func (s *BadDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *BadDocumentException) OrigErr() error {
	return nil
}

func (s *BadDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *BadDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *BadDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A Block represents items that are recognized in a document within a group
// of pixels close to each other. The information returned in a Block object
// depends on the type of operation. In text detection for documents (for example
// DetectDocumentText), you get information about the detected words and lines
// of text. In text analysis (for example AnalyzeDocument), you can also get
// information about the fields, tables, and selection elements that are detected
// in the document.
//
// An array of Block objects is returned by both synchronous and asynchronous
// operations. In synchronous operations, such as DetectDocumentText, the array
// of Block objects is the entire set of results. In asynchronous operations,
// such as GetDocumentAnalysis, the array is returned over one or more responses.
//
// For more information, see How Amazon Textract Works (https://docs.aws.amazon.com/textract/latest/dg/how-it-works.html).
type Block struct {
	_ struct{} `type:"structure"`

	// The type of text item that's recognized. In operations for text detection,
	// the following types are returned:
	//
	//    * PAGE - Contains a list of the LINE Block objects that are detected on
	//    a document page.
	//
	//    * WORD - A word detected on a document page. A word is one or more ISO
	//    basic Latin script characters that aren't separated by spaces.
	//
	//    * LINE - A string of tab-delimited, contiguous words that are detected
	//    on a document page.
	//
	// In text analysis operations, the following types are returned:
	//
	//    * PAGE - Contains a list of child Block objects that are detected on a
	//    document page.
	//
	//    * KEY_VALUE_SET - Stores the KEY and VALUE Block objects for linked text
	//    that's detected on a document page. Use the EntityType field to determine
	//    if a KEY_VALUE_SET object is a KEY Block object or a VALUE Block object.
	//
	//    * WORD - A word that's detected on a document page. A word is one or more
	//    ISO basic Latin script characters that aren't separated by spaces.
	//
	//    * LINE - A string of tab-delimited, contiguous words that are detected
	//    on a document page.
	//
	//    * TABLE - A table that's detected on a document page. A table is grid-based
	//    information with two or more rows or columns, with a cell span of one
	//    row and one column each.
	//
	//    * CELL - A cell within a detected table. The cell is the parent of the
	//    block that contains the text in the cell.
	//
	//    * SELECTION_ELEMENT - A selection element such as an option button (radio
	//    button) or a check box that's detected on a document page. Use the value
	//    of SelectionStatus to determine the status of the selection element.
	//
	//    * QUERY - A question asked during the call of AnalyzeDocument. Contains
	//    an alias and an ID that attaches it to its answer.
	//
	//    * QUERY_RESULT - A response to a question asked during the call of analyze
	//    document. Comes with an alias and ID for ease of locating in a response.
	//    Also contains location and confidence score.
	BlockType *string `type:"string" enum:"BlockType"`

	// The column in which a table cell appears. The first column position is 1.
	// ColumnIndex isn't returned by DetectDocumentText and GetDocumentTextDetection.
	ColumnIndex *int64 `type:"integer"`

	// The number of columns that a table cell spans. Currently this value is always
	// 1, even if the number of columns spanned is greater than 1. ColumnSpan isn't
	// returned by DetectDocumentText and GetDocumentTextDetection.
	ColumnSpan *int64 `type:"integer"`

	// The confidence score that Amazon Textract has in the accuracy of the recognized
	// text and the accuracy of the geometry points around the recognized text.
	Confidence *float64 `type:"float"`

	// The type of entity. The following can be returned:
	//
	//    * KEY - An identifier for a field on the document.
	//
	//    * VALUE - The field text.
	//
	// EntityTypes isn't returned by DetectDocumentText and GetDocumentTextDetection.
	EntityTypes []*string `type:"list" enum:"EntityType"`

	// The location of the recognized text on the image. It includes an axis-aligned,
	// coarse bounding box that surrounds the text, and a finer-grain polygon for
	// more accurate spatial information.
	Geometry *Geometry `type:"structure"`

	// The identifier for the recognized text. The identifier is only unique for
	// a single operation.
	Id *string `type:"string"`

	// The page on which a block was detected. Page is returned by synchronous and
	// asynchronous operations. Page values greater than 1 are only returned for
	// multipage documents that are in PDF or TIFF format. A scanned image (JPEG/PNG)
	// provided to an asynchronous operation, even if it contains multiple document
	// pages, is considered a single-page document. This means that for scanned
	// images the value of Page is always 1. Synchronous operations operations will
	// also return a Page value of 1 because every input document is considered
	// to be a single-page document.
	Page *int64 `type:"integer"`

	// Each query contains the question you want to ask in the Text and the alias
	// you want to associate.
	Query *Query `type:"structure"`

	// A list of child blocks of the current block. For example, a LINE object has
	// child blocks for each WORD block that's part of the line of text. There aren't
	// Relationship objects in the list for relationships that don't exist, such
	// as when the current block has no child blocks. The list size can be the following:
	//
	//    * 0 - The block has no child blocks.
	//
	//    * 1 - The block has child blocks.
	Relationships []*Relationship `type:"list"`

	// The row in which a table cell is located. The first row position is 1. RowIndex
	// isn't returned by DetectDocumentText and GetDocumentTextDetection.
	RowIndex *int64 `type:"integer"`

	// The number of rows that a table cell spans. Currently this value is always
	// 1, even if the number of rows spanned is greater than 1. RowSpan isn't returned
	// by DetectDocumentText and GetDocumentTextDetection.
	RowSpan *int64 `type:"integer"`

	// The selection status of a selection element, such as an option button or
	// check box.
	SelectionStatus *string `type:"string" enum:"SelectionStatus"`

	// The word or line of text that's recognized by Amazon Textract.
	Text *string `type:"string"`

	// The kind of text that Amazon Textract has detected. Can check for handwritten
	// text and printed text.
	TextType *string `type:"string" enum:"TextType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Block) GoString() string {
	return s.String()
}

// SetBlockType sets the BlockType field's value.
func (s *Block) SetBlockType(v string) *Block {
	s.BlockType = &v
	return s
}

// SetColumnIndex sets the ColumnIndex field's value.
func (s *Block) SetColumnIndex(v int64) *Block {
	s.ColumnIndex = &v
	return s
}

// SetColumnSpan sets the ColumnSpan field's value.
func (s *Block) SetColumnSpan(v int64) *Block {
	s.ColumnSpan = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *Block) SetConfidence(v float64) *Block {
	s.Confidence = &v
	return s
}

// SetEntityTypes sets the EntityTypes field's value.
func (s *Block) SetEntityTypes(v []*string) *Block {
	s.EntityTypes = v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *Block) SetGeometry(v *Geometry) *Block {
	s.Geometry = v
	return s
}

// SetId sets the Id field's value.
func (s *Block) SetId(v string) *Block {
	s.Id = &v
	return s
}

// SetPage sets the Page field's value.
func (s *Block) SetPage(v int64) *Block {
	s.Page = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *Block) SetQuery(v *Query) *Block {
	s.Query = v
	return s
}

// SetRelationships sets the Relationships field's value.
func (s *Block) SetRelationships(v []*Relationship) *Block {
	s.Relationships = v
	return s
}

// SetRowIndex sets the RowIndex field's value.
func (s *Block) SetRowIndex(v int64) *Block {
	s.RowIndex = &v
	return s
}

// SetRowSpan sets the RowSpan field's value.
func (s *Block) SetRowSpan(v int64) *Block {
	s.RowSpan = &v
	return s
}

// SetSelectionStatus sets the SelectionStatus field's value.
func (s *Block) SetSelectionStatus(v string) *Block {
	s.SelectionStatus = &v
	return s
}

// SetText sets the Text field's value.
func (s *Block) SetText(v string) *Block {
	s.Text = &v
	return s
}

// SetTextType sets the TextType field's value.
func (s *Block) SetTextType(v string) *Block {
	s.TextType = &v
	return s
}

// The bounding box around the detected page, text, key-value pair, table, table
// cell, or selection element on a document page. The left (x-coordinate) and
// top (y-coordinate) are coordinates that represent the top and left sides
// of the bounding box. Note that the upper-left corner of the image is the
// origin (0,0).
//
// The top and left values returned are ratios of the overall document page
// size. For example, if the input image is 700 x 200 pixels, and the top-left
// coordinate of the bounding box is 350 x 50 pixels, the API returns a left
// value of 0.5 (350/700) and a top value of 0.25 (50/200).
//
// The width and height values represent the dimensions of the bounding box
// as a ratio of the overall document page dimension. For example, if the document
// page size is 700 x 200 pixels, and the bounding box width is 70 pixels, the
// width returned is 0.1.
type BoundingBox struct {
	_ struct{} `type:"structure"`

	// The height of the bounding box as a ratio of the overall document page height.
	Height *float64 `type:"float"`

	// The left coordinate of the bounding box as a ratio of overall document page
	// width.
	Left *float64 `type:"float"`

	// The top coordinate of the bounding box as a ratio of overall document page
	// height.
	Top *float64 `type:"float"`

	// The width of the bounding box as a ratio of the overall document page width.
	Width *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s BoundingBox) GoString() string {
	return s.String()
}

// SetHeight sets the Height field's value.
func (s *BoundingBox) SetHeight(v float64) *BoundingBox {
	s.Height = &v
	return s
}

// SetLeft sets the Left field's value.
func (s *BoundingBox) SetLeft(v float64) *BoundingBox {
	s.Left = &v
	return s
}

// SetTop sets the Top field's value.
func (s *BoundingBox) SetTop(v float64) *BoundingBox {
	s.Top = &v
	return s
}

// SetWidth sets the Width field's value.
func (s *BoundingBox) SetWidth(v float64) *BoundingBox {
	s.Width = &v
	return s
}

type DetectDocumentTextInput struct {
	_ struct{} `type:"structure"`

	// The input document as base64-encoded bytes or an Amazon S3 object. If you
	// use the AWS CLI to call Amazon Textract operations, you can't pass image
	// bytes. The document must be an image in JPEG or PNG format.
	//
	// If you're using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes that are passed using the Bytes field.
	//
	// Document is a required field
	Document *Document `type:"structure" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDocumentTextInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDocumentTextInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DetectDocumentTextInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DetectDocumentTextInput"}
	if s.Document == nil {
		invalidParams.Add(request.NewErrParamRequired("Document"))
	}
	if s.Document != nil {
		if err := s.Document.Validate(); err != nil {
			invalidParams.AddNested("Document", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDocument sets the Document field's value.
func (s *DetectDocumentTextInput) SetDocument(v *Document) *DetectDocumentTextInput {
	s.Document = v
	return s
}

type DetectDocumentTextOutput struct {
	_ struct{} `type:"structure"`

	// An array of Block objects that contain the text that's detected in the document.
	Blocks []*Block `type:"list"`

	DetectDocumentTextModelVersion *string `type:"string"`

	// Metadata about the document. It contains the number of pages that are detected
	// in the document.
	DocumentMetadata *DocumentMetadata `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDocumentTextOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DetectDocumentTextOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *DetectDocumentTextOutput) SetBlocks(v []*Block) *DetectDocumentTextOutput {
	s.Blocks = v
	return s
}

// SetDetectDocumentTextModelVersion sets the DetectDocumentTextModelVersion field's value.
func (s *DetectDocumentTextOutput) SetDetectDocumentTextModelVersion(v string) *DetectDocumentTextOutput {
	s.DetectDocumentTextModelVersion = &v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *DetectDocumentTextOutput) SetDocumentMetadata(v *DocumentMetadata) *DetectDocumentTextOutput {
	s.DocumentMetadata = v
	return s
}

// The input document, either as bytes or as an S3 object.
//
// You pass image bytes to an Amazon Textract API operation by using the Bytes
// property. For example, you would use the Bytes property to pass a document
// loaded from a local file system. Image bytes passed by using the Bytes property
// must be base64 encoded. Your code might not need to encode document file
// bytes if you're using an AWS SDK to call Amazon Textract API operations.
//
// You pass images stored in an S3 bucket to an Amazon Textract API operation
// by using the S3Object property. Documents stored in an S3 bucket don't need
// to be base64 encoded.
//
// The AWS Region for the S3 bucket that contains the S3 object must match the
// AWS Region that you use for Amazon Textract operations.
//
// If you use the AWS CLI to call Amazon Textract operations, passing image
// bytes using the Bytes property isn't supported. You must first upload the
// document to an Amazon S3 bucket, and then call the operation using the S3Object
// property.
//
// For Amazon Textract to process an S3 object, the user must have permission
// to access the S3 object.
type Document struct {
	_ struct{} `type:"structure"`

	// A blob of base64-encoded document bytes. The maximum size of a document that's
	// provided in a blob of bytes is 5 MB. The document bytes must be in PNG or
	// JPEG format.
	//
	// If you're using an AWS SDK to call Amazon Textract, you might not need to
	// base64-encode image bytes passed using the Bytes field.
	// Bytes is automatically base64 encoded/decoded by the SDK.
	Bytes []byte `min:"1" type:"blob"`

	// Identifies an S3 object as the document source. The maximum size of a document
	// that's stored in an S3 bucket is 5 MB.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Document) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Document) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Document"}
	if s.Bytes != nil && len(s.Bytes) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Bytes", 1))
	}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBytes sets the Bytes field's value.
func (s *Document) SetBytes(v []byte) *Document {
	s.Bytes = v
	return s
}

// SetS3Object sets the S3Object field's value.
func (s *Document) SetS3Object(v *S3Object) *Document {
	s.S3Object = v
	return s
}

// The Amazon S3 bucket that contains the document to be processed. It's used
// by asynchronous operations such as StartDocumentTextDetection.
//
// The input document can be an image file in JPEG or PNG format. It can also
// be a file in PDF format.
type DocumentLocation struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 bucket that contains the input document.
	S3Object *S3Object `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentLocation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentLocation) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DocumentLocation) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DocumentLocation"}
	if s.S3Object != nil {
		if err := s.S3Object.Validate(); err != nil {
			invalidParams.AddNested("S3Object", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Object sets the S3Object field's value.
func (s *DocumentLocation) SetS3Object(v *S3Object) *DocumentLocation {
	s.S3Object = v
	return s
}

// Information about the input document.
type DocumentMetadata struct {
	_ struct{} `type:"structure"`

	// The number of pages that are detected in the document.
	Pages *int64 `type:"integer"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadata) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentMetadata) GoString() string {
	return s.String()
}

// SetPages sets the Pages field's value.
func (s *DocumentMetadata) SetPages(v int64) *DocumentMetadata {
	s.Pages = &v
	return s
}

// The document can't be processed because it's too large. The maximum document
// size for synchronous operations 10 MB. The maximum document size for asynchronous
// operations is 500 MB for PDF files.
type DocumentTooLargeException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentTooLargeException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DocumentTooLargeException) GoString() string {
	return s.String()
}

func newErrorDocumentTooLargeException(v protocol.ResponseMetadata) error {
	return &DocumentTooLargeException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DocumentTooLargeException) Code() string {
	return "DocumentTooLargeException"
}

// Message returns the exception's message.
func (s *DocumentTooLargeException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DocumentTooLargeException) OrigErr() error {
	return nil
}

func (s *DocumentTooLargeException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DocumentTooLargeException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DocumentTooLargeException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Returns the kind of currency detected.
type ExpenseCurrency struct {
	_ struct{} `type:"structure"`

	// Currency code for detected currency. the current supported codes are:
	//
	//    * USD
	//
	//    * EUR
	//
	//    * GBP
	//
	//    * CAD
	//
	//    * INR
	//
	//    * JPY
	//
	//    * CHF
	//
	//    * AUD
	//
	//    * CNY
	//
	//    * BZR
	//
	//    * SEK
	//
	//    * HKD
	Code *string `type:"string"`

	// Percentage confideence in the detected currency.
	Confidence *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseCurrency) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseCurrency) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ExpenseCurrency) SetCode(v string) *ExpenseCurrency {
	s.Code = &v
	return s
}

// SetConfidence sets the Confidence field's value.
func (s *ExpenseCurrency) SetConfidence(v float64) *ExpenseCurrency {
	s.Confidence = &v
	return s
}

// An object used to store information about the Value or Label detected by
// Amazon Textract.
type ExpenseDetection struct {
	_ struct{} `type:"structure"`

	// The confidence in detection, as a percentage
	Confidence *float64 `type:"float"`

	// Information about where the following items are located on a document page:
	// detected page, text, key-value pairs, tables, table cells, and selection
	// elements.
	Geometry *Geometry `type:"structure"`

	// The word or line of text recognized by Amazon Textract
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseDetection) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseDetection) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *ExpenseDetection) SetConfidence(v float64) *ExpenseDetection {
	s.Confidence = &v
	return s
}

// SetGeometry sets the Geometry field's value.
func (s *ExpenseDetection) SetGeometry(v *Geometry) *ExpenseDetection {
	s.Geometry = v
	return s
}

// SetText sets the Text field's value.
func (s *ExpenseDetection) SetText(v string) *ExpenseDetection {
	s.Text = &v
	return s
}

// The structure holding all the information returned by AnalyzeExpense
type ExpenseDocument struct {
	_ struct{} `type:"structure"`

	// This is a block object, the same as reported when DetectDocumentText is run
	// on a document. It provides word level recognition of text.
	Blocks []*Block `type:"list"`

	// Denotes which invoice or receipt in the document the information is coming
	// from. First document will be 1, the second 2, and so on.
	ExpenseIndex *int64 `type:"integer"`

	// Information detected on each table of a document, seperated into LineItems.
	LineItemGroups []*LineItemGroup `type:"list"`

	// Any information found outside of a table by Amazon Textract.
	SummaryFields []*ExpenseField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseDocument) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *ExpenseDocument) SetBlocks(v []*Block) *ExpenseDocument {
	s.Blocks = v
	return s
}

// SetExpenseIndex sets the ExpenseIndex field's value.
func (s *ExpenseDocument) SetExpenseIndex(v int64) *ExpenseDocument {
	s.ExpenseIndex = &v
	return s
}

// SetLineItemGroups sets the LineItemGroups field's value.
func (s *ExpenseDocument) SetLineItemGroups(v []*LineItemGroup) *ExpenseDocument {
	s.LineItemGroups = v
	return s
}

// SetSummaryFields sets the SummaryFields field's value.
func (s *ExpenseDocument) SetSummaryFields(v []*ExpenseField) *ExpenseDocument {
	s.SummaryFields = v
	return s
}

// Breakdown of detected information, seperated into the catagories Type, LabelDetection,
// and ValueDetection
type ExpenseField struct {
	_ struct{} `type:"structure"`

	// Shows the kind of currency, both the code and confidence associated with
	// any monatary value detected.
	Currency *ExpenseCurrency `type:"structure"`

	// Shows which group a response object belongs to, such as whether an address
	// line belongs to the vendor's address or the recipent's address.
	GroupProperties []*ExpenseGroupProperty `type:"list"`

	// The explicitly stated label of a detected element.
	LabelDetection *ExpenseDetection `type:"structure"`

	// The page number the value was detected on.
	PageNumber *int64 `type:"integer"`

	// The implied label of a detected element. Present alongside LabelDetection
	// for explicit elements.
	Type *ExpenseType `type:"structure"`

	// The value of a detected element. Present in explicit and implicit elements.
	ValueDetection *ExpenseDetection `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseField) GoString() string {
	return s.String()
}

// SetCurrency sets the Currency field's value.
func (s *ExpenseField) SetCurrency(v *ExpenseCurrency) *ExpenseField {
	s.Currency = v
	return s
}

// SetGroupProperties sets the GroupProperties field's value.
func (s *ExpenseField) SetGroupProperties(v []*ExpenseGroupProperty) *ExpenseField {
	s.GroupProperties = v
	return s
}

// SetLabelDetection sets the LabelDetection field's value.
func (s *ExpenseField) SetLabelDetection(v *ExpenseDetection) *ExpenseField {
	s.LabelDetection = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ExpenseField) SetPageNumber(v int64) *ExpenseField {
	s.PageNumber = &v
	return s
}

// SetType sets the Type field's value.
func (s *ExpenseField) SetType(v *ExpenseType) *ExpenseField {
	s.Type = v
	return s
}

// SetValueDetection sets the ValueDetection field's value.
func (s *ExpenseField) SetValueDetection(v *ExpenseDetection) *ExpenseField {
	s.ValueDetection = v
	return s
}

// Shows the group that a certain key belongs to. This helps differentiate between
// names and addresses for different organizations, that can be hard to determine
// via JSON response.
type ExpenseGroupProperty struct {
	_ struct{} `type:"structure"`

	// Provides a group Id number, which will be the same for each in the group.
	Id *string `type:"string"`

	// Informs you on whether the expense group is a name or an address.
	Types []*string `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseGroupProperty) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseGroupProperty) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *ExpenseGroupProperty) SetId(v string) *ExpenseGroupProperty {
	s.Id = &v
	return s
}

// SetTypes sets the Types field's value.
func (s *ExpenseGroupProperty) SetTypes(v []*string) *ExpenseGroupProperty {
	s.Types = v
	return s
}

// An object used to store information about the Type detected by Amazon Textract.
type ExpenseType struct {
	_ struct{} `type:"structure"`

	// The confidence of accuracy, as a percentage.
	Confidence *float64 `type:"float"`

	// The word or line of text detected by Amazon Textract.
	Text *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseType) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ExpenseType) GoString() string {
	return s.String()
}

// SetConfidence sets the Confidence field's value.
func (s *ExpenseType) SetConfidence(v float64) *ExpenseType {
	s.Confidence = &v
	return s
}

// SetText sets the Text field's value.
func (s *ExpenseType) SetText(v string) *ExpenseType {
	s.Text = &v
	return s
}

// Information about where the following items are located on a document page:
// detected page, text, key-value pairs, tables, table cells, and selection
// elements.
type Geometry struct {
	_ struct{} `type:"structure"`

	// An axis-aligned coarse representation of the location of the recognized item
	// on the document page.
	BoundingBox *BoundingBox `type:"structure"`

	// Within the bounding box, a fine-grained polygon around the recognized item.
	Polygon []*Point `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Geometry) GoString() string {
	return s.String()
}

// SetBoundingBox sets the BoundingBox field's value.
func (s *Geometry) SetBoundingBox(v *BoundingBox) *Geometry {
	s.BoundingBox = v
	return s
}

// SetPolygon sets the Polygon field's value.
func (s *Geometry) SetPolygon(v []*Point) *Geometry {
	s.Polygon = v
	return s
}

type GetDocumentAnalysisInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text-detection job. The JobId is returned from
	// StartDocumentAnalysis. A JobId value is only valid for 7 days.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// that you can specify is 1,000. If you specify a value greater than 1,000,
	// a maximum of 1,000 results is returned. The default value is 1,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentAnalysisInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetDocumentAnalysisInput) SetJobId(v string) *GetDocumentAnalysisInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDocumentAnalysisInput) SetMaxResults(v int64) *GetDocumentAnalysisInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentAnalysisInput) SetNextToken(v string) *GetDocumentAnalysisInput {
	s.NextToken = &v
	return s
}

type GetDocumentAnalysisOutput struct {
	_ struct{} `type:"structure"`

	AnalyzeDocumentModelVersion *string `type:"string"`

	// The results of the text-analysis operation.
	Blocks []*Block `type:"list"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// video operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The current status of the text detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text
	// detection results.
	NextToken *string `min:"1" type:"string"`

	// Returns if the detection job could not be completed. Contains explanation
	// for what error occured.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the document-analysis operation.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalyzeDocumentModelVersion sets the AnalyzeDocumentModelVersion field's value.
func (s *GetDocumentAnalysisOutput) SetAnalyzeDocumentModelVersion(v string) *GetDocumentAnalysisOutput {
	s.AnalyzeDocumentModelVersion = &v
	return s
}

// SetBlocks sets the Blocks field's value.
func (s *GetDocumentAnalysisOutput) SetBlocks(v []*Block) *GetDocumentAnalysisOutput {
	s.Blocks = v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *GetDocumentAnalysisOutput) SetDocumentMetadata(v *DocumentMetadata) *GetDocumentAnalysisOutput {
	s.DocumentMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetDocumentAnalysisOutput) SetJobStatus(v string) *GetDocumentAnalysisOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentAnalysisOutput) SetNextToken(v string) *GetDocumentAnalysisOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetDocumentAnalysisOutput) SetStatusMessage(v string) *GetDocumentAnalysisOutput {
	s.StatusMessage = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetDocumentAnalysisOutput) SetWarnings(v []*Warning) *GetDocumentAnalysisOutput {
	s.Warnings = v
	return s
}

type GetDocumentTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text detection job. The JobId is returned from
	// StartDocumentTextDetection. A JobId value is only valid for 7 days.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 1,000. If you specify a value greater than 1,000, a maximum
	// of 1,000 results is returned. The default value is 1,000.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDocumentTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDocumentTextDetectionInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetDocumentTextDetectionInput) SetJobId(v string) *GetDocumentTextDetectionInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetDocumentTextDetectionInput) SetMaxResults(v int64) *GetDocumentTextDetectionInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentTextDetectionInput) SetNextToken(v string) *GetDocumentTextDetectionInput {
	s.NextToken = &v
	return s
}

type GetDocumentTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The results of the text-detection operation.
	Blocks []*Block `type:"list"`

	DetectDocumentTextModelVersion *string `type:"string"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// video operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The current status of the text detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text-detection
	// results.
	NextToken *string `min:"1" type:"string"`

	// Returns if the detection job could not be completed. Contains explanation
	// for what error occured.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the text-detection operation for
	// the document.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDocumentTextDetectionOutput) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *GetDocumentTextDetectionOutput) SetBlocks(v []*Block) *GetDocumentTextDetectionOutput {
	s.Blocks = v
	return s
}

// SetDetectDocumentTextModelVersion sets the DetectDocumentTextModelVersion field's value.
func (s *GetDocumentTextDetectionOutput) SetDetectDocumentTextModelVersion(v string) *GetDocumentTextDetectionOutput {
	s.DetectDocumentTextModelVersion = &v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *GetDocumentTextDetectionOutput) SetDocumentMetadata(v *DocumentMetadata) *GetDocumentTextDetectionOutput {
	s.DocumentMetadata = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetDocumentTextDetectionOutput) SetJobStatus(v string) *GetDocumentTextDetectionOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetDocumentTextDetectionOutput) SetNextToken(v string) *GetDocumentTextDetectionOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetDocumentTextDetectionOutput) SetStatusMessage(v string) *GetDocumentTextDetectionOutput {
	s.StatusMessage = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetDocumentTextDetectionOutput) SetWarnings(v []*Warning) *GetDocumentTextDetectionOutput {
	s.Warnings = v
	return s
}

type GetExpenseAnalysisInput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text detection job. The JobId is returned from
	// StartExpenseAnalysis. A JobId value is only valid for 7 days.
	//
	// JobId is a required field
	JobId *string `min:"1" type:"string" required:"true"`

	// The maximum number of results to return per paginated call. The largest value
	// you can specify is 20. If you specify a value greater than 20, a maximum
	// of 20 results is returned. The default value is 20.
	MaxResults *int64 `min:"1" type:"integer"`

	// If the previous response was incomplete (because there are more blocks to
	// retrieve), Amazon Textract returns a pagination token in the response. You
	// can use this pagination token to retrieve the next set of blocks.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExpenseAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExpenseAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetExpenseAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetExpenseAnalysisInput"}
	if s.JobId == nil {
		invalidParams.Add(request.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobId", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetJobId sets the JobId field's value.
func (s *GetExpenseAnalysisInput) SetJobId(v string) *GetExpenseAnalysisInput {
	s.JobId = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *GetExpenseAnalysisInput) SetMaxResults(v int64) *GetExpenseAnalysisInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExpenseAnalysisInput) SetNextToken(v string) *GetExpenseAnalysisInput {
	s.NextToken = &v
	return s
}

type GetExpenseAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The current model version of AnalyzeExpense.
	AnalyzeExpenseModelVersion *string `type:"string"`

	// Information about a document that Amazon Textract processed. DocumentMetadata
	// is returned in every page of paginated responses from an Amazon Textract
	// operation.
	DocumentMetadata *DocumentMetadata `type:"structure"`

	// The expenses detected by Amazon Textract.
	ExpenseDocuments []*ExpenseDocument `type:"list"`

	// The current status of the text detection job.
	JobStatus *string `type:"string" enum:"JobStatus"`

	// If the response is truncated, Amazon Textract returns this token. You can
	// use this token in the subsequent request to retrieve the next set of text-detection
	// results.
	NextToken *string `min:"1" type:"string"`

	// Returns if the detection job could not be completed. Contains explanation
	// for what error occured.
	StatusMessage *string `type:"string"`

	// A list of warnings that occurred during the text-detection operation for
	// the document.
	Warnings []*Warning `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExpenseAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetExpenseAnalysisOutput) GoString() string {
	return s.String()
}

// SetAnalyzeExpenseModelVersion sets the AnalyzeExpenseModelVersion field's value.
func (s *GetExpenseAnalysisOutput) SetAnalyzeExpenseModelVersion(v string) *GetExpenseAnalysisOutput {
	s.AnalyzeExpenseModelVersion = &v
	return s
}

// SetDocumentMetadata sets the DocumentMetadata field's value.
func (s *GetExpenseAnalysisOutput) SetDocumentMetadata(v *DocumentMetadata) *GetExpenseAnalysisOutput {
	s.DocumentMetadata = v
	return s
}

// SetExpenseDocuments sets the ExpenseDocuments field's value.
func (s *GetExpenseAnalysisOutput) SetExpenseDocuments(v []*ExpenseDocument) *GetExpenseAnalysisOutput {
	s.ExpenseDocuments = v
	return s
}

// SetJobStatus sets the JobStatus field's value.
func (s *GetExpenseAnalysisOutput) SetJobStatus(v string) *GetExpenseAnalysisOutput {
	s.JobStatus = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *GetExpenseAnalysisOutput) SetNextToken(v string) *GetExpenseAnalysisOutput {
	s.NextToken = &v
	return s
}

// SetStatusMessage sets the StatusMessage field's value.
func (s *GetExpenseAnalysisOutput) SetStatusMessage(v string) *GetExpenseAnalysisOutput {
	s.StatusMessage = &v
	return s
}

// SetWarnings sets the Warnings field's value.
func (s *GetExpenseAnalysisOutput) SetWarnings(v []*Warning) *GetExpenseAnalysisOutput {
	s.Warnings = v
	return s
}

// Shows the results of the human in the loop evaluation. If there is no HumanLoopArn,
// the input did not trigger human review.
type HumanLoopActivationOutput struct {
	_ struct{} `type:"structure"`

	// Shows the result of condition evaluations, including those conditions which
	// activated a human review.
	HumanLoopActivationConditionsEvaluationResults aws.JSONValue `type:"jsonvalue"`

	// Shows if and why human review was needed.
	HumanLoopActivationReasons []*string `min:"1" type:"list"`

	// The Amazon Resource Name (ARN) of the HumanLoop created.
	HumanLoopArn *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopActivationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopActivationOutput) GoString() string {
	return s.String()
}

// SetHumanLoopActivationConditionsEvaluationResults sets the HumanLoopActivationConditionsEvaluationResults field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopActivationConditionsEvaluationResults(v aws.JSONValue) *HumanLoopActivationOutput {
	s.HumanLoopActivationConditionsEvaluationResults = v
	return s
}

// SetHumanLoopActivationReasons sets the HumanLoopActivationReasons field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopActivationReasons(v []*string) *HumanLoopActivationOutput {
	s.HumanLoopActivationReasons = v
	return s
}

// SetHumanLoopArn sets the HumanLoopArn field's value.
func (s *HumanLoopActivationOutput) SetHumanLoopArn(v string) *HumanLoopActivationOutput {
	s.HumanLoopArn = &v
	return s
}

// Sets up the human review workflow the document will be sent to if one of
// the conditions is met. You can also set certain attributes of the image before
// review.
type HumanLoopConfig struct {
	_ struct{} `type:"structure"`

	// Sets attributes of the input data.
	DataAttributes *HumanLoopDataAttributes `type:"structure"`

	// The Amazon Resource Name (ARN) of the flow definition.
	//
	// FlowDefinitionArn is a required field
	FlowDefinitionArn *string `type:"string" required:"true"`

	// The name of the human workflow used for this image. This should be kept unique
	// within a region.
	//
	// HumanLoopName is a required field
	HumanLoopName *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *HumanLoopConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "HumanLoopConfig"}
	if s.FlowDefinitionArn == nil {
		invalidParams.Add(request.NewErrParamRequired("FlowDefinitionArn"))
	}
	if s.HumanLoopName == nil {
		invalidParams.Add(request.NewErrParamRequired("HumanLoopName"))
	}
	if s.HumanLoopName != nil && len(*s.HumanLoopName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("HumanLoopName", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataAttributes sets the DataAttributes field's value.
func (s *HumanLoopConfig) SetDataAttributes(v *HumanLoopDataAttributes) *HumanLoopConfig {
	s.DataAttributes = v
	return s
}

// SetFlowDefinitionArn sets the FlowDefinitionArn field's value.
func (s *HumanLoopConfig) SetFlowDefinitionArn(v string) *HumanLoopConfig {
	s.FlowDefinitionArn = &v
	return s
}

// SetHumanLoopName sets the HumanLoopName field's value.
func (s *HumanLoopConfig) SetHumanLoopName(v string) *HumanLoopConfig {
	s.HumanLoopName = &v
	return s
}

// Allows you to set attributes of the image. Currently, you can declare an
// image as free of personally identifiable information and adult content.
type HumanLoopDataAttributes struct {
	_ struct{} `type:"structure"`

	// Sets whether the input image is free of personally identifiable information
	// or adult content.
	ContentClassifiers []*string `type:"list" enum:"ContentClassifier"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopDataAttributes) GoString() string {
	return s.String()
}

// SetContentClassifiers sets the ContentClassifiers field's value.
func (s *HumanLoopDataAttributes) SetContentClassifiers(v []*string) *HumanLoopDataAttributes {
	s.ContentClassifiers = v
	return s
}

// Indicates you have exceeded the maximum number of active human in the loop
// workflows available
type HumanLoopQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`

	// The quota code.
	QuotaCode *string `type:"string"`

	// The resource type.
	ResourceType *string `type:"string"`

	// The service code.
	ServiceCode *string `type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s HumanLoopQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorHumanLoopQuotaExceededException(v protocol.ResponseMetadata) error {
	return &HumanLoopQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *HumanLoopQuotaExceededException) Code() string {
	return "HumanLoopQuotaExceededException"
}

// Message returns the exception's message.
func (s *HumanLoopQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *HumanLoopQuotaExceededException) OrigErr() error {
	return nil
}

func (s *HumanLoopQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s\n%s", s.Code(), s.Message(), s.String())
}

// Status code returns the HTTP status code for the request's response error.
func (s *HumanLoopQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *HumanLoopQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A ClientRequestToken input parameter was reused with an operation, but at
// least one of the other input parameters is different from the previous call
// to the operation.
type IdempotentParameterMismatchException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdempotentParameterMismatchException) GoString() string {
	return s.String()
}

func newErrorIdempotentParameterMismatchException(v protocol.ResponseMetadata) error {
	return &IdempotentParameterMismatchException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *IdempotentParameterMismatchException) Code() string {
	return "IdempotentParameterMismatchException"
}

// Message returns the exception's message.
func (s *IdempotentParameterMismatchException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *IdempotentParameterMismatchException) OrigErr() error {
	return nil
}

func (s *IdempotentParameterMismatchException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *IdempotentParameterMismatchException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *IdempotentParameterMismatchException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The structure that lists each document processed in an AnalyzeID operation.
type IdentityDocument struct {
	_ struct{} `type:"structure"`

	// Individual word recognition, as returned by document detection.
	Blocks []*Block `type:"list"`

	// Denotes the placement of a document in the IdentityDocument list. The first
	// document is marked 1, the second 2 and so on.
	DocumentIndex *int64 `type:"integer"`

	// The structure used to record information extracted from identity documents.
	// Contains both normalized field and value of the extracted text.
	IdentityDocumentFields []*IdentityDocumentField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDocument) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDocument) GoString() string {
	return s.String()
}

// SetBlocks sets the Blocks field's value.
func (s *IdentityDocument) SetBlocks(v []*Block) *IdentityDocument {
	s.Blocks = v
	return s
}

// SetDocumentIndex sets the DocumentIndex field's value.
func (s *IdentityDocument) SetDocumentIndex(v int64) *IdentityDocument {
	s.DocumentIndex = &v
	return s
}

// SetIdentityDocumentFields sets the IdentityDocumentFields field's value.
func (s *IdentityDocument) SetIdentityDocumentFields(v []*IdentityDocumentField) *IdentityDocument {
	s.IdentityDocumentFields = v
	return s
}

// Structure containing both the normalized type of the extracted information
// and the text associated with it. These are extracted as Type and Value respectively.
type IdentityDocumentField struct {
	_ struct{} `type:"structure"`

	// Used to contain the information detected by an AnalyzeID operation.
	Type *AnalyzeIDDetections `type:"structure"`

	// Used to contain the information detected by an AnalyzeID operation.
	ValueDetection *AnalyzeIDDetections `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDocumentField) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s IdentityDocumentField) GoString() string {
	return s.String()
}

// SetType sets the Type field's value.
func (s *IdentityDocumentField) SetType(v *AnalyzeIDDetections) *IdentityDocumentField {
	s.Type = v
	return s
}

// SetValueDetection sets the ValueDetection field's value.
func (s *IdentityDocumentField) SetValueDetection(v *AnalyzeIDDetections) *IdentityDocumentField {
	s.ValueDetection = v
	return s
}

// Amazon Textract experienced a service issue. Try your call again.
type InternalServerError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServerError) GoString() string {
	return s.String()
}

func newErrorInternalServerError(v protocol.ResponseMetadata) error {
	return &InternalServerError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServerError) Code() string {
	return "InternalServerError"
}

// Message returns the exception's message.
func (s *InternalServerError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServerError) OrigErr() error {
	return nil
}

func (s *InternalServerError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServerError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServerError) RequestID() string {
	return s.RespMetadata.RequestID
}

// An invalid job identifier was passed to GetDocumentAnalysis or to GetDocumentAnalysis.
type InvalidJobIdException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobIdException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidJobIdException) GoString() string {
	return s.String()
}

func newErrorInvalidJobIdException(v protocol.ResponseMetadata) error {
	return &InvalidJobIdException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidJobIdException) Code() string {
	return "InvalidJobIdException"
}

// Message returns the exception's message.
func (s *InvalidJobIdException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidJobIdException) OrigErr() error {
	return nil
}

func (s *InvalidJobIdException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidJobIdException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidJobIdException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Indicates you do not have decrypt permissions with the KMS key entered, or
// the KMS key was entered incorrectly.
type InvalidKMSKeyException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSKeyException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidKMSKeyException) GoString() string {
	return s.String()
}

func newErrorInvalidKMSKeyException(v protocol.ResponseMetadata) error {
	return &InvalidKMSKeyException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidKMSKeyException) Code() string {
	return "InvalidKMSKeyException"
}

// Message returns the exception's message.
func (s *InvalidKMSKeyException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidKMSKeyException) OrigErr() error {
	return nil
}

func (s *InvalidKMSKeyException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidKMSKeyException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidKMSKeyException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An input parameter violated a constraint. For example, in synchronous operations,
// an InvalidParameterException exception occurs when neither of the S3Object
// or Bytes values are supplied in the Document request parameter. Validate
// your parameter before calling the API operation again.
type InvalidParameterException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidParameterException) GoString() string {
	return s.String()
}

func newErrorInvalidParameterException(v protocol.ResponseMetadata) error {
	return &InvalidParameterException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidParameterException) Code() string {
	return "InvalidParameterException"
}

// Message returns the exception's message.
func (s *InvalidParameterException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidParameterException) OrigErr() error {
	return nil
}

func (s *InvalidParameterException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidParameterException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidParameterException) RequestID() string {
	return s.RespMetadata.RequestID
}

// Amazon Textract is unable to access the S3 object that's specified in the
// request. for more information, Configure Access to Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/s3-access-control.html)
// For troubleshooting information, see Troubleshooting Amazon S3 (https://docs.aws.amazon.com/AmazonS3/latest/dev/troubleshooting.html)
type InvalidS3ObjectException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3ObjectException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidS3ObjectException) GoString() string {
	return s.String()
}

func newErrorInvalidS3ObjectException(v protocol.ResponseMetadata) error {
	return &InvalidS3ObjectException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidS3ObjectException) Code() string {
	return "InvalidS3ObjectException"
}

// Message returns the exception's message.
func (s *InvalidS3ObjectException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidS3ObjectException) OrigErr() error {
	return nil
}

func (s *InvalidS3ObjectException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidS3ObjectException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidS3ObjectException) RequestID() string {
	return s.RespMetadata.RequestID
}

// An Amazon Textract service limit was exceeded. For example, if you start
// too many asynchronous jobs concurrently, calls to start operations (StartDocumentTextDetection,
// for example) raise a LimitExceededException exception (HTTP status code:
// 400) until the number of concurrently running jobs is below the Amazon Textract
// service limit.
type LimitExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LimitExceededException) GoString() string {
	return s.String()
}

func newErrorLimitExceededException(v protocol.ResponseMetadata) error {
	return &LimitExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *LimitExceededException) Code() string {
	return "LimitExceededException"
}

// Message returns the exception's message.
func (s *LimitExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *LimitExceededException) OrigErr() error {
	return nil
}

func (s *LimitExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *LimitExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *LimitExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A structure that holds information about the different lines found in a document's
// tables.
type LineItemFields struct {
	_ struct{} `type:"structure"`

	// ExpenseFields used to show information from detected lines on a table.
	LineItemExpenseFields []*ExpenseField `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LineItemFields) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LineItemFields) GoString() string {
	return s.String()
}

// SetLineItemExpenseFields sets the LineItemExpenseFields field's value.
func (s *LineItemFields) SetLineItemExpenseFields(v []*ExpenseField) *LineItemFields {
	s.LineItemExpenseFields = v
	return s
}

// A grouping of tables which contain LineItems, with each table identified
// by the table's LineItemGroupIndex.
type LineItemGroup struct {
	_ struct{} `type:"structure"`

	// The number used to identify a specific table in a document. The first table
	// encountered will have a LineItemGroupIndex of 1, the second 2, etc.
	LineItemGroupIndex *int64 `type:"integer"`

	// The breakdown of information on a particular line of a table.
	LineItems []*LineItemFields `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LineItemGroup) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s LineItemGroup) GoString() string {
	return s.String()
}

// SetLineItemGroupIndex sets the LineItemGroupIndex field's value.
func (s *LineItemGroup) SetLineItemGroupIndex(v int64) *LineItemGroup {
	s.LineItemGroupIndex = &v
	return s
}

// SetLineItems sets the LineItems field's value.
func (s *LineItemGroup) SetLineItems(v []*LineItemFields) *LineItemGroup {
	s.LineItems = v
	return s
}

// Contains information relating to dates in a document, including the type
// of value, and the value.
type NormalizedValue struct {
	_ struct{} `type:"structure"`

	// The value of the date, written as Year-Month-DayTHour:Minute:Second.
	Value *string `type:"string"`

	// The normalized type of the value detected. In this case, DATE.
	ValueType *string `type:"string" enum:"ValueType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NormalizedValue) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NormalizedValue) GoString() string {
	return s.String()
}

// SetValue sets the Value field's value.
func (s *NormalizedValue) SetValue(v string) *NormalizedValue {
	s.Value = &v
	return s
}

// SetValueType sets the ValueType field's value.
func (s *NormalizedValue) SetValueType(v string) *NormalizedValue {
	s.ValueType = &v
	return s
}

// The Amazon Simple Notification Service (Amazon SNS) topic to which Amazon
// Textract publishes the completion status of an asynchronous document operation,
// such as StartDocumentTextDetection.
type NotificationChannel struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of an IAM role that gives Amazon Textract
	// publishing permissions to the Amazon SNS topic.
	//
	// RoleArn is a required field
	RoleArn *string `min:"20" type:"string" required:"true"`

	// The Amazon SNS topic that Amazon Textract posts the completion status to.
	//
	// SNSTopicArn is a required field
	SNSTopicArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s NotificationChannel) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NotificationChannel) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NotificationChannel"}
	if s.RoleArn == nil {
		invalidParams.Add(request.NewErrParamRequired("RoleArn"))
	}
	if s.RoleArn != nil && len(*s.RoleArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("RoleArn", 20))
	}
	if s.SNSTopicArn == nil {
		invalidParams.Add(request.NewErrParamRequired("SNSTopicArn"))
	}
	if s.SNSTopicArn != nil && len(*s.SNSTopicArn) < 20 {
		invalidParams.Add(request.NewErrParamMinLen("SNSTopicArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetRoleArn sets the RoleArn field's value.
func (s *NotificationChannel) SetRoleArn(v string) *NotificationChannel {
	s.RoleArn = &v
	return s
}

// SetSNSTopicArn sets the SNSTopicArn field's value.
func (s *NotificationChannel) SetSNSTopicArn(v string) *NotificationChannel {
	s.SNSTopicArn = &v
	return s
}

// Sets whether or not your output will go to a user created bucket. Used to
// set the name of the bucket, and the prefix on the output file.
//
// OutputConfig is an optional parameter which lets you adjust where your output
// will be placed. By default, Amazon Textract will store the results internally
// and can only be accessed by the Get API operations. With OutputConfig enabled,
// you can set the name of the bucket the output will be sent to and the file
// prefix of the results where you can download your results. Additionally,
// you can set the KMSKeyID parameter to a customer master key (CMK) to encrypt
// your output. Without this parameter set Amazon Textract will encrypt server-side
// using the AWS managed CMK for Amazon S3.
//
// Decryption of Customer Content is necessary for processing of the documents
// by Amazon Textract. If your account is opted out under an AI services opt
// out policy then all unencrypted Customer Content is immediately and permanently
// deleted after the Customer Content has been processed by the service. No
// copy of of the output is retained by Amazon Textract. For information about
// how to opt out, see Managing AI services opt-out policy. (https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_policies_ai-opt-out.html)
//
// For more information on data privacy, see the Data Privacy FAQ (https://aws.amazon.com/compliance/data-privacy-faq/).
type OutputConfig struct {
	_ struct{} `type:"structure"`

	// The name of the bucket your output will go to.
	//
	// S3Bucket is a required field
	S3Bucket *string `min:"3" type:"string" required:"true"`

	// The prefix of the object key that the output will be saved to. When not enabled,
	// the prefix will be “textract_output".
	S3Prefix *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s OutputConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *OutputConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "OutputConfig"}
	if s.S3Bucket == nil {
		invalidParams.Add(request.NewErrParamRequired("S3Bucket"))
	}
	if s.S3Bucket != nil && len(*s.S3Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("S3Bucket", 3))
	}
	if s.S3Prefix != nil && len(*s.S3Prefix) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("S3Prefix", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetS3Bucket sets the S3Bucket field's value.
func (s *OutputConfig) SetS3Bucket(v string) *OutputConfig {
	s.S3Bucket = &v
	return s
}

// SetS3Prefix sets the S3Prefix field's value.
func (s *OutputConfig) SetS3Prefix(v string) *OutputConfig {
	s.S3Prefix = &v
	return s
}

// The X and Y coordinates of a point on a document page. The X and Y values
// that are returned are ratios of the overall document page size. For example,
// if the input document is 700 x 200 and the operation returns X=0.5 and Y=0.25,
// then the point is at the (350,50) pixel coordinate on the document page.
//
// An array of Point objects, Polygon, is returned by DetectDocumentText. Polygon
// represents a fine-grained polygon around detected text. For more information,
// see Geometry in the Amazon Textract Developer Guide.
type Point struct {
	_ struct{} `type:"structure"`

	// The value of the X coordinate for a point on a Polygon.
	X *float64 `type:"float"`

	// The value of the Y coordinate for a point on a Polygon.
	Y *float64 `type:"float"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Point) GoString() string {
	return s.String()
}

// SetX sets the X field's value.
func (s *Point) SetX(v float64) *Point {
	s.X = &v
	return s
}

// SetY sets the Y field's value.
func (s *Point) SetY(v float64) *Point {
	s.Y = &v
	return s
}

// The number of requests exceeded your throughput limit. If you want to increase
// this limit, contact Amazon Textract.
type ProvisionedThroughputExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ProvisionedThroughputExceededException) GoString() string {
	return s.String()
}

func newErrorProvisionedThroughputExceededException(v protocol.ResponseMetadata) error {
	return &ProvisionedThroughputExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ProvisionedThroughputExceededException) Code() string {
	return "ProvisionedThroughputExceededException"
}

// Message returns the exception's message.
func (s *ProvisionedThroughputExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ProvisionedThroughputExceededException) OrigErr() error {
	return nil
}

func (s *ProvisionedThroughputExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ProvisionedThroughputExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ProvisionedThroughputExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

type QueriesConfig struct {
	_ struct{} `type:"structure"`

	// Queries is a required field
	Queries []*Query `min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueriesConfig) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s QueriesConfig) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueriesConfig) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueriesConfig"}
	if s.Queries == nil {
		invalidParams.Add(request.NewErrParamRequired("Queries"))
	}
	if s.Queries != nil && len(s.Queries) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Queries", 1))
	}
	if s.Queries != nil {
		for i, v := range s.Queries {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Queries", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetQueries sets the Queries field's value.
func (s *QueriesConfig) SetQueries(v []*Query) *QueriesConfig {
	s.Queries = v
	return s
}

// Each query contains the question you want to ask in the Text and the alias
// you want to associate.
type Query struct {
	_ struct{} `type:"structure"`

	// Alias attached to the query, for ease of location.
	Alias *string `min:"1" type:"string"`

	// Pages is a parameter that the user inputs to specify which pages to apply
	// a query to. The following is a list of rules for using this parameter.
	//
	//    * If a page is not specified, it is set to ["1"] by default.
	//
	//    * The following characters are allowed in the parameter's string: 0 1
	//    2 3 4 5 6 7 8 9 - *. No whitespace is allowed.
	//
	//    * When using * to indicate all pages, it must be the only element in the
	//    list.
	//
	//    * You can use page intervals, such as [“1-3”, “1-1”, “4-*”].
	//    Where * indicates last page of document.
	//
	//    * Specified pages must be greater than 0 and less than or equal to the
	//    number of pages in the document.
	Pages []*string `min:"1" type:"list"`

	// Question that Amazon Textract will apply to the document. An example would
	// be "What is the customer's SSN?"
	//
	// Text is a required field
	Text *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Query) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Query) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *Query) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "Query"}
	if s.Alias != nil && len(*s.Alias) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Alias", 1))
	}
	if s.Pages != nil && len(s.Pages) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Pages", 1))
	}
	if s.Text == nil {
		invalidParams.Add(request.NewErrParamRequired("Text"))
	}
	if s.Text != nil && len(*s.Text) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Text", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlias sets the Alias field's value.
func (s *Query) SetAlias(v string) *Query {
	s.Alias = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *Query) SetPages(v []*string) *Query {
	s.Pages = v
	return s
}

// SetText sets the Text field's value.
func (s *Query) SetText(v string) *Query {
	s.Text = &v
	return s
}

// Information about how blocks are related to each other. A Block object contains
// 0 or more Relation objects in a list, Relationships. For more information,
// see Block.
//
// The Type element provides the type of the relationship for all blocks in
// the IDs array.
type Relationship struct {
	_ struct{} `type:"structure"`

	// An array of IDs for related blocks. You can get the type of the relationship
	// from the Type element.
	Ids []*string `type:"list"`

	// The type of relationship that the blocks in the IDs array have with the current
	// block. The relationship can be VALUE or CHILD. A relationship of type VALUE
	// is a list that contains the ID of the VALUE block that's associated with
	// the KEY of a key-value pair. A relationship of type CHILD is a list of IDs
	// that identify WORD blocks in the case of lines Cell blocks in the case of
	// Tables, and WORD blocks in the case of Selection Elements.
	Type *string `type:"string" enum:"RelationshipType"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relationship) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Relationship) GoString() string {
	return s.String()
}

// SetIds sets the Ids field's value.
func (s *Relationship) SetIds(v []*string) *Relationship {
	s.Ids = v
	return s
}

// SetType sets the Type field's value.
func (s *Relationship) SetType(v string) *Relationship {
	s.Type = &v
	return s
}

// The S3 bucket name and file name that identifies the document.
//
// The AWS Region for the S3 bucket that contains the document must match the
// Region that you use for Amazon Textract operations.
//
// For Amazon Textract to process a file in an S3 bucket, the user must have
// permission to access the S3 bucket and file.
type S3Object struct {
	_ struct{} `type:"structure"`

	// The name of the S3 bucket. Note that the # character is not valid in the
	// file name.
	Bucket *string `min:"3" type:"string"`

	// The file name of the input document. Synchronous operations can use image
	// files that are in JPEG or PNG format. Asynchronous operations also support
	// PDF and TIFF format files.
	Name *string `min:"1" type:"string"`

	// If the bucket has versioning enabled, you can specify the object version.
	Version *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s S3Object) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *S3Object) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "S3Object"}
	if s.Bucket != nil && len(*s.Bucket) < 3 {
		invalidParams.Add(request.NewErrParamMinLen("Bucket", 3))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Version != nil && len(*s.Version) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Version", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetBucket sets the Bucket field's value.
func (s *S3Object) SetBucket(v string) *S3Object {
	s.Bucket = &v
	return s
}

// SetName sets the Name field's value.
func (s *S3Object) SetName(v string) *S3Object {
	s.Name = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *S3Object) SetVersion(v string) *S3Object {
	s.Version = &v
	return s
}

type StartDocumentAnalysisInput struct {
	_ struct{} `type:"structure"`

	// The idempotent token that you use to identify the start request. If you use
	// the same token with multiple StartDocumentAnalysis requests, the same JobId
	// is returned. Use ClientRequestToken to prevent the same job from being accidentally
	// started more than once. For more information, see Calling Amazon Textract
	// Asynchronous Operations (https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
	ClientRequestToken *string `min:"1" type:"string"`

	// The location of the document to be processed.
	//
	// DocumentLocation is a required field
	DocumentLocation *DocumentLocation `type:"structure" required:"true"`

	// A list of the types of analysis to perform. Add TABLES to the list to return
	// information about the tables that are detected in the input document. Add
	// FORMS to return detected form data. To perform both types of analysis, add
	// TABLES and FORMS to FeatureTypes. All lines and words detected in the document
	// are included in the response (including text that isn't related to the value
	// of FeatureTypes).
	//
	// FeatureTypes is a required field
	FeatureTypes []*string `type:"list" required:"true" enum:"FeatureType"`

	// An identifier that you specify that's included in the completion notification
	// published to the Amazon SNS topic. For example, you can use JobTag to identify
	// the type of document that the completion notification corresponds to (such
	// as a tax form or a receipt).
	JobTag *string `min:"1" type:"string"`

	// The KMS key used to encrypt the inference results. This can be in either
	// Key ID or Key Alias format. When a KMS key is provided, the KMS key will
	// be used for server-side encryption of the objects in the customer bucket.
	// When this parameter is not enabled, the result will be encrypted server side,using
	// SSE-S3.
	KMSKeyId *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the completion
	// status of the operation to.
	NotificationChannel *NotificationChannel `type:"structure"`

	// Sets if the output will go to a customer defined bucket. By default, Amazon
	// Textract will save the results internally to be accessed by the GetDocumentAnalysis
	// operation.
	OutputConfig *OutputConfig `type:"structure"`

	QueriesConfig *QueriesConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentAnalysisInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DocumentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentLocation"))
	}
	if s.FeatureTypes == nil {
		invalidParams.Add(request.NewErrParamRequired("FeatureTypes"))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.KMSKeyId != nil && len(*s.KMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKeyId", 1))
	}
	if s.DocumentLocation != nil {
		if err := s.DocumentLocation.Validate(); err != nil {
			invalidParams.AddNested("DocumentLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}
	if s.QueriesConfig != nil {
		if err := s.QueriesConfig.Validate(); err != nil {
			invalidParams.AddNested("QueriesConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentAnalysisInput) SetClientRequestToken(v string) *StartDocumentAnalysisInput {
	s.ClientRequestToken = &v
	return s
}

// SetDocumentLocation sets the DocumentLocation field's value.
func (s *StartDocumentAnalysisInput) SetDocumentLocation(v *DocumentLocation) *StartDocumentAnalysisInput {
	s.DocumentLocation = v
	return s
}

// SetFeatureTypes sets the FeatureTypes field's value.
func (s *StartDocumentAnalysisInput) SetFeatureTypes(v []*string) *StartDocumentAnalysisInput {
	s.FeatureTypes = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartDocumentAnalysisInput) SetJobTag(v string) *StartDocumentAnalysisInput {
	s.JobTag = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *StartDocumentAnalysisInput) SetKMSKeyId(v string) *StartDocumentAnalysisInput {
	s.KMSKeyId = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartDocumentAnalysisInput) SetNotificationChannel(v *NotificationChannel) *StartDocumentAnalysisInput {
	s.NotificationChannel = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *StartDocumentAnalysisInput) SetOutputConfig(v *OutputConfig) *StartDocumentAnalysisInput {
	s.OutputConfig = v
	return s
}

// SetQueriesConfig sets the QueriesConfig field's value.
func (s *StartDocumentAnalysisInput) SetQueriesConfig(v *QueriesConfig) *StartDocumentAnalysisInput {
	s.QueriesConfig = v
	return s
}

type StartDocumentAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// The identifier for the document text detection job. Use JobId to identify
	// the job in a subsequent call to GetDocumentAnalysis. A JobId value is only
	// valid for 7 days.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentAnalysisOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentAnalysisOutput) SetJobId(v string) *StartDocumentAnalysisOutput {
	s.JobId = &v
	return s
}

type StartDocumentTextDetectionInput struct {
	_ struct{} `type:"structure"`

	// The idempotent token that's used to identify the start request. If you use
	// the same token with multiple StartDocumentTextDetection requests, the same
	// JobId is returned. Use ClientRequestToken to prevent the same job from being
	// accidentally started more than once. For more information, see Calling Amazon
	// Textract Asynchronous Operations (https://docs.aws.amazon.com/textract/latest/dg/api-async.html).
	ClientRequestToken *string `min:"1" type:"string"`

	// The location of the document to be processed.
	//
	// DocumentLocation is a required field
	DocumentLocation *DocumentLocation `type:"structure" required:"true"`

	// An identifier that you specify that's included in the completion notification
	// published to the Amazon SNS topic. For example, you can use JobTag to identify
	// the type of document that the completion notification corresponds to (such
	// as a tax form or a receipt).
	JobTag *string `min:"1" type:"string"`

	// The KMS key used to encrypt the inference results. This can be in either
	// Key ID or Key Alias format. When a KMS key is provided, the KMS key will
	// be used for server-side encryption of the objects in the customer bucket.
	// When this parameter is not enabled, the result will be encrypted server side,using
	// SSE-S3.
	KMSKeyId *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the completion
	// status of the operation to.
	NotificationChannel *NotificationChannel `type:"structure"`

	// Sets if the output will go to a customer defined bucket. By default Amazon
	// Textract will save the results internally to be accessed with the GetDocumentTextDetection
	// operation.
	OutputConfig *OutputConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentTextDetectionInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentTextDetectionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartDocumentTextDetectionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartDocumentTextDetectionInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DocumentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentLocation"))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.KMSKeyId != nil && len(*s.KMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKeyId", 1))
	}
	if s.DocumentLocation != nil {
		if err := s.DocumentLocation.Validate(); err != nil {
			invalidParams.AddNested("DocumentLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartDocumentTextDetectionInput) SetClientRequestToken(v string) *StartDocumentTextDetectionInput {
	s.ClientRequestToken = &v
	return s
}

// SetDocumentLocation sets the DocumentLocation field's value.
func (s *StartDocumentTextDetectionInput) SetDocumentLocation(v *DocumentLocation) *StartDocumentTextDetectionInput {
	s.DocumentLocation = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartDocumentTextDetectionInput) SetJobTag(v string) *StartDocumentTextDetectionInput {
	s.JobTag = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *StartDocumentTextDetectionInput) SetKMSKeyId(v string) *StartDocumentTextDetectionInput {
	s.KMSKeyId = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartDocumentTextDetectionInput) SetNotificationChannel(v *NotificationChannel) *StartDocumentTextDetectionInput {
	s.NotificationChannel = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *StartDocumentTextDetectionInput) SetOutputConfig(v *OutputConfig) *StartDocumentTextDetectionInput {
	s.OutputConfig = v
	return s
}

type StartDocumentTextDetectionOutput struct {
	_ struct{} `type:"structure"`

	// The identifier of the text detection job for the document. Use JobId to identify
	// the job in a subsequent call to GetDocumentTextDetection. A JobId value is
	// only valid for 7 days.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentTextDetectionOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartDocumentTextDetectionOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartDocumentTextDetectionOutput) SetJobId(v string) *StartDocumentTextDetectionOutput {
	s.JobId = &v
	return s
}

type StartExpenseAnalysisInput struct {
	_ struct{} `type:"structure"`

	// The idempotent token that's used to identify the start request. If you use
	// the same token with multiple StartDocumentTextDetection requests, the same
	// JobId is returned. Use ClientRequestToken to prevent the same job from being
	// accidentally started more than once. For more information, see Calling Amazon
	// Textract Asynchronous Operations (https://docs.aws.amazon.com/textract/latest/dg/api-async.html)
	ClientRequestToken *string `min:"1" type:"string"`

	// The location of the document to be processed.
	//
	// DocumentLocation is a required field
	DocumentLocation *DocumentLocation `type:"structure" required:"true"`

	// An identifier you specify that's included in the completion notification
	// published to the Amazon SNS topic. For example, you can use JobTag to identify
	// the type of document that the completion notification corresponds to (such
	// as a tax form or a receipt).
	JobTag *string `min:"1" type:"string"`

	// The KMS key used to encrypt the inference results. This can be in either
	// Key ID or Key Alias format. When a KMS key is provided, the KMS key will
	// be used for server-side encryption of the objects in the customer bucket.
	// When this parameter is not enabled, the result will be encrypted server side,using
	// SSE-S3.
	KMSKeyId *string `min:"1" type:"string"`

	// The Amazon SNS topic ARN that you want Amazon Textract to publish the completion
	// status of the operation to.
	NotificationChannel *NotificationChannel `type:"structure"`

	// Sets if the output will go to a customer defined bucket. By default, Amazon
	// Textract will save the results internally to be accessed by the GetExpenseAnalysis
	// operation.
	OutputConfig *OutputConfig `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExpenseAnalysisInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExpenseAnalysisInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartExpenseAnalysisInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "StartExpenseAnalysisInput"}
	if s.ClientRequestToken != nil && len(*s.ClientRequestToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientRequestToken", 1))
	}
	if s.DocumentLocation == nil {
		invalidParams.Add(request.NewErrParamRequired("DocumentLocation"))
	}
	if s.JobTag != nil && len(*s.JobTag) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("JobTag", 1))
	}
	if s.KMSKeyId != nil && len(*s.KMSKeyId) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KMSKeyId", 1))
	}
	if s.DocumentLocation != nil {
		if err := s.DocumentLocation.Validate(); err != nil {
			invalidParams.AddNested("DocumentLocation", err.(request.ErrInvalidParams))
		}
	}
	if s.NotificationChannel != nil {
		if err := s.NotificationChannel.Validate(); err != nil {
			invalidParams.AddNested("NotificationChannel", err.(request.ErrInvalidParams))
		}
	}
	if s.OutputConfig != nil {
		if err := s.OutputConfig.Validate(); err != nil {
			invalidParams.AddNested("OutputConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientRequestToken sets the ClientRequestToken field's value.
func (s *StartExpenseAnalysisInput) SetClientRequestToken(v string) *StartExpenseAnalysisInput {
	s.ClientRequestToken = &v
	return s
}

// SetDocumentLocation sets the DocumentLocation field's value.
func (s *StartExpenseAnalysisInput) SetDocumentLocation(v *DocumentLocation) *StartExpenseAnalysisInput {
	s.DocumentLocation = v
	return s
}

// SetJobTag sets the JobTag field's value.
func (s *StartExpenseAnalysisInput) SetJobTag(v string) *StartExpenseAnalysisInput {
	s.JobTag = &v
	return s
}

// SetKMSKeyId sets the KMSKeyId field's value.
func (s *StartExpenseAnalysisInput) SetKMSKeyId(v string) *StartExpenseAnalysisInput {
	s.KMSKeyId = &v
	return s
}

// SetNotificationChannel sets the NotificationChannel field's value.
func (s *StartExpenseAnalysisInput) SetNotificationChannel(v *NotificationChannel) *StartExpenseAnalysisInput {
	s.NotificationChannel = v
	return s
}

// SetOutputConfig sets the OutputConfig field's value.
func (s *StartExpenseAnalysisInput) SetOutputConfig(v *OutputConfig) *StartExpenseAnalysisInput {
	s.OutputConfig = v
	return s
}

type StartExpenseAnalysisOutput struct {
	_ struct{} `type:"structure"`

	// A unique identifier for the text detection job. The JobId is returned from
	// StartExpenseAnalysis. A JobId value is only valid for 7 days.
	JobId *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExpenseAnalysisOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s StartExpenseAnalysisOutput) GoString() string {
	return s.String()
}

// SetJobId sets the JobId field's value.
func (s *StartExpenseAnalysisOutput) SetJobId(v string) *StartExpenseAnalysisOutput {
	s.JobId = &v
	return s
}

// Amazon Textract is temporarily unable to process the request. Try your call
// again.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The format of the input document isn't supported. Documents for operations
// can be in PNG, JPEG, PDF, or TIFF format.
type UnsupportedDocumentException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDocumentException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UnsupportedDocumentException) GoString() string {
	return s.String()
}

func newErrorUnsupportedDocumentException(v protocol.ResponseMetadata) error {
	return &UnsupportedDocumentException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *UnsupportedDocumentException) Code() string {
	return "UnsupportedDocumentException"
}

// Message returns the exception's message.
func (s *UnsupportedDocumentException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *UnsupportedDocumentException) OrigErr() error {
	return nil
}

func (s *UnsupportedDocumentException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *UnsupportedDocumentException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *UnsupportedDocumentException) RequestID() string {
	return s.RespMetadata.RequestID
}

// A warning about an issue that occurred during asynchronous text analysis
// (StartDocumentAnalysis) or asynchronous document text detection (StartDocumentTextDetection).
type Warning struct {
	_ struct{} `type:"structure"`

	// The error code for the warning.
	ErrorCode *string `type:"string"`

	// A list of the pages that the warning applies to.
	Pages []*int64 `type:"list"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Warning) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s Warning) GoString() string {
	return s.String()
}

// SetErrorCode sets the ErrorCode field's value.
func (s *Warning) SetErrorCode(v string) *Warning {
	s.ErrorCode = &v
	return s
}

// SetPages sets the Pages field's value.
func (s *Warning) SetPages(v []*int64) *Warning {
	s.Pages = v
	return s
}

const (
	// BlockTypeKeyValueSet is a BlockType enum value
	BlockTypeKeyValueSet = "KEY_VALUE_SET"

	// BlockTypePage is a BlockType enum value
	BlockTypePage = "PAGE"

	// BlockTypeLine is a BlockType enum value
	BlockTypeLine = "LINE"

	// BlockTypeWord is a BlockType enum value
	BlockTypeWord = "WORD"

	// BlockTypeTable is a BlockType enum value
	BlockTypeTable = "TABLE"

	// BlockTypeCell is a BlockType enum value
	BlockTypeCell = "CELL"

	// BlockTypeSelectionElement is a BlockType enum value
	BlockTypeSelectionElement = "SELECTION_ELEMENT"

	// BlockTypeMergedCell is a BlockType enum value
	BlockTypeMergedCell = "MERGED_CELL"

	// BlockTypeTitle is a BlockType enum value
	BlockTypeTitle = "TITLE"

	// BlockTypeQuery is a BlockType enum value
	BlockTypeQuery = "QUERY"

	// BlockTypeQueryResult is a BlockType enum value
	BlockTypeQueryResult = "QUERY_RESULT"
)

// BlockType_Values returns all elements of the BlockType enum
func BlockType_Values() []string {
	return []string{
		BlockTypeKeyValueSet,
		BlockTypePage,
		BlockTypeLine,
		BlockTypeWord,
		BlockTypeTable,
		BlockTypeCell,
		BlockTypeSelectionElement,
		BlockTypeMergedCell,
		BlockTypeTitle,
		BlockTypeQuery,
		BlockTypeQueryResult,
	}
}

const (
	// ContentClassifierFreeOfPersonallyIdentifiableInformation is a ContentClassifier enum value
	ContentClassifierFreeOfPersonallyIdentifiableInformation = "FreeOfPersonallyIdentifiableInformation"

	// ContentClassifierFreeOfAdultContent is a ContentClassifier enum value
	ContentClassifierFreeOfAdultContent = "FreeOfAdultContent"
)

// ContentClassifier_Values returns all elements of the ContentClassifier enum
func ContentClassifier_Values() []string {
	return []string{
		ContentClassifierFreeOfPersonallyIdentifiableInformation,
		ContentClassifierFreeOfAdultContent,
	}
}

const (
	// EntityTypeKey is a EntityType enum value
	EntityTypeKey = "KEY"

	// EntityTypeValue is a EntityType enum value
	EntityTypeValue = "VALUE"

	// EntityTypeColumnHeader is a EntityType enum value
	EntityTypeColumnHeader = "COLUMN_HEADER"
)

// EntityType_Values returns all elements of the EntityType enum
func EntityType_Values() []string {
	return []string{
		EntityTypeKey,
		EntityTypeValue,
		EntityTypeColumnHeader,
	}
}

const (
	// FeatureTypeTables is a FeatureType enum value
	FeatureTypeTables = "TABLES"

	// FeatureTypeForms is a FeatureType enum value
	FeatureTypeForms = "FORMS"

	// FeatureTypeQueries is a FeatureType enum value
	FeatureTypeQueries = "QUERIES"
)

// FeatureType_Values returns all elements of the FeatureType enum
func FeatureType_Values() []string {
	return []string{
		FeatureTypeTables,
		FeatureTypeForms,
		FeatureTypeQueries,
	}
}

const (
	// JobStatusInProgress is a JobStatus enum value
	JobStatusInProgress = "IN_PROGRESS"

	// JobStatusSucceeded is a JobStatus enum value
	JobStatusSucceeded = "SUCCEEDED"

	// JobStatusFailed is a JobStatus enum value
	JobStatusFailed = "FAILED"

	// JobStatusPartialSuccess is a JobStatus enum value
	JobStatusPartialSuccess = "PARTIAL_SUCCESS"
)

// JobStatus_Values returns all elements of the JobStatus enum
func JobStatus_Values() []string {
	return []string{
		JobStatusInProgress,
		JobStatusSucceeded,
		JobStatusFailed,
		JobStatusPartialSuccess,
	}
}

const (
	// RelationshipTypeValue is a RelationshipType enum value
	RelationshipTypeValue = "VALUE"

	// RelationshipTypeChild is a RelationshipType enum value
	RelationshipTypeChild = "CHILD"

	// RelationshipTypeComplexFeatures is a RelationshipType enum value
	RelationshipTypeComplexFeatures = "COMPLEX_FEATURES"

	// RelationshipTypeMergedCell is a RelationshipType enum value
	RelationshipTypeMergedCell = "MERGED_CELL"

	// RelationshipTypeTitle is a RelationshipType enum value
	RelationshipTypeTitle = "TITLE"

	// RelationshipTypeAnswer is a RelationshipType enum value
	RelationshipTypeAnswer = "ANSWER"
)

// RelationshipType_Values returns all elements of the RelationshipType enum
func RelationshipType_Values() []string {
	return []string{
		RelationshipTypeValue,
		RelationshipTypeChild,
		RelationshipTypeComplexFeatures,
		RelationshipTypeMergedCell,
		RelationshipTypeTitle,
		RelationshipTypeAnswer,
	}
}

const (
	// SelectionStatusSelected is a SelectionStatus enum value
	SelectionStatusSelected = "SELECTED"

	// SelectionStatusNotSelected is a SelectionStatus enum value
	SelectionStatusNotSelected = "NOT_SELECTED"
)

// SelectionStatus_Values returns all elements of the SelectionStatus enum
func SelectionStatus_Values() []string {
	return []string{
		SelectionStatusSelected,
		SelectionStatusNotSelected,
	}
}

const (
	// TextTypeHandwriting is a TextType enum value
	TextTypeHandwriting = "HANDWRITING"

	// TextTypePrinted is a TextType enum value
	TextTypePrinted = "PRINTED"
)

// TextType_Values returns all elements of the TextType enum
func TextType_Values() []string {
	return []string{
		TextTypeHandwriting,
		TextTypePrinted,
	}
}

const (
	// ValueTypeDate is a ValueType enum value
	ValueTypeDate = "DATE"
)

// ValueType_Values returns all elements of the ValueType enum
func ValueType_Values() []string {
	return []string{
		ValueTypeDate,
	}
}
