/* pgp4pine prefs.c
 *
 * See common.c for the version and license.
 * Copyright (C) 1998 by Chris Wiegand
 */

#include "defines.h"
#include "includes.h"
#include "structs.h"
#include "declares.h"
#include "externs.h"

/* ------------------------------------------------------------ */
/* Parse for the searchKey in the .pgp4pinerc or use defaultVal */
/* ------------------------------------------------------------ */

char *readPrefs(const char *searchKey, char *defaultVal)
{
	/* searchKey is "text", and defaultVal is "text" too */
	/* so they're safe pointers... */
	FILE *prefsFile;
	char inLine[PREFS_LINE_LENGTH];
	char *key;
	char *value;
	char *homeDir;
	char prefsFileName[MAX_COMMAND_LINE_LENGTH];

	/* Okay, first, let's get the rc file name ($HOME/.pgp4pinerc)	 */
	homeDir = getenv("HOME");
	if (!homeDir || !*homeDir) { /* No home dir? Strange.. */
	  homeDir = "/tmp";
	} 
	strncpy(prefsFileName,homeDir,PREFS_LINE_LENGTH-20);
	strcat(prefsFileName,"/.pgp4pinerc");
	
	/* now, open it... */
	if ((prefsFile = fopen(prefsFileName,"r"))!=NULL) {
		while (!feof(prefsFile)) {
			/* get a line, parse it for variable and value, then compare against
			   what we want. */
			fgets(inLine,PREFS_LINE_LENGTH,prefsFile);
			/* sprintf(debugLine,"readPrefs: lineIn: -%s-",inLine); 
			   documentStatus(debugLine); */
			if (strncmp("#",inLine,1) != 0 && strncmp("//",inLine,2) != 0 ) {
				/* comments always start with # in rc files */
				key = strtok(inLine,"= ");
				value = strtok('\0',"\n");
				/* Cut off leading '=' or ' ', if something was found */
				if (value)
				{ while ((*value=='=') || (*value==' ') || (*value=='\t')) value++; }
				if (strcmp(key,searchKey) == 0) {
					fclose(prefsFile);
					return value;
				}
			}
		}
		fclose(prefsFile);
	}
	return defaultVal;
}

/* ------------------------------------ */
/* Parse a Time entry (cache_decrypted) */
/* ------------------------------------ */

int parseTime(char *a)
{
  int val;

  while ((*a==' ') || (*a=='\t')) a++; /* skip whitespaces */
  val=atoi(a);
  while ((*a>='0') && (*a<='9')) {    /* skip number */
    if(*a++ == 0) return val; }    /* no unit given (end of string), return as minutes*/

  while ((*a==' ') || (*a=='\t')) a++; /* skip whitespaces */

  if (!strncasecmp(a,"min",3))  return val;    /* minutes */
  if (!strncasecmp(a,"hour",4)) return val*60; /* hours */
  if (!strncasecmp(a,"day",3))  return val*60*24; /* days */

  return val; /* not recognized, treat as minutes */
}

/* -------------------------------------------------------------------------- */
/* Read the non-Profile part of pgp4pinerc. Set global variables accordingly. */
/* -------------------------------------------------------------------------- */

void readRCFile()
{
	char *a;
	char *homeDir;

	homeDir = getenv("HOME");
	if (homeDir && *homeDir  /* Got a real home dir */
 	   && (strlen(homeDir) <= PREFS_LINE_LENGTH-20)) {	/* avoid overflow */
	    strcpy(DecryptCacheName,homeDir);
	    strcat(DecryptCacheName,"/.pgp4pine.cache");
	}

	a = readPrefs("override_recipients","0");
	prefsOverrideRecipients = atoi(a);
	
	a = readPrefs("extra_enter_at_end","0");
	prefsExtraCRLFAtEnd = atoi(a);
	
	strcpy(prefsMyPager,readPrefs("external_pager","more"));

	a = readPrefs("verbose_output","1");
	prefsVerboseOutput = atoi(a);
	
	a = readPrefs("add_comment","1");
	prefsAddComment = atoi(a);
	
	if (strlen(DecryptCacheName)>0) {
	  a = readPrefs("cache_decrypted","0");
	  prefsCacheDecrypted = parseTime(a);   /* Parse a time entry: 5 min, 1 day */
	  a = readPrefs("cache_keyrings","1 day");
	  prefsCacheDecrypted = parseTime(a);   /* Parse a time entry: 5 min, 1 day */
	} else prefsCacheDecrypted=-1;
}
