/*
 * @(#)$Id: pass_all.c,v 1.3 1994/04/21 12:25:54 shin Exp $
 *
 * - read/write from/to stdin/pseudo tty for communication between
 *	working	shell and terminal.
 */

static char *rcsid =
	"@(#)$Id: pass_all.c,v 1.3 1994/04/21 12:25:54 shin Exp $";

#include	<stdio.h>
#include	<sys/types.h>
#include	<sys/time.h>
#ifdef	AIX
#include	<sys/select.h>
#endif
#include	"ccode.h"
#include	"ttycmd.h"

/*
#define		BUFSIZ	1024
*/

extern	int	LogStdin;
extern	int	LogStdout;

#define		XLOGF_P1		/* for comparison before/after cnvt */

#ifdef	TWTTY

#define	adjust_buff(buff, nread, wq_state)			\
{								\
	int	i;						\
								\
	wqs0 = wq_state;					\
								\
	/* whether the input terminated at a high byte */	\
	for ( i = 0 ; i < nread ; i++ )				\
		if ( wq_state )					\
			wq_state = 0;				\
		else if ( buff[i] & 0x80 )			\
			wq_state = 1;				\
								\
	/*							\
	 * decide which part to pass:				\
	 *							\
	 * wqs0     == 1: something is waiting			\
	 *		in the last iteration			\
	 * wq_state == 1: the last input char is to be saved	\
	 *		in the waiting queue in this iteration	\
	 */							\
	if ( wqs0 ) {		/* waiting queue not empty */	\
		for (i=nread; i>0 ; i--) buff[i] = buff[i-1];	\
		buff[0] = wq;					\
								\
		if ( wq_state )	/* something to wait */		\
			wq = buff[nread];			\
		else						\
			nread ++;				\
	}							\
	else if ( wq_state )					\
		wq = buff[--nread];				\
								\
	/* if nothing to pass, just skip ... */			\
}
#endif	/* TWTTY */

/*
 * @(#)pass_all: either pass through or on-line convert in/out codes
 *	with optional file logging
 */
pass_all(i_code, o_code, fd, childpid, logfp1, logfps)
int	i_code;
int	o_code;
int	fd;
int	childpid;
int	logfp1, logfps;
{
	int	maxfdp1, nfound, nread;
	char	buff[BUFSIZ+1];	/* buffer for input data */

#ifdef	TWTTY
	int	nwrite;			/* num. items to write */
	char	wbuff[BUFSIZ+1];	/* write buffer, if diff from buff[] */
	char	obuff[BUFSIZ+1];	/* buffer for output from shell */
	char	Owbuff[BUFSIZ+1];	/* write buffer, to stdout */
	char	mesg[BUFSIZ+1];		/* diagnostics messages */

	char	wq;			/* 1-char waiting queue */
	int	wq_state;		/* waiting queue full? */
	int	wqs0;			/* last wq_state */

#endif

	fd_set	readmask;

#ifdef	TWTTY
	wq_state = 0;
#endif

	FD_ZERO(&readmask);

	for (;;) {
		FD_SET(0, &readmask);
		FD_SET(fd, &readmask);
		maxfdp1 = fd + 1;	/* check [0..fd] */

		nfound = select(maxfdp1, &readmask, (fd_set *) 0,
				(fd_set *) 0, (struct timeval *) 0);
		if (nfound < 0)
			err_sys("select error");
		/*
		 * stdin -> pty -> shell
		 */
		if ( FD_ISSET(0, &readmask) ) { /* data to read on stdin */
			nread = read(0, buff, BUFSIZ);
			if (nread<0)
				err_sys("read error from stdin");
			else if (nread == 0)
				break;		/* stdin EOF, done */
#ifndef	TWTTY
		/*
		 * NO code conversion, simply pass through
		 */

			if (write(fd, buff, nread) != nread)
				err_sys("write error to pty");

			if ( LogStdin )
				write(logfps, buff, nread);

#else	/* TWTTY */
		/*
		 * Apply input code conversion & command parsing
		 */
			
			/*
			 * Make sure high bytes are always followed by
			 * one byte in the input buffer.
			 * Prevent the double-byte codes (including EUC
			 * codes) from being cut midway.
			 */
			adjust_buff(buff, nread, wq_state);

			if ( nread <= 0 ) goto do_stdo;

			ttycmd_parse(buff, wbuff, i_code, o_code, nread, &nwrite);
/**
			if ( ttyic )
				cnvtcode(buff, wbuff, i_code, o_code, nread, &nwrite);
			else
				bcopy(buff, wbuff, nwrite = nread);
**/

			if (write(fd, wbuff, nwrite) != nwrite)
				err_sys("write error to pty");

			if ( LogStdin )
				write(logfps, wbuff, nwrite);

#endif	/* !TWTTY */
				
		} /* if FD_ISSET(0) */

		/*
		 * stdout <- pty <- shell
		 */

do_stdo:
		if ( FD_ISSET(fd, &readmask) ) { /* data to read on pty */
#ifndef	TWTTY
		/*
		 * NO code conversion, simply pass through
		 */
			nread = read(fd, buff, BUFSIZ);
			if (nread<=0)
				break;		/* error or EOF, exit */
			if (write(1, buff, nread) != nread)
				err_sys("write error to stdout");

			if ( LogStdout )
				write(logfp1, buff, nread);

#else	/* TWTTY */

		/*
		 * Apply code conversion, ESC sequence parsing, etc.
		 */
#ifdef	CNS_SPEC
		/* special codes for SeedNet stuff */
#endif	/* CNS_SPEC */
		/*
		 * Process other 2byte/4byte codes
		 */
			bzero(obuff,BUFSIZ);

			nread = read(fd, obuff, BUFSIZ);
			if (nread<=0)
				break;		/* error or EOF, exit */

#ifdef	CNS_SPEC
		/* special codes for SeedNet stuff */
#endif
#ifdef	XLOGF_P1
			if ( LogStdout ) {
				sprintf(mesg,"\n-cnvt: nr: %d\n", nread);
				write(logfp1, mesg, strlen(mesg));
				write(logfp1, obuff, nread);
			}
#endif	/* XLOGF_P1 */

			if ( ttyoc )
				cnvtcode(obuff, Owbuff, o_code, i_code, nread, &nwrite);
			else
				bcopy(obuff, Owbuff, nwrite = nread);

			if (write(1, Owbuff, nwrite) != nwrite)
				err_sys("write error to stdout");

			if ( LogStdout ) {
#ifdef	XLOGF_P1
				sprintf(mesg,"\n+cnvt: nw: %d\n", nwrite);
				write(logfp1, mesg, strlen(mesg));
#endif	/* XLOGF_P1 */
				write(logfp1, Owbuff, nwrite);
			}
#endif	/* !TWTTY */
				
		} /* FD_ISSET(fd) */
	} /* for */
} /* pass_all */


/*
 * History:
 *
 * $Log: pass_all.c,v $
 * Revision 1.3  1994/04/21  12:25:54  shin
 * 1. enlarge read/write buffers to 1K so that some time critical
 * 	conversion can be handled on time
 * 2. include "ccode.h"
 * 3. pass length of input bytes explicitly to Alter() so that it
 * 	does not depend on the strlen() function, which may count
 * 	incorrectly at a '\0' boundary
 * 4. add SOSIrecover() to recover SO/SI sequences that were printed as
 * 	^N/^O in printable ASCII chars.
 * 5. add EscNSCP() to segment data streams from shell output so that only
 * 	codes between SO/SI are send to Alter().
 * 	** This function is now commented out because it slows down the
 * 	** conversion speed. Originally I am trying to fix a Bus/Alignment
 * 	** error since I though the ESC sequences for terminal may make
 * 	** the conversion error. However, it is not Alter()'s fault. So
 * 	** EscNSCP may be removed in later version.
 * 6. rearrange the order of codes for pass-through and on-line conversion
 * 	codes.
 * 7. one read buffer is now changed to TWO buffers when code conversion
 * 	is necessary.
 * 8. add some XON/XOFF stuffs, but it appears useless to overcome time-
 * 	critical, mass data conversion problem. The probelm is resolved
 * 	by using a larger buffer as described in 1.
 * 9. Because of the debugging for 5., codes are added to give an extensive
 * 	log (XLOGF_PS.) should be deleted later.
 *
 * Revision 1.2  1994/03/19  20:38:59  shin
 * 1. log files for shell and stdout are control by their own #defined
 * 	constants: LOGF_PS and LOGF_P1, respectively.
 * 2. use write(), instead of fprintf() when writing log files.
 * 3. arguments changed for pass log files to pass_all()
 * 4. allocate one more byte for wbuff[] in pass_all()
 *
 * Revision 1.1  1994/03/16  19:58:00  shin
 * Initial revision
 */
