/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

public class ByteBuffer {
    private int _position;
    private int _limit;
    private int _capacity;
    private byte[] _bytes;
    private int _order = 0;

    public ByteBuffer order(int n) {
        this._order = n;
        return this;
    }

    public static ByteBuffer allocate(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("capacity must be non-negative");
        }
        ByteBuffer byteBuffer = new ByteBuffer();
        byteBuffer._position = 0;
        byteBuffer._limit = n;
        byteBuffer._capacity = n;
        byteBuffer._bytes = new byte[n];
        return byteBuffer;
    }

    public int position() {
        return this._position;
    }

    public ByteBuffer position(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (n > this._limit) {
            throw new IllegalArgumentException("position must be less than limit");
        }
        this._position = n;
        return this;
    }

    public int limit() {
        return this._limit;
    }

    public ByteBuffer limit(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("limit must be non-negative");
        }
        if (n > this._capacity) {
            throw new IllegalArgumentException("limit must be less than capacity");
        }
        this._limit = n;
        return this;
    }

    public int remaining() {
        return this._limit - this._position;
    }

    public boolean hasRemaining() {
        return this._position < this._limit;
    }

    public int capacity() {
        return this._capacity;
    }

    public byte[] array() {
        return this._bytes;
    }

    public ByteBuffer put(ByteBuffer byteBuffer) {
        int n = byteBuffer.remaining();
        this.checkOverflow(n);
        System.arraycopy(byteBuffer._bytes, byteBuffer._position, this._bytes, this._position, n);
        this._position += n;
        return this;
    }

    public byte get() {
        this.checkUnderflow(1);
        return this._bytes[this._position++];
    }

    public ByteBuffer get(byte[] byArray) {
        return this.get(byArray, 0, byArray.length);
    }

    public ByteBuffer get(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset must be non-negative");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("insufficient room beyond given offset in destination array");
        }
        this.checkUnderflow(n2);
        System.arraycopy(this._bytes, this._position, byArray, n, n2);
        this._position += n2;
        return this;
    }

    public ByteBuffer put(byte by) {
        this.checkOverflow(1);
        this._bytes[this._position++] = by;
        return this;
    }

    public ByteBuffer put(byte[] byArray) {
        return this.put(byArray, 0, byArray.length);
    }

    public ByteBuffer put(byte[] byArray, int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("offset must be non-negative");
        }
        if (n + n2 > byArray.length) {
            throw new IllegalArgumentException("insufficient data beyond given offset in source array");
        }
        this.checkOverflow(n2);
        System.arraycopy(byArray, n, this._bytes, this._position, n2);
        this._position += n2;
        return this;
    }

    public short getShort() {
        int n;
        int n2;
        this.checkUnderflow(2);
        if (this._order == 0) {
            n2 = this._bytes[this._position++] & 0xFF;
            n = this._bytes[this._position++] & 0xFF;
        } else {
            n = this._bytes[this._position++] & 0xFF;
            n2 = this._bytes[this._position++] & 0xFF;
        }
        return (short)(n2 << 8 | n);
    }

    public ByteBuffer putShort(short s) {
        this.checkOverflow(2);
        if (this._order == 0) {
            this._bytes[this._position++] = (byte)(s >>> 8);
            this._bytes[this._position++] = (byte)s;
        } else {
            this._bytes[this._position++] = (byte)s;
            this._bytes[this._position++] = (byte)(s >>> 8);
        }
        return this;
    }

    public int getInt() {
        this.checkUnderflow(4);
        int n = 0;
        if (this._order == 0) {
            for (int i = 24; i >= 0; i -= 8) {
                n |= (this._bytes[this._position++] & 0xFF) << i;
            }
        } else {
            for (int i = 0; i < 32; i += 8) {
                n |= (this._bytes[this._position++] & 0xFF) << i;
            }
        }
        return n;
    }

    public ByteBuffer putInt(int n) {
        this.putInt(this._position, n);
        this._position += 4;
        return this;
    }

    public ByteBuffer putInt(int n, int n2) {
        if (n < 0) {
            throw new IllegalArgumentException("position must be non-negative");
        }
        if (n + 4 > this._limit) {
            throw new IllegalArgumentException("position must be less than limit - 4");
        }
        if (this._order == 0) {
            for (int i = 24; i >= 0; i -= 8) {
                this._bytes[n++] = (byte)(n2 >> i & 0xFF);
            }
        } else {
            for (int i = 0; i < 32; i += 8) {
                this._bytes[n++] = (byte)(n2 >> i & 0xFF);
            }
        }
        return this;
    }

    public long getLong() {
        this.checkUnderflow(8);
        long l = 0L;
        if (this._order == 0) {
            for (int i = 56; i >= 0; i -= 8) {
                l |= (long)(this._bytes[this._position++] & 0xFF) << i;
            }
        } else {
            for (int i = 0; i < 64; i += 8) {
                l |= (long)(this._bytes[this._position++] & 0xFF) << i;
            }
        }
        return l;
    }

    public ByteBuffer putLong(long l) {
        this.checkOverflow(8);
        if (this._order == 0) {
            for (int i = 56; i >= 0; i -= 8) {
                this._bytes[this._position++] = (byte)(l >> i & 0xFFL);
            }
        } else {
            for (int i = 0; i < 64; i += 8) {
                this._bytes[this._position++] = (byte)(l >> i & 0xFFL);
            }
        }
        return this;
    }

    private void checkUnderflow(int n) {
        if (this._position + n > this._limit) {
            throw new UnderflowException();
        }
    }

    private void checkOverflow(int n) {
        if (this._position + n > this._limit) {
            throw new OverflowException();
        }
    }

    public static class OverflowException
    extends RuntimeException {
        public OverflowException() {
            super("buffer overflow");
        }
    }

    public static class UnderflowException
    extends RuntimeException {
        public UnderflowException() {
            super("buffer underflow");
        }
    }
}

