/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.EndpointSelectionType;
import Ice.EndpointSelectionTypeParseException;
import Ice.Properties;
import IceInternal.BasicStream;

public final class DefaultsAndOverrides {
    public final String defaultHost;
    public final String defaultProtocol;
    public final boolean defaultCollocationOptimization;
    public final EndpointSelectionType defaultEndpointSelection;
    public final int defaultLocatorCacheTimeout;
    public final boolean defaultPreferSecure;
    public final boolean overrideTimeout;
    public final int overrideTimeoutValue;
    public final boolean overrideConnectTimeout;
    public final int overrideConnectTimeoutValue;
    public final boolean overrideCompress;
    public final boolean overrideCompressValue;
    public final boolean overrideSecure;
    public final boolean overrideSecureValue;

    DefaultsAndOverrides(Properties properties) {
        this.defaultProtocol = properties.getPropertyWithDefault("Ice.Default.Protocol", "tcp");
        String value = properties.getProperty("Ice.Default.Host");
        this.defaultHost = value.length() != 0 ? value : null;
        value = properties.getProperty("Ice.Override.Timeout");
        if (value.length() > 0) {
            this.overrideTimeout = true;
            this.overrideTimeoutValue = properties.getPropertyAsInt("Ice.Override.Timeout");
        } else {
            this.overrideTimeout = false;
            this.overrideTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.ConnectTimeout");
        if (value.length() > 0) {
            this.overrideConnectTimeout = true;
            this.overrideConnectTimeoutValue = properties.getPropertyAsInt("Ice.Override.ConnectTimeout");
        } else {
            this.overrideConnectTimeout = false;
            this.overrideConnectTimeoutValue = -1;
        }
        value = properties.getProperty("Ice.Override.Compress");
        if (value.length() > 0) {
            boolean b;
            this.overrideCompress = true;
            boolean bl = b = properties.getPropertyAsInt("Ice.Override.Compress") > 0;
            if (!BasicStream.compressible() && b) {
                System.err.println("warning: bzip2 support not available, Ice.Override.Compress ignored");
                b = false;
            }
            this.overrideCompressValue = b;
        } else {
            this.overrideCompress = !BasicStream.compressible();
            this.overrideCompressValue = false;
        }
        value = properties.getProperty("Ice.Override.Secure");
        if (value.length() > 0) {
            this.overrideSecure = true;
            this.overrideSecureValue = properties.getPropertyAsInt("Ice.Override.Secure") > 0;
        } else {
            this.overrideSecure = false;
            this.overrideSecureValue = false;
        }
        this.defaultCollocationOptimization = properties.getPropertyAsIntWithDefault("Ice.Default.CollocationOptimization", 1) > 0;
        value = properties.getPropertyWithDefault("Ice.Default.EndpointSelection", "Random");
        if (value.equals("Random")) {
            this.defaultEndpointSelection = EndpointSelectionType.Random;
        } else if (value.equals("Ordered")) {
            this.defaultEndpointSelection = EndpointSelectionType.Ordered;
        } else {
            EndpointSelectionTypeParseException ex = new EndpointSelectionTypeParseException();
            ex.str = value;
            throw ex;
        }
        this.defaultLocatorCacheTimeout = properties.getPropertyAsIntWithDefault("Ice.Default.LocatorCacheTimeout", -1);
        this.defaultPreferSecure = properties.getPropertyAsIntWithDefault("Ice.Default.PreferSecure", 0) > 0;
    }
}

