/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.ConnectionI;
import Ice.LocalException;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterI;
import Ice.SocketException;
import Ice.SyscallException;
import Ice.TimeoutException;
import IceInternal.Acceptor;
import IceInternal.BasicStream;
import IceInternal.DefaultsAndOverrides;
import IceInternal.EndpointI;
import IceInternal.EndpointIHolder;
import IceInternal.EventHandler;
import IceInternal.Instance;
import IceInternal.ThreadPool;
import IceInternal.Transceiver;
import IceUtil.Assert;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.ListIterator;

public final class IncomingConnectionFactory
extends EventHandler {
    private Thread _threadPerIncomingConnectionFactory;
    private Acceptor _acceptor;
    private final Transceiver _transceiver;
    private EndpointI _endpoint;
    private final ObjectAdapter _adapter;
    private boolean _registeredWithPool;
    private int _finishedCount;
    private final boolean _warn;
    private LinkedList _connections;
    private int _state;
    static final /* synthetic */ boolean $assertionsDisabled;

    public synchronized void activate() {
        this.setState(0);
    }

    public synchronized void hold() {
        this.setState(1);
    }

    public synchronized void destroy() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilHolding() {
        LinkedList connections;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state < 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            connections = (LinkedList)this._connections.clone();
        }
        ListIterator p = connections.listIterator();
        while (p.hasNext()) {
            ConnectionI connection = (ConnectionI)p.next();
            connection.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        LinkedList connections;
        Thread threadPerIncomingConnectionFactory = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            while (this._state != 2 || this._acceptor != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            threadPerIncomingConnectionFactory = this._threadPerIncomingConnectionFactory;
            this._threadPerIncomingConnectionFactory = null;
            connections = this._connections;
            this._connections = null;
        }
        if (threadPerIncomingConnectionFactory != null) {
            while (true) {
                try {
                    threadPerIncomingConnectionFactory.join();
                }
                catch (InterruptedException ex) {
                    continue;
                }
                break;
            }
        }
        ListIterator p = connections.listIterator();
        while (p.hasNext()) {
            ConnectionI connection = (ConnectionI)p.next();
            connection.waitUntilFinished();
        }
    }

    public EndpointI endpoint() {
        return this._endpoint;
    }

    public boolean equivalent(EndpointI endp) {
        if (this._transceiver != null) {
            return endp.equivalent(this._transceiver);
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        return endp.equivalent(this._acceptor);
    }

    public synchronized ConnectionI[] connections() {
        LinkedList<ConnectionI> connections = new LinkedList<ConnectionI>();
        ListIterator p = this._connections.listIterator();
        while (p.hasNext()) {
            ConnectionI connection = (ConnectionI)p.next();
            if (connection.isDestroyed()) continue;
            connections.add(connection);
        }
        ConnectionI[] arr = new ConnectionI[connections.size()];
        connections.toArray(arr);
        return arr;
    }

    public void flushBatchRequests() {
        ConnectionI[] c = this.connections();
        for (int i = 0; i < c.length; ++i) {
            try {
                c[i].flushBatchRequests();
                continue;
            }
            catch (LocalException localException) {
                // empty catch block
            }
        }
    }

    public boolean datagram() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        return this._endpoint.datagram();
    }

    public boolean readable() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        return false;
    }

    public boolean read(BasicStream unused) {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void message(BasicStream unused, ThreadPool threadPool) {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        ConnectionI connection = null;
        IncomingConnectionFactory incomingConnectionFactory = this;
        synchronized (incomingConnectionFactory) {
            block26: {
                try {
                    Transceiver transceiver;
                    if (this._state != 0) {
                        Thread.yield();
                        return;
                    }
                    ListIterator p = this._connections.listIterator();
                    while (p.hasNext()) {
                        ConnectionI con = (ConnectionI)p.next();
                        if (!con.isFinished()) continue;
                        p.remove();
                    }
                    try {
                        transceiver = this._acceptor.accept(0);
                    }
                    catch (TimeoutException ex) {
                        threadPool.promoteFollower();
                        return;
                    }
                    catch (LocalException ex) {
                        if (this._warn) {
                            this.warning(ex);
                        }
                        threadPool.promoteFollower();
                        return;
                    }
                    if (!$assertionsDisabled && transceiver == null) {
                        throw new AssertionError();
                    }
                    try {
                        connection = new ConnectionI(this._instance, transceiver, this._endpoint, this._adapter);
                    }
                    catch (LocalException ex) {
                        threadPool.promoteFollower();
                        return;
                    }
                    this._connections.add(connection);
                    break block26;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
                finally {
                    threadPool.promoteFollower();
                }
            }
        }
        if (!$assertionsDisabled && connection == null) {
            throw new AssertionError();
        }
        try {
            connection.validate();
        }
        catch (LocalException ex) {
            IncomingConnectionFactory incomingConnectionFactory2 = this;
            synchronized (incomingConnectionFactory2) {
                connection.waitUntilFinished();
                this._connections.remove(connection);
                return;
            }
        }
        connection.activate();
    }

    public synchronized void finished(ThreadPool threadPool) {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        threadPool.promoteFollower();
        --this._finishedCount;
        if (this._finishedCount == 0 && this._state == 2) {
            this._acceptor.close();
            this._acceptor = null;
            this.notifyAll();
        }
    }

    public void exception(LocalException ex) {
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
    }

    public synchronized String toString() {
        if (this._transceiver != null) {
            return ((Object)this._transceiver).toString();
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        return ((Object)this._acceptor).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IncomingConnectionFactory(Instance instance, EndpointI endpoint, ObjectAdapter adapter, String adapterName) {
        block17: {
            super(instance);
            this._connections = new LinkedList();
            this._endpoint = endpoint;
            this._adapter = adapter;
            this._registeredWithPool = false;
            this._finishedCount = 0;
            this._warn = this._instance.initializationData().properties.getPropertyAsInt("Ice.Warn.Connections") > 0;
            this._state = 1;
            DefaultsAndOverrides defaultsAndOverrides = this._instance.defaultsAndOverrides();
            if (defaultsAndOverrides.overrideTimeout) {
                this._endpoint = this._endpoint.timeout(defaultsAndOverrides.overrideTimeoutValue);
            }
            if (defaultsAndOverrides.overrideCompress) {
                this._endpoint = this._endpoint.compress(defaultsAndOverrides.overrideCompressValue);
            }
            EndpointIHolder h = new EndpointIHolder();
            h.value = this._endpoint;
            this._transceiver = this._endpoint.serverTransceiver(h);
            try {
                if (this._transceiver != null) {
                    this._endpoint = h.value;
                    ConnectionI connection = null;
                    try {
                        connection = new ConnectionI(this._instance, this._transceiver, this._endpoint, this._adapter);
                        connection.validate();
                    }
                    catch (LocalException ex) {
                        if (connection != null) {
                            connection.waitUntilFinished();
                        }
                        return;
                    }
                    this._connections.add(connection);
                    break block17;
                }
                h.value = this._endpoint;
                this._acceptor = this._endpoint.acceptor(h, adapterName);
                this._endpoint = h.value;
                if (!$assertionsDisabled && this._acceptor == null) {
                    throw new AssertionError();
                }
                this._acceptor.listen();
                if (!this._instance.threadPerConnection()) break block17;
                try {
                    this._threadPerIncomingConnectionFactory = new ThreadPerIncomingConnectionFactory();
                    this._threadPerIncomingConnectionFactory.start();
                }
                catch (Exception ex) {
                    this.error("cannot create thread for incoming connection factory", ex);
                    throw ex;
                }
            }
            catch (Exception ex) {
                if (this._acceptor != null) {
                    try {
                        this._acceptor.close();
                    }
                    catch (LocalException e) {
                        // empty catch block
                    }
                }
                Object e = this;
                synchronized (e) {
                    this._state = 2;
                    this._acceptor = null;
                    this._connections = null;
                    this._threadPerIncomingConnectionFactory = null;
                }
                e = new SyscallException();
                ((Throwable)e).initCause(ex);
                throw e;
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        Assert.FinalizerAssert(this._state == 2);
        Assert.FinalizerAssert(this._acceptor == null);
        Assert.FinalizerAssert(this._connections == null);
        Assert.FinalizerAssert(this._threadPerIncomingConnectionFactory == null);
        super.finalize();
    }

    private void setState(int state) {
        if (this._state == state) {
            return;
        }
        switch (state) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                if (!this._instance.threadPerConnection() && this._acceptor != null) {
                    this.registerWithPool();
                }
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = (ConnectionI)p.next();
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                if (!this._instance.threadPerConnection() && this._acceptor != null) {
                    this.unregisterWithPool();
                }
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = (ConnectionI)p.next();
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    if (this._instance.threadPerConnection()) {
                        this._acceptor.connectToSelf();
                    } else {
                        this.registerWithPool();
                        this.unregisterWithPool();
                    }
                }
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI connection = (ConnectionI)p.next();
                    connection.destroy(0);
                }
                break;
            }
        }
        this._state = state;
        this.notifyAll();
    }

    private void registerWithPool() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        if (!this._registeredWithPool) {
            ((ObjectAdapterI)this._adapter).getThreadPool()._register(this._acceptor.fd(), this);
            this._registeredWithPool = true;
        }
    }

    private void unregisterWithPool() {
        if (!$assertionsDisabled && this._instance.threadPerConnection()) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        if (this._registeredWithPool) {
            ((ObjectAdapterI)this._adapter).getThreadPool().unregister(this._acceptor.fd());
            this._registeredWithPool = false;
            ++this._finishedCount;
        }
    }

    private void warning(LocalException ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = "connection exception:\n" + sw.toString() + '\n' + ((Object)this._acceptor).toString();
        this._instance.initializationData().logger.warning(s);
    }

    private void error(String msg, Exception ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String s = msg + ":\n" + this.toString() + "\n" + sw.toString();
        this._instance.initializationData().logger.error(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run() {
        if (!$assertionsDisabled && this._acceptor == null) {
            throw new AssertionError();
        }
        while (true) {
            Transceiver transceiver;
            block23: {
                transceiver = null;
                try {
                    transceiver = this._acceptor.accept(-1);
                }
                catch (SocketException ex) {
                    throw ex;
                }
                catch (TimeoutException ex) {
                }
                catch (LocalException ex) {
                    if (!this._warn) break block23;
                    this.warning(ex);
                }
            }
            ConnectionI connection = null;
            IncomingConnectionFactory incomingConnectionFactory = this;
            synchronized (incomingConnectionFactory) {
                while (this._state == 1) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException ex) {}
                }
                if (this._state == 2) {
                    if (transceiver != null) {
                        try {
                            transceiver.close();
                        }
                        catch (LocalException ex) {
                            // empty catch block
                        }
                    }
                    try {
                        this._acceptor.close();
                    }
                    catch (LocalException ex) {
                        this._acceptor = null;
                        this.notifyAll();
                        throw ex;
                    }
                    this._acceptor = null;
                    this.notifyAll();
                    return;
                }
                if (!$assertionsDisabled && this._state != 0) {
                    throw new AssertionError();
                }
                ListIterator p = this._connections.listIterator();
                while (p.hasNext()) {
                    ConnectionI con = (ConnectionI)p.next();
                    if (!con.isFinished()) continue;
                    p.remove();
                }
                if (transceiver != null) {
                    try {
                        connection = new ConnectionI(this._instance, transceiver, this._endpoint, this._adapter);
                    }
                    catch (LocalException ex) {
                        return;
                    }
                    this._connections.add(connection);
                }
            }
        }
    }

    static {
        $assertionsDisabled = !IncomingConnectionFactory.class.desiredAssertionStatus();
    }

    private class ThreadPerIncomingConnectionFactory
    extends Thread {
        private ThreadPerIncomingConnectionFactory() {
        }

        public void run() {
            try {
                IncomingConnectionFactory.this.run();
            }
            catch (Exception ex) {
                IncomingConnectionFactory.this.error("exception in thread per incoming connection factory", ex);
            }
        }
    }
}

