/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.Application;

import IceGrid.BoxedString;
import IceGrid.IceBoxDescriptor;
import IceGrid.NodeDescriptor;
import IceGrid.NodeUpdateDescriptor;
import IceGrid.PropertySetDescriptor;
import IceGrid.ServerDescriptor;
import IceGrid.ServerInstanceDescriptor;
import IceGrid.TemplateDescriptor;
import IceGridGUI.Application.Editable;
import IceGridGUI.Application.Editor;
import IceGridGUI.Application.NodeEditor;
import IceGridGUI.Application.Nodes;
import IceGridGUI.Application.PlainServer;
import IceGridGUI.Application.PropertySet;
import IceGridGUI.Application.PropertySetParent;
import IceGridGUI.Application.PropertySets;
import IceGridGUI.Application.Root;
import IceGridGUI.Application.Server;
import IceGridGUI.Application.ServerInstance;
import IceGridGUI.Application.ServerTemplate;
import IceGridGUI.Application.ServiceInstance;
import IceGridGUI.Application.TreeNode;
import IceGridGUI.Application.UpdateFailedException;
import IceGridGUI.ApplicationActions;
import IceGridGUI.Utils;
import IceGridGUI.XMLWriter;
import java.awt.Component;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;

class Node
extends TreeNode
implements PropertySetParent {
    private NodeDescriptor _descriptor;
    private Utils.Resolver _resolver;
    private Map _origVariables;
    private String _origDescription;
    private String _origLoadFactor;
    private final boolean _ephemeral;
    private NodeEditor _editor;
    private LinkedList _propertySets = new LinkedList();
    private LinkedList _servers = new LinkedList();
    private Editable _editable;
    private static DefaultTreeCellRenderer _cellRenderer;
    private static JPopupMenu _popup;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static NodeDescriptor copyDescriptor(NodeDescriptor nd) {
        NodeDescriptor copy = (NodeDescriptor)nd.clone();
        copy.propertySets = PropertySets.copyDescriptors(copy.propertySets);
        copy.serverInstances = new LinkedList();
        Iterator p = nd.serverInstances.iterator();
        while (p.hasNext()) {
            copy.serverInstances.add(ServerInstance.copyDescriptor((ServerInstanceDescriptor)p.next()));
        }
        copy.servers = new LinkedList();
        p = nd.servers.iterator();
        while (p.hasNext()) {
            copy.servers.add(PlainServer.copyDescriptor((ServerDescriptor)p.next()));
        }
        return copy;
    }

    public Enumeration children() {
        return new Enumeration(){
            private Iterator _p;
            private boolean _iteratingOverServers;
            {
                this._p = Node.this._propertySets.iterator();
                this._iteratingOverServers = false;
            }

            public boolean hasMoreElements() {
                if (!this._p.hasNext()) {
                    if (!this._iteratingOverServers) {
                        this._p = Node.this._servers.iterator();
                        this._iteratingOverServers = true;
                        return this._p.hasNext();
                    }
                    return false;
                }
                return true;
            }

            public Object nextElement() {
                return this._p.next();
            }
        };
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public javax.swing.tree.TreeNode getChildAt(int childIndex) {
        if (childIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(childIndex);
        }
        if (childIndex < this._propertySets.size()) {
            return (javax.swing.tree.TreeNode)this._propertySets.get(childIndex);
        }
        if (childIndex < this._propertySets.size() + this._servers.size()) {
            return (javax.swing.tree.TreeNode)this._servers.get(childIndex - this._propertySets.size());
        }
        throw new ArrayIndexOutOfBoundsException(childIndex);
    }

    public int getChildCount() {
        return this._propertySets.size() + this._servers.size();
    }

    public int getIndex(javax.swing.tree.TreeNode node) {
        if (node instanceof PropertySet) {
            return this._propertySets.indexOf(node);
        }
        int index = this._servers.indexOf(node);
        if (index != -1) {
            index += this._propertySets.size();
        }
        return index;
    }

    public boolean isLeaf() {
        return this._propertySets.isEmpty() && this._servers.isEmpty();
    }

    void removeServers(String[] childIds) {
        this.removeSortedChildren(childIds, this._servers, this.getRoot().getTreeModel());
    }

    void removePropertySets(String[] childIds) {
        this.removeSortedChildren(childIds, this._propertySets, this.getRoot().getTreeModel());
    }

    void childrenChanged(List children) {
        this.childrenChanged(children, this.getRoot().getTreeModel());
    }

    Server findServer(String id) {
        return (Server)((Object)this.find(id, this._servers));
    }

    PropertySet findPropertySet(String id) {
        return (PropertySet)this.find(id, this._propertySets);
    }

    void insertPropertySets(List newChildren, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        String badChildId = this.insertSortedChildren(newChildren, this._propertySets, treeModel);
        if (badChildId != null) {
            throw new UpdateFailedException(this, badChildId);
        }
    }

    void insertServer(TreeNode child, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel;
        DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        if (!this.insertSortedChild(child, this._servers, treeModel)) {
            throw new UpdateFailedException(this, child.getId());
        }
    }

    void insertServers(List newChildren, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        String badChildId = this.insertSortedChildren(newChildren, this._servers, treeModel);
        if (badChildId != null) {
            throw new UpdateFailedException(this, badChildId);
        }
    }

    void removeServer(TreeNode child) {
        int index = this.getIndex(child);
        this._servers.remove(child);
        this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
    }

    public void insertPropertySet(PropertySet child, boolean fireEvent) throws UpdateFailedException {
        DefaultTreeModel treeModel;
        DefaultTreeModel defaultTreeModel = treeModel = fireEvent ? this.getRoot().getTreeModel() : null;
        if (!this.insertSortedChild(child, this._propertySets, treeModel)) {
            throw new UpdateFailedException(this, child.getId());
        }
    }

    public void removePropertySet(PropertySet child) {
        int index = this.getIndex(child);
        this._propertySets.remove(child);
        this.getRoot().getTreeModel().nodesWereRemoved(this, new int[]{index}, new Object[]{child});
    }

    public void removeDescriptor(String id) {
        this._descriptor.propertySets.remove(id);
    }

    public Editable getEditable() {
        return this._editable;
    }

    public boolean[] getAvailableActions() {
        boolean[] actions = new boolean[20];
        actions[13] = true;
        actions[15] = true;
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor != null) {
            boolean bl = actions[14] = descriptor instanceof NodeDescriptor || descriptor instanceof ServerInstanceDescriptor || descriptor instanceof ServerDescriptor || descriptor instanceof PropertySetDescriptor;
        }
        if (!this._ephemeral) {
            actions[16] = true;
            actions[17] = true;
            actions[3] = true;
            actions[5] = true;
            actions[6] = true;
            actions[7] = true;
        }
        return actions;
    }

    public JPopupMenu getPopupMenu() {
        ApplicationActions actions = this.getCoordinator().getActionsForPopup();
        if (_popup == null) {
            _popup = new JPopupMenu();
            _popup.add(actions.get(3));
            _popup.addSeparator();
            _popup.add(actions.get(5));
            _popup.add(actions.get(6));
            _popup.add(actions.get(7));
        }
        actions.setTarget(this);
        return _popup;
    }

    public void copy() {
        this.getCoordinator().setClipboard(Node.copyDescriptor(this._descriptor));
        this.getCoordinator().getActionsForMenu().get(14).setEnabled(true);
    }

    public void paste() {
        Object descriptor = this.getCoordinator().getClipboard();
        if (descriptor instanceof NodeDescriptor) {
            ((TreeNode)this._parent).paste();
        } else if (descriptor instanceof PropertySetDescriptor) {
            this.newPropertySet(PropertySet.copyDescriptor((PropertySetDescriptor)descriptor));
        } else if (descriptor instanceof ServerInstanceDescriptor) {
            this.newServer(ServerInstance.copyDescriptor((ServerInstanceDescriptor)descriptor));
        } else {
            this.newServer(PlainServer.copyDescriptor((ServerDescriptor)descriptor));
        }
    }

    public void newPropertySet() {
        this.newPropertySet(new PropertySetDescriptor(new String[0], new LinkedList()));
    }

    public void newServer() {
        this.newServer(PlainServer.newServerDescriptor());
    }

    public void newServerIceBox() {
        this.newServer(PlainServer.newIceBoxDescriptor());
    }

    public void newServerFromTemplate() {
        ServerInstanceDescriptor descriptor = new ServerInstanceDescriptor("", new HashMap(), new PropertySetDescriptor(new String[0], new LinkedList()));
        this.newServer(descriptor);
    }

    public void destroy() {
        Nodes nodes = (Nodes)this._parent;
        if (this._ephemeral) {
            nodes.removeChild(this);
        } else {
            nodes.removeChild(this);
            nodes.removeDescriptor(this._id);
            nodes.getEditable().removeElement(this._id, this._editable, Node.class);
            this.getRoot().updated();
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (_cellRenderer == null) {
            _cellRenderer = new DefaultTreeCellRenderer();
            ImageIcon nodeIcon = Utils.getIcon("/icons/16x16/node.png");
            _cellRenderer.setOpenIcon(nodeIcon);
            _cellRenderer.setClosedIcon(nodeIcon);
        }
        return _cellRenderer.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    public Editor getEditor() {
        if (this._editor == null) {
            this._editor = (NodeEditor)this.getRoot().getEditor(NodeEditor.class, this);
        }
        this._editor.show(this);
        return this._editor;
    }

    protected Editor createEditor() {
        return new NodeEditor();
    }

    public boolean isEphemeral() {
        return this._ephemeral;
    }

    Object getDescriptor() {
        return this._descriptor;
    }

    NodeDescriptor saveDescriptor() {
        return (NodeDescriptor)this._descriptor.clone();
    }

    void restoreDescriptor(NodeDescriptor copy) {
        this._descriptor.description = copy.description;
        this._descriptor.loadFactor = copy.loadFactor;
        this._descriptor.variables = copy.variables;
    }

    void write(XMLWriter writer) throws IOException {
        if (!this._ephemeral) {
            LinkedList<String[]> attributes = new LinkedList<String[]>();
            attributes.add(Node.createAttribute("name", this._id));
            if (this._descriptor.loadFactor.length() > 0) {
                attributes.add(Node.createAttribute("load-factor", this._descriptor.loadFactor));
            }
            writer.writeStartTag("node", attributes);
            if (this._descriptor.description.length() > 0) {
                writer.writeElement("description", this._descriptor.description);
            }
            Node.writeVariables(writer, this._descriptor.variables);
            Iterator p = this._propertySets.iterator();
            while (p.hasNext()) {
                PropertySet ps = (PropertySet)p.next();
                ps.write(writer);
            }
            p = this._servers.iterator();
            while (p.hasNext()) {
                TreeNode server = (TreeNode)p.next();
                server.write(writer);
            }
            writer.writeEndTag("node");
        }
    }

    Backup rebuild(List editables) throws UpdateFailedException {
        Root root = this.getRoot();
        Backup backup = new Backup();
        backup.resolver = this._resolver;
        this._resolver = new Utils.Resolver(new Map[]{this._descriptor.variables, root.getVariables()});
        this._resolver.put("application", root.getId());
        this._resolver.put("node", this._id);
        backup.backupList = new Vector();
        backup.servers = (LinkedList)this._servers.clone();
        Iterator p = backup.servers.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            try {
                backup.backupList.add(server.rebuild(editables));
            }
            catch (UpdateFailedException e) {
                this.restore(backup);
                throw e;
            }
        }
        return backup;
    }

    void commit() {
        this._editable.commit();
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origLoadFactor = this._descriptor.loadFactor;
        Iterator p = this._propertySets.iterator();
        while (p.hasNext()) {
            PropertySet ps = (PropertySet)p.next();
            ps.commit();
        }
        p = this._servers.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            server.getEditable().commit();
        }
    }

    void restore(Backup backup) {
        for (int i = backup.backupList.size() - 1; i >= 0; --i) {
            ((Server)backup.servers.get(i)).restore(backup.backupList.get(i));
        }
        this._resolver = backup.resolver;
    }

    ServerInstance createServer(boolean brandNew, ServerInstanceDescriptor instanceDescriptor) throws UpdateFailedException {
        Root root = this.getRoot();
        TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(instanceDescriptor.template);
        if (!$assertionsDisabled && templateDescriptor == null) {
            throw new AssertionError();
        }
        ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
        if (!$assertionsDisabled && serverDescriptor == null) {
            throw new AssertionError();
        }
        boolean isIceBox = serverDescriptor instanceof IceBoxDescriptor;
        Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        return new ServerInstance(brandNew, this, serverId, instanceResolver, instanceDescriptor, isIceBox);
    }

    PlainServer createServer(boolean brandNew, ServerDescriptor serverDescriptor) throws UpdateFailedException {
        Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver);
        String serverId = instanceResolver.substitute(serverDescriptor.id);
        instanceResolver.put("server", serverId);
        return new PlainServer(brandNew, this, serverId, instanceResolver, serverDescriptor);
    }

    NodeUpdateDescriptor getUpdate() {
        Iterator<Object> p;
        NodeUpdateDescriptor update = new NodeUpdateDescriptor();
        update.name = this._id;
        if (this._editable.isNew()) {
            update.removePropertySets = new String[0];
            update.propertySets = this._descriptor.propertySets;
        } else {
            update.removePropertySets = this._editable.removedElements(PropertySet.class);
            update.propertySets = new HashMap();
            p = this._propertySets.iterator();
            while (p.hasNext()) {
                PropertySet ps = (PropertySet)p.next();
                if (!ps.getEditable().isNew() && !ps.getEditable().isModified()) continue;
                update.propertySets.put(ps.getId(), ps.getDescriptor());
            }
        }
        update.removeServers = this._editable.isNew() ? new String[0] : this._editable.removedElements(Server.class);
        update.serverInstances = new LinkedList();
        update.servers = new LinkedList();
        p = this._servers.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            if (!this._editable.isNew() && !server.getEditable().isModified() && !server.getEditable().isNew()) continue;
            if (server instanceof PlainServer) {
                update.servers.add(server.getDescriptor());
                continue;
            }
            update.serverInstances.add(server.getDescriptor());
        }
        if (!this._editable.isNew() && !this._editable.isModified() && update.removePropertySets.length == 0 && update.propertySets.size() == 0 && update.removeServers.length == 0 && update.servers.size() == 0 && update.serverInstances.size() == 0) {
            return null;
        }
        if (this._editable.isNew()) {
            update.variables = this._descriptor.variables;
            update.removeVariables = new String[0];
            update.loadFactor = new BoxedString(this._descriptor.loadFactor);
        } else {
            if (!this._descriptor.description.equals(this._origDescription)) {
                update.description = new BoxedString(this._descriptor.description);
            }
            if (!this._descriptor.loadFactor.equals(this._origLoadFactor)) {
                update.loadFactor = new BoxedString(this._descriptor.loadFactor);
            }
            update.variables = new TreeMap(this._descriptor.variables);
            LinkedList removeVariables = new LinkedList();
            p = this._origVariables.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = (Map.Entry)p.next();
                Object key = entry.getKey();
                Object newValue = update.variables.get(key);
                if (newValue == null) {
                    removeVariables.add(key);
                    continue;
                }
                Object value = entry.getValue();
                if (!newValue.equals(value)) continue;
                update.variables.remove(key);
            }
            update.removeVariables = removeVariables.toArray(new String[0]);
        }
        return update;
    }

    void update(NodeUpdateDescriptor update, Set serverTemplates, Set serviceTemplates) throws UpdateFailedException {
        Server server;
        Root root = this.getRoot();
        Vector<TreeNode> newServers = new Vector<TreeNode>();
        Vector<Object> updatedServers = new Vector<Object>();
        if (update != null) {
            int i;
            if (update.description != null) {
                this._origDescription = this._descriptor.description = update.description.value;
            }
            if (update.loadFactor != null) {
                this._origLoadFactor = this._descriptor.loadFactor = update.loadFactor.value;
            }
            for (i = 0; i < update.removeVariables.length; ++i) {
                this._descriptor.variables.remove(update.removeVariables[i]);
            }
            this._descriptor.variables.putAll(update.variables);
            this.removePropertySets(update.removePropertySets);
            for (i = 0; i < update.removePropertySets.length; ++i) {
                this._descriptor.propertySets.remove(update.removePropertySets[i]);
            }
            Vector<PropertySet> newPropertySets = new Vector<PropertySet>();
            Vector<PropertySet> updatedPropertySets = new Vector<PropertySet>();
            Iterator p = update.propertySets.entrySet().iterator();
            while (p.hasNext()) {
                Map.Entry entry = p.next();
                String id = (String)entry.getKey();
                PropertySetDescriptor psd = (PropertySetDescriptor)entry.getValue();
                PropertySet ps = this.findPropertySet(id);
                if (ps != null) {
                    ps.rebuild(psd);
                    updatedPropertySets.add(ps);
                    continue;
                }
                ps = new PropertySet(false, this, id, psd);
                newPropertySets.add(ps);
                this._descriptor.propertySets.put(id, psd);
            }
            this.childrenChanged(updatedPropertySets);
            this.insertPropertySets(newPropertySets, true);
            for (int i2 = 0; i2 < update.removeServers.length; ++i2) {
                Server server2 = this.findServer(update.removeServers[i2]);
                this.removeDescriptor(server2);
            }
            this.removeServers(update.removeServers);
            p = update.serverInstances.iterator();
            while (p.hasNext()) {
                ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)((Object)p.next());
                TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(instanceDescriptor.template);
                if (!$assertionsDisabled && templateDescriptor == null) {
                    throw new AssertionError();
                }
                ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
                if (!$assertionsDisabled && serverDescriptor == null) {
                    throw new AssertionError();
                }
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                instanceResolver.put("server", serverId);
                ServerInstance server3 = (ServerInstance)this.findServer(serverId);
                if (server3 != null) {
                    this.removeDescriptor(server3);
                    server3.rebuild(instanceResolver, instanceDescriptor, serverDescriptor instanceof IceBoxDescriptor);
                    updatedServers.add(server3);
                    this._descriptor.serverInstances.add(instanceDescriptor);
                    continue;
                }
                server3 = new ServerInstance(false, this, serverId, instanceResolver, instanceDescriptor, serverDescriptor instanceof IceBoxDescriptor);
                newServers.add(server3);
                this._descriptor.serverInstances.add(instanceDescriptor);
            }
            p = update.servers.iterator();
            while (p.hasNext()) {
                ServerDescriptor serverDescriptor = (ServerDescriptor)((Object)p.next());
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                instanceResolver.put("server", serverId);
                PlainServer server4 = (PlainServer)this.findServer(serverId);
                if (server4 != null) {
                    this.removeDescriptor(server4);
                    server4.rebuild(instanceResolver, serverDescriptor);
                    updatedServers.add(server4);
                    this._descriptor.servers.add(serverDescriptor);
                    continue;
                }
                server4 = new PlainServer(false, this, serverId, instanceResolver, serverDescriptor);
                newServers.add(server4);
                this._descriptor.servers.add(serverDescriptor);
            }
        }
        HashSet<ServerInstance> serverSet = new HashSet<ServerInstance>();
        Iterator p = serverTemplates.iterator();
        while (p.hasNext()) {
            String template = (String)p.next();
            List serverInstances = this.findServerInstances(template);
            Iterator q = serverInstances.iterator();
            while (q.hasNext()) {
                server = (ServerInstance)q.next();
                if (updatedServers.contains(server) || newServers.contains(server)) continue;
                serverSet.add((ServerInstance)server);
            }
        }
        p = serviceTemplates.iterator();
        while (p.hasNext()) {
            List serviceInstances = this.findServiceInstances((String)p.next());
            Iterator q = serviceInstances.iterator();
            while (q.hasNext()) {
                ServiceInstance service = (ServiceInstance)q.next();
                server = (Server)((Object)service.getParent().getParent());
                if (updatedServers.contains(server) || newServers.contains(server)) continue;
                serverSet.add((ServerInstance)server);
            }
        }
        p = serverSet.iterator();
        while (p.hasNext()) {
            Server server5 = (Server)p.next();
            if (server5 instanceof PlainServer) {
                PlainServer ps = (PlainServer)server5;
                ServerDescriptor serverDescriptor = (ServerDescriptor)ps.getDescriptor();
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                if (!$assertionsDisabled && !serverId.equals(ps.getId())) {
                    throw new AssertionError();
                }
                ps.rebuild(instanceResolver, serverDescriptor);
            } else {
                ServerInstance si = (ServerInstance)server5;
                ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)si.getDescriptor();
                TemplateDescriptor templateDescriptor = root.findServerTemplateDescriptor(instanceDescriptor.template);
                if (!$assertionsDisabled && templateDescriptor == null) {
                    throw new AssertionError();
                }
                ServerDescriptor serverDescriptor = (ServerDescriptor)templateDescriptor.descriptor;
                if (!$assertionsDisabled && serverDescriptor == null) {
                    throw new AssertionError();
                }
                Utils.Resolver instanceResolver = new Utils.Resolver(this._resolver, instanceDescriptor.parameterValues, templateDescriptor.parameterDefaults);
                String serverId = instanceResolver.substitute(serverDescriptor.id);
                if (!$assertionsDisabled && !serverId.equals(si.getId())) {
                    throw new AssertionError();
                }
                si.rebuild(instanceResolver, instanceDescriptor, serverDescriptor instanceof IceBoxDescriptor);
            }
            updatedServers.add(server5);
        }
        this.childrenChanged(updatedServers);
        this.insertServers(newServers, true);
    }

    Node(boolean brandNew, TreeNode parent, String nodeName, NodeDescriptor descriptor) throws UpdateFailedException {
        super(parent, nodeName);
        this._editable = new Editable(brandNew);
        this._ephemeral = false;
        this._descriptor = descriptor;
        this._origVariables = this._descriptor.variables;
        this._origDescription = this._descriptor.description;
        this._origLoadFactor = this._descriptor.loadFactor;
        this._resolver = new Utils.Resolver(new Map[]{this._descriptor.variables, this.getRoot().getVariables()});
        this._resolver.put("application", this.getRoot().getId());
        this._resolver.put("node", this._id);
        Iterator p = this._descriptor.propertySets.entrySet().iterator();
        while (p.hasNext()) {
            Map.Entry entry = p.next();
            this.insertPropertySet(new PropertySet(false, this, (String)entry.getKey(), (PropertySetDescriptor)entry.getValue()), false);
        }
        p = this._descriptor.serverInstances.iterator();
        while (p.hasNext()) {
            ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)((Object)p.next());
            this.insertServer(this.createServer(false, instanceDescriptor), false);
        }
        p = this._descriptor.servers.iterator();
        while (p.hasNext()) {
            ServerDescriptor serverDescriptor = (ServerDescriptor)((Object)p.next());
            this.insertServer(this.createServer(false, serverDescriptor), false);
        }
    }

    Node(TreeNode parent, String nodeName, NodeDescriptor descriptor) {
        super(parent, nodeName);
        this._editable = new Editable(false);
        this._ephemeral = true;
        this._descriptor = descriptor;
    }

    List findServerInstances(String template) {
        LinkedList<Server> result = new LinkedList<Server>();
        Iterator p = this._servers.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            if (!(server instanceof ServerInstance)) continue;
            ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)server.getDescriptor();
            if (!instanceDescriptor.template.equals(template)) continue;
            result.add(server);
        }
        return result;
    }

    void removeServerInstances(String template) {
        LinkedList<String> toRemove = new LinkedList<String>();
        Iterator p = this._servers.iterator();
        while (p.hasNext()) {
            Server server = (Server)p.next();
            if (!(server instanceof ServerInstance)) continue;
            ServerInstanceDescriptor instanceDescriptor = (ServerInstanceDescriptor)server.getDescriptor();
            if (!instanceDescriptor.template.equals(template)) continue;
            this.removeDescriptor(instanceDescriptor);
            String id = ((TreeNode)((Object)server)).getId();
            this._editable.removeElement(id, server.getEditable(), class$IceGridGUI$Application$Server == null ? Node.class$("IceGridGUI.Application.Server") : class$IceGridGUI$Application$Server);
            toRemove.add(id);
        }
        if (toRemove.size() > 0) {
            this.removeServers(toRemove.toArray(new String[0]));
        }
    }

    List findServiceInstances(String template) {
        LinkedList result = new LinkedList();
        Iterator p = this._servers.iterator();
        while (p.hasNext()) {
            Object o = p.next();
            if (!(o instanceof PlainServer)) continue;
            result.addAll(((PlainServer)o).findServiceInstances(template));
        }
        return result;
    }

    void removeServiceInstances(String template) {
        Iterator p = this._servers.iterator();
        while (p.hasNext()) {
            Object o = p.next();
            if (!(o instanceof PlainServer)) continue;
            ((PlainServer)o).removeServiceInstances(template);
        }
    }

    Utils.Resolver getResolver() {
        return this._resolver;
    }

    public void tryAdd(String id, PropertySetDescriptor descriptor) throws UpdateFailedException {
        this.insertPropertySet(new PropertySet(true, this, id, descriptor), true);
        this._descriptor.propertySets.put(id, descriptor);
    }

    void tryAdd(ServerInstanceDescriptor instanceDescriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertServer(this.createServer(true, instanceDescriptor), true);
        if (addDescriptor) {
            this._descriptor.serverInstances.add(instanceDescriptor);
        }
    }

    void tryAdd(ServerDescriptor serverDescriptor, boolean addDescriptor) throws UpdateFailedException {
        this.insertServer(this.createServer(true, serverDescriptor), true);
        if (addDescriptor) {
            this._descriptor.servers.add(serverDescriptor);
        }
    }

    void removeDescriptor(Server server) {
        if (server instanceof ServerInstance) {
            this.removeDescriptor((ServerInstanceDescriptor)server.getDescriptor());
        } else {
            this.removeDescriptor((ServerDescriptor)server.getDescriptor());
        }
    }

    void removeDescriptor(ServerDescriptor sd) {
        Iterator p = this._descriptor.servers.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    void removeDescriptor(ServerInstanceDescriptor sd) {
        Iterator p = this._descriptor.serverInstances.iterator();
        while (p.hasNext()) {
            if (sd != p.next()) continue;
            p.remove();
            break;
        }
    }

    private void newPropertySet(PropertySetDescriptor descriptor) {
        PropertySet ps;
        block2: {
            String id = this.makeNewChildId("PropertySet");
            ps = new PropertySet(this, id, descriptor);
            try {
                this.insertPropertySet(ps, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(ps);
    }

    private void newServer(ServerDescriptor descriptor) {
        PlainServer server;
        block2: {
            descriptor.id = this.makeNewChildId(descriptor.id);
            server = new PlainServer(this, descriptor.id, descriptor);
            try {
                this.insertServer(server, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.getRoot().setSelectedNode(server);
    }

    private void newServer(ServerInstanceDescriptor descriptor) {
        ServerInstance server;
        Root root;
        block4: {
            String id = this.makeNewChildId("NewServer");
            root = this.getRoot();
            ServerTemplate t = root.findServerTemplate(descriptor.template);
            if (t == null) {
                t = (ServerTemplate)root.getServerTemplates().getChildAt(0);
                if (t == null) {
                    JOptionPane.showMessageDialog(this.getCoordinator().getMainFrame(), "You need to create a server template before you can create a server from a template.", "No Server Template", 1);
                    return;
                }
                descriptor.template = t.getId();
                descriptor.parameterValues = new HashMap();
            }
            server = new ServerInstance(this, id, descriptor);
            try {
                this.insertServer(server, true);
            }
            catch (UpdateFailedException e) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        root.setSelectedNode(server);
    }

    static {
        $assertionsDisabled = !Node.class.desiredAssertionStatus();
    }

    static class Backup {
        Utils.Resolver resolver;
        List backupList;
        List servers;

        Backup() {
        }
    }
}

