/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.AdapterAlreadyActiveException;
import Ice.AdapterNotFoundException;
import Ice.AlreadyRegisteredException;
import Ice.BooleanHolder;
import Ice.Communicator;
import Ice.ConnectionI;
import Ice.Current;
import Ice.EndpointParseException;
import Ice.Identity;
import Ice.IllegalIdentityException;
import Ice.InvalidReplicaGroupIdException;
import Ice.LocalException;
import Ice.LocalObject;
import Ice.LocalObjectImpl;
import Ice.LocatorPrx;
import Ice.LocatorPrxHelper;
import Ice.LocatorRegistryPrx;
import Ice.NotRegisteredException;
import Ice.Object;
import Ice.ObjectAdapter;
import Ice.ObjectAdapterDeactivatedException;
import Ice.ObjectAdapterIdInUseException;
import Ice.ObjectPrx;
import Ice.ObjectPrxHelperBase;
import Ice.ProcessPrxHelper;
import Ice.RouterPrx;
import Ice.RouterPrxHelper;
import Ice.ServantLocator;
import Ice.ServerNotFoundException;
import Ice.Util;
import Ice._ProcessDisp;
import IceInternal.EndpointI;
import IceInternal.IncomingConnectionFactory;
import IceInternal.IndirectReference;
import IceInternal.Instance;
import IceInternal.LocatorInfo;
import IceInternal.ObjectAdapterFactory;
import IceInternal.OutgoingConnectionFactory;
import IceInternal.Reference;
import IceInternal.RouterInfo;
import IceInternal.ServantManager;
import IceInternal.ThreadPool;
import IceInternal.TraceLevels;
import IceUtil.Assert;
import IceUtil.StringUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public final class ObjectAdapterI
extends LocalObjectImpl
implements ObjectAdapter {
    private boolean _deactivated = false;
    private Instance _instance;
    private Communicator _communicator;
    private ObjectAdapterFactory _objectAdapterFactory;
    private ThreadPool _threadPool;
    private ServantManager _servantManager;
    private boolean _activateOneOffDone;
    private final String _name;
    private final String _id;
    private final String _replicaGroupId;
    private ArrayList _incomingConnectionFactories = new ArrayList();
    private ArrayList _routerEndpoints = new ArrayList();
    private RouterInfo _routerInfo = null;
    private ArrayList _publishedEndpoints = new ArrayList();
    private LocatorInfo _locatorInfo;
    private int _directCount;
    private boolean _waitForActivate;
    private boolean _waitForDeactivate;
    static final /* synthetic */ boolean $assertionsDisabled;

    public String getName() {
        return this._name;
    }

    public synchronized Communicator getCommunicator() {
        this.checkForDeactivation();
        return this._communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activate() {
        LocalObject properties;
        LocatorInfo locatorInfo = null;
        boolean registerProcess = false;
        boolean printAdapterReady = false;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            this.checkForDeactivation();
            if (this._activateOneOffDone) {
                int sz = this._incomingConnectionFactories.size();
                for (int i = 0; i < sz; ++i) {
                    IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
                    factory.activate();
                }
                return;
            }
            this._waitForActivate = true;
            locatorInfo = this._locatorInfo;
            properties = this._instance.initializationData().properties;
            registerProcess = properties.getPropertyAsInt(this._name + ".RegisterProcess") > 0;
            printAdapterReady = properties.getPropertyAsInt("Ice.PrintAdapterReady") > 0;
        }
        try {
            Identity dummy = new Identity();
            dummy.name = "dummy";
            this.updateLocatorRegistry(locatorInfo, this.createDirectProxy(dummy), registerProcess);
        }
        catch (LocalException ex) {
            properties = this;
            synchronized (properties) {
                this._waitForActivate = false;
                this.notifyAll();
            }
            throw ex;
        }
        if (printAdapterReady) {
            System.out.println(this._name + " ready");
        }
        objectAdapterI = this;
        synchronized (objectAdapterI) {
            if (!$assertionsDisabled && this._deactivated) {
                throw new AssertionError();
            }
            this._waitForActivate = false;
            this.notifyAll();
            this._activateOneOffDone = true;
            int sz = this._incomingConnectionFactories.size();
            for (int i = 0; i < sz; ++i) {
                IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
                factory.activate();
            }
        }
    }

    public synchronized void hold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.hold();
        }
    }

    public synchronized void waitForHold() {
        this.checkForDeactivation();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            factory.waitUntilHolding();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deactivate() {
        LocatorInfo locatorInfo;
        OutgoingConnectionFactory outgoingConnectionFactory;
        ArrayList incomingConnectionFactories;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            if (this._deactivated) {
                return;
            }
            while (this._waitForActivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (this._routerInfo != null) {
                this._instance.routerManager().erase(this._routerInfo.getRouter());
                this._routerInfo.setAdapter(null);
            }
            incomingConnectionFactories = new ArrayList(this._incomingConnectionFactories);
            outgoingConnectionFactory = this._instance.outgoingConnectionFactory();
            locatorInfo = this._locatorInfo;
            this._deactivated = true;
            this.notifyAll();
        }
        try {
            this.updateLocatorRegistry(locatorInfo, null, false);
        }
        catch (LocalException ex) {
            // empty catch block
        }
        int sz = incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)incomingConnectionFactories.get(i);
            factory.destroy();
        }
        outgoingConnectionFactory.removeAdapter(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForDeactivate() {
        ObjectAdapterFactory objectAdapterFactory;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            while (!this._deactivated || this._directCount > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            while (this._waitForDeactivate) {
                try {
                    this.wait();
                }
                catch (InterruptedException ex) {}
            }
            this._waitForDeactivate = true;
        }
        if (this._incomingConnectionFactories != null) {
            int sz = this._incomingConnectionFactories.size();
            for (int i = 0; i < sz; ++i) {
                IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
                factory.waitUntilFinished();
            }
        }
        if (this._instance != null) {
            this._servantManager.destroy();
        }
        if (this._threadPool != null) {
            this._threadPool.destroy();
            this._threadPool.joinWithAllThreads();
        }
        ObjectAdapterI objectAdapterI2 = this;
        synchronized (objectAdapterI2) {
            this._waitForDeactivate = false;
            this.notifyAll();
            this._incomingConnectionFactories = null;
            this._instance = null;
            this._threadPool = null;
            this._communicator = null;
            this._routerEndpoints = null;
            this._routerInfo = null;
            this._publishedEndpoints = null;
            this._locatorInfo = null;
            objectAdapterFactory = this._objectAdapterFactory;
            this._objectAdapterFactory = null;
        }
        if (objectAdapterFactory != null) {
            objectAdapterFactory.removeObjectAdapter(this._name);
        }
    }

    public ObjectPrx add(Object object, Identity ident) {
        return this.addFacet(object, ident, "");
    }

    public synchronized ObjectPrx addFacet(Object object, Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        Identity id = new Identity();
        id.category = ident.category;
        id.name = ident.name;
        this._servantManager.addServant(object, id, facet);
        return this.newProxy(id, facet);
    }

    public ObjectPrx addWithUUID(Object object) {
        return this.addFacetWithUUID(object, "");
    }

    public ObjectPrx addFacetWithUUID(Object object, String facet) {
        Identity ident = new Identity();
        ident.category = "";
        ident.name = Util.generateUUID();
        return this.addFacet(object, ident, facet);
    }

    public Object remove(Identity ident) {
        return this.removeFacet(ident, "");
    }

    public synchronized Object removeFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeServant(ident, facet);
    }

    public synchronized Map removeAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.removeAllFacets(ident);
    }

    public Object find(Identity ident) {
        return this.findFacet(ident, "");
    }

    public synchronized Object findFacet(Identity ident, String facet) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findServant(ident, facet);
    }

    public synchronized Map findAllFacets(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this._servantManager.findAllFacets(ident);
    }

    public synchronized Object findByProxy(ObjectPrx proxy) {
        this.checkForDeactivation();
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        return this.findFacet(ref.getIdentity(), ref.getFacet());
    }

    public synchronized void addServantLocator(ServantLocator locator, String prefix) {
        this.checkForDeactivation();
        this._servantManager.addServantLocator(locator, prefix);
    }

    public synchronized ServantLocator findServantLocator(String prefix) {
        this.checkForDeactivation();
        return this._servantManager.findServantLocator(prefix);
    }

    public synchronized ObjectPrx createProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newProxy(ident, "");
    }

    public synchronized ObjectPrx createDirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newDirectProxy(ident, "");
    }

    public synchronized ObjectPrx createIndirectProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        return this.newIndirectProxy(ident, "", this._id);
    }

    public synchronized ObjectPrx createReverseProxy(Identity ident) {
        this.checkForDeactivation();
        ObjectAdapterI.checkIdentity(ident);
        LinkedList<ConnectionI> connections = new LinkedList<ConnectionI>();
        int sz = this._incomingConnectionFactories.size();
        for (int i = 0; i < sz; ++i) {
            IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
            ConnectionI[] conns = factory.connections();
            for (int j = 0; j < conns.length; ++j) {
                connections.add(conns[j]);
            }
        }
        EndpointI[] endpoints = new EndpointI[]{};
        ConnectionI[] arr = new ConnectionI[connections.size()];
        connections.toArray(arr);
        Reference ref = this._instance.referenceFactory().create(ident, this._instance.getDefaultContext(), "", 0, arr);
        return this._instance.proxyFactory().referenceToProxy(ref);
    }

    public synchronized void setLocator(LocatorPrx locator) {
        this.checkForDeactivation();
        this._locatorInfo = this._instance.locatorManager().get(locator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLocal(ObjectPrx proxy) {
        EndpointI[] endpoints;
        Reference ref = ((ObjectPrxHelperBase)proxy).__reference();
        try {
            IndirectReference ir = (IndirectReference)ref;
            if (ir.getAdapterId().length() != 0) {
                return ir.getAdapterId().equals(this._id);
            }
            LocatorInfo info = ir.getLocatorInfo();
            if (info == null) {
                return false;
            }
            endpoints = info.getEndpoints(ir, ir.getLocatorCacheTimeout(), new BooleanHolder());
        }
        catch (ClassCastException e) {
            endpoints = ref.getEndpoints();
        }
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            int i;
            this.checkForDeactivation();
            for (i = 0; i < endpoints.length; ++i) {
                int sz = this._incomingConnectionFactories.size();
                for (int j = 0; j < sz; ++j) {
                    IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(j);
                    if (!factory.equivalent(endpoints[i])) continue;
                    return true;
                }
            }
            if (this._routerInfo != null && this._routerInfo.getRouter().equals(proxy.ice_getRouter())) {
                for (i = 0; i < endpoints.length; ++i) {
                    if (Collections.binarySearch(this._routerEndpoints, endpoints[i]) < 0) continue;
                    return true;
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBatchRequests() {
        ArrayList f;
        ObjectAdapterI objectAdapterI = this;
        synchronized (objectAdapterI) {
            f = new ArrayList(this._incomingConnectionFactories);
        }
        Iterator i = f.iterator();
        while (i.hasNext()) {
            ((IncomingConnectionFactory)i.next()).flushBatchRequests();
        }
    }

    public synchronized void incDirectCount() {
        this.checkForDeactivation();
        if (!$assertionsDisabled && this._directCount < 0) {
            throw new AssertionError();
        }
        ++this._directCount;
    }

    public synchronized void decDirectCount() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (!$assertionsDisabled && this._directCount <= 0) {
            throw new AssertionError();
        }
        if (--this._directCount == 0) {
            this.notifyAll();
        }
    }

    public ThreadPool getThreadPool() {
        if (!$assertionsDisabled && this._instance == null) {
            throw new AssertionError();
        }
        if (this._threadPool != null) {
            return this._threadPool;
        }
        return this._instance.serverThreadPool();
    }

    public ServantManager getServantManager() {
        return this._servantManager;
    }

    public ObjectAdapterI(Instance instance, Communicator communicator, ObjectAdapterFactory objectAdapterFactory, String name, String endpointInfo, RouterPrx router) {
        this._instance = instance;
        this._communicator = communicator;
        this._objectAdapterFactory = objectAdapterFactory;
        this._servantManager = new ServantManager(instance, name);
        this._activateOneOffDone = false;
        this._name = name;
        this._id = instance.initializationData().properties.getProperty(name + ".AdapterId");
        this._replicaGroupId = instance.initializationData().properties.getProperty(name + ".ReplicaGroupId");
        this._directCount = 0;
        this._waitForActivate = false;
        this._waitForDeactivate = false;
        try {
            String locator;
            String routerStr;
            if (router == null && (routerStr = this._instance.initializationData().properties.getProperty(name + ".Router")).length() > 0) {
                router = RouterPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy(routerStr));
            }
            if (router != null) {
                this._routerInfo = this._instance.routerManager().get(router);
                if (this._routerInfo != null) {
                    int i;
                    if (this._routerInfo.getAdapter() != null) {
                        throw new AlreadyRegisteredException("object adapter with router", this._instance.identityToString(router.ice_getIdentity()));
                    }
                    ObjectPrxHelperBase proxy = (ObjectPrxHelperBase)this._routerInfo.getServerProxy();
                    EndpointI[] endpoints = proxy.__reference().getEndpoints();
                    for (i = 0; i < endpoints.length; ++i) {
                        this._routerEndpoints.add(endpoints[i]);
                    }
                    Collections.sort(this._routerEndpoints);
                    i = 0;
                    while (i < this._routerEndpoints.size() - 1) {
                        java.lang.Object o2;
                        java.lang.Object o1 = this._routerEndpoints.get(i);
                        if (o1.equals(o2 = this._routerEndpoints.get(i + 1))) {
                            this._routerEndpoints.remove(i);
                            continue;
                        }
                        ++i;
                    }
                    this._routerInfo.setAdapter(this);
                    this._instance.outgoingConnectionFactory().setRouterInfo(this._routerInfo);
                }
            } else {
                ArrayList endpoints = this.parseEndpoints(endpointInfo);
                for (int i = 0; i < endpoints.size(); ++i) {
                    EndpointI endp = (EndpointI)endpoints.get(i);
                    this._incomingConnectionFactories.add(new IncomingConnectionFactory(instance, endp, this, this._name));
                }
                if (endpoints.size() == 0) {
                    TraceLevels tl = this._instance.traceLevels();
                    if (tl.network >= 2) {
                        this._instance.initializationData().logger.trace(tl.networkCat, "created adapter `" + name + "' without endpoints");
                    }
                }
                String endpts = this._instance.initializationData().properties.getProperty(name + ".PublishedEndpoints");
                this._publishedEndpoints = this.parseEndpoints(endpts);
                if (this._publishedEndpoints.size() == 0) {
                    for (int i = 0; i < this._incomingConnectionFactories.size(); ++i) {
                        IncomingConnectionFactory factory = (IncomingConnectionFactory)this._incomingConnectionFactories.get(i);
                        this._publishedEndpoints.add(factory.endpoint());
                    }
                }
                Iterator p = this._publishedEndpoints.iterator();
                while (p.hasNext()) {
                    EndpointI endpoint = (EndpointI)p.next();
                    if (endpoint.publish()) continue;
                    p.remove();
                }
            }
            if ((locator = this._instance.initializationData().properties.getProperty(name + ".Locator")).length() > 0) {
                this.setLocator(LocatorPrxHelper.uncheckedCast(this._instance.proxyFactory().stringToProxy(locator)));
            } else {
                this.setLocator(this._instance.referenceFactory().getDefaultLocator());
            }
            if (!this._instance.threadPerConnection()) {
                int size = this._instance.initializationData().properties.getPropertyAsInt(this._name + ".ThreadPool.Size");
                int sizeMax = this._instance.initializationData().properties.getPropertyAsInt(this._name + ".ThreadPool.SizeMax");
                if (size > 0 || sizeMax > 0) {
                    this._threadPool = new ThreadPool(this._instance, this._name + ".ThreadPool", 0);
                }
            }
        }
        catch (LocalException ex) {
            this.deactivate();
            this.waitForDeactivate();
            throw ex;
        }
    }

    protected synchronized void finalize() throws Throwable {
        if (this._deactivated && this._instance == null) {
            Assert.FinalizerAssert(this._threadPool == null);
            Assert.FinalizerAssert(this._communicator == null);
            Assert.FinalizerAssert(this._incomingConnectionFactories == null);
            Assert.FinalizerAssert(this._directCount == 0);
            Assert.FinalizerAssert(!this._waitForActivate);
            Assert.FinalizerAssert(!this._waitForDeactivate);
        }
        super.finalize();
    }

    private ObjectPrx newProxy(Identity ident, String facet) {
        if (this._id.length() == 0) {
            return this.newDirectProxy(ident, facet);
        }
        if (this._replicaGroupId.length() == 0) {
            return this.newIndirectProxy(ident, facet, this._id);
        }
        return this.newIndirectProxy(ident, facet, this._replicaGroupId);
    }

    private ObjectPrx newDirectProxy(Identity ident, String facet) {
        int sz = this._publishedEndpoints.size();
        EndpointI[] endpoints = new EndpointI[sz + this._routerEndpoints.size()];
        this._publishedEndpoints.toArray(endpoints);
        for (int i = 0; i < this._routerEndpoints.size(); ++i) {
            endpoints[sz + i] = (EndpointI)this._routerEndpoints.get(i);
        }
        ConnectionI[] connections = new ConnectionI[]{};
        Reference reference = this._instance.referenceFactory().create(ident, new HashMap(), facet, 0, false, endpoints, null, this._instance.defaultsAndOverrides().defaultCollocationOptimization);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private ObjectPrx newIndirectProxy(Identity ident, String facet, String id) {
        EndpointI[] endpoints = new EndpointI[]{};
        ConnectionI[] connections = new ConnectionI[]{};
        Reference reference = this._instance.referenceFactory().create(ident, new HashMap(), facet, 0, false, id, null, this._locatorInfo, this._instance.defaultsAndOverrides().defaultCollocationOptimization, this._instance.defaultsAndOverrides().defaultLocatorCacheTimeout);
        return this._instance.proxyFactory().referenceToProxy(reference);
    }

    private void checkForDeactivation() {
        if (this._deactivated) {
            ObjectAdapterDeactivatedException ex = new ObjectAdapterDeactivatedException();
            ex.name = this._name;
            throw ex;
        }
    }

    private static void checkIdentity(Identity ident) {
        if (ident.name == null || ident.name.length() == 0) {
            IllegalIdentityException e = new IllegalIdentityException();
            e.id = (Identity)ident.clone();
            throw e;
        }
        if (ident.category == null) {
            ident.category = "";
        }
    }

    private ArrayList parseEndpoints(String endpts) {
        int beg;
        endpts = endpts.toLowerCase();
        int end = 0;
        String delim = " \t\n\r";
        ArrayList endpoints = new ArrayList();
        while (end < endpts.length() && (beg = StringUtil.findFirstNotOf(endpts, " \t\n\r", end)) != -1) {
            end = endpts.indexOf(58, beg);
            if (end == -1) {
                end = endpts.length();
            }
            if (end == beg) {
                ++end;
                continue;
            }
            String s = endpts.substring(beg, end);
            EndpointI endp = this._instance.endpointFactoryManager().create(s);
            if (endp == null) {
                EndpointParseException e = new EndpointParseException();
                e.str = s;
                throw e;
            }
            ArrayList endps = endp.expand(true);
            endpoints.addAll(endps);
            ++end;
        }
        return endpoints;
    }

    private void updateLocatorRegistry(LocatorInfo locatorInfo, ObjectPrx proxy, boolean registerProcess) {
        if (!registerProcess && this._id.length() == 0) {
            return;
        }
        LocatorRegistryPrx locatorRegistry = locatorInfo != null ? locatorInfo.getLocatorRegistry() : null;
        String serverId = "";
        if (registerProcess) {
            if (!$assertionsDisabled && this._instance == null) {
                throw new AssertionError();
            }
            serverId = this._instance.initializationData().properties.getProperty("Ice.ServerId");
            if (locatorRegistry == null) {
                this._instance.initializationData().logger.warning("object adapter `" + this._name + "' cannot register the process without a locator registry");
            } else if (serverId.length() == 0) {
                this._instance.initializationData().logger.warning("object adapter `" + this._name + "' cannot register the process without a value for Ice.ServerId");
            }
        }
        if (locatorRegistry == null) {
            return;
        }
        if (this._id.length() > 0) {
            try {
                if (this._replicaGroupId.length() == 0) {
                    locatorRegistry.setAdapterDirectProxy(this._id, proxy);
                } else {
                    locatorRegistry.setReplicatedAdapterDirectProxy(this._id, this._replicaGroupId, proxy);
                }
            }
            catch (AdapterNotFoundException ex) {
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.kindOfObject = "object adapter";
                ex1.id = this._id;
                throw ex1;
            }
            catch (InvalidReplicaGroupIdException ex) {
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.kindOfObject = "replica group";
                ex1.id = this._replicaGroupId;
                throw ex1;
            }
            catch (AdapterAlreadyActiveException ex) {
                ObjectAdapterIdInUseException ex1 = new ObjectAdapterIdInUseException();
                ex1.id = this._id;
                throw ex1;
            }
        }
        if (registerProcess && serverId.length() > 0) {
            try {
                ProcessI servant = new ProcessI(this._communicator);
                ObjectPrx process = this.createDirectProxy(this.addWithUUID(servant).ice_getIdentity());
                locatorRegistry.setServerProcessProxy(serverId, ProcessPrxHelper.uncheckedCast(process));
            }
            catch (ServerNotFoundException ex) {
                NotRegisteredException ex1 = new NotRegisteredException();
                ex1.id = serverId;
                ex1.kindOfObject = "server";
                throw ex1;
            }
        }
    }

    static {
        $assertionsDisabled = !ObjectAdapterI.class.desiredAssertionStatus();
    }

    private static class ProcessI
    extends _ProcessDisp {
        private Communicator _communicator;

        ProcessI(Communicator communicator) {
            this._communicator = communicator;
        }

        public void shutdown(Current current) {
            this._communicator.shutdown();
        }

        public void writeMessage(String message, int fd, Current current) {
            switch (fd) {
                case 1: {
                    System.out.println(message);
                    break;
                }
                case 2: {
                    System.err.println(message);
                }
            }
        }
    }
}

