#!/usr/bin/python


try:
  import os, sys
  if os.path.exists('/usr/lib/woody'):
    sys.path.append('/usr/lib/woody')
  from woody_defs import *
  import woody_tree
except IOError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)
except ImportError, msg:
  print "%s: Fatal Error loading program modules: %s" % (__name__, msg)
  sys.exit(1)

import xmllib


# Stinkin' global variables!  Ick!
# (used to keep a bit of state between xml callbacks)
wood = None
parent = None

callback = None
save_filename = ""
save_current = 0
save_total = 0

######################################################################
# Conversion helper functions...
# (works better than "float(variable)")
######################################################################

############################################################
#
#
def to_bool(str, default=None):
  if str == "yes"  or  str == "true":
    str = 1
  elif str == "no"  or  str == "false":
    str = None
  elif type(str) != type(1):
    try:
      str = int(str)
      if str == 0:
        str = None
    except:
      str = default
  return str

############################################################
#
#
def to_int(str, default=0):
  if str == "yes"  or  str == "true":
    str = 1
  elif str == "no"  or  str == "false":
    str = 0
  elif type(str) != type(1):
    try:
      str = int(str)
    except:
      str = default
  return str

############################################################
#
#
def to_float(str, default=0.0):
  if str == "yes"  or  str == "true":
    str = 1.0
  elif str == "no"  or  str == "false":
    str = 0.0
  elif type(str) != type(1.0):
    try:
      str = float(str)
    except:
      str = default
  return str

######################################################################
# XML Callback functions...
######################################################################

############################################################
#
#
def Options_start(args):
  global wood, parent
  #print "Options(%s)" % (args)

  if args.has_key("only_first_line"):
    wood.options.only_first_line = to_int(args["only_first_line"], 0)

  if args.has_key("show_notes"):
    wood.options.show_notes = to_int(args["show_notes"])

  if args.has_key("show_due_dates"):
    wood.options.show_due_dates = to_int(args["show_due_dates"])

  if args.has_key("show_priorities"):
    wood.options.show_priorities = to_int(args["show_priorities"])

  if args.has_key("show_todo"):
    wood.options.show_todo = to_int(args["show_todo"], 1)

  if args.has_key("show_numbering"):
    wood.options.show_numbering = to_int(args["show_numbering"])

  if args.has_key("show_done_items"):
    wood.options.show_done_items = to_int(args["show_done_items"], 1)

  if args.has_key("new_items"):
    foo = args["new_items"]
    if foo not in ["normal", "todo", "progress"]:
      foo = "normal"
    wood.options.new_items = foo

  if args.has_key("autocollapse"):
    wood.options.autocollapse = to_int(args["autocollapse"], 0)

  if args.has_key("BF_tree_type"):
    foo = args["BF_tree_type"]
    if foo not in ["normal", "project"]:
      foo = "normal"
    wood.options.BF_tree_type = foo


############################################################
#
#
def Outline_start(args):
  #print "Outline_start(%s)" % (args)

  title = "<Untitled>"
  if args.has_key("title"):
    title = args["title"]

  wood.children.text = title

  if args.has_key("edit_count"):
    wood.edit_count = to_int(args["edit_count"])
    
  
############################################################
#
#
def Outline_end():
  #print "Outline_end()"
  pass


############################################################
#
#
def Node_start(args):
  global wood, parent
  import string
  
  #print "Node_start(%s)" % (args)

  n = woody_tree.node()
  
  text = ""
  if args.has_key("title"):
    text = args["title"]
  n.text = text

  note = ""
  if args.has_key("note"):
    note = args["note"]
  n.note = note

  todo = None
  if args.has_key("todo"):
    todo = args["todo"]
    if todo == "yes"  or  todo == "true"  or  todo == "1":
      todo = "todo"
    elif todo == "no"  or  todo == "false"  or  todo == "0":
      todo = None
    elif todo == "percent"  or  todo == "project":
      todo = "progress"
  n.todo = todo

  done = 0
  if args.has_key("done"):
    done = args["done"]
    if done == "yes"  or  done == "true":
      done = 1
    elif done == "no"  or  done == "false":
      done = 0
    done = to_float(done)
  n.done = done

  if args.has_key("expanded"):
    n.expanded = to_int(args["expanded"])

  if args.has_key("priority"):
    n.priority = to_int(args["priority"])

  # TODO: implement sorting...
  #if args.has_key("autosort"):
  #  n.autosort = args["autosort"]

  if args.has_key("hidden"):
    n.hidden = to_int(args["hidden"])

  

  parent.extend(n)
  #print "parent(%s) becoming (%s)" % (parent.text, n.text)
  parent = n
  

############################################################
#
#
def Node_end():
  global wood, parent

  #print "Node_end()"

  if parent.parent:
    parent = parent.parent

############################################################
#
#
def syntax_error(msg):
  print "Syntax Error: %s" % msg

############################################################
# This handles compatability with Think's XML format
# (it puts notes outside of node tags)
def handle_data(data):
  global wood, parent

  foo = data

  if foo:
    while foo  and  foo[-1] in [" ", "\n", "\t"]:
      foo = foo[:-1]

    if foo:
      #print "Note (%s): %s" % (parent.text, foo)
      if parent.note:
        parent.note = parent.note + data
      else:
        parent.note = data

######################################################################
#
######################################################################

############################################################
#
#
def xml_save(wood, file):
  # stuff to save, in order:
  # - xml header
  # - outline tag
  # - options tag
  # - nodes
  # - outline close tag

  global save_current, save_total
  save_current = 0

  
  file.write('<?xml version="1.0"?>\n')

  # TODO: save creation and mod dates, too...
  wood.edit_count = wood.edit_count + 1
  num_nodes = wood.len()
  save_total = num_nodes
  str = '<Outline title="%s" edit_count="%s" num_nodes="%s" '\
        'creator="%s">\n' % \
        (xml_escape(wood.children.text),
         xml_escape(wood.edit_count),
         num_nodes,
         xml_escape("%s %s" % (program_name, version)))
  file.write(str)
  
  str = '  <Options only_first_line="%s" show_notes="%s" show_due_dates="%s" '\
        'show_priorities="%s" show_todo="%s" show_numbering="%s" '\
        'show_done_items="%s" new_items="%s" autocollapse="%s" '\
        'BF_tree_type="%s"/>\n' % \
        (wood.options.only_first_line, wood.options.show_notes,
         wood.options.show_due_dates, wood.options.show_priorities,
         wood.options.show_todo, wood.options.show_numbering,
         wood.options.show_done_items, wood.options.new_items,
         wood.options.autocollapse, wood.options.BF_tree_type)
  file.write(str)

  # TODO: save the nodes...
  write_node(wood.children, file, 0)
  
  str = '</Outline>\n'
  file.write(str)


############################################################
#
#
def node_to_str(branch):
  str = ''
  
  str = str + '<Node '
  if branch.text: str = str + 'title="%s" ' % xml_escape(branch.text)
  if branch.note: str = str + 'note="%s" ' % xml_escape(branch.note)
  if branch.todo: str = str + 'todo="%s" ' % xml_escape(branch.todo)
  if branch.done: str = str + 'done="%s" ' % branch.done
  str = str + 'expanded="%s" ' % branch.expanded
  if branch.priority: str = str + 'priority="%s" ' % branch.priority
  if branch.autosort: str = str + 'autosort="%s" ' % xml_escape(branch.autosort)
  if branch.hidden: str = str + 'hidden="%s" ' % branch.hidden

  while str[-1] == " ":
    str = str[:-1]

  if branch.children:
    str = str + '>\n'
  else:
    str = str + '/>\n'

  return str

############################################################
#
#
def write_node(branch, file, depth):
  global callback, save_filename, save_current, save_total

  if depth == 0:
    for child in branch.children:
      write_node(child, file, depth+1)
    return

  str = '  ' * depth
  if branch.children:
    str = str + node_to_str(branch)
    file.write(str)
    callback("file save", (save_filename, save_current, save_total))
    save_current = save_current + 1

    for child in branch.children:
      write_node(child, file, depth+1)
    str = '  ' * depth
    str = str + '</Node>\n'
    file.write(str)
  else:
    str = str + node_to_str(branch)
    file.write(str)
    callback("file save", (save_filename, save_current, save_total))
    save_current = save_current + 1


############################################################
#
#
def xml_escape(str):
  import string
  if str:
    if type(str) == type("a"):
      str = string.replace(str, '&', "&amp;")
      str = string.replace(str, "<", "&lt;")
      str = string.replace(str, ">", "&gt;")
      str = string.replace(str, '"', "&quot;")
      str = string.replace(str, "'", "&apos;")
      #str = string.replace(str, "\\", "&back;")
      str = string.replace(str, "\n", "&nl;")
    return str
  else:
    return ""


######################################################################
# The main, important functions
# (ones which should be called from other modules...)
# (I suppose I should put "_"'s on the others, but I haven't yet)
######################################################################

############################################################
#
#
def load(cfg, filename, callback=None):
  global wood
  global parent
  
  xml = xmllib.XMLParser()
  xml.elements = {
    "Options" : (Options_start, None),
    "Outline" : (Outline_start, Outline_end),
    "Node" : (Node_start, Node_end),
    }
  xml.entitydefs["nl"] = "&#10;"
  xml.syntax_error = syntax_error
  xml.handle_data = handle_data

  wood = woody_tree.tree(cfg=cfg, filename=filename)
  parent = wood.children
  wood.callback = callback

  try:
    if len(filename) > 3  and  filename[-3:] == ".gz":
      import gzip
      file = gzip.open(filename, "rb")
    else:
      file = open(filename, "rb")
    lines = file.readlines()
    i = 0
    total = len(lines)
    for line in lines:
      xml.feed(line)
      i = i + 1
      if callback:
        callback("file load", (filename, i, total))
  except IOError, msg:
    print "Cannot open file %s: %s" % (filename, msg)
    
  return wood


############################################################
#
#
def save(wood, filename=None, cb=None):
  global save_filename
  
  err = 0

  if filename:
    wood.filename = filename
  else:
    filename = wood.filename

  save_filename = filename

  cb("file save", (filename, 0, 1))
  # Make a backup file first..
  try:
    file = open(filename, "r")
    if file:
      file.close()
      # Now rename the file...
      import os
      os.rename(filename, filename + "~")
  except:
    pass

  try:
    global callback
    callback = cb
    if len(filename) > 3  and  filename[-3:] == ".gz":
      import gzip
      file = gzip.open(filename, "wb")
    else:
      file = open(filename, "wb")
    xml_save(wood, file)
    file.close()
    cb("file save", (filename, 1, 1))
  except IOError, msg:
    print "Cannot save %s: IOError: %s" % (filename, msg)
    err = -1

  return err

