/**************************************************************************
* This file is part of the WebIssues program
* Copyright (C) 2006 Michał Męciński
* Copyright (C) 2007-2008 WebIssues Team
*
* This program is free software; you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation; either version 2 of the License, or
* (at your option) any later version.
**************************************************************************/

#include "loginbatch.h"

#include "commands/command.h"
#include "connectioninfo.h"

using namespace WebIssues;

LoginBatch::LoginBatch( const QString& login, const QString& password ) : AbstractBatch( 127 ),
    m_userId( 0 ),
    m_access( NoAccess )
{
    Job job1( &LoginBatch::helloJob );
    m_queue.addJob( job1 );

    Job job2( &LoginBatch::loginJob );
    job2.addArg( login );
    job2.addArg( password );
    m_queue.addJob( job2 );
}

LoginBatch::~LoginBatch()
{
}

ConnectionInfo* LoginBatch::connectionInfo()
{
    if ( m_userId != 0 )
        return new ConnectionInfo( m_serverName, m_serverUuid, m_userId, m_access );
    return NULL;
}

Command* LoginBatch::fetchNext()
{
    if ( m_queue.moreJobs() )
        return m_queue.callJob( this );

    return NULL;
}

Command* LoginBatch::helloJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "HELLO" );

    command->addRule( "SERVER ss", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( helloReply( const Reply& ) ) );

    return command;
}

Command* LoginBatch::loginJob( const Job& job )
{
    Command* command = new Command();

    command->setKeyword( "LOGIN" );
    command->addArg( job.argString( 0 ) );
    command->addArg( job.argString( 1 ) );

    command->addRule( "USER ii", ReplyRule::One );

    connect( command, SIGNAL( commandReply( const Reply& ) ), this, SLOT( loginReply( const Reply& ) ) );

    return command;
}

void LoginBatch::helloReply( const Reply& reply )
{
    ReplyLine line = reply.lines().at( 0 );

    m_serverName = line.argString( 0 );
    m_serverUuid = line.argString( 1 );
}

void LoginBatch::loginReply( const Reply& reply )
{
    ReplyLine line = reply.lines().at( 0 );

    m_userId = line.argInt( 0 );
    m_access = (Access)line.argInt( 1 );
}
