var webdeveloper_userStyleSheet = null;

// Adds a user style sheet to the page
function webdeveloper_addUserStyleSheet(element)
{
    var addStyleSheet = webdeveloper_convertToBoolean(element.getAttribute("checked"));

    // If adding a style sheet
    if(addStyleSheet)
    {
        var filePicker   = Components.classes["@mozilla.org/filepicker;1"].createInstance(Components.interfaces.nsIFilePicker);
        var stringBundle = document.getElementById("webdeveloper-string-bundle");

        filePicker.appendFilter(stringBundle.getString("webdeveloper_styleSheetDescription"), "*.css");
        filePicker.init(window, stringBundle.getString("webdeveloper_addUserStyleSheet"), filePicker.modeOpen);

        // If the user selected a style sheet
        if(filePicker.show() == filePicker.returnOK)
        {
            var inputStream      = Components.classes["@mozilla.org/network/file-input-stream;1"].createInstance(Components.interfaces.nsIFileInputStream);
            var scriptableStream = Components.classes["@mozilla.org/scriptableinputstream;1"].createInstance(Components.interfaces.nsIScriptableInputStream);

            inputStream.init(filePicker.file, 0x01, 0444, null);
            scriptableStream.init(inputStream);

            webdeveloper_userStyleSheet = scriptableStream.read(scriptableStream.available());

            scriptableStream.close();
            inputStream.close();
        }
        else
        {
            addStyleSheet               = false;
            webdeveloper_userStyleSheet = null;
        }
    }

    // If adding a style sheet and the style sheet is not empty
    if(addStyleSheet && webdeveloper_userStyleSheet)
    {
        var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
        var documentLength = documentList.length;
        var pageDocument   = null;
        var styleElement   = null;

        // Loop through the documents
        for(var i = 0; i < documentLength; i++)
        {
            pageDocument = documentList[i];
            styleElement = pageDocument.createElement("style");

            styleElement.setAttribute("id", "webdeveloper-add-user-style-sheet");
            styleElement.setAttribute("type", "text/css");
            styleElement.appendChild(pageDocument.createTextNode(webdeveloper_userStyleSheet));

            webdeveloper_getDocumentHeadElement(pageDocument).appendChild(styleElement);
        }

        webdeveloper_addAppliedStyle("webdeveloper-add-user-style-sheet");
    }
    else
    {
        webdeveloper_userStyleSheet = null;
        webdeveloper_removeStyleSheet("webdeveloper-add-user-style-sheet", true);
    }
}

// Display CSS for the given media type
function webdeveloper_displayCSSMediaType(type, reset)
{
    var documentList     = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength   = documentList.length;
    var media            = null;
    var pageDocument     = null;
    var styleSheet       = null;
    var styleSheetLength = null;
    var styleSheetList   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument     = documentList[i];
        styleSheetList   = pageDocument.styleSheets;
        styleSheetLength = styleSheetList.length;

        // Loop through the style sheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If the style sheet is valid and not an alternate style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet) && !webdeveloper_isAlternateStyleSheet(styleSheet))
            {
                media = styleSheet.media;

                // If resetting
                if(reset)
                {
                    // If the style sheet has the webdeveloper-appended-screen media
                    if(webdeveloper_isMediaStyleSheet(styleSheet, "webdeveloper-appended-screen"))
                    {
                        media.deleteMedium("webdeveloper-appended-screen");
                        media.deleteMedium("screen");
                    }
                    else if(webdeveloper_isMediaStyleSheet(styleSheet, "webdeveloper-deleted-screen"))
                    {
                        media.appendMedium("screen");
                        media.deleteMedium("webdeveloper-deleted-screen");
                    }
                }
                else
                {
                    // If the style sheet matches this media
                    if(webdeveloper_isMediaStyleSheet(styleSheet, type))
                    {
                        // If the style sheet has the screen media
                        if(!webdeveloper_isMediaStyleSheet(styleSheet, "screen"))
                        {
                            media.appendMedium("webdeveloper-appended-screen");
                            media.appendMedium("screen");
                        }
                    }
                    else if(webdeveloper_isMediaStyleSheet(styleSheet, "screen"))
                    {
                        // If the media length is not 0
                        if(media.length != 0)
                        {
                            media.deleteMedium("screen");
                        }

                        media.appendMedium("webdeveloper-deleted-screen");
                    }
                }

                // Force the styles to reapply by disabling and enabling the style sheet
                styleSheet.disabled = true;
                styleSheet.disabled = false;
            }
        }
    }
}

// Display the disable individual style sheet menu
function webdeveloper_displayDisableIndividualStyleSheetMenu(menu)
{
    var currentDocument  = webdeveloper_getContentDocument();
    var mediaList        = null;
    var menuItem         = null;
    var ownerNode        = null;
    var styleSheet       = null;
    var styleSheetHref   = null;
    var styleSheetLabel  = null;
    var styleSheetList   = currentDocument.styleSheets;
    var styleSheetLength = styleSheetList.length;

    webdeveloper_removeGeneratedMenuItems(menu);

    // Loop through the style sheets
    for(var i = 0; i < styleSheetLength; i++)
    {
        styleSheet     = styleSheetList[i];
        ownerNode      = styleSheet.ownerNode;
        styleSheetHref = styleSheet.href;

        // If this is a valid style sheet, is not an line style sheet and is not an alternate style sheet
        if(webdeveloper_isValidStyleSheet(styleSheet) && styleSheetHref != currentDocument.documentURI)
        {
            menuItem = document.createElement("menuitem");

            // If the owner node is set, is not a processing instruction and has a title attribute
            if(ownerNode && ownerNode.nodeType != Components.interfaces.nsIDOMNode.PROCESSING_INSTRUCTION_NODE && ownerNode.hasAttribute("title"))
            {
                styleSheetLabel = ownerNode.getAttribute("title");
            }
            else
            {
                styleSheetLabel = styleSheetHref;
            }

            menuItem.setAttribute("class", "webdeveloper-generated-menu");
            menuItem.setAttribute("label", styleSheetLabel);
            menuItem.setAttribute("oncommand", "webdeveloper_toggleIndividualStyleSheet('" + styleSheetHref + "')");
            menuItem.setAttribute("type", "checkbox");

            // If the style sheet is disabled
            if(!styleSheet.disabled)
            {
                menuItem.setAttribute("checked", true);
            }

            menu.appendChild(menuItem);
        }
    }

    // If the menu has no children
    if(!menu.hasChildNodes())
    {
        menuItem        = document.createElement("menuitem");
        styleSheetLabel = document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_noStyleSheets");

        menuItem.disabled = true;
        menuItem.setAttribute("class", "webdeveloper-generated-menu");
        menuItem.setAttribute("label", styleSheetLabel);
        menu.appendChild(menuItem);
    }
}

// Display CSS for the handheld media type
function webdeveloper_displayHandheldCSS(element)
{
    var printElement = document.getElementById("webdeveloper-display-print-css-menu");

    webdeveloper_configureElementByAppliedStyle(printElement, "checked", "webdeveloper-display-print-css");

    // If the print element is checked
    if(webdeveloper_convertToBoolean(printElement.getAttribute("checked")))
    {
        webdeveloper_displayCSSMediaType("print", true);
        webdeveloper_removeStyleSheet("webdeveloper-display-print-css");
    }

    webdeveloper_displayCSSMediaType("handheld", !webdeveloper_convertToBoolean(element.getAttribute("checked")));
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-display-handheld-css");
}

// Display CSS for the print media type
function webdeveloper_displayPrintCSS(element)
{
    var handheldElement = document.getElementById("webdeveloper-display-handheld-css-menu");

    webdeveloper_configureElementByAppliedStyle(handheldElement, "checked", "webdeveloper-display-handheld-css");

    // If the handheld element is checked
    if(webdeveloper_convertToBoolean(handheldElement.getAttribute("checked")))
    {
        webdeveloper_displayCSSMediaType("handheld", true);
        webdeveloper_removeStyleSheet("webdeveloper-display-handheld-css");
    }

    webdeveloper_displayCSSMediaType("print", !webdeveloper_convertToBoolean(element.getAttribute("checked")));
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-display-print-css");
}

// Allows the user to edit the CSS of the current page
function webdeveloper_editCSS()
{
    var stringBundle = document.getElementById("webdeveloper-string-bundle");
    var editCSS      = stringBundle.getString("webdeveloper_editCSS");

    // If edit CSS is open in the dashboard
    if(webdeveloper_isOpenInDashboard(editCSS))
    {
        webdeveloper_closeInDashboard(editCSS);
    }
    else if(webdeveloper_pageHasFrames())
    {
        window.openDialog("chrome://webdeveloper/content/message/message.xul", "webdeveloper-message-dialog", "centerscreen,chrome,modal", stringBundle.getString("webdeveloper_framesNotSupported"));
    }
    else
    {
        webdeveloper_openInDashboard(editCSS, "chrome://webdeveloper/content/dashboard/edit_css.xul");
    }
}

// Toggles the border box model
function webdeveloper_toggleBorderBoxModel(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/use_border_box_model.css", "webdeveloper-use-border-box-model");
}

// Toggles the browser default styles
function webdeveloper_toggleBrowserDefaultStyles(element)
{
    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/disable_browser_default_styles.css", "webdeveloper-disable-browser-default-styles");
}

// Toggles all the inline styles in elements in the document
function webdeveloper_toggleDocumentInlineStyles(node, disable)
{
    // If the node exists and is an element
    if(node && node.nodeType == Node.ELEMENT_NODE)
    {
        var childNodes       = node.childNodes;
        var childNodesLength = childNodes.length;

        // If disabling styles and the node has a style attribute
        if(disable && node.hasAttribute("style"))
        {
            node.setAttribute("webdeveloper-inline-style", node.getAttribute("style"));
            node.removeAttribute("style");
        }
        else if(!disable && node.hasAttribute("webdeveloper-inline-style"))
        {
            node.setAttribute("style", node.getAttribute("webdeveloper-inline-style"));
            node.removeAttribute("webdeveloper-inline-style");
        }

        // Loop through the child nodes
        for(var i = 0; i < childNodesLength; i++)
        {
            webdeveloper_toggleDocumentInlineStyles(childNodes[i], disable);
        }
    }
}

// Toggles all the embedded styles on the page
function webdeveloper_toggleEmbeddedStyles(element)
{
    var disable          = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    var documentList     = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength   = documentList.length;
    var pageDocument     = null;
    var styleSheetLength = null;
    var styleSheetList   = null;
    var styleSheet       = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument     = documentList[i];
        styleSheetList   = pageDocument.getElementsByTagName("style");
        styleSheetLength = styleSheetList.length;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j].sheet;

            // If this is a valid style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet))
            {
                styleSheet.disabled = disable;
            }
        }

    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-disable-embedded-styles");
}

// Toggles all the inline styles in elements on the page
function webdeveloper_toggleInlineStyles(element)
{
    var disable        = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    var documentList   = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength = documentList.length;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        webdeveloper_toggleDocumentInlineStyles(documentList[i].documentElement, disable);
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-disable-inline-styles");
}

// Toggles all the linked styles on the page
function webdeveloper_toggleLinkedStyles(element)
{
    var disable          = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    var documentList     = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength   = documentList.length;
    var ownerNode        = null;
    var pageDocument     = null;
    var styleSheet       = null;
    var styleSheetLength = null;
    var styleSheetList   = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument     = documentList[i];
        styleSheetList   = pageDocument.styleSheets;
        styleSheetLength = styleSheetList.length;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is a valid style sheet, is not an inline style sheet and is not an alternate style sheet or style sheets are being disabled
            if(webdeveloper_isValidStyleSheet(styleSheet) && styleSheet.href != pageDocument.documentURI && (!webdeveloper_isAlternateStyleSheet(styleSheet) || disable))
            {
                styleSheet.disabled = disable;
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-disable-linked-styles");
}

// Toggles the print styles for the page
function webdeveloper_togglePrintStyles(element)
{
    var disable         = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    var documentList    = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength  = documentList.length;
    var pageDocument    = null;
    var styleSheet      = null;
    var styleSheetLength = null;
    var styleSheetList  = null;

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument     = documentList[i];
        styleSheetList   = pageDocument.styleSheets;
        styleSheetLength = styleSheetList.length;

        // Loop through the style sheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If the style sheet is valid, is not an alternate style sheet and is a print style sheet, but not a screen style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet) && !webdeveloper_isAlternateStyleSheet(styleSheet) && webdeveloper_isMediaStyleSheet(styleSheet, "print") && !webdeveloper_isMediaStyleSheet(styleSheet, "screen"))
            {
                styleSheet.disabled = disable;
            }
        }
    }

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-disable-print-styles");
}

// Toggles the styles for the page
function webdeveloper_toggleStyles(element)
{
    var disable          = true;
    var contentWindow    = webdeveloper_getContentWindow();
    var documentList     = webdeveloper_getDocuments(contentWindow);
    var documentLength   = documentList.length;
    var key              = null;
    var ownerNode        = null;
    var pageDocument     = null;
    var styleElement     = null;
    var styleSheet       = null;
    var styleSheetLength = null;
    var styleSheetList   = null;

    // If the element is set
    if(element)
    {
        disable = webdeveloper_convertToBoolean(element.getAttribute("checked"));
    }
    else
    {
        var currentDocument = contentWindow.document;

        element = document.getElementById("webdeveloper-disable-all-styles-menu");

        // If the disable all styles element is set
        if(currentDocument.getElementById("webdeveloper-disable-all-styles"))
        {
            disable = false;
        }

        webdeveloper_configureElement(element, "checked", disable);
    }

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        pageDocument     = documentList[i];
        styleSheetList   = pageDocument.styleSheets;
        styleSheetLength = styleSheetList.length;

        // Loop through all the stylesheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is a valid style sheet and is not an alternate style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet) && (!webdeveloper_isAlternateStyleSheet(styleSheet) || disable))
            {
				styleSheet.disabled = disable;
            }
        }

        webdeveloper_toggleDocumentInlineStyles(pageDocument.documentElement, disable);
    }

    // Toggle other CSS feature keyboard shortcuts
    document.getElementById("webdeveloper-edit-css-key").setAttribute("disabled", disable);
    document.getElementById("webdeveloper-view-style-information-key").setAttribute("disabled", disable);

    webdeveloper_toggleStyleSheet(element, "chrome://webdeveloper/content/stylesheets/empty.css", "webdeveloper-disable-all-styles");
}

// Updates the CSS menu
function webdeveloper_updateCSSMenu(suffix)
{
    var currentDocument         = webdeveloper_getContentDocument();
    var disableAllStylesChecked = webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-disable-all-styles");
    var menu                    = document.getElementById("webdeveloper-edit-css-" + suffix);

    // If the menu exists
    if(menu)
    {
        var editCSSOpen = webdeveloper_isOpenInDashboard(document.getElementById("webdeveloper-string-bundle").getString("webdeveloper_editCSS"));

        webdeveloper_configureElement(menu, "checked", editCSSOpen);

        // If edit CSS is not open and the page has frames
        if(!editCSSOpen && webdeveloper_pageHasFrames())
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }

        webdeveloper_configureElement(menu, "disabled", disableAllStylesChecked);
    }

    menu = document.getElementById("webdeveloper-view-style-information-" + suffix);

    // If the menu exists
    if(menu)
    {
        // If the DOM Inspector is not found
        if(!webdeveloper_isDOMInspectorAvailable())
        {
            menu.setAttribute("class", "menuitem-iconic");
        }
        else if(menu.hasAttribute("class"))
        {
            menu.removeAttribute("class");
        }

        webdeveloper_configureElement(menu, "disabled", disableAllStylesChecked);
        webdeveloper_configureElementByAppliedStyle(menu, "checked", "webdeveloper-view-style-information");
    }

    webdeveloper_configureElement(document.getElementById("webdeveloper-add-user-style-sheet-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-individual-style-sheet-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-display-media-type-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-use-border-box-model-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-add-user-style-sheet-" + suffix), "checked", "webdeveloper-add-user-style-sheet");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-use-border-box-model-" + suffix), "checked", "webdeveloper-use-border-box-model");
}

// Updates the CSS media type menu
function webdeveloper_updateCSSMediaTypeMenu(suffix)
{
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-handheld-css-" + suffix), "checked", "webdeveloper-display-handheld-css");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-display-print-css-" + suffix), "checked", "webdeveloper-display-print-css");
}

// Updates the disable styles menu
function webdeveloper_updateDisableStylesMenu(suffix)
{
    var currentDocument         = webdeveloper_getContentDocument();
    var disableAllStylesChecked = webdeveloper_contains(webdeveloper_appliedStyles, "webdeveloper-disable-all-styles");

    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-all-styles-" + suffix), "checked", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-browser-default-styles-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-embedded-styles-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-inline-styles-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-linked-styles-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElement(document.getElementById("webdeveloper-disable-print-styles-" + suffix), "disabled", disableAllStylesChecked);
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-disable-browser-default-styles-" + suffix), "checked", "webdeveloper-disable-browser-default-styles");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-disable-embedded-styles-" + suffix), "checked", "webdeveloper-disable-embedded-styles");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-disable-inline-styles-" + suffix), "checked", "webdeveloper-disable-inline-styles");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-disable-linked-styles-" + suffix), "checked", "webdeveloper-disable-linked-styles");
    webdeveloper_configureElementByAppliedStyle(document.getElementById("webdeveloper-disable-print-styles-" + suffix), "checked", "webdeveloper-disable-print-styles");
}

// View CSS
function webdeveloper_viewCSS()
{
    var divElement        = null;
    var documentList      = webdeveloper_getDocuments(webdeveloper_getContentWindow());
    var documentLength    = documentList.length;
    var documentURL       = null;
    var inlineStylesText  = "";
    var linkElement       = null;
    var oldTab            = getBrowser().selectedTab;
    var oldURL            = getBrowser().currentURI.spec;
    var generatedDocument = webdeveloper_generateDocument("");
    var bodyElement       = webdeveloper_getDocumentBodyElement(generatedDocument);
    var headElement       = webdeveloper_getDocumentHeadElement(generatedDocument);
    var headerElement     = generatedDocument.createElement("h1");
    var pageDocument      = null;
    var preElement        = null;
    var scriptElement     = generatedDocument.createElement("script");
    var spanElement       = null;
    var stringBundle      = document.getElementById("webdeveloper-string-bundle");
    var styleSheet        = null;
    var styleSheetHref    = null;
    var styleSheetList    = new Array();
    var styleSheetLength  = null;
    var title             = stringBundle.getFormattedString("webdeveloper_viewCSSTitle", [oldURL]);

    generatedDocument.title = title;

    webdeveloper_addGeneratedStyles(generatedDocument);

    headerElement.appendChild(generatedDocument.createTextNode(title));
    bodyElement.appendChild(headerElement);

    webdeveloper_addGeneratedTools(generatedDocument);

    // Loop through the documents
    for(var i = 0; i < documentLength; i++)
    {
        headerElement    = generatedDocument.createElement("h2");
        inlineStylesText = "";
        linkElement      = generatedDocument.createElement("a");
        pageDocument     = documentList[i];
        documentURL      = pageDocument.documentURI;
        styleSheetList   = pageDocument.getElementsByTagName("style");
        styleSheetLength = styleSheetList.length;

        linkElement.setAttribute("href", documentURL);
        linkElement.appendChild(generatedDocument.createTextNode(documentURL));
        headerElement.appendChild(linkElement);
        bodyElement.appendChild(headerElement);

        // Loop through the inline style sheets
        for(var j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is a valid style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet.sheet) && (!styleSheet.hasAttribute("id") || styleSheet.getAttribute("id").indexOf("webdeveloper-") != 0))
            {
                inlineStylesText += styleSheet.innerHTML.trim() + "\n\n";
            }
        }

        // If there are inline styles
        if(inlineStylesText != "")
        {
            divElement    = generatedDocument.createElement("div");
            headerElement = generatedDocument.createElement("h3");
            preElement    = generatedDocument.createElement("pre");
            spanElement   = generatedDocument.createElement("span");

            spanElement.setAttribute("class", "expanded pivot");
            headerElement.appendChild(spanElement);
            headerElement.appendChild(generatedDocument.createTextNode(stringBundle.getFormattedString("webdeveloper_embeddedStylesFrom", [documentURL])));
            bodyElement.appendChild(headerElement);

            preElement.appendChild(generatedDocument.createTextNode(inlineStylesText));
            divElement.setAttribute("class", "output");
            divElement.appendChild(preElement);
            bodyElement.appendChild(divElement);
        }

        styleSheetList   = webdeveloper_getStyleSheetsForDocument(pageDocument, true, true);
        styleSheetLength = styleSheetList.length;

        // Loop through the style sheets
        for(j = 0; j < styleSheetLength; j++)
        {
            styleSheet = styleSheetList[j];

            // If this is a valid style sheet and is not an inline style sheet
            if(webdeveloper_isValidStyleSheet(styleSheet) && styleSheet.href && styleSheet.href != documentURL)
            {
                divElement     = generatedDocument.createElement("div");
                headerElement  = generatedDocument.createElement("h3");
                linkElement    = generatedDocument.createElement("a");
                preElement     = generatedDocument.createElement("pre");
                spanElement    = generatedDocument.createElement("span");
                styleSheetHref = styleSheet.href;

                spanElement.setAttribute("class", "expanded pivot");
                headerElement.appendChild(spanElement);
                linkElement.setAttribute("href", styleSheetHref);
                linkElement.appendChild(generatedDocument.createTextNode(styleSheetHref));
                headerElement.appendChild(linkElement);
                bodyElement.appendChild(headerElement);
                preElement.appendChild(generatedDocument.createTextNode(webdeveloper_retrieveSource(styleSheetHref).replace(new RegExp("\r", "gi"), "\n")));
                divElement.setAttribute("class", "output");
                divElement.appendChild(preElement);
                bodyElement.appendChild(divElement);
            }
        }
    }

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/common/xpath.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    scriptElement = generatedDocument.createElement("script");

    scriptElement.setAttribute("defer", "defer");
    scriptElement.setAttribute("src", "chrome://webdeveloper/content/generated/output_pivot.js");
    scriptElement.setAttribute("type", "text/javascript");
    headElement.appendChild(scriptElement);

    // If the open tabs in background preference is set to true
    if(webdeveloper_getBooleanPreference("webdeveloper.open.tabs.background", true))
    {
        getBrowser().selectedTab = oldTab;
    }
}
