/*
 *   Copyright (C) 2000 Loic Dachary
 *
 *   This program is free software; you can redistribute it and/or modify it
 *   under the terms of the GNU General Public License as published by the
 *   Free Software Foundation; either version 2, or (at your option) any
 *   later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#ifdef HAVE_STDLIB_H
#include <stdlib.h>
#endif /* HAVE_STDLIB_H */
#include <stdio.h>
#include <string.h>

#include <ltdl.h>
#include <webbasedl.h>

webbasedl_init_function_t webbasedl(const char* name)
{
  webbasedl_init_function_t init_function = 0;
  char* filename = 0;
  char* function = 0;

  if(!name) {
    fprintf(stderr, "webbasedl: null name\n");
    goto err;
  }
  
  if(lt_dlinit() > 0) {
    fprintf(stderr, "webbasedl: lt_dlinit: %s\n", lt_dlerror());
    goto err;
  }

  {
    lt_dlhandle handle;
    lt_ptr_t symbol;
    filename = (char*)malloc(strlen(name) + 1 + 128);
    sprintf(filename, "lib%s.la", name);
    handle = lt_dlopen(filename);
    if(!handle) {
      fprintf(stderr, "webbasedl: lt_dlhandle: %s %s\n", filename, lt_dlerror());
      goto err;
    }

    function = (char*)malloc(strlen(name) + 1 + 128);
    sprintf(function, "%s_init", name);
    symbol = lt_dlsym(handle, function);
    if(!symbol) {
      fprintf(stderr, "webbasedl: lt_dlsym: %s\n", lt_dlerror());
      goto err;
    }

    init_function = (webbasedl_init_function_t)symbol;
  }
 err:
  if(function) free(function);
  if(filename) free(filename);
  return init_function;
}
