// Runtime+compiler production build (Browser)
/* jshint node: true */
'use strict';
var path = require('path');
var webpack = require('webpack');
var config = {
  target: 'web',
  entry: './src/platforms/web/entry-runtime-with-compiler.js',
  resolve: {
    modules: ['/usr/lib/nodejs', './src', './src/platforms'],
  },
  resolveLoader: {
    modules: ['/usr/lib/nodejs'],
  },
  output: {
    path: path.resolve(__dirname, '../dist'),
    filename: 'vue.min.js',
    library: "Vue",
    libraryTarget: 'umd',
    umdNamedDefine: true
  },
  module: { rules: [ { use: [ 'babel-loader' ] } ] },
  plugins: [
    new webpack.optimize.UglifyJsPlugin( {
      minimize : true,
      sourceMap : false,
      mangle: true,
      compress: {
        warnings: false
      }
    })
  ]
};
module.exports = config;
