#include "cs.h"
/* solve Lx=b(:,k), leaving pattern in xi[top..n-1], values scattered in x. */
CS_INT cs_splsolve (cs *L, const cs *B, CS_INT k, CS_INT *xi, CS_ENTRY *x, const CS_INT *Pinv)
{
    CS_INT j, jnew, p, px, top, n, *Lp, *Li, *Bp, *Bi ;
    CS_ENTRY *Lx, *Bx ;
    if (!L || !B || !xi || !x) return (-1) ;
    Lp = L->p ; Li = L->i ; Lx = L->x ; n = L->n ;
    Bp = B->p ; Bi = B->i ; Bx = B->x ;
    top = cs_reach (L, B, k, xi, Pinv) ;	/* xi[top..n-1]=Reach(B(:,k)) */
    for (p = top ; p < n ; p++) x [xi [p]] = 0 ;/* clear x */
    for (p = Bp [k] ; p < Bp [k+1] ; p++) x [Bi [p]] = Bx [p] ;	/* scatter B */
    for (px = top ; px < n ; px++)
    {
	j = xi [px] ;				/* x(j) is nonzero */
	jnew = Pinv ? (Pinv [j]) : j ;		/* j is column jnew of L */
	if (jnew < 0) continue ;		/* column jnew is empty */
	for (p = Lp [jnew]+1 ; p < Lp [jnew+1] ; p++)
	{
	    x [Li [p]] -= Lx [p] * x [j] ;	/* x(i) -= L(i,j) * x(j) */
	}
    }
    return (top) ;				/* return top of stack */
}
