// ------------------------------------------------------------
// 
// Author: Tony Darugar, tdarugar@binevolve.com
// 
// $Id$ 
// -------------------------------------------------------------

#include "tcl.h"
#include "connection_manager.h"

// -------------------------------------------------------------
// Our sample command. 
// Notice how the ClientData is used to pass around the reference
// to our 'counter' object.
//
SampleCmd(ClientData clientData, Tcl_Interp *interp, int argc, char **argv) 
{

	// Get a pointer to the sample object from the clientData:
	Sample *counter = (Sample *)clientData;

	// Call the counter:
	int c = counter->getNext();

	// Return the result of the command:
	char returnValue[10];
	sprintf(returnValue, "%d", c);

	// The TCL_VOLATILE means the memory for our returnValue was allocated
	// from the stack. See Tcl_SetResult for details.
	Tcl_SetResult(interp, returnValue, TCL_VOLATILE);

	return TCL_OK;
}

// -------------------------------------------------------------
// It's necessary to declare the Init procedure as extern C to make
// tcl happy.
//
extern "C" {
Sample_Init(Tcl_Interp *interp);
}

// -------------------------------------------------------------
// The initialization function. Tcl calls this function when you
// load the package. Its name must be the name of the package, with
// the first letter capitalized, the rest lower, and '_Init' appended
// to the end of it.
//
Sample_Init(Tcl_Interp *interp) {

	Sample *counter = new Sample();

	// Create a new tcl command called 'counter'
	// Notes:
	// the first argument is the interpreter, as passed in. Ignore it.
	// the 2nd arg is the name of your command
	// the 3rd arg is the name of the function to call when the new command
	//     is used
	// the 4th arg is data that your command can use as it wants to.
	//     In this case we pass a pointer to the 'counter' object.
	//     This pointer will be passed to our 'SampleCmd' command whenever
	//     it's called.
	// the 5th argument is a function to delete your command. It can be NULL.
	Tcl_CreateCommand (interp, "counter", SampleCmd ,(ClientData) counter,
										 (Tcl_CmdDeleteProc*) NULL);

	// Provide a package called Sample 
	if (Tcl_PkgProvide(interp, "Sample", "1.0") == TCL_ERROR)
		return TCL_ERROR;

	return TCL_OK; 
}
