// ------------------------------------------------------------
// 
// This is the 'interface' that each database class has to provide.
// Inherit from this class in your database class and provide all
// of the functions listed here.
//
// Author: Tony Darugar, tdarugar@binevolve.com
// 
// $Id: sql-interface.h,v 1.4 1998/09/14 10:52:27 tdarugar Exp $
// -------------------------------------------------------------

#ifndef SQL_INTERFACE_H
#define SQL_INTERFACE_H

class Sql_row;

class Sql_interface {
 public:

	// Connect to the database
	// Returns 0 in case of error.
	virtual int connect(int argc, char **argv) { return 0; }

	// Are we connected to the database?
	// Returns 1 if connected, 0 if not.
	virtual int isConnected()          { return 0; }

	// Select the database to use.
	// Returns 0 in case of error.
	virtual int selectdb(char *dbname) { return 0; }

	// Execute the sql statement. Used for statements that do not
	// return anything (almost everything other than select).
	// Returns 0 in case of error.
	virtual int exec(char *cmd)        { return 0; }

	// Execute the select statement, or other statement that returns
	// results. The results will be retrieved via 'fetchrow'.
	// Returns the number of rows selected, -1 in case of error.
	virtual int query(char *cmd)       { return 0; }

	// Return the number of rows return or effected.
	virtual int numRows(int resHandle=0)       { return 0; }

	// Return the next row from the select statement.
	// Returns null in case of error or no more rows left.
	// Note: A new Sql_row is allocated to hold the result. The
	// caller has to delete.
	virtual Sql_row *fetchrow(int resHandle=0)  { return NULL; }

	// End fetching rows. This is called when processing of the results
	// of an earlier 'select' are finished.
	virtual void endquery(int resHandle=0)      {}

	// Get the error message, if there was one, for the last message
	virtual char *getErrorMsg()        { return NULL; }

	// Virtual destructor
	virtual ~Sql_interface() { }
};


// --------------------------------------------------------------
class Sql_row {
 private:
	char **columns;
	int  nColumns;
	int  capacity;
 public:
	Sql_row(int c) { nColumns = 0 ; capacity = c; columns = new char*[capacity]; }

	// ---------
	int setColumn(int i, char *val) {
		if (i >= capacity) return 0;
		columns[i] = val; nColumns++; 
		return 1;
	}

	// ---------
	char *getColumn(int i) {
		if (i >= capacity) return NULL;
		return columns[i];
	}

	// ---------
	int numColumns() { return nColumns; }
};

#endif
