/******************************************************************************

  SUFARYڵץ getart
    Version 1.0 981022

   USAGE:
     getart KEYWORD FILE1 FILE2
     getart '' FILE1 FILE2

   FILE2 DocIDե

   (KEYWORD)  '' ꤹȡɸϤ饭
     ϤƸԤʤޤ

 *****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include "sufary.h"

typedef struct _doc_info {
  long start;
  long size;
  long no;
  int freq;
} doc_info;

void search_and_print(SUFARY *ary, DID *d, char *key, char *fname);
static int mycomp(doc_info *i,doc_info *j){return(i->no - j->no);}
static int mycomp2(doc_info *i,doc_info *j){return(j->freq - i->freq);}

main(int argc, char *argv[])
{
  SUFARY *ary;
  DID *did;

  if(argc < 3){ /* ­ʤ */
    fprintf(stderr, "getart Version 1.0 981022\n"
	    "  USAGE: getart KEYWORD TEXT_FILE DocID_FILE\n");
    exit(1);
  }

  /** ե򳫤 **/
  if ((ary = sa_openfiles(argv[2],NULL)) == NULL) exit(1);
  if ((did = sa_opendid(argv[3])) == NULL) exit(1);

  if(argv[1][0] == '\0'){ /*** ɸϤ饭 ***/
    char cmd[1000];
    while(fgets(cmd, (int)sizeof(cmd), stdin)){
      cmd[strlen(cmd)-1] = '\0'; /* Ϥ줿ɤβ٤ */
      search_and_print(ary, did, cmd, NULL);
      sa_reset(ary); /*  */
    }
  } else /*** (argv[1]) ***/
    search_and_print(ary, did, argv[1], NULL);

  /** եĤ **/
  sa_closefiles(ary);
  sa_closedid(did);
}


/************************************************************
  void search_and_print(SUFARY *ary, char *key, char *fname)
  ɽ
 ************************************************************/
void search_and_print(SUFARY *ary, DID *d, char *key, char *fname)
{
  int i, pre_art, num;
  long ai, pos, lpos, sar, sal;
  char *s;
  doc_info *start_and_size;

  if (sa_sel(ary, key) == CONT){
    sar = sa_right(ary); sal = sa_left(ary);
    start_and_size = (doc_info *)malloc(sizeof(doc_info) * (sar - sal +1));
    for (ai = sal; ai <= sar; ai++){
      pos = sa_aryidx2txtidx(ary, ai);
      sa_didsearch(d, pos);
      start_and_size[ai-sal].start = sa_doc_start(d);
      start_and_size[ai-sal].size = sa_doc_size(d);
      start_and_size[ai-sal].no = sa_doc_no(d);
    }
  } else {
    printf("NOT FOUND\n");
    return;
  }

  qsort(start_and_size,(size_t)(sar-sal+1),sizeof(doc_info),
	(int(*)(const void*,const void*))mycomp);

  /*** Ĥ ***/
  pre_art = -1;
  num = 0;
  for(i = 0; i < sar-sal+1; i++){
    long now_start = start_and_size[i].start;
    if(now_start == pre_art){
      if(now_start != -1) (start_and_size[num-1].freq)++;
      goto JUMP;
    }
    if(start_and_size[num].start != now_start)
      start_and_size[num] = start_and_size[i];
    start_and_size[num].freq = 1;
    num++;
  JUMP:
    pre_art = start_and_size[i].start;
  }

  printf("FOUND %d\n", num);

  qsort(start_and_size,(size_t)num,sizeof(doc_info),
	(int(*)(const void*,const void*))mycomp2);

  /*** ɽ ***/
  for(i = 0; i < num; i++){
    char *art;
    art = sa_getstr(ary, start_and_size[i].start, start_and_size[i].size);
    printf("freq=%d\n", start_and_size[i].freq);
    printf("%s\n", art);
    free(art);
  }
}
