/*
 *  SPL - The SPL Programming Language
 *  Copyright (C) 2004, 2005  Clifford Wolf <clifford@clifford.at>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  mod_uuidgen.c: Module for creating UUID strings
 */

/**
 * This module provides a simple API for creating UUID strings
 */

#define _GNU_SOURCE

#include <uuid/uuid.h>
#include <stdlib.h>

#include "spl.h"
#include "compat.h"

extern void SPL_ABI(spl_mod_uuidgen_init)(struct spl_vm *vm, struct spl_module *mod, int restore);
extern void SPL_ABI(spl_mod_uuidgen_done)(struct spl_vm *vm, struct spl_module *mod);

/**
 * This function generates a UUID (using libuuid) and returns a 36
 * character string with a hex representation of th uuid.
 */
// builtin uuidgen()
static struct spl_node *handler_uuidgen(struct spl_task *task UNUSED, void *data UNUSED)
{
	uuid_t my_uuid;
	char my_uuid_string[64];

	uuid_generate(my_uuid);
	uuid_unparse(my_uuid, my_uuid_string);

	for (int i=0; my_uuid_string[i]; i++)
		if (my_uuid_string[i] >= 'A' && my_uuid_string[i] <= 'Z')
			my_uuid_string[i] += 'a' - 'A';

	return SPL_NEW_STRING_DUP(my_uuid_string);
}

void SPL_ABI(spl_mod_uuidgen_init)(struct spl_vm *vm, struct spl_module *mod UNUSED, int restore UNUSED)
{
	spl_clib_reg(vm, "uuidgen", handler_uuidgen, 0);
}

void SPL_ABI(spl_mod_uuidgen_done)(struct spl_vm *vm UNUSED, struct spl_module *mod UNUSED)
{
	return;
}

