(* $Id: unix_exts.mli,v 1.1 2000/12/10 15:12:54 gerd Exp $
 * ----------------------------------------------------------------------
 *
 *)

open Unix;;

(* Misc *)

val int_of_file_descr : file_descr -> int;;
val file_descr_of_int : int -> file_descr;;

external is_open_descr : file_descr -> bool = "unix_is_open_descr";;

external _exit : int -> unit = "unix__exit";;

(* Limits  & resources *)

external sysconf_open_max : unit -> int = "unix_sysconf_open_max";;
(* max number of open file descriptors per process *)

(* Process groups, sessions, terminals *)

external getpgid : int -> int = "unix_getpgid";;
val getpgrp : unit -> int;;
external setpgid : int -> int -> unit = "unix_setpgid";;
val setpgrp : unit -> unit;;

external tcgetpgrp : file_descr -> int = "unix_tcgetpgrp";;
external tcsetpgrp : file_descr -> int -> unit = "unix_tcsetpgrp";;

external ctermid : unit -> string = "unix_ctermid";;
external ttyname : file_descr -> string = "unix_ttyname";;

external getsid : int -> int = "unix_getsid";;

(* Users and groups *)

external setreuid : int -> int -> unit = "unix_setreuid";;
external setregid : int -> int -> unit = "unix_setregid";;

(* Still missing:
 * - improved signal handling
 * - async I/O
 * - poll syscall
 * - message catalogues
 * - syslog
 * - crypt
 * - fnmatch
 * - get/setitimer
 * - pseudo ttys (how to do it in a portable way?)
 *)

(* ======================================================================
 * History:
 * 
 * $Log: unix_exts.mli,v $
 * Revision 1.1  2000/12/10 15:12:54  gerd
 * 	Initial revision.
 *
 * 
 *)
