=begin
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
=end

# $Id: segment_integral.rb,v 1.4 2002/01/16 15:17:06 nando Exp $

require 'QuantLib'
require 'runit/testcase'
require 'runit/cui/testrunner'

class SegmentIntegralTest < RUNIT::TestCase
    def name
        "Testing segment integral..."
    end
    def test
        tol = 1.0e-4
        integrate = QuantLib::SegmentIntegral.new(10000)

        i1 = integrate.call(0, 1) { |x| 1.0 }
        i1_res = 1.0

        unless (i1 - i1_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = 1 on [0,1]
        calculated: #{i1}
        expected  : #{i1_res}

                MESSAGE
            )
        end

        i2 = integrate.call(0, 1) { |x| x }
        i2_res = 0.5

        unless (i2 - i2_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = x on [0,1]
        calculated: #{i2}
        expected  : #{i2_res}

                MESSAGE
            )
        end

        i3 = integrate.call(0, 1) { |x| x*x }
        i3_res = 1.0/3.0

        unless (i3 - i3_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = x^2 on [0,1]
        calculated: #{i3}
        expected  : #{i3_res}

                MESSAGE
            )
        end

        i4 = integrate.call(0, Math::PI) { |x| Math.sin(x) }
        i4_res = 2.0

        unless (i4 - i4_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = sin x on [0,pi]
        calculated: #{i4}
        expected  : #{i4_res}

                MESSAGE
            )
        end


        i5 = integrate.call(0, Math::PI) { |x| Math.cos(x) }
        i5_res = 0.0

        unless (i5 - i5_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = cos x on [0,pi]
        calculated: #{i5}
        expected  : #{i5_res}

                MESSAGE
            )
        end


        i6 = integrate.call(-10, 10) { |x| Math.exp(-x*x/2.0)/Math.sqrt(2.0*Math::PI) }
        i6_res = 1.0

        unless (i6 - i6_res).abs <= tol
            assert_fail(<<-MESSAGE

    f(x) = 1/sqrt(2*pi) exp(x^2/2) on [-10,10]
        calculated: #{i6}
        expected  : #{i6_res}

                MESSAGE
            )
        end
    end
end

if $0 == __FILE__
    RUNIT::CUI::TestRunner.run(SegmentIntegralTest.suite)
end

