#!/usr/bin/python

"""
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
"""

__version__ = "$Revision: 1.12 $"
# $Source: /cvsroot/quantlib/QuantLib-Python/QuantLib/test/get_covariance.py,v $

import QuantLib
import unittest

def initCovariance(vol, corr):
    n = len(vol)
    cov = QuantLib.Matrix([[0.0]*n]*n)
    for i in range(n):
        cov[i][i] = vol[i]*vol[i]
        for j in range(i):
            cov[i][j] = corr[i][j]*vol[i]*vol[j]
            cov[j][i] = cov[i][j]
    return cov


class CovarianceTest(unittest.TestCase):
    def runTest(self):
        "Testing covariance calculation"
        vol = QuantLib.Array([0.1, 0.5, 1.0])
        corr = [[1.0, 0.2, 0.5],
                [0.2, 1.0, 0.8],
                [0.5, 0.8, 1.0]]

        expectedCov = initCovariance(vol, corr)
        cov = QuantLib.getCovariance(vol, corr)

        for i in range(3):
            for j in range(3):
                calculated = cov[i][j]
                expected   = expectedCov[i][j]
                if not (abs(calculated - expected) <= 1e-10):
                    self.fail("""
cov[%(i)d][%(j)d]: %(calculated)g
expected   : %(expected)g
tolerance exceeded
                              """ % locals())


if __name__ == '__main__':
    print 'testing QuantLib', QuantLib.__version__, QuantLib.QuantLibc.__file__, QuantLib.__file__
    import sys
    suite = unittest.TestSuite()
    suite.addTest(CovarianceTest())
    if sys.hexversion >= 0x020100f0:
        unittest.TextTestRunner(verbosity=2).run(suite)
    else:
        unittest.TextTestRunner().run(suite)
    raw_input('press any key to continue')
