
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: RateHelpers.i,v 1.23 2002/01/16 14:50:51 nando Exp $

#ifndef quantlib_rate_helpers_i
#define quantlib_rate_helpers_i

%include Date.i
%include Calendars.i
%include DayCounters.i
%include Types.i
%include CashFlows.i
%include MarketElements.i

%{
    using QuantLib::Handle;
    using QuantLib::TermStructures::RateHelper;
    using QuantLib::TermStructures::DepositRateHelper;
    using QuantLib::TermStructures::FraRateHelper;
    using QuantLib::TermStructures::FuturesRateHelper;
    using QuantLib::TermStructures::SwapRateHelper;
    typedef Handle<RateHelper> RateHelperHandle;
    typedef Handle<DepositRateHelper> DepositRateHelperHandle;
    typedef Handle<FraRateHelper> FraRateHelperHandle;
    typedef Handle<FuturesRateHelper> FuturesRateHelperHandle;
    typedef Handle<SwapRateHelper> SwapRateHelperHandle;
%}

%name(RateHelper) class RateHelperHandle {
  private:
    // abstract class - no constructor exported
    RateHelperHandle();
  public:
    ~RateHelperHandle();
};

%addmethods RateHelperHandle {
    Date maturity() {
        return (*self)->maturity();
    }
}

// fake inheritance between handles
%name(DepositRateHelper) class DepositRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~DepositRateHelperHandle();
};

%addmethods DepositRateHelperHandle {
    DepositRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int n, TimeUnit units, Calendar calendar,
        RollingConvention convention, DayCounter dayCounter) {
            return new DepositRateHelperHandle(
                new DepositRateHelper(rate,settlementDays,n,units,calendar,
                    convention,dayCounter));
    }
}

// fake inheritance between handles
%name(FraRateHelper) class FraRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~FraRateHelperHandle();
};

%addmethods FraRateHelperHandle {
    FraRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int monthsToStart, int monthsToEnd,
        Calendar calendar, RollingConvention convention,
        DayCounter dayCounter) {
            return new FraRateHelperHandle(
                new FraRateHelper(rate,settlementDays,monthsToStart,
                    monthsToEnd,calendar,convention,dayCounter));
    }
}

// fake inheritance between handles
%name(FuturesRateHelper) class FuturesRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~FuturesRateHelperHandle();
};

%addmethods FuturesRateHelperHandle {
    FuturesRateHelperHandle(MarketElementRelinkableHandle price,
        const Date& ImmDate, int settlementDays, int nMonths,
        Calendar calendar, RollingConvention convention,
        DayCounter dayCounter) {
            return new FuturesRateHelperHandle(
                new FuturesRateHelper(price,ImmDate,settlementDays,nMonths,
                    calendar,convention,dayCounter));
    }
}

// fake inheritance between handles
%name(SwapRateHelper) class SwapRateHelperHandle
: public RateHelperHandle {
  public:
    // constructor redefined below
    ~SwapRateHelperHandle();
};

%addmethods SwapRateHelperHandle {
    SwapRateHelperHandle(MarketElementRelinkableHandle rate,
        int settlementDays, int lengthInYears, Calendar calendar,
        RollingConvention rollingConvention,
        int fixedFrequency, bool fixedIsAdjusted,
        DayCounter fixedDayCount, int floatingFrequency) {
            return new SwapRateHelperHandle(
                new SwapRateHelper(rate, settlementDays, lengthInYears,
                    calendar, rollingConvention, fixedFrequency,
                    fixedIsAdjusted, fixedDayCount, floatingFrequency));
    }
}


// typedef Python list of rate helpers to std::vector<Handle<RateHelper> >

TypemapVector(RateHelperHandle,RateHelper,
    RateHelperHandleVector,RateHelperVector);
ExportVector(RateHelperHandle,RateHelperHandleVector,RateHelperVector);



#endif
