
/*
 Copyright (C) 2000, 2001, 2002 RiskMap srl

 This file is part of QuantLib, a free-software/open-source library
 for financial quantitative analysts and developers - http://quantlib.org/

 QuantLib is free software: you can redistribute it and/or modify it under the
 terms of the QuantLib license.  You should have received a copy of the
 license along with this program; if not, please email ferdinando@ametrano.net
 The license is also available online at http://quantlib.org/html/license.html

 This program is distributed in the hope that it will be useful, but WITHOUT
 ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 FOR A PARTICULAR PURPOSE.  See the license for more details.
*/

// $Id: BlackInstruments.i,v 1.2 2002/03/14 14:08:35 lballabio Exp $

#ifndef quantlib_black_instruments_i
#define quantlib_black_instruments_i

%include Instruments.i
%include Options.i
%include MarketElements.i
%include TermStructures.i
%include Exercise.i
%include Swap.i
%include CashFlows.i
%include Observer.i

%{
using QuantLib::Handle;
using QuantLib::Instruments::Swaption;
using QuantLib::Instruments::VanillaCap;
using QuantLib::Instruments::VanillaFloor;
using QuantLib::Instruments::VanillaCollar;
typedef Handle<Swaption> SwaptionHandle;
typedef Handle<VanillaCap> VanillaCapHandle;
typedef Handle<VanillaFloor> VanillaFloorHandle;
typedef Handle<VanillaCollar> VanillaCollarHandle;
%}

%name(Swaption) class SwaptionHandle : public InstrumentHandle {
  public:
    ~Swaption();
};

%addmethods SwaptionHandle {
    SwaptionHandle(const SimpleSwapHandle& swap,
                   const Exercise& exercise,
                   const TermStructureRelinkableHandle& termStructure,
                   const OptionEngineHandle& engine) {
        return new SwaptionHandle(new Swaption(swap,exercise,
                                               termStructure,engine));
    }
}

%name(Cap) class VanillaCapHandle : public InstrumentHandle {
  public:
    ~VanillaCapHandle();
};

%addmethods VanillaCapHandle {
    VanillaCapHandle(const FloatingRateCouponVector& leg,
                     const DoubleVector& capRates,
                     const TermStructureRelinkableHandle& termStructure,
                     const OptionEngineHandle& engine) {
        return new VanillaCapHandle(
                       new VanillaCap(leg,capRates,
                                      termStructure,engine));
    }
}

%name(Floor) class VanillaFloorHandle : public InstrumentHandle {
  public:
    ~VanillaFloorHandle();
};

%addmethods VanillaFloorHandle {
    VanillaFloorHandle(const FloatingRateCouponVector& leg,
                       const DoubleVector& floorRates,
                       const TermStructureRelinkableHandle& termStructure,
                       const OptionEngineHandle& engine) {
        return new VanillaFloorHandle(
                       new VanillaFloor(leg,floorRates,
                                        termStructure,engine));
    }
}

%name(Collar) class VanillaCollarHandle : public InstrumentHandle {
  public:
    ~VanillaCollarHandle();
};

%addmethods VanillaCollarHandle {
    VanillaCollarHandle(const FloatingRateCouponVector& leg,
                        const DoubleVector& capRates,
                        const DoubleVector& floorRates,
                        const TermStructureRelinkableHandle& termStructure,
                        const OptionEngineHandle& engine) {
        return new VanillaCollarHandle(
                       new VanillaCollar(leg,capRates,floorRates,
                                         termStructure,engine));
    }
}


%{
using QuantLib::InterestRateModelling::BlackModel;
typedef Handle<BlackModel> BlackModelHandle;
%}

%name(BlackModel) class BlackModelHandle : public ObservableHandle {
  public:
    ~BlackModelHandle();
};

%addmethods BlackModelHandle {
    BlackModelHandle(const MarketElementRelinkableHandle& volatility,
                     const TermStructureRelinkableHandle& termStructure) {
        return new BlackModelHandle(new BlackModel(volatility,termStructure));
    }
}

%{
using QuantLib::Pricers::BlackSwaption;
using QuantLib::Pricers::BlackCapFloor;
typedef Handle<BlackSwaption> BlackSwaptionHandle;
typedef Handle<BlackCapFloor> BlackCapFloorHandle;
%}

%name(BlackSwaptionEngine) class BlackSwaptionHandle 
: public OptionEngineHandle {
  public:
    ~BlackSwaptionHandle();
};

%addmethods BlackSwaptionHandle {
    BlackSwaptionHandle(const BlackModelHandle& model) {
        return new BlackSwaptionHandle(new BlackSwaption(model));
    }
}

%name(BlackCapFloorEngine) class BlackCapFloorHandle 
: public OptionEngineHandle {
  public:
    ~BlackCapFloorHandle();
};

%addmethods BlackCapFloorHandle {
    BlackCapFloorHandle(const BlackModelHandle& model) {
        return new BlackCapFloorHandle(new BlackCapFloor(model));
    }
}



#endif
