// Copyright (c) 2014 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef UI_EVENTS_KEYCODES_KEYBOARD_CODE_CONVERSION_XKB_H_
#define UI_EVENTS_KEYCODES_KEYBOARD_CODE_CONVERSION_XKB_H_

// These functions are used by X11 targets and by Ozone/XKBcommon targets.

#include "base/strings/string16.h"
#include "ui/events/events_base_export.h"
#include "ui/events/keycodes/dom/dom_key.h"
#include "ui/events/keycodes/xkb_keysym.h"

namespace ui {

// Returns the DomKey associated with a non-character xkb_keysym_t.
// Returns DomKey::NONE for unrecognized keysyms, which includes
// all printable characters.
EVENTS_BASE_EXPORT DomKey NonPrintableXKeySymToDomKey(xkb_keysym_t keysym);

// TODO(kpschoedel) crbug.com/442757
// Returns the dead key combining character associated with an xkb_keysym_t,
// or 0 if the keysym is not recognized.
// base::char16 DeadXKeySymToCombiningCharacter(xkb_keysym_t keysym);

// Return the DomKey determined by the XKB layout result (keysym, character).
EVENTS_BASE_EXPORT DomKey
XKeySymToDomKey(xkb_keysym_t keysym, base::char16 character);

}  // namespace ui

#endif  // UI_EVENTS_KEYCODES_KEYBOARD_CODE_CONVERSION_XKB_H_
