// Copyright 2017 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
// Protocol Buffer 2 Copyright 2008 Google Inc.
// All other code copyright its respective owners.

/**
 * @fileoverview Generated Protocol Buffer code for file
 * logs/proto/research/ink/ink_event.proto.
 * Generated by //net/proto2/compiler/public:protocol_compiler.
 * @suppress {messageConventions} 
 */

goog.provide('protos.research.ink.InkEvent');
goog.provide('protos.research.ink.InkEvent.DocumentEvent');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.OpenedEvent');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.DocumentState');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField');
goog.provide('protos.research.ink.InkEvent.DocumentEvent.DocumentEventType');
goog.provide('protos.research.ink.InkEvent.ToolbarEvent');
goog.provide('protos.research.ink.InkEvent.ToolbarEvent.ToolEventType');
goog.provide('protos.research.ink.InkEvent.ToolbarEvent.ToolType');
goog.provide('protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod');
goog.provide('protos.research.ink.InkEvent.EngineEvent');
goog.provide('protos.research.ink.InkEvent.EngineEvent.EngineEventType');
goog.provide('protos.research.ink.InkEvent.GmsEvent');
goog.provide('protos.research.ink.InkEvent.GmsEvent.GmsEventType');
goog.provide('protos.research.ink.InkEvent.Host');
goog.provide('protos.research.ink.InkEvent.EventType');

goog.require('goog.proto2.Message');



/**
 * Message InkEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.prototype.clone;


/**
 * Gets the value of the host field.
 * @return {?protos.research.ink.InkEvent.Host} The value.
 */
protos.research.ink.InkEvent.prototype.getHost = function() {
  return /** @type {?protos.research.ink.InkEvent.Host} */ (this.get$Value(1));
};


/**
 * Gets the value of the host field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.Host} The value.
 */
protos.research.ink.InkEvent.prototype.getHostOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.Host} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the host field.
 * @param {!protos.research.ink.InkEvent.Host} value The value.
 */
protos.research.ink.InkEvent.prototype.setHost = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the host field has a value.
 */
protos.research.ink.InkEvent.prototype.hasHost = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the host field.
 */
protos.research.ink.InkEvent.prototype.hostCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the host field.
 */
protos.research.ink.InkEvent.prototype.clearHost = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the event_type field.
 * @return {?protos.research.ink.InkEvent.EventType} The value.
 */
protos.research.ink.InkEvent.prototype.getEventType = function() {
  return /** @type {?protos.research.ink.InkEvent.EventType} */ (this.get$Value(2));
};


/**
 * Gets the value of the event_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.EventType} The value.
 */
protos.research.ink.InkEvent.prototype.getEventTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.EventType} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the event_type field.
 * @param {!protos.research.ink.InkEvent.EventType} value The value.
 */
protos.research.ink.InkEvent.prototype.setEventType = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the event_type field has a value.
 */
protos.research.ink.InkEvent.prototype.hasEventType = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the event_type field.
 */
protos.research.ink.InkEvent.prototype.eventTypeCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the event_type field.
 */
protos.research.ink.InkEvent.prototype.clearEventType = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the document_event field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getDocumentEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent} */ (this.get$Value(3));
};


/**
 * Gets the value of the document_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getDocumentEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the document_event field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent} value The value.
 */
protos.research.ink.InkEvent.prototype.setDocumentEvent = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the document_event field has a value.
 */
protos.research.ink.InkEvent.prototype.hasDocumentEvent = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the document_event field.
 */
protos.research.ink.InkEvent.prototype.documentEventCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the document_event field.
 */
protos.research.ink.InkEvent.prototype.clearDocumentEvent = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the toolbar_event field.
 * @return {?protos.research.ink.InkEvent.ToolbarEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getToolbarEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.ToolbarEvent} */ (this.get$Value(4));
};


/**
 * Gets the value of the toolbar_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.ToolbarEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getToolbarEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.ToolbarEvent} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the toolbar_event field.
 * @param {!protos.research.ink.InkEvent.ToolbarEvent} value The value.
 */
protos.research.ink.InkEvent.prototype.setToolbarEvent = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the toolbar_event field has a value.
 */
protos.research.ink.InkEvent.prototype.hasToolbarEvent = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the toolbar_event field.
 */
protos.research.ink.InkEvent.prototype.toolbarEventCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the toolbar_event field.
 */
protos.research.ink.InkEvent.prototype.clearToolbarEvent = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the engine_event field.
 * @return {?protos.research.ink.InkEvent.EngineEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getEngineEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.EngineEvent} */ (this.get$Value(5));
};


/**
 * Gets the value of the engine_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.EngineEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getEngineEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.EngineEvent} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the engine_event field.
 * @param {!protos.research.ink.InkEvent.EngineEvent} value The value.
 */
protos.research.ink.InkEvent.prototype.setEngineEvent = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the engine_event field has a value.
 */
protos.research.ink.InkEvent.prototype.hasEngineEvent = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the engine_event field.
 */
protos.research.ink.InkEvent.prototype.engineEventCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the engine_event field.
 */
protos.research.ink.InkEvent.prototype.clearEngineEvent = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the gms_event field.
 * @return {?protos.research.ink.InkEvent.GmsEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getGmsEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.GmsEvent} */ (this.get$Value(6));
};


/**
 * Gets the value of the gms_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.GmsEvent} The value.
 */
protos.research.ink.InkEvent.prototype.getGmsEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.GmsEvent} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the gms_event field.
 * @param {!protos.research.ink.InkEvent.GmsEvent} value The value.
 */
protos.research.ink.InkEvent.prototype.setGmsEvent = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the gms_event field has a value.
 */
protos.research.ink.InkEvent.prototype.hasGmsEvent = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the gms_event field.
 */
protos.research.ink.InkEvent.prototype.gmsEventCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the gms_event field.
 */
protos.research.ink.InkEvent.prototype.clearGmsEvent = function() {
  this.clear$Field(6);
};


/**
 * Enumeration Host.
 * @enum {number}
 */
protos.research.ink.InkEvent.Host = {
  UNKNOWN_HOST: 0,
  FISHFOOD: 1,
  KEEP: 2,
  CLASSROOM: 3,
  FIREBALL: 4
};


/**
 * Enumeration EventType.
 * @enum {number}
 */
protos.research.ink.InkEvent.EventType = {
  UNKNOWN_TYPE: 0,
  DOCUMENT_EVENT: 1,
  TOOLBAR_EVENT: 2,
  ENGINE_EVENT: 3,
  GMS_EVENT: 4
};



/**
 * Message DocumentEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clone;


/**
 * Gets the value of the event_type field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.DocumentEventType} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getEventType = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.DocumentEventType} */ (this.get$Value(1));
};


/**
 * Gets the value of the event_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.DocumentEventType} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getEventTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.DocumentEventType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the event_type field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.DocumentEventType} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setEventType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the event_type field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasEventType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the event_type field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.eventTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the event_type field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearEventType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the opened_event field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getOpenedEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} */ (this.get$Value(2));
};


/**
 * Gets the value of the opened_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getOpenedEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the opened_event field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setOpenedEvent = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the opened_event field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasOpenedEvent = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the opened_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.openedEventCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the opened_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearOpenedEvent = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the open_cancelled_event field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getOpenCancelledEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} */ (this.get$Value(3));
};


/**
 * Gets the value of the open_cancelled_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getOpenCancelledEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the open_cancelled_event field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setOpenCancelledEvent = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the open_cancelled_event field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasOpenCancelledEvent = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the open_cancelled_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.openCancelledEventCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the open_cancelled_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearOpenCancelledEvent = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the error_code field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getErrorCode = function() {
  return /** @type {?string} */ (this.get$Value(4));
};


/**
 * Gets the value of the error_code field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getErrorCodeOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the error_code field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setErrorCode = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the error_code field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasErrorCode = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the error_code field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.errorCodeCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the error_code field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearErrorCode = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the brix_error_code field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getBrixErrorCode = function() {
  return /** @type {?string} */ (this.get$Value(5));
};


/**
 * Gets the value of the brix_error_code field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getBrixErrorCodeOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the brix_error_code field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setBrixErrorCode = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the brix_error_code field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasBrixErrorCode = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the brix_error_code field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.brixErrorCodeCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the brix_error_code field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearBrixErrorCode = function() {
  this.clear$Field(5);
};


/**
 * Gets the value of the collaborator_joined_event field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getCollaboratorJoinedEvent = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} */ (this.get$Value(6));
};


/**
 * Gets the value of the collaborator_joined_event field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getCollaboratorJoinedEventOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} */ (this.get$ValueOrDefault(6));
};


/**
 * Sets the value of the collaborator_joined_event field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setCollaboratorJoinedEvent = function(value) {
  this.set$Value(6, value);
};


/**
 * @return {boolean} Whether the collaborator_joined_event field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasCollaboratorJoinedEvent = function() {
  return this.has$Value(6);
};


/**
 * @return {number} The number of values in the collaborator_joined_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.collaboratorJoinedEventCount = function() {
  return this.count$Values(6);
};


/**
 * Clears the values in the collaborator_joined_event field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearCollaboratorJoinedEvent = function() {
  this.clear$Field(6);
};


/**
 * Gets the value of the document_state field.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.DocumentState} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getDocumentState = function() {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.DocumentState} */ (this.get$Value(7));
};


/**
 * Gets the value of the document_state field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.DocumentState} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.getDocumentStateOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.DocumentState} */ (this.get$ValueOrDefault(7));
};


/**
 * Sets the value of the document_state field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.DocumentState} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.setDocumentState = function(value) {
  this.set$Value(7, value);
};


/**
 * @return {boolean} Whether the document_state field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.hasDocumentState = function() {
  return this.has$Value(7);
};


/**
 * @return {number} The number of values in the document_state field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.documentStateCount = function() {
  return this.count$Values(7);
};


/**
 * Clears the values in the document_state field.
 */
protos.research.ink.InkEvent.DocumentEvent.prototype.clearDocumentState = function() {
  this.clear$Field(7);
};


/**
 * Enumeration DocumentEventType.
 * @enum {number}
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentEventType = {
  UNKNOWN_DOCUMENT_EVENT: 0,
  CREATED: 1,
  OPENED: 2,
  OPEN_FAILED: 3,
  KICKED_USER_OUT: 4,
  OPEN_CANCELLED: 5,
  BRIX_DOCUMENT_CONNECT: 6,
  UNDO: 7,
  REDO: 8,
  COLLABORATOR_JOINED: 9,
  SEND: 10,
  ABANDON: 11,
  EXTERNAL_SHARE: 12
};



/**
 * Message OpenedEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent.OpenedEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.OpenedEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clone;


/**
 * Gets the value of the millis_until_first_byte_loaded field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMillisUntilFirstByteLoaded = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the millis_until_first_byte_loaded field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMillisUntilFirstByteLoadedOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the millis_until_first_byte_loaded field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.setMillisUntilFirstByteLoaded = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the millis_until_first_byte_loaded field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.hasMillisUntilFirstByteLoaded = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the millis_until_first_byte_loaded field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.millisUntilFirstByteLoadedCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the millis_until_first_byte_loaded field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clearMillisUntilFirstByteLoaded = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the millis_until_editable field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMillisUntilEditable = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the millis_until_editable field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMillisUntilEditableOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the millis_until_editable field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.setMillisUntilEditable = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the millis_until_editable field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.hasMillisUntilEditable = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the millis_until_editable field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.millisUntilEditableCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the millis_until_editable field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clearMillisUntilEditable = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the missing_document_bounds field.
 * @return {?boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMissingDocumentBounds = function() {
  return /** @type {?boolean} */ (this.get$Value(3));
};


/**
 * Gets the value of the missing_document_bounds field or the default value if not set.
 * @return {boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getMissingDocumentBoundsOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the missing_document_bounds field.
 * @param {boolean} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.setMissingDocumentBounds = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the missing_document_bounds field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.hasMissingDocumentBounds = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the missing_document_bounds field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.missingDocumentBoundsCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the missing_document_bounds field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clearMissingDocumentBounds = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the was_opened_by_cosmoid field.
 * @return {?boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getWasOpenedByCosmoid = function() {
  return /** @type {?boolean} */ (this.get$Value(4));
};


/**
 * Gets the value of the was_opened_by_cosmoid field or the default value if not set.
 * @return {boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getWasOpenedByCosmoidOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the was_opened_by_cosmoid field.
 * @param {boolean} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.setWasOpenedByCosmoid = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the was_opened_by_cosmoid field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.hasWasOpenedByCosmoid = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the was_opened_by_cosmoid field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.wasOpenedByCosmoidCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the was_opened_by_cosmoid field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clearWasOpenedByCosmoid = function() {
  this.clear$Field(4);
};


/**
 * Gets the value of the active_users field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getActiveUsers = function() {
  return /** @type {?string} */ (this.get$Value(5));
};


/**
 * Gets the value of the active_users field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getActiveUsersOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(5));
};


/**
 * Sets the value of the active_users field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.setActiveUsers = function(value) {
  this.set$Value(5, value);
};


/**
 * @return {boolean} Whether the active_users field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.hasActiveUsers = function() {
  return this.has$Value(5);
};


/**
 * @return {number} The number of values in the active_users field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.activeUsersCount = function() {
  return this.count$Values(5);
};


/**
 * Clears the values in the active_users field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.clearActiveUsers = function() {
  this.clear$Field(5);
};



/**
 * Message OpenCancelledEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.clone;


/**
 * Gets the value of the time_until_cancelled field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.getTimeUntilCancelled = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the time_until_cancelled field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.getTimeUntilCancelledOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the time_until_cancelled field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.setTimeUntilCancelled = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the time_until_cancelled field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.hasTimeUntilCancelled = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the time_until_cancelled field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.timeUntilCancelledCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the time_until_cancelled field.
 */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.clearTimeUntilCancelled = function() {
  this.clear$Field(1);
};



/**
 * Message CollaboratorJoined.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.clone;


/**
 * Gets the value of the is_me field.
 * @return {?boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.getIsMe = function() {
  return /** @type {?boolean} */ (this.get$Value(1));
};


/**
 * Gets the value of the is_me field or the default value if not set.
 * @return {boolean} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.getIsMeOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the is_me field.
 * @param {boolean} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.setIsMe = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the is_me field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.hasIsMe = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the is_me field.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.isMeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the is_me field.
 */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.clearIsMe = function() {
  this.clear$Field(1);
};



/**
 * Message DocumentState.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent.DocumentState, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.DocumentState} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.clone;


/**
 * Gets the value of the stroke_count field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getStrokeCount = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the stroke_count field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getStrokeCountOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the stroke_count field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.setStrokeCount = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the stroke_count field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.hasStrokeCount = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the stroke_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.strokeCountCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the stroke_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.clearStrokeCount = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the text_field field at the index given.
 * @param {number} index The index to lookup.
 * @return {?protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getTextField = function(index) {
  return /** @type {?protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} */ (this.get$Value(2, index));
};


/**
 * Gets the value of the text_field field at the index given or the default value if not set.
 * @param {number} index The index to lookup.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getTextFieldOrDefault = function(index) {
  return /** @type {!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} */ (this.get$ValueOrDefault(2, index));
};


/**
 * Adds a value to the text_field field.
 * @param {!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} value The value to add.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.addTextField = function(value) {
  this.add$Value(2, value);
};


/**
 * Returns the array of values in the text_field field.
 * @return {!Array<!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField>} The values in the field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.textFieldArray = function() {
  return /** @type {!Array<!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField>} */ (this.array$Values(2));
};


/**
 * @return {boolean} Whether the text_field field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.hasTextField = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the text_field field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.textFieldCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the text_field field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.clearTextField = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the sticker_count field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getStickerCount = function() {
  return /** @type {?string} */ (this.get$Value(3));
};


/**
 * Gets the value of the sticker_count field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getStickerCountOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the sticker_count field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.setStickerCount = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the sticker_count field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.hasStickerCount = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the sticker_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.stickerCountCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the sticker_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.clearStickerCount = function() {
  this.clear$Field(3);
};



/**
 * Message TextField.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.clone;


/**
 * Gets the value of the character_count field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getCharacterCount = function() {
  return /** @type {?string} */ (this.get$Value(1));
};


/**
 * Gets the value of the character_count field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getCharacterCountOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the character_count field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.setCharacterCount = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the character_count field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.hasCharacterCount = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the character_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.characterCountCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the character_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.clearCharacterCount = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the line_count field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getLineCount = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the line_count field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getLineCountOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the line_count field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.setLineCount = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the line_count field has a value.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.hasLineCount = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the line_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.lineCountCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the line_count field.
 */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.clearLineCount = function() {
  this.clear$Field(2);
};



/**
 * Message ToolbarEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.ToolbarEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.ToolbarEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.ToolbarEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.ToolbarEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.clone;


/**
 * Gets the value of the tool_event_type field.
 * @return {?protos.research.ink.InkEvent.ToolbarEvent.ToolEventType} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getToolEventType = function() {
  return /** @type {?protos.research.ink.InkEvent.ToolbarEvent.ToolEventType} */ (this.get$Value(1));
};


/**
 * Gets the value of the tool_event_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.ToolbarEvent.ToolEventType} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getToolEventTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.ToolbarEvent.ToolEventType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the tool_event_type field.
 * @param {!protos.research.ink.InkEvent.ToolbarEvent.ToolEventType} value The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.setToolEventType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the tool_event_type field has a value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.hasToolEventType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the tool_event_type field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.toolEventTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the tool_event_type field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.clearToolEventType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the tool_type field.
 * @return {?protos.research.ink.InkEvent.ToolbarEvent.ToolType} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getToolType = function() {
  return /** @type {?protos.research.ink.InkEvent.ToolbarEvent.ToolType} */ (this.get$Value(2));
};


/**
 * Gets the value of the tool_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.ToolbarEvent.ToolType} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getToolTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.ToolbarEvent.ToolType} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the tool_type field.
 * @param {!protos.research.ink.InkEvent.ToolbarEvent.ToolType} value The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.setToolType = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the tool_type field has a value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.hasToolType = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the tool_type field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.toolTypeCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the tool_type field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.clearToolType = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the expand_method field.
 * @return {?protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getExpandMethod = function() {
  return /** @type {?protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod} */ (this.get$Value(3));
};


/**
 * Gets the value of the expand_method field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getExpandMethodOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the expand_method field.
 * @param {!protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod} value The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.setExpandMethod = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the expand_method field has a value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.hasExpandMethod = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the expand_method field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.expandMethodCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the expand_method field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.clearExpandMethod = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the color field.
 * @return {?number} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getColor = function() {
  return /** @type {?number} */ (this.get$Value(4));
};


/**
 * Gets the value of the color field or the default value if not set.
 * @return {number} The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getColorOrDefault = function() {
  return /** @type {number} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the color field.
 * @param {number} value The value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.setColor = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the color field has a value.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.hasColor = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the color field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.colorCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the color field.
 */
protos.research.ink.InkEvent.ToolbarEvent.prototype.clearColor = function() {
  this.clear$Field(4);
};


/**
 * Enumeration ToolEventType.
 * @enum {number}
 */
protos.research.ink.InkEvent.ToolbarEvent.ToolEventType = {
  UNKNOWN_TOOL_EVENT: 0,
  TOOLBAR_EXPANDED: 1,
  TOOLBAR_EXTRA_COLORS_EXPANDED: 2,
  TOOLBAR_CONTRACTED_BY_USER: 3,
  TOOL_TYPE_CHANGED: 4,
  TOOL_COLOR_SELECTED: 5,
  TOOL_SIZE_SELECTED: 6,
  CLEAR_CANVAS: 7,
  SELECT_NONE: 8
};


/**
 * Enumeration ToolType.
 * @enum {number}
 */
protos.research.ink.InkEvent.ToolbarEvent.ToolType = {
  UNKNOWN_TOOL_TYPE: 0,
  EDIT_TOOL: 1,
  CALLIGRAPHY: 2,
  MARKER: 3,
  HIGHLIGHTER: 4,
  MAGIC_ERASER: 5
};


/**
 * Enumeration ExpandMethod.
 * @enum {number}
 */
protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod = {
  UNKNOWN_EXPAND_METHOD: 0,
  SECOND_TAP: 1,
  DRAG: 2,
  EXPAND_BUTTON_TAP: 3
};



/**
 * Message EngineEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.EngineEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.EngineEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.EngineEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.EngineEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.EngineEvent.prototype.clone;


/**
 * Gets the value of the engine_event_type field.
 * @return {?protos.research.ink.InkEvent.EngineEvent.EngineEventType} The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.getEngineEventType = function() {
  return /** @type {?protos.research.ink.InkEvent.EngineEvent.EngineEventType} */ (this.get$Value(1));
};


/**
 * Gets the value of the engine_event_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.EngineEvent.EngineEventType} The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.getEngineEventTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.EngineEvent.EngineEventType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the engine_event_type field.
 * @param {!protos.research.ink.InkEvent.EngineEvent.EngineEventType} value The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.setEngineEventType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the engine_event_type field has a value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.hasEngineEventType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the engine_event_type field.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.engineEventTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the engine_event_type field.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.clearEngineEventType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the error_code field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.getErrorCode = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the error_code field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.getErrorCodeOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the error_code field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.setErrorCode = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the error_code field has a value.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.hasErrorCode = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the error_code field.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.errorCodeCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the error_code field.
 */
protos.research.ink.InkEvent.EngineEvent.prototype.clearErrorCode = function() {
  this.clear$Field(2);
};


/**
 * Enumeration EngineEventType.
 * @enum {number}
 */
protos.research.ink.InkEvent.EngineEvent.EngineEventType = {
  UNKNOWN_ENGINE_EVENT: 0,
  LOST_GL_CONTEXT: 1,
  RAISED_FATAL_EXCEPTION: 2
};



/**
 * Message GmsEvent.
 * @constructor
 * @extends {goog.proto2.Message}
 * @final
 */
protos.research.ink.InkEvent.GmsEvent = function() {
  goog.proto2.Message.call(this);
};
goog.inherits(protos.research.ink.InkEvent.GmsEvent, goog.proto2.Message);


/**
 * Descriptor for this message, deserialized lazily in getDescriptor().
 * @private {?goog.proto2.Descriptor}
 */
protos.research.ink.InkEvent.GmsEvent.descriptor_ = null;


/**
 * Overrides {@link goog.proto2.Message#clone} to specify its exact return type.
 * @return {!protos.research.ink.InkEvent.GmsEvent} The cloned message.
 * @override
 */
protos.research.ink.InkEvent.GmsEvent.prototype.clone;


/**
 * Gets the value of the gms_event_type field.
 * @return {?protos.research.ink.InkEvent.GmsEvent.GmsEventType} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getGmsEventType = function() {
  return /** @type {?protos.research.ink.InkEvent.GmsEvent.GmsEventType} */ (this.get$Value(1));
};


/**
 * Gets the value of the gms_event_type field or the default value if not set.
 * @return {!protos.research.ink.InkEvent.GmsEvent.GmsEventType} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getGmsEventTypeOrDefault = function() {
  return /** @type {!protos.research.ink.InkEvent.GmsEvent.GmsEventType} */ (this.get$ValueOrDefault(1));
};


/**
 * Sets the value of the gms_event_type field.
 * @param {!protos.research.ink.InkEvent.GmsEvent.GmsEventType} value The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.setGmsEventType = function(value) {
  this.set$Value(1, value);
};


/**
 * @return {boolean} Whether the gms_event_type field has a value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.hasGmsEventType = function() {
  return this.has$Value(1);
};


/**
 * @return {number} The number of values in the gms_event_type field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.gmsEventTypeCount = function() {
  return this.count$Values(1);
};


/**
 * Clears the values in the gms_event_type field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.clearGmsEventType = function() {
  this.clear$Field(1);
};


/**
 * Gets the value of the time_since_connect_start field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getTimeSinceConnectStart = function() {
  return /** @type {?string} */ (this.get$Value(2));
};


/**
 * Gets the value of the time_since_connect_start field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getTimeSinceConnectStartOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(2));
};


/**
 * Sets the value of the time_since_connect_start field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.setTimeSinceConnectStart = function(value) {
  this.set$Value(2, value);
};


/**
 * @return {boolean} Whether the time_since_connect_start field has a value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.hasTimeSinceConnectStart = function() {
  return this.has$Value(2);
};


/**
 * @return {number} The number of values in the time_since_connect_start field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.timeSinceConnectStartCount = function() {
  return this.count$Values(2);
};


/**
 * Clears the values in the time_since_connect_start field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.clearTimeSinceConnectStart = function() {
  this.clear$Field(2);
};


/**
 * Gets the value of the failure_has_resolution field.
 * @return {?boolean} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getFailureHasResolution = function() {
  return /** @type {?boolean} */ (this.get$Value(3));
};


/**
 * Gets the value of the failure_has_resolution field or the default value if not set.
 * @return {boolean} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getFailureHasResolutionOrDefault = function() {
  return /** @type {boolean} */ (this.get$ValueOrDefault(3));
};


/**
 * Sets the value of the failure_has_resolution field.
 * @param {boolean} value The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.setFailureHasResolution = function(value) {
  this.set$Value(3, value);
};


/**
 * @return {boolean} Whether the failure_has_resolution field has a value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.hasFailureHasResolution = function() {
  return this.has$Value(3);
};


/**
 * @return {number} The number of values in the failure_has_resolution field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.failureHasResolutionCount = function() {
  return this.count$Values(3);
};


/**
 * Clears the values in the failure_has_resolution field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.clearFailureHasResolution = function() {
  this.clear$Field(3);
};


/**
 * Gets the value of the gms_error_code field.
 * @return {?string} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getGmsErrorCode = function() {
  return /** @type {?string} */ (this.get$Value(4));
};


/**
 * Gets the value of the gms_error_code field or the default value if not set.
 * @return {string} The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.getGmsErrorCodeOrDefault = function() {
  return /** @type {string} */ (this.get$ValueOrDefault(4));
};


/**
 * Sets the value of the gms_error_code field.
 * @param {string} value The value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.setGmsErrorCode = function(value) {
  this.set$Value(4, value);
};


/**
 * @return {boolean} Whether the gms_error_code field has a value.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.hasGmsErrorCode = function() {
  return this.has$Value(4);
};


/**
 * @return {number} The number of values in the gms_error_code field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.gmsErrorCodeCount = function() {
  return this.count$Values(4);
};


/**
 * Clears the values in the gms_error_code field.
 */
protos.research.ink.InkEvent.GmsEvent.prototype.clearGmsErrorCode = function() {
  this.clear$Field(4);
};


/**
 * Enumeration GmsEventType.
 * @enum {number}
 */
protos.research.ink.InkEvent.GmsEvent.GmsEventType = {
  CONNECT_SUCCESS: 0,
  CONNECT_FAILED: 1,
  STOPPED_WHEN_PENDING_CONNECT: 2
};


/** @override */
protos.research.ink.InkEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'InkEvent',
        fullName: 'logs.proto.research.ink.InkEvent'
      },
      1: {
        name: 'host',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.Host.UNKNOWN_HOST,
        type: protos.research.ink.InkEvent.Host
      },
      2: {
        name: 'event_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.EventType.UNKNOWN_TYPE,
        type: protos.research.ink.InkEvent.EventType
      },
      3: {
        name: 'document_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent
      },
      4: {
        name: 'toolbar_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.ToolbarEvent
      },
      5: {
        name: 'engine_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.EngineEvent
      },
      6: {
        name: 'gms_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.GmsEvent
      }
    };
    protos.research.ink.InkEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.getDescriptor =
    protos.research.ink.InkEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'DocumentEvent',
        containingType: protos.research.ink.InkEvent,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent'
      },
      1: {
        name: 'event_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.DocumentEvent.DocumentEventType.UNKNOWN_DOCUMENT_EVENT,
        type: protos.research.ink.InkEvent.DocumentEvent.DocumentEventType
      },
      2: {
        name: 'opened_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent.OpenedEvent
      },
      3: {
        name: 'open_cancelled_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent
      },
      4: {
        name: 'error_code',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      5: {
        name: 'brix_error_code',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      6: {
        name: 'collaborator_joined_event',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined
      },
      7: {
        name: 'document_state',
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent.DocumentState
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'OpenedEvent',
        containingType: protos.research.ink.InkEvent.DocumentEvent,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent.OpenedEvent'
      },
      1: {
        name: 'millis_until_first_byte_loaded',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      2: {
        name: 'millis_until_editable',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      3: {
        name: 'missing_document_bounds',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      4: {
        name: 'was_opened_by_cosmoid',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      5: {
        name: 'active_users',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent.OpenedEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.OpenedEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'OpenCancelledEvent',
        containingType: protos.research.ink.InkEvent.DocumentEvent,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent'
      },
      1: {
        name: 'time_until_cancelled',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.OpenCancelledEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'CollaboratorJoined',
        containingType: protos.research.ink.InkEvent.DocumentEvent,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent.CollaboratorJoined'
      },
      1: {
        name: 'is_me',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.CollaboratorJoined.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.DocumentState.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'DocumentState',
        containingType: protos.research.ink.InkEvent.DocumentEvent,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent.DocumentState'
      },
      1: {
        name: 'stroke_count',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      2: {
        name: 'text_field',
        repeated: true,
        fieldType: goog.proto2.Message.FieldType.MESSAGE,
        type: protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField
      },
      3: {
        name: 'sticker_count',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.DocumentState.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent.DocumentState, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.DocumentState.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'TextField',
        containingType: protos.research.ink.InkEvent.DocumentEvent.DocumentState,
        fullName: 'logs.proto.research.ink.InkEvent.DocumentEvent.DocumentState.TextField'
      },
      1: {
        name: 'character_count',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      2: {
        name: 'line_count',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.getDescriptor =
    protos.research.ink.InkEvent.DocumentEvent.DocumentState.TextField.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.ToolbarEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.ToolbarEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'ToolbarEvent',
        containingType: protos.research.ink.InkEvent,
        fullName: 'logs.proto.research.ink.InkEvent.ToolbarEvent'
      },
      1: {
        name: 'tool_event_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.ToolbarEvent.ToolEventType.UNKNOWN_TOOL_EVENT,
        type: protos.research.ink.InkEvent.ToolbarEvent.ToolEventType
      },
      2: {
        name: 'tool_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.ToolbarEvent.ToolType.UNKNOWN_TOOL_TYPE,
        type: protos.research.ink.InkEvent.ToolbarEvent.ToolType
      },
      3: {
        name: 'expand_method',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod.UNKNOWN_EXPAND_METHOD,
        type: protos.research.ink.InkEvent.ToolbarEvent.ExpandMethod
      },
      4: {
        name: 'color',
        fieldType: goog.proto2.Message.FieldType.INT32,
        type: Number
      }
    };
    protos.research.ink.InkEvent.ToolbarEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.ToolbarEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.ToolbarEvent.getDescriptor =
    protos.research.ink.InkEvent.ToolbarEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.EngineEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.EngineEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'EngineEvent',
        containingType: protos.research.ink.InkEvent,
        fullName: 'logs.proto.research.ink.InkEvent.EngineEvent'
      },
      1: {
        name: 'engine_event_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.EngineEvent.EngineEventType.UNKNOWN_ENGINE_EVENT,
        type: protos.research.ink.InkEvent.EngineEvent.EngineEventType
      },
      2: {
        name: 'error_code',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.EngineEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.EngineEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.EngineEvent.getDescriptor =
    protos.research.ink.InkEvent.EngineEvent.prototype.getDescriptor;


/** @override */
protos.research.ink.InkEvent.GmsEvent.prototype.getDescriptor = function() {
  var descriptor = protos.research.ink.InkEvent.GmsEvent.descriptor_;
  if (!descriptor) {
    // The descriptor is created lazily when we instantiate a new instance.
    var descriptorObj = {
      0: {
        name: 'GmsEvent',
        containingType: protos.research.ink.InkEvent,
        fullName: 'logs.proto.research.ink.InkEvent.GmsEvent'
      },
      1: {
        name: 'gms_event_type',
        fieldType: goog.proto2.Message.FieldType.ENUM,
        defaultValue: protos.research.ink.InkEvent.GmsEvent.GmsEventType.CONNECT_SUCCESS,
        type: protos.research.ink.InkEvent.GmsEvent.GmsEventType
      },
      2: {
        name: 'time_since_connect_start',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      },
      3: {
        name: 'failure_has_resolution',
        fieldType: goog.proto2.Message.FieldType.BOOL,
        type: Boolean
      },
      4: {
        name: 'gms_error_code',
        fieldType: goog.proto2.Message.FieldType.INT64,
        type: String
      }
    };
    protos.research.ink.InkEvent.GmsEvent.descriptor_ = descriptor =
        goog.proto2.Message.createDescriptor(
             protos.research.ink.InkEvent.GmsEvent, descriptorObj);
  }
  return descriptor;
};


/** @nocollapse */
protos.research.ink.InkEvent.GmsEvent.getDescriptor =
    protos.research.ink.InkEvent.GmsEvent.prototype.getDescriptor;
