/*
 * Decompiled with CFR 0.152.
 */
package com.squareup.haha.guava.collect;

import com.squareup.haha.guava.collect.ImmutableCollection;
import com.squareup.haha.guava.collect.ImmutableMap;
import com.squareup.haha.guava.collect.ImmutableMultiset;
import com.squareup.haha.guava.collect.Multiset;
import com.squareup.haha.guava.collect.Multisets;
import java.util.Map;
import javax.annotation.Nullable;

final class RegularImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final transient ImmutableMap<E, Integer> map;
    private final transient int size;

    RegularImmutableMultiset(ImmutableMap<E, Integer> map, int size) {
        this.map = map;
        this.size = 0;
    }

    @Override
    final boolean isPartialView() {
        return this.map.isPartialView();
    }

    @Override
    public final int count(@Nullable Object element) {
        Integer value = this.map.get(element);
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final boolean contains(@Nullable Object element) {
        return this.map.containsKey(element);
    }

    @Override
    final Multiset.Entry<E> getEntry(int index) {
        Map.Entry mapEntry = (Map.Entry)((ImmutableCollection)((Object)this.map.entrySet())).asList().get(index);
        return Multisets.immutableEntry(mapEntry.getKey(), (Integer)mapEntry.getValue());
    }

    @Override
    public final int hashCode() {
        return this.map.hashCode();
    }
}

