
// Boost Includes ==============================================================
#include <boost/python.hpp>
#include <boost/cstdint.hpp>

// Includes ====================================================================
#include <Magick++/Drawable.h>

// Using =======================================================================
using namespace boost::python;

// Declarations ================================================================
#include <Magick++.h>

namespace  {

struct Magick_DrawableGravity_Wrapper: Magick::DrawableGravity
{
    Magick_DrawableGravity_Wrapper(PyObject* py_self_, MagickLib::GravityType p0):
        Magick::DrawableGravity(p0), py_self(py_self_) {}


    PyObject* py_self;
};


}// namespace 


// Module ======================================================================
void Export_pyste_src_DrawableGravity()
{
    class_< Magick::DrawableGravity, boost::noncopyable, Magick_DrawableGravity_Wrapper >("DrawableGravity", init< MagickLib::GravityType >())
        .def("gravity", (void (Magick::DrawableGravity::*)(MagickLib::GravityType) )&Magick::DrawableGravity::gravity)
        .def("gravity", (MagickLib::GravityType (Magick::DrawableGravity::*)() const)&Magick::DrawableGravity::gravity)
    ;

}

