
#include "glcontext.h"
#include "vcache.h"
#include GL_INCLUDE

namespace visual {

void
glContext::add_pending_glDeleteList(int base, int howmany)
{
	Cache::write_lock L(list_lock);
	pending_glDeleteLists.push_back( std::make_pair(base, howmany));	
}

void 
glContext::delete_pending_lists()
{
	Cache::write_lock L( list_lock);
	for (std::vector<std::pair<int, int> >::iterator i = pending_glDeleteLists.begin();
		i != pending_glDeleteLists.end(); ++i) {
		glDeleteLists(i->first, i->second);	
	}
	pending_glDeleteLists.clear();
}

} // !namespace visual
