#ifndef VISUAL_ELLIPSOID_H
#define VISUAL_ELLIPSOID_H

// Copyright (c) 2000, 2001, 2002, 2003 by David Scherer and others.
// See the file license.txt for complete license terms.
// See the file authors.txt for a complete list of contributors.

#include "prim.h"

namespace visual {

class ellipsoid : public Primitive
{
private:
	double width;
	double height;

public:
	ellipsoid() : width(1.0), height(1.0) {}
	ellipsoid( const ellipsoid& other) 
		: Primitive( other), width( other.width), height( other.height)
	{}
		
	double get_width(){ return width; }
	void set_width( double w);
	double get_length();
	void set_length( double);
	double get_height() { return height; }
	void set_height( double);
	
	vector get_size();
	void set_size( vector v);
	void set_size_t( boost::python::object s) { this->set_size( vector(s)); }
	
	virtual vector getScale();
	virtual void glRender( rView& view);
	virtual double rayIntersect( const vector& camera, const vector& ray);

};

}

#endif // !defined VISUAL_ELLIPSOID_H
