// C++ interface wrapper code.
//
// Generated by SIP v2.5 on Fri Aug 10 18:47:41 2001
//
// Terms and Conditions
// 
// Copyright (c) 1998, 1999, 2000, 2001
// 	Phil Thompson <phil@river-bank.demon.co.uk>
// 
// Permission is hereby granted, free of charge, to any person obtaining a copy
// of this software and associated documentation files (the "Software"), to
// deal in the Software without restriction, including without limitation the
// rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
// sell copies of the Software, and to permit persons to whom the Software is
// furnished to do so, subject to the following conditions:
// 
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
// COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
// WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
// IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
// SOFTWARE.
// 
// Except as contained in this notice, the name of the copyright holder shall
// not be used in advertising or otherwise to promote the sale, use or other
// dealings in this Software without prior written authorization from the
// copyright holder.

#include "sipqtDeclqt.h"
#include "sipqtQStrList.h"


int sipCanConvertTo_QStrList(PyObject *sipPy)
{
#line 62 "qstrlist.sip"
	return PyList_Check(sipPy);
#line 42 "sipqtQStrList.cpp"
}

int sipConvertTo_QStrList(PyObject *sipPy,QStrList **sipCppPtr,int sipWillDeref,int *sipIsErr)
{
	if (*sipIsErr || sipPy == NULL)
		return 0;

#line 66 "qstrlist.sip"
	// Convert a Python list of strings to a QStrList on the heap.

	if (sipPy == Py_None)
	{
		sipCheckNone(sipWillDeref,sipIsErr,sipName_qt_QStrList);
		*sipCppPtr = NULL;

		return 0;
	}

	QStrList *qsl = new QStrList;

	for (int i = 0; i < PyList_GET_SIZE(sipPy); ++i)
	{
		char *s;

		if ((s = PyString_AsString(PyList_GET_ITEM(sipPy,i))) == NULL)
		{
			*sipIsErr = 1;
			delete qsl;

			return 0;
		}

		qsl -> append(s);
	}

	*sipCppPtr = qsl;

	return 1;
#line 81 "sipqtQStrList.cpp"
}

QStrList *sipForceConvertTo_QStrList(PyObject *valobj,int *iserrp)
{
	if (*iserrp || valobj == NULL || valobj == Py_None)
		return NULL;

	if (sipCanConvertTo_QStrList(valobj))
	{
		QStrList *val;

		sipConvertTo_QStrList(valobj,&val,0,iserrp);

		return val;
	}

	sipBadClass(sipName_qt_QStrList);

	*iserrp = 1;

	return NULL;
}

PyObject *sipConvertFrom_QStrList(const QStrList *sipCpp)
{
#line 24 "qstrlist.sip"
	// Handle no list.

	if (!sipCpp)
		return PyList_New(0);

	// Convert to a Python list of strings.

	char *s;
	int i;
	PyObject *l;

	// Create the list.

	if ((l = PyList_New(sipCpp -> count())) == NULL)
		return NULL;

	// Get it.

	i = 0;

	for (s = ((QStrList *)sipCpp) -> first(); s != NULL; s = ((QStrList *)sipCpp) -> next())
	{
		PyObject *ps;

		if ((ps = PyString_FromString(s)) == NULL || PyList_SetItem(l,i,ps) < 0)
		{
			Py_XDECREF(ps);
			Py_DECREF(l);
			return NULL;
		}

		++i;
	}

	return l;
#line 143 "sipqtQStrList.cpp"
}
