#!/www/python/bin/python

import sys
from cStringIO import StringIO
from optik import OptionParser, Option, OptionValueError, SUPPRESS_USAGE

__revision__ = "$Id: test_callback.py,v 1.8 2001/12/18 21:46:23 gward Exp $"


def process_opt (option, opt, value, parser_):
    global parser
    if opt == "-x":
        assert option._short_opts == ["-x"]
        assert option._long_opts == []
        assert parser_ is parser
        assert value is None
        assert vars(parser_.values) == {'filename': None}, \
               vars(parser_.values)
        parser_.values.x = 42
        print "ok: 1"
    elif opt == "--file":
        assert option._short_opts == ["-f"]
        assert option._long_opts == ["--file"]
        assert parser_ is parser
        assert value == "foo"
        assert vars(parser_.values) == {'filename': None, 'x': 42}, \
               vars(parser_.values)
        setattr(parser_.values, option.dest, value)
        print "ok: 2"
    else:
        print "not ok: unknown opt %r" % opt
        

parser = OptionParser(option_list=[
    Option("-x", None, action="callback", callback=process_opt),
    Option("-f", "--file", action="callback", callback=process_opt,
           type="string", dest="filename")])
(values, args) = parser.parse_args(["-x", "--file=foo"])
assert vars(values) == {'filename': "foo", 'x': 42}
assert args == []

# Callback with extra args
def process_tuple (option, opt, value, parser_, len, type):
    assert len == 3
    assert type is int

    if opt == "-p":
        assert value == "1,2,3"
    elif opt == "--point":
        assert value == "4,5,6"

    value = tuple(map(type, value.split(",")))
    getattr(parser_.values, option.dest).append(value)
    print "ok: 3"

parser.add_option("-p", "--point", action="callback",
                  callback=process_tuple, callback_args=(3, int),
                  type="string", dest="points", default=[])
(values, args) = parser.parse_args(["-p1,2,3", "--point", "4,5,6"])
assert values.points == [(1,2,3), (4,5,6)], values.points
assert args == []
print "ok: 4"


# Callback that meddles in rargs, largs
def process_n (option, opt, value, parser_):
    # option is -3, -5, etc.
    nargs = int(opt[1:])
    rargs = parser_.rargs
    if len(rargs) < nargs:
        raise OptionValueError("expected %d arguments for %s option"
                               % (nargs, opt))
    dest = parser_.values.ensure_value(option.dest, [])
    dest.append(tuple(rargs[0:nargs]))
    parser_.largs.append(nargs)
    del rargs[0:nargs]

parser = OptionParser(usage=SUPPRESS_USAGE,
                      option_list=[
    Option("-1", action="callback", callback=process_n, dest='things'),
    Option("-2", action="callback", callback=process_n, dest='things'),
    Option("-3", action="callback", callback=process_n, dest='things'),
    Option("-4", action="callback", callback=process_n, dest='things'),
    Option("-5", action="callback", callback=process_n, dest='things')])
(options, args) = parser.parse_args(["-1", "foo", "-3", "bar", "baz", "qux"])
assert len(vars(options)) == 1
assert options.things == [("foo",), ("bar", "baz", "qux")], options.things
assert args == [1, 3]
print "ok: 5"


(options, args) = parser.parse_args(["-2", "foo", "--"])
assert vars(options) == {'things': [('foo', '--')]}
assert args == [2], args
print "ok: 6"

# Callback with nargs > 1.
def process_many (option, opt, value, parser_):
    if opt == "-a":
        assert value == ("foo", "bar")
        print "ok: 7"
    elif opt == "--apple":
        assert value == ("ding", "dong")
        print "ok: 8"
    elif opt == "-b":
        assert value == (1, 2, 3)
        print "ok: 9"
    elif opt == "--bob":
        assert value == (-666, 42, 0)
        print "ok: 10"

parser = OptionParser(option_list=[
    Option("-a", "--apple",
           action="callback", callback=process_many, type="string", nargs=2),
    Option("-b", "--bob",
           action="callback", callback=process_many, type="int", nargs=3),
    ])
(values, args) = parser.parse_args(["-a", "foo", "bar",
                                    "--apple", "ding", "dong",
                                    "-b", "1", "2", "3",
                                    "--bob", "-666", "42", "0"])
assert len(vars(values)) == 0
assert args == []
print "ok: 11"

    
                  
# Test that an abbreviated long option is expanded when passed to the
# callback.

def check_abbrev (option, opt, value, parser):
    assert opt == "--foo-bar", opt
    print "ok: 12"

parser = OptionParser()
parser.add_option("--foo-bar", action="callback", callback=check_abbrev)
(values, args) = parser.parse_args(["--foo"])
assert vars(values) == {}
assert args == []
print "ok: 13"


# Test a callback for variable arguments (from callback.txt).

def varargs (option, opt, value, parser):
    assert value is None
    done = 0
    value = []
    rargs = parser.rargs
    while rargs:
        arg = rargs[0]
        if ((arg[:2] == "--" and len(arg) > 2) or
            (arg[:1] == "-" and len(arg) > 1 and arg[1] != "-")):
            break
        else:
            value.append(arg)
            del rargs[0]

    setattr(parser.values, option.dest, value)

parser = OptionParser(usage=SUPPRESS_USAGE)
parser.add_option("-a", type="int", nargs=2, dest="a")
parser.add_option("-b", action="store_true", dest="b")
parser.add_option("-c", "--callback",
                  action="callback", callback=varargs, dest="c")

(options, args) = parser.parse_args(["-a3", "-5", "--callback", "foo", "bar"])
assert len(vars(options)) == 3
assert args == [], args
assert options.a == (3, -5)
assert options.b is None
assert options.c == ["foo", "bar"]
print "ok: 14"

(options, args) = parser.parse_args(["-c", "37", "--", "xxx", "-b", "hello"])
assert len(vars(options)) == 3
assert args == ["hello"], args
assert options.a is None
assert options.b
assert options.c == ["37", "--", "xxx"]
print "ok: 15"

(options, args) = parser.parse_args(["hello", "-c", "foo", "-", "bar"])
assert len(vars(options)) == 3
assert args == ["hello"], args
assert options.a is None
assert options.b is None
assert options.c == ["foo", "-", "bar"]
print "ok: 16"

(options, args) = parser.parse_args(["-c", "foo", "-b"])
assert len(vars(options)) == 3
assert args == [], args
assert options.a is None
assert options.b
assert options.c == ["foo"]
print "ok: 17"

try:
    (options, args) = parser.parse_args(["-c", "3", "-5", "-a"])
except SystemExit, err:
    assert err.args[0].endswith("no such option: -5"), err
    print "ok: 18"
else:
    print "not ok"
