

from oglpm import *

class Att_Obj:
    def __init__(self,location=(0,0,0),rotation=(0,0,0,1),scale=(1,1,1),parent=None):
        self.x = location[0]
        self.y = location[1]
        self.z = location[2]
        self.m = identity(4)
        self.origin = array([0,0,0,1])
        self.worldposition = (self.x,self.y,self.z,1)
        self.rotation_angle = rotation[0]   
        self.rotation_vector_x = rotation[1]  
        self.rotation_vector_y =  rotation [2] 
        self.rotation_vector_z =  rotation[3]  
        self.rotation_delta = 0
        self.scalex = scale[0]
        self.scaley = scale[1]
        self.scalez = scale[2]
        self.it = 0
        self.parent = parent
        self.children = []
        
    def addchild(self,child):
        self.children.append(child)
        child.parent = self
        
    def removechild(self,child):
        for i in range(len(self.children)):
            if self.children[i] == child:
                self.children = self.children[:i-1]+ self.children[i+1:]
                break
           
    def draw(self):
        pass
        
    def att_draw(self):
        glPushMatrix()
        glTranslate(self.x,self.y,self.z)
        glRotate(self.rotation_angle,self.rotation_vector_x,self.rotation_vector_y,self.rotation_vector_z)
        self.rotation_angle = (self.rotation_angle+self.rotation_delta)%360
        glScale(self.scalex,self.scaley,self.scalez)
        self.m = glGetDoublev(GL_MODELVIEW_MATRIX)
        self.worldposition = dot(self.origin,self.m)
        if self.it:
##            print self.m,self.worldposition
            self.it = 0
            glBegin(GL_POINTS)
            glColor3f(1.0,0.0,0.0)
            glVertex3f(0.0,0.0,0.0)
        glEnd()
        self.draw()
        for child in self.children:
            child.att_draw()
        glPopMatrix()
       
class Gate(Att_Obj):
    def __init__(self,location = (0,0,0)):
        Att_Obj.__init__(self,location)
        self.gl = Quads(4)
        self.gl.addquad(-3,0,-3,-2,0,-3,-2,0,3,-3,0,3)
        self.gl.addquad(2,0,-3,3,0,-3,3,0,3,2,0,3)
	
    def draw(self):
        self.gl.draw()	
   	
class Room(Att_Obj):
    def __init__(self,location = (0,0,0)):
        Att_Obj.__init__(self,location)
        self.gl = Quads(10)
        c = ((-5,-5),(5,-5),(5,5),(-5,5))	
        h  = 4
        self.gl.addquad(c[0][0],c[0][1],0,c[1][0],c[1][1],0,c[2][0],c[2][1],0,c[3][0],c[3][1],0)
        self.gl.addquad(c[0][0],c[0][1],h,c[1][0],c[1][1],h,c[2][0],c[2][1],h,c[3][0],c[3][1],h)
	
    def draw(self):
        self.gl.draw()	
	
	
        
