
##############################################################################
#
# Copyright (c) 2003-2016 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2016 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"


__author__="Lutz Gross, l.gross@uq.edu.au"

import esys.escriptcore.utestselect as unittest
from esys.escript import *
from esys.escript.linearPDEs import LinearPDE

class Test_assemblage_3Do1(unittest.TestCase):
  def setNormal(self,fs):
     out=Vector(0.,fs)
     out.setTaggedValue(200,[0,0,1])
     out.setTaggedValue(100,[0,0,-1])
     out.setTaggedValue(20,[0,1,0])
     out.setTaggedValue(10,[0,-1,0])
     out.setTaggedValue(2,[1,0,0])
     out.setTaggedValue(1,[-1,0,0])
     return out
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=1-6*x[2]-1*x[1]-3*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,0]=7
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*((-21))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=2-7*x[2]+2*x[1]-7*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,1]=7
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*(14)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=7-5*x[2]+x[1]-5*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,2]=4
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*((-20))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=2-5*x[2]-8*x[1]+6*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,0]=7
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=(-4)+4*x[2]+2*x[1]-6*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,1]=8
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*(16)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=(-7)-1*x[2]+5*x[1]+x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,2]=6
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=4+2*x[2]+8*x[1]-1*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,0]=1
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*((-1))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=(-5)-5*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,1]=8
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*((-56))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=7-4*x[2]+8*x[1]-4*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,2]=4
    Y_test=0
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*((-16))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeStrong_comp0(self):
    x=self.domain.getX()
    u=(-3)+x[2]-3*x[1]-1*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[0]=5
    Y_test=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*((-15)+5*x[2]-15*x[1]-5*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeStrong_comp1(self):
    x=self.domain.getX()
    u=(-5)+7*x[2]+2*x[1]+4*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[1]=2
    Y_test=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*((-10)+14*x[2]+4*x[1]+8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeStrong_comp2(self):
    x=self.domain.getX()
    u=7-8*x[2]-3*x[1]-8*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[2]=4
    Y_test=32
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*(28-32*x[2]-12*x[1]-32*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Const_typeStrong_comp0(self):
    x=self.domain.getX()
    u=8+2*x[2]+2*x[1]-5*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[0]=8
    Y_test=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Const_typeStrong_comp1(self):
    x=self.domain.getX()
    u=8-5*x[2]+4*x[1]-6*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[1]=2
    Y_test=8
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Const_typeStrong_comp2(self):
    x=self.domain.getX()
    u=8-4*x[2]+2*x[1]+2*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[2]=7
    Y_test=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_D_Const_typeStrong(self):
    x=self.domain.getX()
    u=7+x[2]-8*x[1]-6*x[0]
    D_test=Data(6,(),Function(self.domain))
    Y_test=42+6*x[2]-48*x[1]-36*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_d_Const_typeStrong(self):
    x=self.domain.getX()
    u=(-4)+2*x[2]-9*x[1]+2*x[0]
    d_test=Data(8,(),FunctionOnBoundary(self.domain))
    y_test=(-32)+16*x[2]-72*x[1]+16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=4-9*x[2]-6*x[1]+x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,0]=x[0]
    Y_test=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*(x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=6-7*x[2]-1*x[1]-8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,1]=x[0]
    Y_test=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*((-1)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp02(self):
    x=self.domain.getX()
    u=(-6)-2*x[2]-8*x[1]+x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,2]=x[0]
    Y_test=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=(-2)-7*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,0]=x[1]
    Y_test=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=7-5*x[2]+7*x[1]-5*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,1]=x[1]
    Y_test=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp12(self):
    x=self.domain.getX()
    u=6-9*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,2]=x[1]
    Y_test=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp20(self):
    x=self.domain.getX()
    u=(-2)+2*x[2]+5*x[1]+x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,0]=x[2]
    Y_test=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp21(self):
    x=self.domain.getX()
    u=1+7*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,1]=x[2]
    Y_test=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeStrong_comp22(self):
    x=self.domain.getX()
    u=3-5*x[2]-7*x[1]+8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,2]=x[2]
    Y_test=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*((-5)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeStrong_comp0(self):
    x=self.domain.getX()
    u=5+2*x[2]+4*x[1]+4*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[0]=x[0]
    Y_test=(-5)-2*x[2]-4*x[1]-8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[0]*(5*x[0]+2*x[0]*x[2]+4*x[0]*x[1]+4*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeStrong_comp1(self):
    x=self.domain.getX()
    u=(-2)+8*x[2]-6*x[1]-5*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[1]=x[1]
    Y_test=2-8*x[2]+12*x[1]+5*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[1]*((-2)*x[1]+8*x[1]*x[2]-6*x[1]**2-5*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeStrong_comp2(self):
    x=self.domain.getX()
    u=(-5)-2*x[2]+4*x[1]-4*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[2]=x[2]
    Y_test=5+4*x[2]-4*x[1]+4*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*((-5)*x[2]-2*x[2]**2+4*x[1]*x[2]-4*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Vario_typeStrong_comp0(self):
    x=self.domain.getX()
    u=5-4*x[2]+5*x[1]-2*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[0]=x[0]
    Y_test=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Vario_typeStrong_comp1(self):
    x=self.domain.getX()
    u=7-3*x[2]+2*x[1]-9*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[1]=x[1]
    Y_test=2*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_C_Vario_typeStrong_comp2(self):
    x=self.domain.getX()
    u=3-2*x[2]-3*x[1]-4*x[0]
    C_test=Data(0.,(3,),Function(self.domain))
    C_test[2]=x[2]
    Y_test=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_D_Vario_typeStrong(self):
    x=self.domain.getX()
    u=(-5)
    D_test=Function(self.domain).getX()[0]
    Y_test=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_d_Vario_typeStrong(self):
    x=self.domain.getX()
    u=8
    d_test=interpolate(x[0],FunctionOnBoundary(self.domain))
    y_test=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp00(self):
    x=self.domain.getX()
    u=8+2*x[2]-7*x[1]-2*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,0]=7
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-14)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp01(self):
    x=self.domain.getX()
    u=5-2*x[2]-4*x[1]-4*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,1]=8
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-32)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp02(self):
    x=self.domain.getX()
    u=(-5)+6*x[2]-4*x[1]-7*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,2]=1
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp10(self):
    x=self.domain.getX()
    u=(-7)-7*x[2]+4*x[1]-4*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,0]=7
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp11(self):
    x=self.domain.getX()
    u=(-1)+7*x[2]-7*x[1]+8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,1]=5
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp12(self):
    x=self.domain.getX()
    u=(-9)+4*x[2]-1*x[1]-3*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,2]=6
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp20(self):
    x=self.domain.getX()
    u=(-8)+8*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,0]=1
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp21(self):
    x=self.domain.getX()
    u=(-9)-8*x[2]-6*x[1]-8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,1]=3
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Const_typeWeak_comp22(self):
    x=self.domain.getX()
    u=(-8)+8*x[2]-2*x[1]-9*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,2]=3
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeWeak_comp0(self):
    x=self.domain.getX()
    u=2-6*x[2]+3*x[1]+4*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[0]=4
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=8-24*x[2]+12*x[1]+16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeWeak_comp1(self):
    x=self.domain.getX()
    u=1+2*x[2]+2*x[1]+3*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[1]=7
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=7+14*x[2]+14*x[1]+21*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Const_typeWeak_comp2(self):
    x=self.domain.getX()
    u=5+3*x[2]-2*x[1]+2*x[0]
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[2]=6
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=30+18*x[2]-12*x[1]+12*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp00(self):
    x=self.domain.getX()
    u=(-5)-2*x[2]+4*x[1]-1*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,0]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp01(self):
    x=self.domain.getX()
    u=(-4)-1*x[2]-1*x[1]-7*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,1]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp02(self):
    x=self.domain.getX()
    u=(-6)+2*x[2]+5*x[1]-6*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[0,2]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp10(self):
    x=self.domain.getX()
    u=4-9*x[2]+2*x[1]-8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,0]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp11(self):
    x=self.domain.getX()
    u=6-8*x[2]-6*x[1]-4*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,1]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-6)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp12(self):
    x=self.domain.getX()
    u=4+8*x[2]-5*x[1]-8*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[1,2]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp20(self):
    x=self.domain.getX()
    u=2-4*x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,0]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp21(self):
    x=self.domain.getX()
    u=6+x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,1]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_A_Vario_typeWeak_comp22(self):
    x=self.domain.getX()
    u=(-7)-5*x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(3,3),Function(self.domain))
    A_test[2,2]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeWeak_comp0(self):
    x=self.domain.getX()
    u=(-6)
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[0]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeWeak_comp1(self):
    x=self.domain.getX()
    u=3
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[1]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu1_B_Vario_typeWeak_comp2(self):
    x=self.domain.getX()
    u=1
    B_test=Data(0.,(3,),Function(self.domain))
    B_test[2]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]+5*x[1]-4*x[0]
    u[1]=4+8*x[2]+3*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-20))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-5*x[1]+7*x[0]
    u[1]=3-2*x[2]+x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+6*x[2]+x[1]-5*x[0]
    u[1]=2-3*x[2]+2*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,2]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+7*x[1]-4*x[0]
    u[1]=(-7)-6*x[2]+8*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+3*x[2]-2*x[1]-4*x[0]
    u[1]=7+5*x[2]+6*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-7*x[2]-9*x[1]+7*x[0]
    u[1]=7-7*x[2]+7*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,2]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-21))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+2*x[2]-5*x[1]-5*x[0]
    u[1]=(-8)+6*x[2]+4*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-35))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+x[2]-4*x[1]+4*x[0]
    u[1]=(-7)-7*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-28))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+7*x[2]-5*x[1]+7*x[0]
    u[1]=6-4*x[2]-6*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,2]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(49)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-8*x[2]+2*x[1]+3*x[0]
    u[1]=(-5)-7*x[2]+x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]+7*x[1]-3*x[0]
    u[1]=(-5)+8*x[2]+x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-5*x[1]-1*x[0]
    u[1]=(-4)+x[2]+x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,2]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(1)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]+2*x[1]-2*x[0]
    u[1]=3-8*x[2]+5*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-1*x[2]-9*x[1]-7*x[0]
    u[1]=1-2*x[2]-4*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-4*x[2]-8*x[1]-2*x[0]
    u[1]=1-3*x[2]+2*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,2]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-16))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+5*x[2]-3*x[1]+5*x[0]
    u[1]=5-7*x[2]-3*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-8*x[2]+3*x[1]+x[0]
    u[1]=(-3)+x[2]-6*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-30))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-5*x[2]+2*x[1]+8*x[0]
    u[1]=8-9*x[2]-4*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-72))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-4*x[2]+x[1]+2*x[0]
    u[1]=7-2*x[2]+8*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-7*x[2]-8*x[1]-3*x[0]
    u[1]=7+8*x[2]-7*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-32))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+6*x[2]+4*x[1]-9*x[0]
    u[1]=8+8*x[2]-1*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(48)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]-2*x[1]+3*x[0]
    u[1]=(-7)+7*x[2]+5*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-9))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+4*x[2]+5*x[1]-2*x[0]
    u[1]=(-3)-3*x[2]-3*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-2*x[2]-4*x[1]+5*x[0]
    u[1]=(-9)-1*x[2]+3*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+3*x[2]+7*x[1]+x[0]
    u[1]=2+8*x[2]-4*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,0]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-9*x[1]-7*x[0]
    u[1]=(-4)-6*x[2]-9*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-18))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-9*x[2]-7*x[1]-5*x[0]
    u[1]=3+7*x[2]-5*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-72))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-1*x[2]+8*x[1]-1*x[0]
    u[1]=(-5)+4*x[2]-6*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-5*x[2]-1*x[1]-6*x[0]
    u[1]=8-5*x[2]-8*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-64))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+6*x[2]+5*x[1]+7*x[0]
    u[1]=(-5)-8*x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,2]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-40))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]+5*x[1]+8*x[0]
    u[1]=(-5)-9*x[2]-3*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]+6*x[1]-5*x[0]
    u[1]=5-5*x[2]+x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]-6*x[1]+6*x[0]
    u[1]=(-3)+x[2]-9*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,2]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-7*x[2]+4*x[1]+3*x[0]
    u[1]=(-6)+3*x[2]+8*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-9*x[2]+3*x[1]-2*x[0]
    u[1]=(-3)+8*x[2]-9*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+4*x[2]+3*x[1]+4*x[0]
    u[1]=(-7)-8*x[2]-5*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,2]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-16))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+x[2]+4*x[1]-4*x[0]
    u[1]=3+2*x[2]-9*x[1]-2*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=12
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-9)+3*x[2]+12*x[1]-12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+6*x[2]-3*x[1]-7*x[0]
    u[1]=(-4)-5*x[2]-4*x[1]-7*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=28
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-16)-20*x[2]-16*x[1]-28*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]+4*x[1]-8*x[0]
    u[1]=4+x[2]+5*x[1]+8*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,0]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-16)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-36)+32*x[2]+16*x[1]-32*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-5*x[2]+8*x[1]-1*x[0]
    u[1]=8-4*x[2]-6*x[1]+2*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=18
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(24-12*x[2]-18*x[1]+6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-8*x[2]-1*x[1]+4*x[0]
    u[1]=(-1)-3*x[2]+7*x[1]-6*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=16
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(8-16*x[2]-2*x[1]+8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-8*x[2]-1*x[1]-3*x[0]
    u[1]=(-8)-8*x[2]-2*x[1]-1*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=24
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-24)-24*x[2]-6*x[1]-3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-7*x[2]-8*x[1]-8*x[0]
    u[1]=8-2*x[2]+2*x[1]+5*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-1)-7*x[2]-8*x[1]-8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-3*x[2]-3*x[1]-4*x[0]
    u[1]=1-8*x[2]+3*x[1]-4*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=28
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(7-56*x[2]+21*x[1]-28*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]+8*x[1]-4*x[0]
    u[1]=(-6)-2*x[2]+x[1]+8*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-24)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(21+24*x[2]+24*x[1]-12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+2*x[2]-1*x[1]+6*x[0]
    u[1]=5+3*x[2]-8*x[1]+6*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=24
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(15+9*x[2]-24*x[1]+18*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]-7*x[1]-1*x[0]
    u[1]=(-9)-4*x[2]+2*x[1]+3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=14
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(14-14*x[2]-14*x[1]-2*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+x[2]-9*x[1]-8*x[0]
    u[1]=(-5)-8*x[2]+7*x[1]+7*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=32
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-20)-32*x[2]+28*x[1]+28*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]-1*x[1]-2*x[0]
    u[1]=(-2)-8*x[2]+7*x[1]-9*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-10)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-9*x[2]-7*x[1]+3*x[0]
    u[1]=(-2)-8*x[2]-4*x[1]+3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-14)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-3*x[2]-4*x[1]-7*x[0]
    u[1]=(-5)-8*x[2]+8*x[1]-6*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,2]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-6*x[2]+2*x[1]-7*x[0]
    u[1]=2-2*x[2]-7*x[1]-3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]+2*x[1]-4*x[0]
    u[1]=4-7*x[2]-9*x[1]+8*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-63)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-5*x[1]-3*x[0]
    u[1]=(-6)+x[2]+6*x[1]+3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,2]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-7*x[2]-2*x[1]+3*x[0]
    u[1]=7-1*x[2]-6*x[1]+4*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=9
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+6*x[2]-3*x[1]-3*x[0]
    u[1]=4-8*x[2]+2*x[1]-2*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,1]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+3*x[2]-3*x[1]+3*x[0]
    u[1]=6+4*x[2]-8*x[1]-8*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-7*x[2]-7*x[1]-6*x[0]
    u[1]=(-6)-9*x[2]-2*x[1]-9*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-63)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+7*x[2]+5*x[1]-6*x[0]
    u[1]=8-8*x[2]+5*x[1]+8*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,1]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=30
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+2*x[2]+2*x[1]+x[0]
    u[1]=(-3)-7*x[2]+2*x[1]-8*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,2]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]+x[1]+7*x[0]
    u[1]=(-6)-2*x[2]+3*x[1]+6*x[0]
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[0,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)+7*x[2]+x[1]+7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-9*x[2]+4*x[1]-5*x[0]
    u[1]=(-8)-2*x[2]+7*x[1]-1*x[0]
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-16)-4*x[2]+14*x[1]-2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-5*x[1]+2*x[0]
    u[1]=7-5*x[2]-2*x[1]+2*x[0]
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[1,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)+14*x[2]-10*x[1]+4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-9*x[2]-7*x[1]+4*x[0]
    u[1]=2-3*x[2]-3*x[1]+5*x[0]
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[1,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=14-21*x[2]-21*x[1]+35*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-6*x[2]+8*x[1]+8*x[0]
    u[1]=(-1)-3*x[2]+5*x[1]+x[0]
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[0,0]=5
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=(-15)-30*x[2]+40*x[1]+40*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]-3*x[1]-1*x[0]
    u[1]=(-8)+5*x[2]+7*x[1]-2*x[0]
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[0,1]=1
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=(-8)+5*x[2]+7*x[1]-2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-9*x[2]+4*x[1]+4*x[0]
    u[1]=5+7*x[2]-4*x[1]-9*x[0]
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[1,0]=6
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=42-54*x[2]+24*x[1]+24*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-3*x[2]-7*x[1]-3*x[0]
    u[1]=(-2)-6*x[2]-6*x[1]+4*x[0]
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[1,1]=2
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=(-4)-12*x[2]-12*x[1]+8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+8*x[2]+2*x[1]+x[0]
    u[1]=(-6)+2*x[2]+5*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]-2*x[1]-3*x[0]
    u[1]=(-6)+2*x[2]-2*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-7*x[2]+7*x[1]+3*x[0]
    u[1]=(-3)-3*x[2]-8*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-7)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+x[2]-6*x[1]-8*x[0]
    u[1]=2-4*x[2]+2*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-7)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-5*x[2]+5*x[1]+6*x[0]
    u[1]=(-8)-2*x[2]+5*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(5*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-8*x[2]+8*x[1]+4*x[0]
    u[1]=(-7)+8*x[2]+6*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-1*x[1]+7*x[0]
    u[1]=(-4)-4*x[2]-3*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]+8*x[1]-7*x[0]
    u[1]=8-9*x[2]+7*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(8*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-1*x[2]+8*x[1]+x[0]
    u[1]=2-6*x[2]-8*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-2*x[2]-8*x[1]+7*x[0]
    u[1]=(-1)+8*x[2]-8*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-7)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+x[2]-1*x[1]+x[0]
    u[1]=2+6*x[2]-9*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+3*x[2]+2*x[1]-5*x[0]
    u[1]=3+7*x[2]-5*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+2*x[2]-6*x[1]+5*x[0]
    u[1]=3-9*x[2]+5*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(5*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8+x[2]-1*x[1]-4*x[0]
    u[1]=(-4)-9*x[2]+5*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-1)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+6*x[2]-1*x[1]+3*x[0]
    u[1]=(-8)-3*x[2]+x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(6*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]+x[1]+x[0]
    u[1]=(-4)+7*x[2]-9*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]-9*x[1]+8*x[0]
    u[1]=(-8)-5*x[2]-4*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]-9*x[1]-6*x[0]
    u[1]=(-4)-5*x[2]+8*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-5)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+5*x[1]+7*x[0]
    u[1]=6+7*x[2]+6*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]+6*x[1]+5*x[0]
    u[1]=7-4*x[2]-3*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-6*x[1]+2*x[0]
    u[1]=(-3)-5*x[2]-5*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-1)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-8*x[1]-3*x[0]
    u[1]=(-4)+6*x[2]-5*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+6*x[2]-3*x[1]-3*x[0]
    u[1]=(-8)+3*x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+x[2]+6*x[1]-6*x[0]
    u[1]=2+8*x[2]-9*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]-2*x[1]-7*x[0]
    u[1]=3+8*x[2]-6*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-7)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]-1*x[1]+x[0]
    u[1]=(-4)-2*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+5*x[2]+4*x[1]+5*x[0]
    u[1]=3-1*x[2]+4*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(5*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-2*x[2]-1*x[1]+5*x[0]
    u[1]=(-2)+x[2]-8*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-5)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-7*x[2]+7*x[1]+6*x[0]
    u[1]=3+6*x[2]+7*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]+x[1]-7*x[0]
    u[1]=(-7)+3*x[2]+5*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(3*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8+4*x[2]-5*x[1]-6*x[0]
    u[1]=1-5*x[2]+5*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-6)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+4*x[2]+7*x[1]-8*x[0]
    u[1]=5+x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-2*x[2]+6*x[1]+6*x[0]
    u[1]=2+8*x[2]+2*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-2)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]-2*x[1]-8*x[0]
    u[1]=(-4)-4*x[2]+8*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(5*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]+x[1]+3*x[0]
    u[1]=1-4*x[2]-4*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+6*x[2]+2*x[1]+x[0]
    u[1]=(-9)+7*x[2]-9*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)-1*x[2]-4*x[1]-9*x[0]
    u[1]=(-4)+3*x[2]-6*x[1]+5*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=5+x[2]+4*x[1]+18*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-5)*x[0]-1*x[0]*x[2]-4*x[0]*x[1]-9*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-9*x[2]+5*x[1]+2*x[0]
    u[1]=4-1*x[2]+x[1]-4*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)+x[2]-1*x[1]+8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(4*x[0]-1*x[0]*x[2]+x[0]*x[1]-4*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+5*x[2]+3*x[1]+6*x[0]
    u[1]=(-1)-9*x[2]-5*x[1]+8*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)-5*x[2]-6*x[1]-6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(5*x[1]+5*x[1]*x[2]+3*x[1]**2+6*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]+2*x[1]+4*x[0]
    u[1]=(-2)-9*x[2]+4*x[1]+6*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=2+9*x[2]-8*x[1]-6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-2)*x[1]-9*x[1]*x[2]+4*x[1]**2+6*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]-9*x[1]-1*x[0]
    u[1]=3-4*x[2]-9*x[1]-9*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=7+12*x[2]+9*x[1]+x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-7)*x[2]-6*x[2]**2-9*x[1]*x[2]-1*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]+8*x[1]+x[0]
    u[1]=(-6)+8*x[2]+8*x[1]+5*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=6-16*x[2]-8*x[1]-5*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6)*x[2]+8*x[2]**2+8*x[1]*x[2]+5*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]+2*x[1]-9*x[0]
    u[1]=(-5)-1*x[2]-1*x[1]-1*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)-4*x[2]-2*x[1]+18*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6*x[0]+4*x[0]*x[2]+2*x[0]*x[1]-9*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+8*x[1]+2*x[0]
    u[1]=5+3*x[2]-8*x[1]-3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)-3*x[2]+8*x[1]+6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(5*x[0]+3*x[0]*x[2]-8*x[0]*x[1]-3*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]-4*x[1]-1*x[0]
    u[1]=(-8)+x[2]+5*x[1]+3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=1+9*x[2]+8*x[1]+x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1]-9*x[1]*x[2]-4*x[1]**2-1*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]-2*x[1]+6*x[0]
    u[1]=(-7)-1*x[2]+2*x[1]+2*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=7+x[2]-4*x[1]-2*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-7)*x[1]-1*x[1]*x[2]+2*x[1]**2+2*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+6*x[2]+8*x[1]-5*x[0]
    u[1]=3+3*x[2]-8*x[1]-3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=3-12*x[2]-8*x[1]+5*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-3)*x[2]+6*x[2]**2+8*x[1]*x[2]-5*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]-3*x[1]-8*x[0]
    u[1]=2-3*x[2]-6*x[1]+3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)+6*x[2]+6*x[1]-3*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(2*x[2]-3*x[2]**2-6*x[1]*x[2]+3*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+6*x[2]-4*x[1]-7*x[0]
    u[1]=4-6*x[2]-1*x[1]+4*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]+8*x[1]-2*x[0]
    u[1]=3-9*x[2]+8*x[1]-9*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+8*x[2]+4*x[1]-9*x[0]
    u[1]=(-1)+7*x[2]+x[1]-8*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+7*x[1]+5*x[0]
    u[1]=7-6*x[2]-5*x[1]-3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+6*x[2]-5*x[1]-3*x[0]
    u[1]=(-5)-6*x[2]-7*x[1]-9*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+5*x[2]+8*x[1]+6*x[0]
    u[1]=6-4*x[2]-3*x[1]-1*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[0,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-8*x[2]+2*x[1]+x[0]
    u[1]=4-1*x[2]+8*x[1]-3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-5*x[2]-7*x[1]+4*x[0]
    u[1]=3+8*x[2]-8*x[1]-2*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]-6*x[1]-9*x[0]
    u[1]=1+7*x[2]+3*x[1]-6*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=4*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+6*x[2]+7*x[1]+8*x[0]
    u[1]=3-6*x[2]-8*x[1]-2*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-5*x[2]-3*x[1]-9*x[0]
    u[1]=(-7)-9*x[2]+6*x[1]+3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=6*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_C_Vario_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]+x[1]+6*x[0]
    u[1]=(-3)-8*x[2]-1*x[1]+3*x[0]
    C_test=Data(0.,(2,2,3),Function(self.domain))
    C_test[1,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=4
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-2)
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-9)
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_D_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-8)
    D_test=Data(0.,(2,2),Function(self.domain))
    D_test[1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3
    u[1]=1
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[0,0]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)
    u[1]=6
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[0,1]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=(-8)
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[1,0]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_d_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=2
    d_test=Data(0.,(2,2),FunctionOnBoundary(self.domain))
    d_test[1,1]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+6*x[2]-8*x[1]+3*x[0]
    u[1]=(-2)-3*x[2]+7*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=3
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]+5*x[1]+4*x[0]
    u[1]=8+3*x[2]+x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,1]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=25
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-3*x[2]+8*x[1]-6*x[0]
    u[1]=3+3*x[2]-3*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]-2*x[1]+x[0]
    u[1]=(-6)-2*x[2]+7*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]+8*x[1]-6*x[0]
    u[1]=(-5)-4*x[2]-1*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,1]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+4*x[2]+8*x[1]+4*x[0]
    u[1]=7-5*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,2]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+2*x[2]-8*x[1]-8*x[0]
    u[1]=2+5*x[2]+3*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,0]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-64)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+3*x[2]-1*x[1]+7*x[0]
    u[1]=(-1)-2*x[2]+7*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,1]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+7*x[1]+4*x[0]
    u[1]=6+7*x[2]+6*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,2]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=40
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]-1*x[1]+7*x[0]
    u[1]=2-1*x[2]-8*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]+x[1]-4*x[0]
    u[1]=5+3*x[2]-7*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+7*x[2]+3*x[1]+3*x[0]
    u[1]=7-8*x[2]-5*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,2]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-48)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+6*x[2]+6*x[1]+8*x[0]
    u[1]=(-6)-5*x[2]+6*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,0]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=64
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]+4*x[1]-1*x[0]
    u[1]=(-2)+7*x[2]-5*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]-3*x[1]-5*x[0]
    u[1]=1-7*x[2]+4*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=20
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+8*x[1]-2*x[0]
    u[1]=5+2*x[2]+6*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=18
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-3*x[2]+4*x[1]+2*x[0]
    u[1]=(-1)-3*x[2]+5*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,1]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=10
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+x[2]+3*x[1]+7*x[0]
    u[1]=7+8*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,2]=4
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=32
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-8*x[2]-1*x[1]-3*x[0]
    u[1]=5+x[2]+7*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+x[2]-6*x[1]-3*x[0]
    u[1]=7+6*x[2]-2*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,1]=4
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+3*x[2]+7*x[1]+x[0]
    u[1]=(-3)-7*x[2]+6*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,2]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=9
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+3*x[2]+8*x[1]-2*x[0]
    u[1]=(-3)+3*x[2]+8*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=35
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+7*x[1]-2*x[0]
    u[1]=5-4*x[2]-5*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-5)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+7*x[2]+2*x[1]+7*x[0]
    u[1]=7-8*x[2]+3*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,2]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-48)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]+3*x[1]+4*x[0]
    u[1]=3+4*x[2]+2*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,0]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=12
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+4*x[2]-9*x[1]-4*x[0]
    u[1]=(-3)+5*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-54)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+8*x[2]+x[1]-8*x[0]
    u[1]=8-6*x[2]-8*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,2]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=56
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]-7*x[1]+7*x[0]
    u[1]=(-7)-4*x[2]-5*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,0]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=18
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+2*x[2]+4*x[1]-7*x[0]
    u[1]=4+6*x[2]-1*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-1)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]+x[1]-8*x[0]
    u[1]=7+8*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=40
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-5*x[2]-5*x[1]+x[0]
    u[1]=6+3*x[2]-3*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,0]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=3
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+4*x[1]-9*x[0]
    u[1]=2-1*x[2]+5*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+8*x[2]-8*x[1]-9*x[0]
    u[1]=(-5)-3*x[2]-1*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,2]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+2*x[2]-1*x[1]+x[0]
    u[1]=1-3*x[2]+x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,0]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=42
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]-5*x[1]-1*x[0]
    u[1]=(-1)+8*x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=49
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Const_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+3*x[2]-9*x[1]-3*x[0]
    u[1]=(-7)+2*x[2]-1*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,2]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=14
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+2*x[2]-3*x[1]+3*x[0]
    u[1]=(-8)-2*x[2]-9*x[1]-9*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=18+12*x[2]-18*x[1]+18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]-1*x[1]-9*x[0]
    u[1]=(-8)-5*x[2]-6*x[1]-2*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,1]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-64)-40*x[2]-48*x[1]-16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+6*x[2]-5*x[1]+6*x[0]
    u[1]=(-3)+7*x[2]+7*x[1]+4*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=20+30*x[2]-25*x[1]+30*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-9*x[2]+6*x[1]-7*x[0]
    u[1]=(-2)+x[2]+x[1]+7*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-14)+7*x[2]+7*x[1]+49*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]-3*x[1]+2*x[0]
    u[1]=(-5)+7*x[2]-5*x[1]-9*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,0]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-63)-49*x[2]-21*x[1]+14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-7*x[2]+4*x[1]-6*x[0]
    u[1]=(-7)+5*x[2]+5*x[1]+2*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-49)+35*x[2]+35*x[1]+14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)-6*x[2]+4*x[1]-6*x[0]
    u[1]=2+7*x[2]+5*x[1]-7*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,0]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-35)-42*x[2]+28*x[1]-42*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+6*x[2]+7*x[1]-2*x[0]
    u[1]=(-8)-7*x[2]-9*x[1]+3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-8)-7*x[2]-9*x[1]+3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-1*x[2]+8*x[1]+2*x[0]
    u[1]=6-7*x[2]+2*x[1]-4*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=48-6*x[2]+48*x[1]+12*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-9*x[2]-9*x[1]+7*x[0]
    u[1]=3-5*x[2]+4*x[1]-3*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=18-30*x[2]+24*x[1]-18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-3*x[2]+8*x[1]+x[0]
    u[1]=(-9)+3*x[2]+8*x[1]+5*x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=6-3*x[2]+8*x[1]+x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Const_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+6*x[2]-4*x[1]-2*x[0]
    u[1]=(-4)+6*x[2]-9*x[1]+x[0]
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,1]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-32)+48*x[2]-72*x[1]+8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-2*x[2]-7*x[1]-5*x[0]
    u[1]=(-3)+5*x[2]-7*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]-8*x[1]+7*x[0]
    u[1]=(-2)-4*x[2]-9*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+4*x[2]+8*x[1]-5*x[0]
    u[1]=3+7*x[2]-9*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,0,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8+5*x[2]-6*x[1]-2*x[0]
    u[1]=(-5)+x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]-9*x[1]-1*x[0]
    u[1]=1+8*x[2]-2*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-5*x[2]+6*x[1]+2*x[0]
    u[1]=(-8)+2*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,0,1,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-3*x[2]-4*x[1]+4*x[0]
    u[1]=(-2)+4*x[2]-9*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+5*x[2]-7*x[1]-2*x[0]
    u[1]=(-9)-6*x[2]+6*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]+7*x[1]+4*x[0]
    u[1]=5-4*x[2]+2*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,0,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]+8*x[1]+7*x[0]
    u[1]=(-4)-4*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-4)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-7*x[2]+4*x[1]+8*x[0]
    u[1]=3+6*x[2]+6*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=6*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+x[2]-8*x[1]-6*x[0]
    u[1]=6-2*x[2]-7*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,1,1,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]-5*x[1]-6*x[0]
    u[1]=(-9)-5*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-6)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]+6*x[1]-6*x[0]
    u[1]=4+7*x[2]-7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+8*x[2]-7*x[1]+3*x[0]
    u[1]=(-4)-9*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,0,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]-7*x[1]+6*x[0]
    u[1]=3+8*x[2]+7*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+x[2]+6*x[1]-6*x[0]
    u[1]=(-4)+x[2]-2*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+3*x[2]+3*x[1]-2*x[0]
    u[1]=(-5)+3*x[2]+4*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[0,2,1,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=3*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-1*x[2]-5*x[1]+2*x[0]
    u[1]=7+4*x[2]+4*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+2*x[2]-4*x[1]+5*x[0]
    u[1]=(-7)-7*x[2]+4*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]+x[1]+5*x[0]
    u[1]=(-2)-5*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,0,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-5*x[2]-8*x[1]-8*x[0]
    u[1]=(-8)-6*x[2]+7*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+2*x[2]-3*x[1]-6*x[0]
    u[1]=(-1)-8*x[2]-3*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+2*x[2]-4*x[1]+8*x[0]
    u[1]=(-8)+4*x[2]+5*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,0,1,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+6*x[2]+3*x[1]+x[0]
    u[1]=2+2*x[2]+7*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-5*x[2]-8*x[1]-2*x[0]
    u[1]=(-5)-6*x[2]+x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+4*x[2]+6*x[1]-7*x[0]
    u[1]=4-5*x[2]-7*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,0,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+3*x[2]+6*x[1]-5*x[0]
    u[1]=4-7*x[2]+x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-5*x[2]-6*x[1]+8*x[0]
    u[1]=(-8)-8*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-3*x[2]-8*x[1]+2*x[0]
    u[1]=(-6)-7*x[2]-4*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,1,1,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]+5*x[1]+x[0]
    u[1]=(-2)-3*x[2]+2*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-3*x[2]+8*x[1]+5*x[0]
    u[1]=1+7*x[2]+x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+6*x[2]-3*x[1]-2*x[0]
    u[1]=6-9*x[2]-9*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,0,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-8*x[2]-3*x[1]-9*x[0]
    u[1]=1+x[2]+8*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=3*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-7*x[2]-9*x[1]-7*x[0]
    u[1]=(-7)-3*x[2]+6*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_A_Vario_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+7*x[2]+7*x[1]+6*x[0]
    u[1]=8-3*x[2]+x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),Function(self.domain))
    A_test[1,2,1,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-3)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=2
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=3
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)
    u[1]=5
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=1
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-5)
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=5
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[0,2,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=8
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-4)
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)
    u[1]=(-9)
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=7
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-8)
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-1)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu2_B_Vario_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=5
    B_test=Data(0.,(2,3,2),Function(self.domain))
    B_test[1,2,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+x[2]+2*x[1]+8*x[0]
    u[1]=(-1)-8*x[2]-8*x[1]+7*x[0]
    u[2]=(-4)+6*x[2]-8*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(16)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-7*x[2]+x[1]+5*x[0]
    u[1]=7+2*x[2]-3*x[1]-5*x[0]
    u[2]=6+6*x[2]-2*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-5*x[2]-9*x[1]-3*x[0]
    u[1]=(-6)+x[2]-3*x[1]+x[0]
    u[2]=3-1*x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+3*x[2]+7*x[1]+5*x[0]
    u[1]=3-8*x[2]-2*x[1]-9*x[0]
    u[2]=2+4*x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-72))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+4*x[2]-5*x[1]+7*x[0]
    u[1]=(-9)-8*x[2]-9*x[1]+x[0]
    u[2]=1-3*x[2]-6*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-3*x[1]-5*x[0]
    u[1]=(-6)-3*x[2]+3*x[1]+6*x[0]
    u[2]=(-7)-8*x[2]+3*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-3))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+4*x[2]+5*x[1]+6*x[0]
    u[1]=2+7*x[2]-7*x[1]-7*x[0]
    u[2]=(-5)-6*x[2]+5*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(32)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-2*x[2]-5*x[1]+3*x[0]
    u[1]=4+6*x[2]-8*x[1]-8*x[0]
    u[2]=(-5)-2*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-7*x[2]-2*x[1]-5*x[0]
    u[1]=(-7)+5*x[2]-2*x[1]+3*x[0]
    u[2]=(-5)-9*x[2]+7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+2*x[2]-5*x[1]+x[0]
    u[1]=(-8)-7*x[2]+6*x[1]-6*x[0]
    u[2]=(-8)+6*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(5)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+6*x[2]-4*x[1]+7*x[0]
    u[1]=1+7*x[2]-3*x[1]-8*x[0]
    u[2]=(-6)-3*x[2]-7*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]-6*x[1]+x[0]
    u[1]=(-5)+5*x[2]-6*x[1]-1*x[0]
    u[2]=(-4)-9*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-8*x[2]+3*x[1]-1*x[0]
    u[1]=4-5*x[2]-9*x[1]-4*x[0]
    u[2]=3+x[2]-2*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+x[2]+x[1]-1*x[0]
    u[1]=(-4)+2*x[2]+x[1]-2*x[0]
    u[2]=3-7*x[2]+2*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(1)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-9*x[2]+x[1]+3*x[0]
    u[1]=7-7*x[2]+8*x[1]-4*x[0]
    u[2]=(-9)+7*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-28))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]+8*x[1]+7*x[0]
    u[1]=(-3)-4*x[2]-8*x[1]-3*x[0]
    u[2]=(-3)+8*x[2]+x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-49))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]+4*x[1]-4*x[0]
    u[1]=(-5)-2*x[2]-8*x[1]-3*x[0]
    u[2]=2-7*x[2]+6*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-6*x[2]+4*x[1]+5*x[0]
    u[1]=(-8)-7*x[2]-6*x[1]-6*x[0]
    u[2]=(-6)+3*x[2]+8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-3*x[1]+x[0]
    u[1]=5-2*x[2]+3*x[1]-6*x[0]
    u[2]=(-1)-7*x[2]-2*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-1*x[2]-1*x[1]+2*x[0]
    u[1]=7+8*x[2]+6*x[1]-4*x[0]
    u[2]=8+7*x[2]-4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+6*x[2]-1*x[1]-8*x[0]
    u[1]=(-4)+4*x[2]+4*x[1]+8*x[0]
    u[2]=4+8*x[2]-5*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]+8*x[1]-6*x[0]
    u[1]=(-3)-8*x[2]+4*x[1]-5*x[0]
    u[2]=7-3*x[2]-8*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-40))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-2*x[2]+6*x[1]+5*x[0]
    u[1]=8-2*x[2]-9*x[1]-7*x[0]
    u[2]=(-3)+5*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-4*x[2]-7*x[1]+2*x[0]
    u[1]=(-6)+3*x[2]-1*x[1]-7*x[0]
    u[2]=2+2*x[2]-8*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]+4*x[1]+4*x[0]
    u[1]=(-8)-7*x[2]-7*x[1]-7*x[0]
    u[2]=(-8)-4*x[2]-5*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]-1*x[1]+3*x[0]
    u[1]=7+6*x[2]+6*x[1]-5*x[0]
    u[2]=(-6)-3*x[2]+6*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]-7*x[1]+3*x[0]
    u[1]=(-3)-2*x[2]-3*x[1]+x[0]
    u[2]=(-2)-2*x[2]-5*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-16))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]+2*x[1]-7*x[0]
    u[1]=1+x[2]+7*x[1]-2*x[0]
    u[2]=(-6)+3*x[2]-2*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-49))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-6*x[2]+3*x[1]+4*x[0]
    u[1]=(-5)+2*x[2]+3*x[1]+8*x[0]
    u[2]=2+8*x[2]+4*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+x[2]-5*x[1]+5*x[0]
    u[1]=(-4)+2*x[2]+2*x[1]+7*x[0]
    u[2]=1+3*x[2]-7*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-1*x[2]-8*x[1]-7*x[0]
    u[1]=(-7)+7*x[2]+5*x[1]-6*x[0]
    u[2]=8+6*x[2]+8*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]-2*x[1]-5*x[0]
    u[1]=8-9*x[2]-5*x[1]+x[0]
    u[2]=(-1)+5*x[2]+4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-30))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]+x[1]+x[0]
    u[1]=6+3*x[2]+7*x[1]+4*x[0]
    u[2]=2+2*x[2]-6*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(9)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-4*x[2]+4*x[1]-8*x[0]
    u[1]=4-4*x[2]-2*x[1]+5*x[0]
    u[2]=(-2)+x[2]+4*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]+7*x[1]+3*x[0]
    u[1]=(-1)+4*x[2]-1*x[1]+4*x[0]
    u[2]=4+2*x[2]-3*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-18))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+4*x[2]+8*x[1]-4*x[0]
    u[1]=(-4)-3*x[2]+x[1]-6*x[0]
    u[2]=(-8)-2*x[2]+8*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-6*x[2]+5*x[1]-6*x[0]
    u[1]=1-7*x[2]-1*x[1]-9*x[0]
    u[2]=2-3*x[2]+8*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+x[1]-8*x[0]
    u[1]=(-8)-9*x[2]+4*x[1]+2*x[0]
    u[2]=(-3)+5*x[2]-2*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(1)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-4*x[2]-4*x[1]-9*x[0]
    u[1]=(-5)-2*x[2]-7*x[1]-2*x[0]
    u[2]=(-6)+x[2]-5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-32))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-3*x[1]+4*x[0]
    u[1]=(-5)-5*x[2]+x[1]+7*x[0]
    u[2]=(-4)-1*x[2]+3*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-2*x[1]-6*x[0]
    u[1]=(-6)-4*x[2]+6*x[1]-2*x[0]
    u[2]=(-2)-4*x[2]+5*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(36)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-8*x[2]+5*x[1]-3*x[0]
    u[1]=5+8*x[2]-6*x[1]-1*x[0]
    u[2]=2+7*x[2]+x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-8*x[2]-4*x[1]+x[0]
    u[1]=(-5)-3*x[2]-5*x[1]-9*x[0]
    u[2]=7+8*x[2]+5*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]-8*x[1]+4*x[0]
    u[1]=(-4)+x[2]-9*x[1]+4*x[0]
    u[2]=(-3)+5*x[2]+8*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(40)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-1*x[2]+3*x[1]-7*x[0]
    u[1]=(-8)-3*x[2]-7*x[1]-2*x[0]
    u[2]=8-6*x[2]-5*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+8*x[2]+x[1]-5*x[0]
    u[1]=(-2)+8*x[2]+7*x[1]-2*x[0]
    u[2]=7-7*x[2]-9*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-5))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-8*x[2]-8*x[1]+x[0]
    u[1]=6-8*x[2]-4*x[1]+x[0]
    u[2]=1+2*x[2]+5*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-32))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+3*x[2]+3*x[1]-3*x[0]
    u[1]=5-8*x[2]-8*x[1]-4*x[0]
    u[2]=(-1)-2*x[2]+6*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+8*x[2]+7*x[1]-7*x[0]
    u[1]=(-2)+4*x[2]+5*x[1]+8*x[0]
    u[2]=(-5)-1*x[2]-6*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+5*x[2]-3*x[1]+6*x[0]
    u[1]=(-3)-3*x[2]+5*x[1]+4*x[0]
    u[2]=(-9)-9*x[2]+8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+5*x[2]-2*x[1]-6*x[0]
    u[1]=8+6*x[2]-4*x[1]-9*x[0]
    u[2]=(-3)+8*x[2]+x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-4*x[2]+8*x[1]-9*x[0]
    u[1]=2+8*x[2]+8*x[1]-6*x[0]
    u[2]=(-9)-7*x[2]-2*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-72))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-1*x[2]+3*x[1]-2*x[0]
    u[1]=8+2*x[2]-7*x[1]+7*x[0]
    u[2]=3-6*x[2]-9*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp1222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]+3*x[1]-4*x[0]
    u[1]=8-2*x[2]-8*x[1]+7*x[0]
    u[2]=(-5)+5*x[2]-4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(10)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-2*x[2]+2*x[1]+7*x[0]
    u[1]=(-1)-3*x[2]+x[1]-6*x[0]
    u[2]=(-4)-9*x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-5*x[2]-6*x[1]-1*x[0]
    u[1]=(-4)-3*x[2]-5*x[1]+7*x[0]
    u[2]=(-4)-3*x[2]-9*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]+8*x[1]+4*x[0]
    u[1]=(-2)-7*x[2]-6*x[1]-4*x[0]
    u[2]=(-9)-5*x[2]-5*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-1*x[2]+5*x[1]+x[0]
    u[1]=(-9)+4*x[2]-8*x[1]+8*x[0]
    u[2]=(-8)-5*x[2]-2*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(48)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+x[2]-5*x[1]-1*x[0]
    u[1]=6-3*x[2]+7*x[1]+5*x[0]
    u[2]=5-1*x[2]+x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-6*x[2]+x[1]-5*x[0]
    u[1]=(-1)+x[2]-4*x[1]-8*x[0]
    u[2]=(-8)+3*x[2]-5*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(5)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]+4*x[1]+8*x[0]
    u[1]=7+7*x[2]+7*x[1]+3*x[0]
    u[2]=(-2)-8*x[2]+3*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+4*x[2]+3*x[1]-5*x[0]
    u[1]=5-2*x[2]+4*x[1]-9*x[0]
    u[2]=3-4*x[2]+5*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+4*x[1]-5*x[0]
    u[1]=(-3)-8*x[2]-3*x[1]-7*x[0]
    u[2]=7+3*x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]-8*x[1]+5*x[0]
    u[1]=8-4*x[2]+5*x[1]-2*x[0]
    u[2]=8+5*x[2]-3*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(10)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-1*x[2]-4*x[1]-3*x[0]
    u[1]=2+4*x[2]-7*x[1]+7*x[0]
    u[2]=4+5*x[2]+3*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-6*x[2]-1*x[1]-9*x[0]
    u[1]=4-8*x[2]-6*x[1]+2*x[0]
    u[2]=(-4)+2*x[2]-5*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-30))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+4*x[2]+4*x[1]+4*x[0]
    u[1]=(-4)+x[2]+5*x[1]-4*x[0]
    u[2]=2-2*x[2]-8*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+x[2]-3*x[1]+3*x[0]
    u[1]=7-7*x[2]-7*x[1]-4*x[0]
    u[2]=3+2*x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-28))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-3*x[2]-3*x[1]-3*x[0]
    u[1]=4-9*x[2]-5*x[1]-2*x[0]
    u[2]=5-4*x[2]+7*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]-6*x[1]+5*x[0]
    u[1]=1+x[2]+4*x[1]-1*x[0]
    u[2]=(-7)-7*x[2]-4*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+6*x[2]+8*x[1]-2*x[0]
    u[1]=(-7)+4*x[2]-9*x[1]-7*x[0]
    u[2]=(-2)+7*x[2]-9*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-45))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+6*x[2]+2*x[1]-7*x[0]
    u[1]=3+8*x[2]-9*x[1]+5*x[0]
    u[2]=(-8)+7*x[2]-3*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(14)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]+4*x[1]-4*x[0]
    u[1]=(-9)+2*x[2]-3*x[1]+7*x[0]
    u[2]=5+4*x[2]+4*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-20))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-8*x[2]+2*x[1]+x[0]
    u[1]=(-6)-3*x[2]-2*x[1]+5*x[0]
    u[2]=(-5)-2*x[2]+4*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-5*x[1]+4*x[0]
    u[1]=8+4*x[2]+4*x[1]-6*x[0]
    u[2]=(-3)-9*x[2]+7*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+3*x[2]+4*x[1]+8*x[0]
    u[1]=3+3*x[2]-4*x[1]+x[0]
    u[2]=4-8*x[2]+4*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+5*x[2]-1*x[1]+7*x[0]
    u[1]=(-2)+5*x[2]+6*x[1]+3*x[0]
    u[2]=(-3)+8*x[2]-4*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]+3*x[1]-3*x[0]
    u[1]=6-1*x[2]-5*x[1]-2*x[0]
    u[2]=8+4*x[2]-9*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-7))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+8*x[2]+3*x[1]+3*x[0]
    u[1]=(-8)-7*x[2]-5*x[1]-9*x[0]
    u[2]=7+3*x[2]-5*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-5*x[2]-8*x[1]-3*x[0]
    u[1]=(-6)+7*x[2]-2*x[1]-5*x[0]
    u[2]=(-4)-9*x[2]+6*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(48)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeStrong_comp2222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-8*x[2]-4*x[1]-3*x[0]
    u[1]=(-8)-7*x[2]+2*x[1]-5*x[0]
    u[2]=(-7)-5*x[2]-9*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-25))
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-3*x[2]+7*x[1]+4*x[0]
    u[1]=(-6)+6*x[2]+5*x[1]-4*x[0]
    u[2]=5-6*x[2]+x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-32)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-16)-24*x[2]+56*x[1]+32*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-5*x[2]+3*x[1]-2*x[0]
    u[1]=(-1)+5*x[2]+6*x[1]-2*x[0]
    u[2]=(-2)+7*x[2]-7*x[1]-5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=12
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-6)+30*x[2]+36*x[1]-12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+3*x[2]-3*x[1]+8*x[0]
    u[1]=1+7*x[2]-3*x[1]-2*x[0]
    u[2]=(-5)-5*x[2]-4*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=24
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-40)-40*x[2]-32*x[1]-24*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+5*x[2]-1*x[1]+6*x[0]
    u[1]=7+8*x[2]-1*x[1]-5*x[0]
    u[2]=(-1)+4*x[2]-3*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=3
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-18)+15*x[2]-3*x[1]+18*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+8*x[2]+x[1]+6*x[0]
    u[1]=6+6*x[2]-2*x[1]+8*x[0]
    u[2]=(-3)-7*x[2]+3*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(18+18*x[2]-6*x[1]+24*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-7*x[2]+8*x[1]-1*x[0]
    u[1]=2+5*x[2]-3*x[1]-2*x[0]
    u[2]=3+5*x[2]-9*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=54
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(18+30*x[2]-54*x[1]+6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+3*x[2]+x[1]+6*x[0]
    u[1]=7-3*x[2]-3*x[1]+2*x[0]
    u[2]=8+7*x[2]-7*x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-12)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(20+12*x[2]+4*x[1]+24*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+7*x[2]-6*x[1]+4*x[0]
    u[1]=2-4*x[2]+8*x[1]-2*x[0]
    u[2]=7+x[2]+x[1]+5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=28
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(14-28*x[2]+56*x[1]-14*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]+4*x[1]-7*x[0]
    u[1]=4-2*x[2]-1*x[1]+3*x[0]
    u[2]=(-8)-5*x[2]+4*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-8)-5*x[2]+4*x[1]-9*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-2*x[2]-2*x[1]-2*x[0]
    u[1]=(-8)-5*x[2]+2*x[1]-8*x[0]
    u[2]=(-1)+3*x[2]-4*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-12)-6*x[2]-6*x[1]-6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+6*x[2]-3*x[1]+x[0]
    u[1]=(-1)-2*x[2]+3*x[1]-3*x[0]
    u[2]=8+4*x[2]-5*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=12
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-4)-8*x[2]+12*x[1]-12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-6*x[2]-6*x[1]-3*x[0]
    u[1]=7-3*x[2]-6*x[1]-2*x[0]
    u[2]=(-4)-6*x[2]+2*x[1]+6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-12)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)-12*x[2]+4*x[1]+12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]-5*x[1]+x[0]
    u[1]=7+x[2]+4*x[1]-4*x[0]
    u[2]=(-9)-6*x[2]-6*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=20
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-28)-12*x[2]-20*x[1]+4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]-8*x[1]-9*x[0]
    u[1]=(-1)-8*x[2]-4*x[1]-7*x[0]
    u[2]=(-5)+6*x[2]+6*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-2)-16*x[2]-8*x[1]-14*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-6*x[1]+5*x[0]
    u[1]=(-6)-3*x[2]+8*x[1]-8*x[0]
    u[2]=(-1)-7*x[2]+6*x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)-7*x[2]+6*x[1]-7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-8*x[2]+8*x[1]-1*x[0]
    u[1]=(-7)+6*x[2]-9*x[1]-4*x[0]
    u[2]=4-3*x[2]-5*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=56
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-21)-56*x[2]+56*x[1]-7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+3*x[2]-7*x[1]+5*x[0]
    u[1]=(-8)+7*x[2]-1*x[1]+x[0]
    u[2]=4-7*x[2]+3*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-21)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-24)+21*x[2]-3*x[1]+3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+2*x[2]-4*x[1]-3*x[0]
    u[1]=1-7*x[2]-5*x[1]-4*x[0]
    u[2]=2+x[2]-6*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4+2*x[2]-12*x[1]-12*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]+x[1]-4*x[0]
    u[1]=8-9*x[2]-9*x[1]-9*x[0]
    u[2]=7+6*x[2]+8*x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-8)+14*x[2]+2*x[1]-8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]+2*x[1]-6*x[0]
    u[1]=4-8*x[2]+4*x[1]+8*x[0]
    u[2]=2+7*x[2]+3*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(4-8*x[2]+4*x[1]+8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-4*x[2]+5*x[1]+3*x[0]
    u[1]=(-4)+7*x[2]+2*x[1]-7*x[0]
    u[2]=2-2*x[2]+x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=49
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(14-14*x[2]+7*x[1]-49*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+5*x[2]-6*x[1]+x[0]
    u[1]=1-5*x[2]-8*x[1]-3*x[0]
    u[2]=6+x[2]-4*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-4)+5*x[2]-6*x[1]+x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-5*x[2]-7*x[1]-2*x[0]
    u[1]=(-9)+4*x[2]-9*x[1]+6*x[0]
    u[2]=3+4*x[2]+2*x[1]+7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=72
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-72)+32*x[2]-72*x[1]+48*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-6*x[2]-7*x[1]+2*x[0]
    u[1]=(-8)+x[2]+x[1]+4*x[0]
    u[2]=1-7*x[2]-7*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=21
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(3-21*x[2]-21*x[1]+3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-2*x[2]+3*x[1]+x[0]
    u[1]=(-2)-7*x[2]-1*x[1]+6*x[0]
    u[2]=(-7)-8*x[2]-8*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=12
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-12)-12*x[2]+18*x[1]+6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]-8*x[1]+3*x[0]
    u[1]=6-3*x[2]-3*x[1]-1*x[0]
    u[2]=(-2)-3*x[2]+7*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(18-9*x[2]-9*x[1]-3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+6*x[2]+3*x[1]+2*x[0]
    u[1]=(-2)+8*x[2]+6*x[1]+x[0]
    u[2]=(-6)-7*x[2]-3*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=49
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-42)-49*x[2]-21*x[1]-14*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+x[2]-9*x[1]-9*x[0]
    u[1]=(-9)+7*x[2]+5*x[1]-7*x[0]
    u[2]=(-4)-1*x[2]+x[1]+4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-72)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]+6*x[1]+7*x[0]
    u[1]=(-1)+8*x[2]+6*x[1]-7*x[0]
    u[2]=6-2*x[2]+2*x[1]+3*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=18
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+3*x[2]+4*x[1]+6*x[0]
    u[1]=4+7*x[2]-5*x[1]-3*x[0]
    u[2]=(-8)-4*x[2]-8*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=15
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+4*x[2]-6*x[1]+8*x[0]
    u[1]=(-4)-4*x[2]-4*x[1]+2*x[0]
    u[2]=1+7*x[2]+2*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+2*x[2]+3*x[1]-3*x[0]
    u[1]=(-1)+3*x[2]-5*x[1]+x[0]
    u[2]=(-4)-2*x[2]+8*x[1]+x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+x[2]-7*x[1]+5*x[0]
    u[1]=(-1)-7*x[2]+6*x[1]+8*x[0]
    u[2]=(-2)-3*x[2]+4*x[1]-5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]-5*x[1]+2*x[0]
    u[1]=(-2)+6*x[2]-8*x[1]-2*x[0]
    u[2]=(-4)+7*x[2]-3*x[1]-6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]-9*x[1]-2*x[0]
    u[1]=(-8)-6*x[2]+6*x[1]-7*x[0]
    u[2]=7+7*x[2]+8*x[1]-3*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=64
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-8*x[2]-3*x[1]+6*x[0]
    u[1]=(-5)+4*x[2]+3*x[1]+7*x[0]
    u[2]=(-9)+8*x[2]-2*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=48
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+6*x[2]-4*x[1]+5*x[0]
    u[1]=(-6)-3*x[2]+4*x[1]-6*x[0]
    u[2]=6-1*x[2]+7*x[1]+2*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=35
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-7*x[2]+2*x[1]-4*x[0]
    u[1]=4-4*x[2]-1*x[1]-2*x[0]
    u[2]=4+8*x[2]-9*x[1]+7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+4*x[2]-8*x[1]+5*x[0]
    u[1]=1-6*x[2]-9*x[1]-4*x[0]
    u[2]=6+7*x[2]+x[1]-8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-7*x[2]+8*x[1]+5*x[0]
    u[1]=3-2*x[2]+3*x[1]-5*x[0]
    u[2]=(-8)-2*x[2]-9*x[1]+4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]+7*x[1]-9*x[0]
    u[1]=7-8*x[2]+6*x[1]-8*x[0]
    u[2]=(-3)-4*x[2]-4*x[1]+x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=30
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+3*x[2]+5*x[1]+8*x[0]
    u[1]=(-3)+x[2]+3*x[1]-8*x[0]
    u[2]=(-1)-6*x[2]-6*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=6
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-5*x[2]+x[1]-9*x[0]
    u[1]=(-8)-5*x[2]+3*x[1]-9*x[0]
    u[2]=(-6)-8*x[2]-4*x[1]-4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-12)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-9*x[2]-2*x[1]+5*x[0]
    u[1]=3+2*x[2]-4*x[1]+4*x[0]
    u[2]=(-1)-8*x[2]+8*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-7*x[2]+3*x[1]+6*x[0]
    u[1]=(-3)-6*x[2]-2*x[1]+8*x[0]
    u[2]=(-1)+5*x[2]-5*x[1]+7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=30
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-7*x[2]-6*x[1]-9*x[0]
    u[1]=1+7*x[2]+4*x[1]-3*x[0]
    u[2]=6+7*x[2]-5*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-63)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-2*x[2]-4*x[1]-9*x[0]
    u[1]=(-4)-8*x[2]+6*x[1]+4*x[0]
    u[2]=2+6*x[2]+2*x[1]-2*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-4)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+x[2]-8*x[1]+8*x[0]
    u[1]=1-1*x[2]-8*x[1]+6*x[0]
    u[2]=(-8)+2*x[2]+x[1]+3*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+5*x[2]-7*x[1]+x[0]
    u[1]=(-3)+6*x[2]+4*x[1]-6*x[0]
    u[2]=4+8*x[2]-8*x[1]-8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]+6*x[1]-2*x[0]
    u[1]=(-8)+2*x[2]-4*x[1]-5*x[0]
    u[2]=8+6*x[2]-8*x[1]-6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-32)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+8*x[2]-9*x[1]-6*x[0]
    u[1]=(-5)-7*x[2]+2*x[1]+5*x[0]
    u[2]=6+x[2]-5*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-49)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]-4*x[1]+6*x[0]
    u[1]=(-1)-9*x[2]+4*x[1]-3*x[0]
    u[2]=(-7)+6*x[2]+2*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-5*x[2]+7*x[1]-3*x[0]
    u[1]=(-2)-6*x[2]-2*x[1]+3*x[0]
    u[2]=1-8*x[2]+4*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=8
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Const_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-7*x[2]+8*x[1]+6*x[0]
    u[1]=6+7*x[2]-2*x[1]+8*x[0]
    u[2]=(-9)+5*x[2]-1*x[1]-4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=30
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-2*x[1]+4*x[0]
    u[1]=1-8*x[2]-4*x[1]-7*x[0]
    u[2]=(-3)-6*x[2]-8*x[1]-7*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-9)+21*x[2]-6*x[1]+12*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]+6*x[1]-9*x[0]
    u[1]=4-1*x[2]-4*x[1]-3*x[0]
    u[2]=(-5)+2*x[2]+3*x[1]+6*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=24-6*x[2]-24*x[1]-18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]-6*x[1]+2*x[0]
    u[1]=(-7)+7*x[2]+6*x[1]-8*x[0]
    u[2]=(-9)-6*x[2]+7*x[1]-9*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-18)-12*x[2]+14*x[1]-18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-5*x[2]+7*x[1]-7*x[0]
    u[1]=3+x[2]-5*x[1]+x[0]
    u[2]=(-3)+7*x[2]-1*x[1]+7*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-49)-35*x[2]+49*x[1]-49*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-7*x[2]-4*x[1]-2*x[0]
    u[1]=(-9)-3*x[2]-9*x[1]+2*x[0]
    u[2]=4-3*x[2]+2*x[1]-3*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-9)-3*x[2]-9*x[1]+2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]-2*x[1]+7*x[0]
    u[1]=(-2)+8*x[2]+3*x[1]-6*x[0]
    u[2]=6-7*x[2]+8*x[1]+5*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=30-35*x[2]+40*x[1]+25*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+7*x[1]+2*x[0]
    u[1]=(-4)+3*x[2]+x[1]+2*x[0]
    u[2]=3-5*x[2]+3*x[1]-4*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=16+40*x[2]+56*x[1]+16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-5*x[2]-8*x[1]+7*x[0]
    u[1]=(-8)+5*x[2]-5*x[1]+x[0]
    u[2]=(-3)+6*x[2]-9*x[1]-8*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-64)+40*x[2]-40*x[1]+8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+5*x[2]+8*x[1]+2*x[0]
    u[1]=(-1)-2*x[2]-8*x[1]-2*x[0]
    u[2]=7-9*x[2]+2*x[1]+4*x[0]
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=7-9*x[2]+2*x[1]+4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-1*x[2]-1*x[1]-7*x[0]
    u[1]=(-6)+4*x[2]+5*x[1]+x[0]
    u[2]=(-6)+4*x[2]-2*x[1]-4*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,0]=2
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=(-16)-2*x[2]-2*x[1]-14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-5*x[2]+x[1]+8*x[0]
    u[1]=5-5*x[2]-2*x[1]+7*x[0]
    u[2]=(-3)-5*x[2]+4*x[1]-4*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,1]=6
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=30-30*x[2]-12*x[1]+42*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]-7*x[1]+7*x[0]
    u[1]=(-4)+8*x[2]+6*x[1]-6*x[0]
    u[2]=(-9)-3*x[2]-3*x[1]-6*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,2]=5
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=(-45)-15*x[2]-15*x[1]-30*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+2*x[2]+5*x[1]-3*x[0]
    u[1]=4-1*x[2]-1*x[1]+3*x[0]
    u[2]=4-5*x[2]-3*x[1]+3*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,0]=4
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=24+8*x[2]+20*x[1]-12*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+8*x[2]-4*x[1]+8*x[0]
    u[1]=8-4*x[2]+3*x[1]+x[0]
    u[2]=3-9*x[2]+4*x[1]+8*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,1]=5
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=40-20*x[2]+15*x[1]+5*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-1*x[2]-2*x[1]+2*x[0]
    u[1]=(-4)+6*x[2]+4*x[1]+4*x[0]
    u[2]=(-8)-4*x[2]-3*x[1]-9*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,2]=6
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=(-48)-24*x[2]-18*x[1]-54*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]-2*x[1]+5*x[0]
    u[1]=3+8*x[2]+5*x[1]-4*x[0]
    u[2]=(-4)-9*x[2]-3*x[1]-1*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,0]=6
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=(-48)+12*x[2]-12*x[1]+30*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-9*x[2]-2*x[1]+6*x[0]
    u[1]=(-3)-5*x[2]+8*x[1]+7*x[0]
    u[2]=(-5)+5*x[2]+6*x[1]-4*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,1]=3
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=(-9)-15*x[2]+24*x[1]+21*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]+4*x[1]+2*x[0]
    u[1]=(-6)-9*x[2]-9*x[1]-7*x[0]
    u[2]=5+7*x[2]+8*x[1]-4*x[0]
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,2]=4
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=20+28*x[2]+32*x[1]-16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-5*x[2]-5*x[1]+x[0]
    u[1]=(-2)+6*x[2]-9*x[1]+7*x[0]
    u[2]=(-7)-3*x[2]-2*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]+7*x[1]+5*x[0]
    u[1]=8-2*x[2]-7*x[1]-4*x[0]
    u[2]=7+5*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-2*x[2]-8*x[1]-3*x[0]
    u[1]=(-6)+3*x[2]-6*x[1]+x[0]
    u[2]=6+4*x[2]+2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-9*x[2]+3*x[1]-4*x[0]
    u[1]=(-8)-6*x[2]-2*x[1]+2*x[0]
    u[2]=5-2*x[2]+3*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(2*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+5*x[2]-5*x[1]-2*x[0]
    u[1]=(-2)-9*x[2]-8*x[1]+6*x[0]
    u[2]=(-7)+5*x[2]+4*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+4*x[2]+2*x[1]-6*x[0]
    u[1]=(-8)+4*x[2]-1*x[1]-3*x[0]
    u[2]=(-5)-2*x[2]-2*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+6*x[2]-8*x[1]+2*x[0]
    u[1]=(-4)+4*x[2]-9*x[1]-1*x[0]
    u[2]=(-6)-5*x[2]-4*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-8*x[2]+8*x[1]-8*x[0]
    u[1]=5+4*x[2]+x[1]-9*x[0]
    u[2]=6-5*x[2]+6*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+4*x[2]-6*x[1]+6*x[0]
    u[1]=(-1)+x[2]+8*x[1]-1*x[0]
    u[2]=(-1)-2*x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-2*x[2]+2*x[1]-9*x[0]
    u[1]=6-6*x[2]+7*x[1]-6*x[0]
    u[2]=(-6)+6*x[2]+4*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+2*x[2]-9*x[1]-9*x[0]
    u[1]=(-8)-8*x[2]-9*x[1]-5*x[0]
    u[2]=(-5)-5*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+8*x[2]-2*x[1]+8*x[0]
    u[1]=6+8*x[2]+6*x[1]+x[0]
    u[2]=4+5*x[2]+8*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(8*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-1*x[2]+5*x[1]+3*x[0]
    u[1]=(-3)+6*x[2]-9*x[1]-9*x[0]
    u[2]=(-1)-6*x[2]-1*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+x[1]-8*x[0]
    u[1]=(-7)+3*x[2]+6*x[1]-1*x[0]
    u[2]=(-8)+8*x[2]+x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(6*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]+6*x[1]+7*x[0]
    u[1]=(-4)+6*x[2]+3*x[1]+2*x[0]
    u[2]=1+2*x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(6*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-6*x[2]-8*x[1]-3*x[0]
    u[1]=(-8)+3*x[2]+x[1]-4*x[0]
    u[2]=7-2*x[2]-9*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-4)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+x[2]+5*x[1]-7*x[0]
    u[1]=7-6*x[2]+8*x[1]-7*x[0]
    u[2]=(-4)+x[2]+4*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(4*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]-5*x[1]-2*x[0]
    u[1]=(-4)+x[2]-6*x[1]-9*x[0]
    u[2]=2-9*x[2]+6*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+x[2]+6*x[1]+x[0]
    u[1]=(-4)+4*x[2]-6*x[1]+7*x[0]
    u[2]=4-7*x[2]-1*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+8*x[2]+x[1]+6*x[0]
    u[1]=4-5*x[2]-4*x[1]-5*x[0]
    u[2]=3+2*x[2]+5*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+7*x[2]+7*x[1]+2*x[0]
    u[1]=2+8*x[2]+6*x[1]+3*x[0]
    u[2]=1+x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+8*x[2]+x[1]-9*x[0]
    u[1]=(-8)-2*x[2]-2*x[1]+2*x[0]
    u[2]=(-1)-9*x[2]-5*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-3*x[2]-8*x[1]-1*x[0]
    u[1]=(-5)+3*x[2]-6*x[1]+8*x[0]
    u[2]=(-9)+4*x[2]+6*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+x[2]-2*x[1]+3*x[0]
    u[1]=(-4)-3*x[2]-5*x[1]+2*x[0]
    u[2]=3-6*x[2]+7*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=3
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-3)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]-6*x[1]-7*x[0]
    u[1]=(-1)-9*x[2]+x[1]+3*x[0]
    u[2]=7-4*x[2]-4*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-8)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-4*x[2]+4*x[1]+5*x[0]
    u[1]=4-6*x[2]-7*x[1]-2*x[0]
    u[2]=(-2)-8*x[2]-9*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]-4*x[1]+8*x[0]
    u[1]=5-4*x[2]+5*x[1]+8*x[0]
    u[2]=(-5)+6*x[2]+4*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(6*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+8*x[2]-1*x[1]+2*x[0]
    u[1]=(-5)-5*x[2]+8*x[1]+6*x[0]
    u[2]=(-5)+7*x[2]-4*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(2*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-9*x[2]-1*x[1]+4*x[0]
    u[1]=(-3)+5*x[2]+5*x[1]-7*x[0]
    u[2]=4-3*x[2]+7*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-1)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]+7*x[1]+4*x[0]
    u[1]=6+2*x[2]-6*x[1]+7*x[0]
    u[2]=(-9)-6*x[2]+2*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-9)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]-6*x[1]+x[0]
    u[1]=4-9*x[2]-2*x[1]-8*x[0]
    u[2]=(-4)+6*x[2]+7*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-1*x[2]-6*x[1]-3*x[0]
    u[1]=(-8)+7*x[2]-5*x[1]+4*x[0]
    u[2]=(-5)-2*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-5)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+7*x[2]-7*x[1]+x[0]
    u[1]=(-3)+6*x[2]+7*x[1]+7*x[0]
    u[2]=6-4*x[2]-8*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]+5*x[1]+7*x[0]
    u[1]=4-7*x[2]+x[1]+2*x[0]
    u[2]=6+x[2]-1*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(5*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+x[2]-5*x[1]+8*x[0]
    u[1]=8-4*x[2]+7*x[1]+7*x[0]
    u[2]=(-8)-4*x[2]-4*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-4)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+3*x[2]+7*x[1]+x[0]
    u[1]=(-1)-9*x[2]+2*x[1]-2*x[0]
    u[2]=4-8*x[2]+3*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-8*x[2]+8*x[1]+5*x[0]
    u[1]=1+7*x[2]-1*x[1]+x[0]
    u[2]=(-6)+2*x[2]+5*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(5*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+8*x[2]-1*x[1]-1*x[0]
    u[1]=(-8)+4*x[2]+3*x[1]-4*x[0]
    u[2]=(-3)+6*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-8*x[1]+8*x[0]
    u[1]=(-6)-7*x[2]-2*x[1]-9*x[0]
    u[2]=(-7)+7*x[2]+6*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+8*x[2]-3*x[1]+4*x[0]
    u[1]=(-5)+6*x[2]+x[1]+8*x[0]
    u[2]=2+4*x[2]-1*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(8*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+3*x[2]-6*x[1]-8*x[0]
    u[1]=(-2)+3*x[2]-1*x[1]-4*x[0]
    u[2]=(-2)+7*x[2]-7*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]-6*x[1]+2*x[0]
    u[1]=(-4)-1*x[2]+6*x[1]-7*x[0]
    u[2]=6-3*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+5*x[2]+x[1]-5*x[0]
    u[1]=(-2)-8*x[2]+2*x[1]+x[0]
    u[2]=3+x[2]+x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-7)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]+x[1]+4*x[0]
    u[1]=(-6)-4*x[2]+8*x[1]+4*x[0]
    u[2]=(-7)+4*x[2]-9*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+3*x[2]-6*x[1]+x[0]
    u[1]=2-1*x[2]-1*x[1]+7*x[0]
    u[2]=3-5*x[2]-5*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-5)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+6*x[2]+x[1]-9*x[0]
    u[1]=(-5)-6*x[2]+7*x[1]+4*x[0]
    u[2]=1+5*x[2]-2*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+2*x[2]+4*x[1]+4*x[0]
    u[1]=2+2*x[2]+3*x[1]+3*x[0]
    u[2]=(-4)-9*x[2]+7*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+4*x[2]-7*x[1]+5*x[0]
    u[1]=7+5*x[2]+8*x[1]-8*x[0]
    u[2]=(-6)+6*x[2]+7*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-6*x[1]-4*x[0]
    u[1]=(-3)+6*x[2]+3*x[1]-4*x[0]
    u[2]=(-2)-2*x[2]-3*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-3*x[1]-3*x[0]
    u[1]=7+2*x[2]-7*x[1]-4*x[0]
    u[2]=(-9)+5*x[2]+4*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-7)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+4*x[1]-5*x[0]
    u[1]=(-3)-5*x[2]-8*x[1]+2*x[0]
    u[2]=(-8)-7*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-5)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-2*x[2]+2*x[1]-3*x[0]
    u[1]=(-4)+7*x[2]-3*x[1]-9*x[0]
    u[2]=(-3)+3*x[2]+x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=3
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-3)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-8*x[2]+5*x[1]+5*x[0]
    u[1]=(-8)-7*x[2]+2*x[1]-1*x[0]
    u[2]=(-5)+8*x[2]-6*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-6)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp1222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+5*x[2]+6*x[1]+3*x[0]
    u[1]=(-1)-4*x[2]-9*x[1]+x[0]
    u[2]=1+8*x[2]-6*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(8*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]-5*x[1]-6*x[0]
    u[1]=1-7*x[2]+7*x[1]+4*x[0]
    u[2]=(-9)-5*x[2]+6*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-6)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-2*x[2]-7*x[1]-1*x[0]
    u[1]=(-3)-9*x[2]-8*x[1]-1*x[0]
    u[2]=(-4)+5*x[2]-8*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=7
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-7)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-6*x[2]+7*x[1]-5*x[0]
    u[1]=3-1*x[2]-8*x[1]-8*x[0]
    u[2]=(-2)-3*x[2]+8*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-6)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-7*x[2]-9*x[1]+4*x[0]
    u[1]=(-2)-8*x[2]-8*x[1]+6*x[0]
    u[2]=(-3)+3*x[2]-2*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-6)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-8*x[2]+8*x[1]-9*x[0]
    u[1]=6-1*x[2]+2*x[1]-3*x[0]
    u[2]=7+3*x[2]-2*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-2)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(2*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-9*x[2]-5*x[1]-8*x[0]
    u[1]=(-5)+5*x[2]-3*x[1]-4*x[0]
    u[2]=(-7)+5*x[2]-7*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(5*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-8*x[2]+7*x[1]-7*x[0]
    u[1]=3+2*x[2]+x[1]-8*x[0]
    u[2]=(-2)+7*x[2]-5*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-6)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-3*x[2]+2*x[1]+6*x[0]
    u[1]=(-5)-2*x[2]-8*x[1]-3*x[0]
    u[2]=(-8)+3*x[2]-5*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-5)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+3*x[1]+5*x[0]
    u[1]=(-2)-6*x[2]-6*x[1]-2*x[0]
    u[2]=(-7)+7*x[2]-5*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+x[2]+2*x[1]-4*x[0]
    u[1]=(-7)+7*x[2]-7*x[1]-6*x[0]
    u[2]=(-4)-4*x[2]-5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-4)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]+5*x[1]-5*x[0]
    u[1]=6-3*x[2]+6*x[1]+6*x[0]
    u[2]=7-3*x[2]+6*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-5)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(5*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+3*x[2]+4*x[1]+4*x[0]
    u[1]=(-9)+8*x[2]-6*x[1]-1*x[0]
    u[2]=2-2*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-3)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(3*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+x[2]+x[1]+4*x[0]
    u[1]=4-3*x[2]-4*x[1]+7*x[0]
    u[2]=(-3)-9*x[2]-2*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+x[2]+7*x[1]+8*x[0]
    u[1]=(-7)+4*x[2]+4*x[1]-7*x[0]
    u[2]=(-7)-8*x[2]+3*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-4)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(4*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+4*x[2]-7*x[1]-9*x[0]
    u[1]=(-4)+x[2]-7*x[1]-8*x[0]
    u[2]=(-2)+x[2]-8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]-9*x[1]-9*x[0]
    u[1]=(-1)-3*x[2]-8*x[1]-6*x[0]
    u[2]=1-5*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=3
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-3)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+4*x[2]+x[1]-2*x[0]
    u[1]=1+3*x[2]-3*x[1]-6*x[0]
    u[2]=3+4*x[2]-3*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=3
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-3)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-4*x[2]-2*x[1]-3*x[0]
    u[1]=7+3*x[2]-5*x[1]+x[0]
    u[2]=7+7*x[2]-3*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-1*x[2]-7*x[1]-2*x[0]
    u[1]=(-1)-8*x[2]-9*x[1]+2*x[0]
    u[2]=8-4*x[2]+x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=2
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-2)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+2*x[2]-4*x[1]-7*x[0]
    u[1]=(-6)+4*x[2]+5*x[1]-1*x[0]
    u[2]=1-9*x[2]-7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-8*x[2]+2*x[1]-9*x[0]
    u[1]=(-5)-2*x[2]-7*x[1]+7*x[0]
    u[2]=(-8)+3*x[2]+6*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=8
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-8)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+x[2]+2*x[1]+2*x[0]
    u[1]=(-2)-2*x[2]+5*x[1]-9*x[0]
    u[2]=(-7)+4*x[2]+6*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-4*x[2]+2*x[1]+4*x[0]
    u[1]=(-5)-5*x[2]+8*x[1]+4*x[0]
    u[2]=(-4)+5*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-8)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(8*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-2*x[1]-9*x[0]
    u[1]=(-3)+7*x[2]-9*x[1]-4*x[0]
    u[2]=(-6)+4*x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-7)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+7*x[2]-8*x[1]-5*x[0]
    u[1]=(-4)-5*x[2]-6*x[1]+6*x[0]
    u[2]=(-8)-3*x[2]-5*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=4
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+3*x[2]-4*x[1]-3*x[0]
    u[1]=5+8*x[2]-5*x[1]+7*x[0]
    u[2]=4-8*x[2]-5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-5)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeStrong_comp2222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]+5*x[1]+7*x[0]
    u[1]=1+8*x[2]-3*x[1]+3*x[0]
    u[2]=8-9*x[2]+3*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=9
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-8*x[2]-9*x[1]-2*x[0]
    u[1]=6+6*x[2]-2*x[1]+6*x[0]
    u[2]=6-8*x[2]-8*x[1]-5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8+8*x[2]+9*x[1]+4*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0]-8*x[0]*x[2]-9*x[0]*x[1]-2*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+8*x[2]+x[1]+8*x[0]
    u[1]=5-7*x[2]+x[1]+7*x[0]
    u[2]=(-6)-1*x[2]+8*x[1]+4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)+7*x[2]-1*x[1]-14*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(5*x[0]-7*x[0]*x[2]+x[0]*x[1]+7*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+8*x[2]-3*x[1]+3*x[0]
    u[1]=(-7)-7*x[2]+6*x[1]+4*x[0]
    u[2]=(-8)-3*x[2]-5*x[1]+7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8+3*x[2]+5*x[1]-14*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0]-3*x[0]*x[2]-5*x[0]*x[1]+7*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-7*x[2]-8*x[1]+7*x[0]
    u[1]=(-9)-8*x[2]-3*x[1]+6*x[0]
    u[2]=(-5)-2*x[2]-4*x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=5+7*x[2]+16*x[1]-7*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-5)*x[1]-7*x[1]*x[2]-8*x[1]**2+7*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+3*x[2]+4*x[1]+2*x[0]
    u[1]=3+x[2]-6*x[1]+6*x[0]
    u[2]=1-9*x[2]-3*x[1]+3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)-1*x[2]+12*x[1]-6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(3*x[1]+x[1]*x[2]-6*x[1]**2+6*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+5*x[2]-2*x[1]-5*x[0]
    u[1]=2-3*x[2]-7*x[1]-5*x[0]
    u[2]=2-5*x[2]+3*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)+5*x[2]-6*x[1]+6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(2*x[1]-5*x[1]*x[2]+3*x[1]**2-6*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+7*x[2]+3*x[1]+7*x[0]
    u[1]=(-1)-4*x[2]+8*x[1]+2*x[0]
    u[2]=3+x[2]-6*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)-14*x[2]-3*x[1]-7*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(3*x[2]+7*x[2]**2+3*x[1]*x[2]+7*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-1*x[2]+2*x[1]+x[0]
    u[1]=(-6)-1*x[2]-4*x[1]+8*x[0]
    u[2]=(-2)+6*x[2]-6*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6+2*x[2]+4*x[1]-8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6)*x[2]-1*x[2]**2-4*x[1]*x[2]+8*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+8*x[2]+6*x[1]+6*x[0]
    u[1]=7-2*x[2]+2*x[1]+x[0]
    u[2]=5-4*x[2]-3*x[1]-5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)+8*x[2]+3*x[1]+5*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(5*x[2]-4*x[2]**2-3*x[1]*x[2]-5*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-6*x[2]-8*x[1]-5*x[0]
    u[1]=4+6*x[2]+5*x[1]+8*x[0]
    u[2]=7+7*x[2]-7*x[1]+5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)+6*x[2]+8*x[1]+10*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(2*x[0]-6*x[0]*x[2]-8*x[0]*x[1]-5*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+7*x[2]-7*x[1]+x[0]
    u[1]=8-3*x[2]+8*x[1]+5*x[0]
    u[2]=7-7*x[2]-3*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)+3*x[2]-8*x[1]-10*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(8*x[0]-3*x[0]*x[2]+8*x[0]*x[1]+5*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+3*x[2]-3*x[1]-9*x[0]
    u[1]=(-2)-1*x[2]-9*x[1]-5*x[0]
    u[2]=(-2)-6*x[2]+7*x[1]-4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2+6*x[2]-7*x[1]+8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2)*x[0]-6*x[0]*x[2]+7*x[0]*x[1]-4*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]+4*x[1]+2*x[0]
    u[1]=(-6)-3*x[2]-8*x[1]-9*x[0]
    u[2]=4+x[2]-4*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=1+2*x[2]-8*x[1]-2*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1]-2*x[1]*x[2]+4*x[1]**2+2*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+5*x[2]+x[1]+x[0]
    u[1]=(-3)-2*x[2]+8*x[1]-4*x[0]
    u[2]=7-8*x[2]+4*x[1]+8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=3+2*x[2]-16*x[1]+4*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-3)*x[1]-2*x[1]*x[2]+8*x[1]**2-4*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-5*x[2]-5*x[1]+3*x[0]
    u[1]=1+6*x[2]+2*x[1]+4*x[0]
    u[2]=(-7)+7*x[2]+8*x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=7-7*x[2]-16*x[1]-2*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-7)*x[1]+7*x[1]*x[2]+8*x[1]**2+2*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-8*x[2]-7*x[1]-2*x[0]
    u[1]=2-9*x[2]+2*x[1]-7*x[0]
    u[2]=(-4)-6*x[2]-6*x[1]+8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=5+16*x[2]+7*x[1]+2*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-5)*x[2]-8*x[2]**2-7*x[1]*x[2]-2*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]+8*x[1]-1*x[0]
    u[1]=6+3*x[2]-1*x[1]-9*x[0]
    u[2]=7-5*x[2]+x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)-6*x[2]+x[1]+9*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(6*x[2]+3*x[2]**2-1*x[1]*x[2]-9*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+6*x[2]+6*x[1]+2*x[0]
    u[1]=2-8*x[2]-2*x[1]+7*x[0]
    u[2]=2+6*x[2]-6*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)-12*x[2]+6*x[1]+9*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(2*x[2]+6*x[2]**2-6*x[1]*x[2]-9*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-1*x[2]+x[1]+3*x[0]
    u[1]=(-5)-1*x[2]+7*x[1]+x[0]
    u[2]=6+6*x[2]+4*x[1]+4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=1+x[2]-1*x[1]-6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-1)*x[0]-1*x[0]*x[2]+x[0]*x[1]+3*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-4*x[2]-8*x[1]+5*x[0]
    u[1]=3+6*x[2]+4*x[1]+6*x[0]
    u[2]=(-2)-6*x[2]-6*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-3)-6*x[2]-4*x[1]-12*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(3*x[0]+6*x[0]*x[2]+4*x[0]*x[1]+6*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+6*x[2]-6*x[1]-4*x[0]
    u[1]=8-2*x[2]-8*x[1]+5*x[0]
    u[2]=(-5)-6*x[2]-9*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5+6*x[2]+9*x[1]+6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-5)*x[0]-6*x[0]*x[2]-9*x[0]*x[1]-3*x[0]**2)
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-4*x[2]+2*x[1]-8*x[0]
    u[1]=(-8)+6*x[2]-8*x[1]-3*x[0]
    u[2]=8-5*x[2]-7*x[1]+3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-6)+4*x[2]-4*x[1]+8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(6*x[1]-4*x[1]*x[2]+2*x[1]**2-8*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+2*x[2]-3*x[1]+2*x[0]
    u[1]=(-6)-8*x[2]-9*x[1]+7*x[0]
    u[2]=(-7)+8*x[2]-2*x[1]+4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=6+8*x[2]+18*x[1]-7*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-6)*x[1]-8*x[1]*x[2]-9*x[1]**2+7*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]-8*x[1]+7*x[0]
    u[1]=(-7)-1*x[2]-7*x[1]-1*x[0]
    u[2]=7+6*x[2]-9*x[1]+6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-7)-6*x[2]+18*x[1]-6*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(7*x[1]+6*x[1]*x[2]-9*x[1]**2+6*x[0]*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+4*x[2]-1*x[1]+8*x[0]
    u[1]=(-7)-4*x[2]+7*x[1]+x[0]
    u[2]=(-3)-6*x[2]-2*x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=4-8*x[2]+x[1]-8*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-4)*x[2]+4*x[2]**2-1*x[1]*x[2]+8*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+3*x[1]+3*x[0]
    u[1]=(-9)-8*x[2]-1*x[1]+2*x[0]
    u[2]=(-6)+3*x[2]+7*x[1]+6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=9+16*x[2]+x[1]-2*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-9)*x[2]-8*x[2]**2-1*x[1]*x[2]+2*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-7*x[2]-9*x[1]+5*x[0]
    u[1]=(-3)-9*x[2]+4*x[1]-6*x[0]
    u[2]=(-7)-4*x[2]-7*x[1]-9*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=7+8*x[2]+7*x[1]+9*x[0]
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),FunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-7)*x[2]-4*x[2]**2-7*x[1]*x[2]-9*x[0]*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, Y=Y_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+6*x[2]+7*x[1]-8*x[0]
    u[1]=(-6)+7*x[2]-1*x[1]-6*x[0]
    u[2]=8+4*x[2]+8*x[1]-6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-8*x[2]+4*x[1]-3*x[0]
    u[1]=2-2*x[2]-3*x[1]+8*x[0]
    u[2]=(-5)-8*x[2]+3*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]-1*x[1]+2*x[0]
    u[1]=(-9)-9*x[2]+7*x[1]-9*x[0]
    u[2]=(-2)+4*x[2]-2*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-1*x[2]+x[1]-9*x[0]
    u[1]=5-6*x[2]+5*x[1]-7*x[0]
    u[2]=5+7*x[2]-7*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-5*x[2]-6*x[1]+2*x[0]
    u[1]=(-3)+4*x[2]-2*x[1]-7*x[0]
    u[2]=(-3)-1*x[2]-1*x[1]+4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+7*x[2]-7*x[1]-6*x[0]
    u[1]=(-3)-9*x[2]-1*x[1]-6*x[0]
    u[2]=6-4*x[2]+5*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+x[2]+4*x[1]-5*x[0]
    u[1]=(-3)+2*x[2]-5*x[1]+8*x[0]
    u[2]=2+5*x[2]-2*x[1]+8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-2*x[1]+3*x[0]
    u[1]=(-3)+7*x[2]-8*x[1]-8*x[0]
    u[2]=(-1)-5*x[2]-8*x[1]+8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-9*x[2]-6*x[1]+2*x[0]
    u[1]=5+x[2]-1*x[1]+8*x[0]
    u[2]=4-7*x[2]+x[1]+8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[0,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]-2*x[1]-8*x[0]
    u[1]=8+3*x[2]+4*x[1]+2*x[0]
    u[2]=1+2*x[2]-5*x[1]-2*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+5*x[2]+8*x[1]+8*x[0]
    u[1]=3+2*x[2]-3*x[1]+x[0]
    u[2]=(-6)+3*x[2]+8*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-5*x[2]-3*x[1]-4*x[0]
    u[1]=(-2)-9*x[2]+6*x[1]-3*x[0]
    u[2]=(-7)-2*x[2]-2*x[1]-5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-5*x[2]+x[1]-4*x[0]
    u[1]=2-7*x[2]-7*x[1]-1*x[0]
    u[2]=3+7*x[2]-4*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+4*x[2]-7*x[1]+2*x[0]
    u[1]=(-4)-9*x[2]+2*x[1]-9*x[0]
    u[2]=8+3*x[2]+4*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-6*x[2]-9*x[1]+4*x[0]
    u[1]=8-4*x[2]-1*x[1]-2*x[0]
    u[2]=1+3*x[2]-4*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+4*x[2]+x[1]-2*x[0]
    u[1]=(-7)+7*x[2]+3*x[1]+7*x[0]
    u[2]=(-4)-1*x[2]+6*x[1]-1*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-5*x[2]-3*x[1]+8*x[0]
    u[1]=(-8)+2*x[2]-6*x[1]+3*x[0]
    u[2]=(-8)+x[2]+4*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+2*x[1]-6*x[0]
    u[1]=(-6)-8*x[2]+4*x[1]+3*x[0]
    u[2]=1-5*x[2]-9*x[1]+8*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[1,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+6*x[1]-5*x[0]
    u[1]=7-8*x[2]-1*x[1]-3*x[0]
    u[2]=6-3*x[2]-6*x[1]+4*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]+7*x[1]+6*x[0]
    u[1]=(-7)-6*x[2]-8*x[1]-1*x[0]
    u[2]=5-4*x[2]-5*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+5*x[2]+8*x[1]+x[0]
    u[1]=1-2*x[2]+6*x[1]+6*x[0]
    u[2]=5+7*x[2]-6*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+3*x[2]+6*x[1]-5*x[0]
    u[1]=(-1)-3*x[2]-1*x[1]-6*x[0]
    u[2]=(-6)-6*x[2]-7*x[1]-6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+x[2]-4*x[1]-5*x[0]
    u[1]=8-6*x[2]+5*x[1]-2*x[0]
    u[2]=(-2)-9*x[2]+6*x[1]+2*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-1*x[1]-8*x[0]
    u[1]=(-5)-1*x[2]+7*x[1]+x[0]
    u[2]=(-1)-2*x[2]+7*x[1]+6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-1)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]+8*x[1]-4*x[0]
    u[1]=6-7*x[2]-4*x[1]-2*x[0]
    u[2]=(-2)-1*x[2]-4*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]-2*x[1]+3*x[0]
    u[1]=7+x[2]-6*x[1]-3*x[0]
    u[2]=(-2)+8*x[2]+2*x[1]+2*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=2*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_C_Vario_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-4*x[2]-3*x[1]+x[0]
    u[1]=(-5)+6*x[2]+2*x[1]+x[0]
    u[2]=(-4)-4*x[2]-8*x[1]-6*x[0]
    C_test=Data(0.,(3,3,3),Function(self.domain))
    C_test[2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C=C_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-1)
    u[2]=2
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=7
    u[2]=1
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=5
    u[2]=(-7)
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1
    u[1]=(-8)
    u[2]=3
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=(-6)
    u[2]=(-2)
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=8
    u[2]=(-3)
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=5
    u[2]=2
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=8
    u[2]=1
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_D_Vario_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-6)
    u[2]=(-3)
    D_test=Data(0.,(3,3),Function(self.domain))
    D_test[2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D=D_test, Y=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=(-9)
    u[2]=(-9)
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,0]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-6)
    u[2]=2
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,1]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=6
    u[2]=4
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[0,2]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3
    u[1]=(-5)
    u[2]=(-5)
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,0]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=5
    u[2]=(-8)
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,1]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=5*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-8)
    u[2]=(-3)
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[1,2]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-9)
    u[2]=(-5)
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,0]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=(-3)
    u[2]=4
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,1]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_d_Vario_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-3)
    u[2]=3
    d_test=Data(0.,(3,3),FunctionOnBoundary(self.domain))
    d_test[2,2]=x[0]
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d=d_test, y=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]+7*x[1]+5*x[0]
    u[1]=(-4)-3*x[2]-1*x[1]+3*x[0]
    u[2]=(-9)+6*x[2]+6*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=40
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]+6*x[1]+8*x[0]
    u[1]=4+4*x[2]+3*x[1]-1*x[0]
    u[2]=3+4*x[2]+8*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-8*x[2]-2*x[1]-8*x[0]
    u[1]=(-6)+7*x[2]+4*x[1]-1*x[0]
    u[2]=7+8*x[2]-1*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,2]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-32)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+4*x[1]+7*x[0]
    u[1]=(-6)+3*x[2]-1*x[1]+2*x[0]
    u[2]=(-3)+x[2]-3*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-8*x[2]+x[1]-8*x[0]
    u[1]=5-5*x[2]+7*x[1]-2*x[0]
    u[2]=(-4)-5*x[2]+7*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,1]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=49
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-2*x[2]-2*x[1]-3*x[0]
    u[1]=(-3)+8*x[2]+2*x[1]+x[0]
    u[2]=1+2*x[2]+5*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,2]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=56
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]-8*x[1]-9*x[0]
    u[1]=(-1)-9*x[2]+2*x[1]-5*x[0]
    u[2]=3+5*x[2]+6*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-56)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+x[2]+3*x[1]+3*x[0]
    u[1]=(-2)+4*x[2]-6*x[1]-4*x[0]
    u[2]=2+2*x[2]-5*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-8*x[2]-1*x[1]-6*x[0]
    u[1]=7-8*x[2]-4*x[1]+4*x[0]
    u[2]=3+7*x[2]-9*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=14
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]+4*x[1]+3*x[0]
    u[1]=2+7*x[2]+2*x[1]-8*x[0]
    u[2]=(-3)+x[2]+4*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,0]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=9
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-4*x[2]+6*x[1]+x[0]
    u[1]=2-2*x[2]+8*x[1]-1*x[0]
    u[2]=5-8*x[2]-4*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,1]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]+x[1]-1*x[0]
    u[1]=(-6)+x[2]+x[1]-7*x[0]
    u[2]=(-3)+3*x[2]+5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,2]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+7*x[2]-7*x[1]+4*x[0]
    u[1]=6+6*x[2]+5*x[1]-7*x[0]
    u[2]=(-6)-7*x[2]+8*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,0]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]+5*x[1]-6*x[0]
    u[1]=(-7)-7*x[2]+2*x[1]-2*x[0]
    u[2]=5+2*x[2]+6*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,1]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=8
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+x[2]+3*x[1]-6*x[0]
    u[1]=(-5)-2*x[2]+4*x[1]+6*x[0]
    u[2]=4-2*x[2]-2*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-4)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]-2*x[1]-9*x[0]
    u[1]=(-3)+2*x[2]-9*x[1]-2*x[0]
    u[2]=(-3)-9*x[2]+x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,0]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=21
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+4*x[2]-4*x[1]-8*x[0]
    u[1]=5-1*x[2]-1*x[1]-9*x[0]
    u[2]=(-7)+3*x[2]+3*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,1]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+5*x[2]-5*x[1]+2*x[0]
    u[1]=(-2)+2*x[2]+4*x[1]-6*x[0]
    u[2]=(-9)+2*x[2]+8*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,2]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-8*x[2]+2*x[1]-5*x[0]
    u[1]=2-4*x[2]+2*x[1]-7*x[0]
    u[2]=1+4*x[2]-8*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,0]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+6*x[2]-2*x[1]+8*x[0]
    u[1]=8+2*x[2]+5*x[1]-6*x[0]
    u[2]=(-9)+2*x[2]-5*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+3*x[2]+5*x[1]+3*x[0]
    u[1]=(-1)-2*x[2]-9*x[1]-4*x[0]
    u[2]=3+2*x[2]+2*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-4*x[2]+8*x[1]-1*x[0]
    u[1]=4+3*x[2]-3*x[1]+2*x[0]
    u[2]=7+3*x[2]+x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+8*x[2]+x[1]-2*x[0]
    u[1]=2-6*x[2]+2*x[1]-9*x[0]
    u[2]=(-2)-6*x[2]+7*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=12
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+4*x[2]-5*x[1]-6*x[0]
    u[1]=(-3)+6*x[2]-8*x[1]+3*x[0]
    u[2]=6-7*x[2]+2*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=18
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]-9*x[1]+8*x[0]
    u[1]=(-1)-4*x[2]-1*x[1]+x[0]
    u[2]=8+x[2]-2*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-8*x[2]+8*x[1]-8*x[0]
    u[1]=(-1)+7*x[2]+8*x[1]+8*x[0]
    u[2]=6-6*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,1]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-4)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]-8*x[1]+x[0]
    u[1]=(-6)-9*x[2]-9*x[1]-7*x[0]
    u[2]=7-6*x[2]-6*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-12)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]-6*x[1]+3*x[0]
    u[1]=6-7*x[2]+8*x[1]+3*x[0]
    u[2]=(-6)-5*x[2]-3*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-8*x[2]+4*x[1]-3*x[0]
    u[1]=3-6*x[2]+4*x[1]-9*x[0]
    u[2]=(-3)-7*x[2]+2*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-2*x[2]+6*x[1]-7*x[0]
    u[1]=2-8*x[2]+7*x[1]+x[0]
    u[2]=2-4*x[2]-1*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,2]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-10)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-1*x[2]+6*x[1]-6*x[0]
    u[1]=7+x[2]+5*x[1]-2*x[0]
    u[2]=2-5*x[2]-2*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]-8*x[1]-8*x[0]
    u[1]=(-6)+2*x[2]-5*x[1]-9*x[0]
    u[2]=(-5)+3*x[2]-2*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-7*x[2]+7*x[1]+3*x[0]
    u[1]=2+8*x[2]+4*x[1]+5*x[0]
    u[2]=8+6*x[2]-3*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,2]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=56
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+x[2]+2*x[1]-2*x[0]
    u[1]=5+8*x[2]-9*x[1]+6*x[0]
    u[2]=2+6*x[2]-4*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-2)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+8*x[2]+3*x[1]+7*x[0]
    u[1]=(-5)+3*x[2]+6*x[1]+7*x[0]
    u[2]=(-4)-8*x[2]+3*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,1]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=21
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]-3*x[1]+x[0]
    u[1]=(-6)+6*x[2]+x[1]+8*x[0]
    u[2]=5-5*x[2]-1*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-10)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+6*x[2]-6*x[1]+2*x[0]
    u[1]=6-7*x[2]-5*x[1]+7*x[0]
    u[2]=(-9)-3*x[2]+4*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]-8*x[1]-4*x[0]
    u[1]=(-9)-1*x[2]+2*x[1]-4*x[0]
    u[2]=7-8*x[2]+6*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-5*x[2]+x[1]+4*x[0]
    u[1]=(-1)+7*x[2]-2*x[1]+2*x[0]
    u[2]=(-3)+6*x[2]-3*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,2]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-6*x[2]-8*x[1]-3*x[0]
    u[1]=8-6*x[2]+7*x[1]+6*x[0]
    u[2]=6-7*x[2]-1*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,0]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=36
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-5*x[2]-1*x[1]+2*x[0]
    u[1]=(-5)-4*x[2]-9*x[1]-9*x[0]
    u[2]=2-1*x[2]-7*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-27)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-9*x[2]+x[1]-8*x[0]
    u[1]=(-1)+4*x[2]-2*x[1]+3*x[0]
    u[2]=8+4*x[2]+x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,2]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-4*x[2]-5*x[1]-4*x[0]
    u[1]=(-6)+4*x[2]+6*x[1]-6*x[0]
    u[2]=1+2*x[2]-9*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,0]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=25
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-6*x[2]+7*x[1]-9*x[0]
    u[1]=1-1*x[2]+4*x[1]-4*x[0]
    u[2]=(-4)-8*x[2]+8*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+6*x[2]+3*x[1]-7*x[0]
    u[1]=(-1)-5*x[2]-5*x[1]+7*x[0]
    u[2]=(-9)+4*x[2]+6*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,2]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]-5*x[1]-5*x[0]
    u[1]=3+2*x[2]+x[1]-6*x[0]
    u[2]=5-3*x[2]-2*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-5)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+2*x[2]-2*x[1]-2*x[0]
    u[1]=5-2*x[2]-6*x[1]+6*x[0]
    u[2]=7-6*x[2]+5*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-7*x[2]+7*x[1]+7*x[0]
    u[1]=(-1)-5*x[2]-1*x[1]-1*x[0]
    u[2]=7-3*x[2]+6*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,2]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-5*x[1]+8*x[0]
    u[1]=7-5*x[2]+3*x[1]-7*x[0]
    u[2]=(-2)+6*x[2]-1*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,0]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-42)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-2*x[2]+8*x[1]-2*x[0]
    u[1]=3+x[2]-4*x[1]+6*x[0]
    u[2]=3+2*x[2]-5*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-12)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+x[2]+7*x[1]+6*x[0]
    u[1]=8-9*x[2]+4*x[1]-4*x[0]
    u[2]=(-1)-7*x[2]-2*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-8*x[2]-7*x[1]+2*x[0]
    u[1]=4-6*x[2]-7*x[1]-4*x[0]
    u[2]=6-3*x[2]-6*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,0]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-4*x[2]+8*x[1]+8*x[0]
    u[1]=7-6*x[2]+x[1]-3*x[0]
    u[2]=(-8)+5*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,1]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=40
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp1222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-4*x[2]+3*x[1]-1*x[0]
    u[1]=(-4)+6*x[2]+6*x[1]+5*x[0]
    u[2]=(-6)-9*x[2]+3*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]-7*x[1]+4*x[0]
    u[1]=1+7*x[2]-1*x[1]+6*x[0]
    u[2]=(-2)+4*x[2]+3*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=32
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]-9*x[1]-9*x[0]
    u[1]=3-5*x[2]+x[1]+3*x[0]
    u[2]=3-2*x[2]+4*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-9)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+2*x[2]-6*x[1]-7*x[0]
    u[1]=8+6*x[2]-5*x[1]-3*x[0]
    u[2]=(-8)-7*x[2]-1*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,2]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+2*x[2]+2*x[1]+4*x[0]
    u[1]=7-9*x[2]-5*x[1]-7*x[0]
    u[2]=(-3)-8*x[2]-9*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-56)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-4*x[2]+6*x[1]-4*x[0]
    u[1]=4-6*x[2]+6*x[1]+3*x[0]
    u[2]=(-2)-3*x[2]-6*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,1]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=30
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]+4*x[1]-2*x[0]
    u[1]=(-2)+2*x[2]+6*x[1]+8*x[0]
    u[2]=(-9)-9*x[2]+6*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]-7*x[1]-4*x[0]
    u[1]=(-5)-5*x[2]-2*x[1]-5*x[0]
    u[2]=(-4)+4*x[2]-9*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,0]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=9
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-8*x[2]-6*x[1]-5*x[0]
    u[1]=(-6)+8*x[2]+5*x[1]+6*x[0]
    u[2]=(-2)-9*x[2]+3*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,1]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]-9*x[1]+6*x[0]
    u[1]=(-1)+8*x[2]-1*x[1]+4*x[0]
    u[2]=1-3*x[2]-4*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,2]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-4*x[2]-4*x[1]+5*x[0]
    u[1]=(-7)+4*x[2]+2*x[1]-4*x[0]
    u[2]=(-5)+8*x[2]-6*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=10
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-6*x[2]+3*x[1]-1*x[0]
    u[1]=(-6)+6*x[2]+2*x[1]+2*x[0]
    u[2]=(-4)-8*x[2]-2*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=3
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-4*x[2]+5*x[1]-4*x[0]
    u[1]=(-4)+5*x[2]-2*x[1]-1*x[0]
    u[2]=3+2*x[2]-9*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,2]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-32)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+8*x[2]+4*x[1]-8*x[0]
    u[1]=5+6*x[2]-5*x[1]-8*x[0]
    u[2]=(-4)+6*x[2]+4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-16)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+2*x[2]-9*x[1]+3*x[0]
    u[1]=7+4*x[2]+7*x[1]-1*x[0]
    u[2]=(-9)-4*x[2]-4*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,1]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=28
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]+x[1]+7*x[0]
    u[1]=2-8*x[2]+8*x[1]+3*x[0]
    u[2]=2+2*x[2]-3*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,2]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+3*x[2]+3*x[1]+5*x[0]
    u[1]=2-2*x[2]-7*x[1]-5*x[0]
    u[2]=4+2*x[2]-5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,0]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+6*x[1]+6*x[0]
    u[1]=5+7*x[2]-2*x[1]+5*x[0]
    u[2]=1+3*x[2]+3*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,1]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]+3*x[1]-8*x[0]
    u[1]=1+x[2]+5*x[1]-5*x[0]
    u[2]=(-2)-9*x[2]+7*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,2]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+3*x[2]-6*x[1]+x[0]
    u[1]=(-5)-8*x[2]-4*x[1]+2*x[0]
    u[2]=5-5*x[2]-8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,0]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=7
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-8*x[2]-8*x[1]-2*x[0]
    u[1]=3-3*x[2]-8*x[1]-3*x[0]
    u[2]=5+2*x[2]-8*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-6*x[1]-6*x[0]
    u[1]=(-5)+5*x[2]-9*x[1]+6*x[0]
    u[2]=3+8*x[2]+7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,2]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]+4*x[1]+3*x[0]
    u[1]=(-8)-7*x[2]+4*x[1]-5*x[0]
    u[2]=(-2)-1*x[2]-7*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,0]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-3*x[2]+6*x[1]-4*x[0]
    u[1]=(-6)-2*x[2]-6*x[1]-6*x[0]
    u[2]=5+4*x[2]+8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-36)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]+5*x[1]-6*x[0]
    u[1]=7-5*x[2]+8*x[1]+5*x[0]
    u[2]=6-9*x[2]-6*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-8*x[1]-9*x[0]
    u[1]=8+3*x[2]+x[1]-6*x[0]
    u[2]=5+6*x[2]+5*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=7
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]-8*x[1]-4*x[0]
    u[1]=7-1*x[2]+7*x[1]+2*x[0]
    u[2]=6+3*x[2]-8*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,1]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-16)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Const_typeWeak_comp2222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+5*x[2]+x[1]+8*x[0]
    u[1]=(-8)+3*x[2]-3*x[1]+2*x[0]
    u[2]=(-7)-7*x[2]+5*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-21)
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-8*x[2]+5*x[1]+3*x[0]
    u[1]=1-3*x[2]+3*x[1]-5*x[0]
    u[2]=5-8*x[2]+4*x[1]-1*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=48-64*x[2]+40*x[1]+24*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+4*x[2]+8*x[1]-2*x[0]
    u[1]=5-6*x[2]+8*x[1]-4*x[0]
    u[2]=8-1*x[2]-8*x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,1]=4
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=20-24*x[2]+32*x[1]-16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+4*x[2]-3*x[1]-5*x[0]
    u[1]=(-8)+3*x[2]-8*x[1]+2*x[0]
    u[2]=2-7*x[2]+3*x[1]-7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,2]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=14-49*x[2]+21*x[1]-49*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+2*x[2]+4*x[1]-4*x[0]
    u[1]=(-2)+4*x[2]+6*x[1]+5*x[0]
    u[2]=6-8*x[2]+5*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,0]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=32+16*x[2]+32*x[1]-32*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+6*x[2]-1*x[1]+6*x[0]
    u[1]=(-9)+2*x[2]+8*x[1]-4*x[0]
    u[2]=(-6)-5*x[2]-6*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,1]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-72)+16*x[2]+64*x[1]-32*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+6*x[2]-6*x[1]+5*x[0]
    u[1]=4-1*x[2]-2*x[1]-7*x[0]
    u[2]=2+5*x[2]-1*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=6+15*x[2]-3*x[1]-24*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+2*x[2]-4*x[1]+2*x[0]
    u[1]=2+6*x[2]+6*x[1]-1*x[0]
    u[2]=6-8*x[2]+x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,0]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=35+14*x[2]-28*x[1]+14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-5*x[2]-9*x[1]-9*x[0]
    u[1]=(-2)-5*x[2]+6*x[1]-7*x[0]
    u[2]=(-1)+4*x[2]-6*x[1]-5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-12)-30*x[2]+36*x[1]-42*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+3*x[2]+x[1]-8*x[0]
    u[1]=(-9)-9*x[2]-6*x[1]-1*x[0]
    u[2]=7-5*x[2]-7*x[1]-3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,2]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=49-35*x[2]-49*x[1]-21*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-9*x[2]-9*x[1]+6*x[0]
    u[1]=(-2)-4*x[2]-9*x[1]+4*x[0]
    u[2]=(-2)+x[2]-3*x[1]+6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,0]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=12-27*x[2]-27*x[1]+18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]+7*x[1]+3*x[0]
    u[1]=6-1*x[2]+8*x[1]-1*x[0]
    u[2]=(-6)+3*x[2]-8*x[1]-5*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,1]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=18-3*x[2]+24*x[1]-3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+6*x[2]-8*x[1]+7*x[0]
    u[1]=1+5*x[2]+8*x[1]-4*x[0]
    u[2]=(-5)-6*x[2]-5*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,2]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-5)-6*x[2]-5*x[1]-2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-2*x[2]+2*x[1]-4*x[0]
    u[1]=(-5)+x[2]-8*x[1]-6*x[0]
    u[2]=(-3)-9*x[2]-1*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=8-2*x[2]+2*x[1]-4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+5*x[2]-5*x[1]+3*x[0]
    u[1]=3-7*x[2]+2*x[1]+2*x[0]
    u[2]=(-8)+5*x[2]-8*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,1]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=3-7*x[2]+2*x[1]+2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+8*x[2]-8*x[1]-2*x[0]
    u[1]=4-8*x[2]+3*x[1]-5*x[0]
    u[2]=(-6)+4*x[2]+3*x[1]+3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,2]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-36)+24*x[2]+18*x[1]+18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]-7*x[1]+4*x[0]
    u[1]=(-7)+5*x[2]-1*x[1]-7*x[0]
    u[2]=5-5*x[2]+x[1]+7*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,0]=7
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-63)+28*x[2]-49*x[1]+28*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-2*x[2]+6*x[1]-6*x[0]
    u[1]=(-1)+x[2]-8*x[1]-8*x[0]
    u[2]=(-2)+5*x[2]-2*x[1]+6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)+6*x[2]-48*x[1]-48*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-6*x[2]-3*x[1]+8*x[0]
    u[1]=6+2*x[2]-8*x[1]+4*x[0]
    u[2]=(-4)-3*x[2]+x[1]+2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,2]=8
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-32)-24*x[2]+8*x[1]+16*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-9*x[2]+8*x[1]-9*x[0]
    u[1]=(-9)-2*x[2]+7*x[1]+8*x[0]
    u[2]=(-9)+x[2]+7*x[1]-4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,0]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-10)-18*x[2]+16*x[1]-18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-3*x[2]+2*x[1]-9*x[0]
    u[1]=5-2*x[2]+8*x[1]-7*x[0]
    u[2]=(-8)+8*x[2]+6*x[1]+4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,1]=2
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=10-4*x[2]+16*x[1]-14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+3*x[2]+x[1]+3*x[0]
    u[1]=(-2)-1*x[2]-3*x[1]+5*x[0]
    u[2]=8-7*x[2]-2*x[1]-4*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=24-21*x[2]-6*x[1]-12*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+8*x[2]+4*x[1]-6*x[0]
    u[1]=(-9)-4*x[2]-5*x[1]+x[0]
    u[2]=(-1)+5*x[2]+6*x[1]-6*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,0]=1
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-3)+8*x[2]+4*x[1]-6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+8*x[2]+4*x[1]+3*x[0]
    u[1]=(-7)+3*x[2]-2*x[1]-7*x[0]
    u[2]=(-3)-4*x[2]-8*x[1]-2*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,1]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-35)+15*x[2]-10*x[1]-35*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]+7*x[1]-1*x[0]
    u[1]=5+3*x[2]-7*x[1]-3*x[0]
    u[2]=6+x[2]-7*x[1]-8*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,2]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=36+6*x[2]-42*x[1]-48*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]+2*x[1]-8*x[0]
    u[1]=(-5)+4*x[2]+3*x[1]-1*x[0]
    u[2]=(-8)-7*x[2]-2*x[1]+x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,0]=5
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-5)-10*x[2]+10*x[1]-40*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-7*x[2]+4*x[1]+8*x[0]
    u[1]=(-5)+8*x[2]+4*x[1]-6*x[0]
    u[2]=(-2)+2*x[2]-3*x[1]-1*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,1]=6
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-30)+48*x[2]+24*x[1]-36*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Const_typeWeak_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]-3*x[1]+7*x[0]
    u[1]=(-7)+2*x[2]-4*x[1]+4*x[0]
    u[2]=(-9)+6*x[2]+7*x[1]+3*x[0]
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,2]=3
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-27)+18*x[2]+21*x[1]+9*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-2*x[2]-5*x[1]-4*x[0]
    u[1]=(-4)+8*x[2]-3*x[1]+4*x[0]
    u[2]=4+2*x[2]-2*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-6*x[2]-4*x[1]-1*x[0]
    u[1]=5+2*x[2]-9*x[1]+6*x[0]
    u[2]=2-8*x[2]+8*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+8*x[2]-1*x[1]-2*x[0]
    u[1]=(-1)-1*x[2]+x[1]+5*x[0]
    u[2]=5-4*x[2]+3*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-9*x[2]+7*x[1]+2*x[0]
    u[1]=(-6)-3*x[2]-7*x[1]-5*x[0]
    u[2]=5+2*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+7*x[2]-3*x[1]+8*x[0]
    u[1]=(-9)+7*x[2]-3*x[1]+x[0]
    u[2]=(-9)+8*x[2]-3*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-8*x[2]+x[1]+3*x[0]
    u[1]=8+7*x[2]+8*x[1]-7*x[0]
    u[2]=(-7)-6*x[2]+2*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,1,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-3*x[2]+3*x[1]-3*x[0]
    u[1]=(-4)-8*x[2]-6*x[1]+4*x[0]
    u[2]=(-6)-5*x[2]-8*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+4*x[2]+x[1]+2*x[0]
    u[1]=4-3*x[2]+7*x[1]+7*x[0]
    u[2]=2-2*x[2]+4*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+5*x[2]+4*x[1]+2*x[0]
    u[1]=5+6*x[2]-8*x[1]-6*x[0]
    u[2]=8+4*x[2]+x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,0,2,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-8*x[2]-1*x[1]-3*x[0]
    u[1]=1+3*x[2]-1*x[1]-8*x[0]
    u[2]=(-9)+4*x[2]-9*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-3)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-3*x[2]+4*x[1]-5*x[0]
    u[1]=(-3)-3*x[2]-8*x[1]-3*x[0]
    u[2]=4+8*x[2]+4*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+5*x[2]-6*x[1]+x[0]
    u[1]=1-5*x[2]-3*x[1]+7*x[0]
    u[2]=(-2)-7*x[2]-4*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,0,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=5*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+3*x[2]+7*x[1]+x[0]
    u[1]=7-6*x[2]+6*x[1]+8*x[0]
    u[2]=(-3)+3*x[2]+7*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+3*x[2]+8*x[1]-1*x[0]
    u[1]=(-4)-2*x[2]+2*x[1]+8*x[0]
    u[2]=(-4)+8*x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=2*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-7*x[2]-8*x[1]-3*x[0]
    u[1]=5+4*x[2]-7*x[1]-9*x[0]
    u[2]=4-2*x[2]+5*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]+6*x[1]+x[0]
    u[1]=(-7)+x[2]-1*x[1]-6*x[0]
    u[2]=(-7)+3*x[2]+8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-3*x[2]+x[1]+7*x[0]
    u[1]=8-5*x[2]+8*x[1]-2*x[0]
    u[2]=(-9)-6*x[2]+6*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=6*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+x[2]+x[1]-1*x[0]
    u[1]=2-4*x[2]+6*x[1]-5*x[0]
    u[2]=(-9)+7*x[2]+7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,1,2,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+2*x[2]+5*x[1]+2*x[0]
    u[1]=7+7*x[2]-6*x[1]-2*x[0]
    u[2]=(-8)+7*x[2]-5*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-5*x[2]+6*x[1]-7*x[0]
    u[1]=(-4)-7*x[2]+7*x[1]+x[0]
    u[2]=(-6)+2*x[2]+7*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]-1*x[1]-3*x[0]
    u[1]=(-6)+4*x[2]-5*x[1]+5*x[0]
    u[2]=6+7*x[2]+2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,0,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+2*x[2]+x[1]+7*x[0]
    u[1]=(-5)-9*x[2]-6*x[1]-2*x[0]
    u[2]=1-6*x[2]+7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-2*x[1]+7*x[0]
    u[1]=(-9)+2*x[2]-8*x[1]-6*x[0]
    u[2]=3+7*x[2]+3*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-8)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+4*x[2]+7*x[1]+2*x[0]
    u[1]=(-7)-4*x[2]+8*x[1]+2*x[0]
    u[2]=(-5)+6*x[2]+6*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,1,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-2*x[2]-7*x[1]-9*x[0]
    u[1]=7+7*x[2]+7*x[1]-9*x[0]
    u[2]=(-8)-1*x[2]-4*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]-9*x[1]+8*x[0]
    u[1]=8+6*x[2]-9*x[1]+2*x[0]
    u[2]=(-3)+5*x[2]+6*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+5*x[2]-6*x[1]+x[0]
    u[1]=(-2)-1*x[2]+x[1]+8*x[0]
    u[2]=(-3)+4*x[2]-6*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[0,2,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=4*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+3*x[2]-5*x[1]-8*x[0]
    u[1]=5-4*x[2]+4*x[1]+8*x[0]
    u[2]=(-2)+5*x[2]-7*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-5*x[2]+5*x[1]+8*x[0]
    u[1]=(-5)-9*x[2]+5*x[1]-4*x[0]
    u[2]=(-4)-5*x[2]-8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=5*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-2*x[2]-5*x[1]-9*x[0]
    u[1]=4-9*x[2]-3*x[1]-6*x[0]
    u[2]=(-6)+6*x[2]+2*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-1*x[2]-8*x[1]-1*x[0]
    u[1]=8+x[2]+x[1]-5*x[0]
    u[2]=6+3*x[2]-5*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-9*x[2]+7*x[1]-8*x[0]
    u[1]=(-6)+6*x[2]-9*x[1]+4*x[0]
    u[2]=7-2*x[2]+2*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-5*x[2]+7*x[1]+x[0]
    u[1]=2+7*x[2]+2*x[1]+6*x[0]
    u[2]=3+4*x[2]-1*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,1,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-9*x[1]+3*x[0]
    u[1]=(-7)-9*x[2]+6*x[1]+x[0]
    u[2]=8-1*x[2]+x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-4*x[2]-5*x[1]-4*x[0]
    u[1]=(-9)-2*x[2]+x[1]-5*x[0]
    u[2]=(-1)-9*x[2]+2*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]-3*x[1]+7*x[0]
    u[1]=3-9*x[2]+x[1]-8*x[0]
    u[2]=3+8*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,0,2,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]-3*x[1]-8*x[0]
    u[1]=(-9)+2*x[2]-5*x[1]-9*x[0]
    u[2]=(-3)+8*x[2]-5*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+6*x[2]-7*x[1]+7*x[0]
    u[1]=(-7)-2*x[2]+3*x[1]-2*x[0]
    u[2]=(-2)+4*x[2]+5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-7*x[2]+6*x[1]-3*x[0]
    u[1]=6-3*x[2]+4*x[1]+8*x[0]
    u[2]=(-3)-4*x[2]+7*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,0,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+8*x[2]+x[1]-7*x[0]
    u[1]=(-6)-5*x[2]-2*x[1]-9*x[0]
    u[2]=6+3*x[2]-6*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-9)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-1*x[2]+3*x[1]-1*x[0]
    u[1]=1+2*x[2]+8*x[1]+6*x[0]
    u[2]=2-6*x[2]-9*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]-2*x[1]-7*x[0]
    u[1]=(-5)-2*x[2]-3*x[1]+3*x[0]
    u[2]=(-3)+2*x[2]-7*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+3*x[2]-5*x[1]-6*x[0]
    u[1]=(-7)+4*x[2]-4*x[1]-4*x[0]
    u[2]=1+6*x[2]-1*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+5*x[2]-7*x[1]-6*x[0]
    u[1]=3-1*x[2]-8*x[1]-7*x[0]
    u[2]=(-2)-8*x[2]-5*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-5)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+x[2]-1*x[1]-4*x[0]
    u[1]=2-1*x[2]+8*x[1]+5*x[0]
    u[2]=6-8*x[2]+4*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,1,2,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-6*x[2]+x[1]-5*x[0]
    u[1]=1-9*x[2]-7*x[1]-2*x[0]
    u[2]=(-9)-7*x[2]+3*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+2*x[2]+8*x[1]+7*x[0]
    u[1]=(-7)+4*x[2]-6*x[1]+5*x[0]
    u[2]=(-7)-3*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-3*x[2]-7*x[1]-7*x[0]
    u[1]=(-8)+7*x[2]+6*x[1]+3*x[0]
    u[2]=6-7*x[2]+x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,0,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-3)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+x[2]+7*x[1]+7*x[0]
    u[1]=(-5)-9*x[2]-4*x[1]-8*x[0]
    u[2]=5+6*x[2]-2*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-8)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-8*x[2]-7*x[1]-4*x[0]
    u[1]=(-1)-4*x[2]+5*x[1]+7*x[0]
    u[2]=(-7)-9*x[2]+x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-1*x[2]+6*x[1]-7*x[0]
    u[1]=4+x[2]+5*x[1]-1*x[0]
    u[2]=1-7*x[2]-8*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,1,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]+5*x[1]+6*x[0]
    u[1]=(-6)+2*x[2]-5*x[1]-4*x[0]
    u[2]=(-2)-4*x[2]+x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+4*x[2]+x[1]+x[0]
    u[1]=(-4)+4*x[2]-5*x[1]-6*x[0]
    u[2]=5-8*x[2]+7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=7*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp1222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+7*x[2]-1*x[1]-3*x[0]
    u[1]=8-9*x[2]-3*x[1]+6*x[0]
    u[2]=8+3*x[2]+5*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[1,2,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=3*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+3*x[2]-9*x[1]-3*x[0]
    u[1]=5-8*x[2]-4*x[1]+x[0]
    u[2]=5+4*x[2]+x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-8*x[2]-1*x[1]-4*x[0]
    u[1]=(-6)-9*x[2]+4*x[1]-9*x[0]
    u[2]=(-5)+2*x[2]-3*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-2*x[2]-6*x[1]-9*x[0]
    u[1]=4-8*x[2]-9*x[1]-6*x[0]
    u[2]=8-2*x[2]-1*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-2*x[2]-8*x[1]+8*x[0]
    u[1]=(-1)-5*x[2]+7*x[1]+8*x[0]
    u[2]=(-4)+6*x[2]-3*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+x[2]+2*x[1]+6*x[0]
    u[1]=(-5)+6*x[2]-6*x[1]-2*x[0]
    u[2]=(-3)+4*x[2]-8*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]-8*x[1]+2*x[0]
    u[1]=(-5)-1*x[2]-5*x[1]-5*x[0]
    u[2]=(-4)+3*x[2]-6*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,1,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]+3*x[1]-2*x[0]
    u[1]=2-6*x[2]-6*x[1]-6*x[0]
    u[2]=1-4*x[2]+8*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-5*x[2]+5*x[1]+8*x[0]
    u[1]=4-4*x[2]-5*x[1]+x[0]
    u[2]=4+3*x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]+8*x[1]-9*x[0]
    u[1]=(-5)+4*x[2]+2*x[1]-3*x[0]
    u[2]=2+6*x[2]-6*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,0,2,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+8*x[2]-9*x[1]+3*x[0]
    u[1]=(-6)+7*x[2]-9*x[1]-9*x[0]
    u[2]=(-8)+x[2]-5*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-2*x[2]+3*x[1]+7*x[0]
    u[1]=(-6)+x[2]+4*x[1]-9*x[0]
    u[2]=3+3*x[2]+6*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+4*x[2]-4*x[1]-9*x[0]
    u[1]=(-9)+x[2]-2*x[1]+4*x[0]
    u[2]=(-6)-1*x[2]+5*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,0,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=4*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+8*x[2]-3*x[1]-6*x[0]
    u[1]=4+4*x[2]-8*x[1]-7*x[0]
    u[2]=(-3)-8*x[2]-3*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+4*x[2]-4*x[1]-7*x[0]
    u[1]=6-1*x[2]+7*x[1]-6*x[0]
    u[2]=(-4)+5*x[2]-8*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-5*x[2]-5*x[1]+6*x[0]
    u[1]=5+7*x[2]+8*x[1]+2*x[0]
    u[2]=4-1*x[2]-8*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]-1*x[1]-7*x[0]
    u[1]=(-3)-5*x[2]-8*x[1]-2*x[0]
    u[2]=4+4*x[2]-8*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-1)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+4*x[2]-9*x[1]+5*x[0]
    u[1]=(-1)+7*x[2]+3*x[1]+x[0]
    u[2]=1+x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-7)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+6*x[2]+7*x[1]+7*x[0]
    u[1]=(-4)-3*x[2]+2*x[1]+4*x[0]
    u[2]=(-9)+3*x[2]-7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,1,2,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-3*x[2]+3*x[1]-1*x[0]
    u[1]=(-5)-4*x[2]-1*x[1]+5*x[0]
    u[2]=5+5*x[2]-3*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-1)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-5*x[2]-5*x[1]+3*x[0]
    u[1]=7-1*x[2]+5*x[1]+7*x[0]
    u[2]=2-8*x[2]+5*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-4*x[2]-5*x[1]-9*x[0]
    u[1]=(-3)-9*x[2]+3*x[1]+x[0]
    u[2]=(-9)+6*x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,0,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-9*x[2]+4*x[1]+4*x[0]
    u[1]=2+x[2]-5*x[1]-5*x[0]
    u[2]=8+6*x[2]-3*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]-8*x[1]+x[0]
    u[1]=7-3*x[2]+2*x[1]+3*x[0]
    u[2]=1-2*x[2]-3*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+2*x[2]-1*x[1]-6*x[0]
    u[1]=(-6)+6*x[2]-6*x[1]-1*x[0]
    u[2]=(-8)+7*x[2]-5*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,1,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+4*x[2]-5*x[1]+x[0]
    u[1]=1+3*x[2]-8*x[1]-4*x[0]
    u[2]=(-9)+5*x[2]+3*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+2*x[2]-4*x[1]+8*x[0]
    u[1]=8-9*x[2]-3*x[1]+7*x[0]
    u[2]=(-3)+6*x[2]+2*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_A_Vario_typeWeak_comp2222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-4*x[2]-2*x[1]-8*x[0]
    u[1]=(-5)-9*x[2]+x[1]+7*x[0]
    u[2]=2-7*x[2]-1*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),Function(self.domain))
    A_test[2,2,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-7)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A=A_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=(-4)
    u[2]=(-8)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=2
    u[2]=(-6)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=7
    u[2]=(-7)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=5
    u[2]=1
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=7
    u[2]=1
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)
    u[1]=8
    u[2]=(-6)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-6)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1
    u[1]=(-1)
    u[2]=(-9)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=(-9)
    u[2]=(-7)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=2
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[0,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-3)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=2
    u[2]=8
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=1
    u[2]=5
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=(-7)
    u[2]=7
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=8
    u[2]=8
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)
    u[1]=7
    u[2]=(-1)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=8
    u[2]=3
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=(-2)
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=4
    u[2]=(-1)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=4*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=4
    u[2]=5
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[1,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[1,2]=5*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=8
    u[2]=5
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,0]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-1)
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,1]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=(-1)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=7
    u[2]=1
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,0,2]=x[0]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,0]=x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=7
    u[2]=(-9)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,0]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=(-4)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=1
    u[2]=(-8)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,1]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=(-8)
    u[2]=3
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,1,2]=x[1]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=4
    u[2]=2
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,0]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=4*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-1)
    u[2]=1
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,1]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-1)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOFull_NEqu3_B_Vario_typeWeak_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=4
    u[2]=(-7)
    B_test=Data(0.,(3,3,3),Function(self.domain))
    B_test[2,2,2]=x[2]
    X_test=Data(0.,(3, 3),ContinuousFunction(self.domain))
    X_test[2,2]=(-7)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B=B_test, X=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=(-3)-8*x[2]-8*x[1]-7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,0]=8
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-56))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=8-2*x[2]-3*x[1]-8*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,1]=5
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=(-1)+6*x[2]-5*x[1]-4*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,2]=2
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=(-9)-7*x[2]-4*x[1]+7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,0]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*(7)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=4+8*x[2]-8*x[1]-6*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,1]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=(-8)+2*x[2]-5*x[1]-9*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,2]=4
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=3-1*x[2]+4*x[1]-7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,0]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*((-7))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=7+3*x[2]+6*x[1]+3*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,1]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=(-5)-1*x[2]+6*x[1]-4*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,2]=2
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeStrong_comp0(self):
    x=self.domain.getX()
    u=(-4)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[0]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeStrong_comp1(self):
    x=self.domain.getX()
    u=(-7)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[1]=7
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*((-49))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeStrong_comp2(self):
    x=self.domain.getX()
    u=(-2)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[2]=1
    Y_test=0
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Const_typeStrong_comp0(self):
    x=self.domain.getX()
    u=5+x[2]-7*x[1]-9*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[0]=2
    Y_test=(-18)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Const_typeStrong_comp1(self):
    x=self.domain.getX()
    u=(-2)+8*x[2]-7*x[1]+4*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[1]=6
    Y_test=(-42)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Const_typeStrong_comp2(self):
    x=self.domain.getX()
    u=2+3*x[2]-5*x[1]+8*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[2]=6
    Y_test=18
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_D_Const_typeStrong(self):
    x=self.domain.getX()
    u=8-9*x[2]-9*x[1]-7*x[0]
    D_test=Data(5,(),ReducedFunction(self.domain))
    Y_test=40-45*x[2]-45*x[1]-35*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_d_Const_typeStrong(self):
    x=self.domain.getX()
    u=(-8)-2*x[2]-7*x[1]-7*x[0]
    d_test=Data(8,(),ReducedFunctionOnBoundary(self.domain))
    y_test=(-64)-16*x[2]-56*x[1]-56*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=(-2)+8*x[2]-2*x[1]+4*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,0]=x[0]
    Y_test=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=(-3)+6*x[2]-5*x[1]-6*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,1]=x[0]
    Y_test=5
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-5)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp02(self):
    x=self.domain.getX()
    u=5-8*x[2]-3*x[1]-1*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,2]=x[0]
    Y_test=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=(-8)+7*x[2]+6*x[1]-7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,0]=x[1]
    Y_test=7
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*((-7)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=(-7)-9*x[2]+2*x[1]+7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,1]=x[1]
    Y_test=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*(2*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp12(self):
    x=self.domain.getX()
    u=(-1)-5*x[2]-5*x[1]+2*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,2]=x[1]
    Y_test=5
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*((-5)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp20(self):
    x=self.domain.getX()
    u=(-1)+8*x[2]-2*x[1]+2*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,0]=x[2]
    Y_test=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp21(self):
    x=self.domain.getX()
    u=(-9)-4*x[2]+2*x[1]-7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,1]=x[2]
    Y_test=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeStrong_comp22(self):
    x=self.domain.getX()
    u=(-5)+x[2]-2*x[1]+6*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,2]=x[2]
    Y_test=(-1)
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeStrong_comp0(self):
    x=self.domain.getX()
    u=(-2)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[0]=x[0]
    Y_test=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeStrong_comp1(self):
    x=self.domain.getX()
    u=3
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[1]=x[1]
    Y_test=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[1]*(3*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeStrong_comp2(self):
    x=self.domain.getX()
    u=1
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[2]=x[2]
    Y_test=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Vario_typeStrong_comp0(self):
    x=self.domain.getX()
    u=(-2)+x[2]+5*x[1]-7*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[0]=x[0]
    Y_test=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Vario_typeStrong_comp1(self):
    x=self.domain.getX()
    u=8+x[2]+7*x[1]-3*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[1]=x[1]
    Y_test=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_C_Vario_typeStrong_comp2(self):
    x=self.domain.getX()
    u=(-3)-9*x[2]+x[1]+6*x[0]
    C_test=Data(0.,(3,),ReducedFunction(self.domain))
    C_test[2]=x[2]
    Y_test=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_D_Vario_typeStrong(self):
    x=self.domain.getX()
    u=2
    D_test=ReducedFunction(self.domain).getX()[0]
    Y_test=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_d_Vario_typeStrong(self):
    x=self.domain.getX()
    u=(-4)
    d_test=interpolate(x[0],ReducedFunctionOnBoundary(self.domain))
    y_test=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp00(self):
    x=self.domain.getX()
    u=(-1)+3*x[2]-6*x[1]+3*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,0]=2
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp01(self):
    x=self.domain.getX()
    u=(-2)+3*x[2]+3*x[1]+5*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,1]=8
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp02(self):
    x=self.domain.getX()
    u=(-5)-4*x[2]+4*x[1]-1*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,2]=1
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp10(self):
    x=self.domain.getX()
    u=7-6*x[2]-5*x[1]+8*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,0]=8
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=64
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp11(self):
    x=self.domain.getX()
    u=7-1*x[2]+2*x[1]-8*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,1]=6
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=12
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp12(self):
    x=self.domain.getX()
    u=1-8*x[2]+6*x[1]-9*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,2]=6
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-48)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp20(self):
    x=self.domain.getX()
    u=(-6)-3*x[2]-9*x[1]+x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,0]=2
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=2
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp21(self):
    x=self.domain.getX()
    u=(-8)-6*x[2]+5*x[1]+2*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,1]=2
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=10
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Const_typeWeak_comp22(self):
    x=self.domain.getX()
    u=(-8)+6*x[2]-9*x[1]+7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,2]=4
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=24
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeWeak_comp0(self):
    x=self.domain.getX()
    u=(-3)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[0]=1
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeWeak_comp1(self):
    x=self.domain.getX()
    u=(-2)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[1]=4
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Const_typeWeak_comp2(self):
    x=self.domain.getX()
    u=(-3)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[2]=5
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp00(self):
    x=self.domain.getX()
    u=(-9)-4*x[2]-9*x[1]-2*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,0]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp01(self):
    x=self.domain.getX()
    u=3-8*x[2]+5*x[1]-9*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,1]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=5*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp02(self):
    x=self.domain.getX()
    u=(-1)-2*x[2]-4*x[1]-7*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[0,2]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp10(self):
    x=self.domain.getX()
    u=(-4)+7*x[2]-3*x[1]-8*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,0]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp11(self):
    x=self.domain.getX()
    u=(-1)-5*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,1]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp12(self):
    x=self.domain.getX()
    u=6+5*x[2]+5*x[1]-3*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[1,2]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=5*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp20(self):
    x=self.domain.getX()
    u=(-1)-2*x[2]-3*x[1]+2*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,0]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp21(self):
    x=self.domain.getX()
    u=(-6)+8*x[2]-3*x[1]+8*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,1]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-3)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_A_Vario_typeWeak_comp22(self):
    x=self.domain.getX()
    u=2-4*x[2]-1*x[1]-4*x[0]
    A_test=Data(0.,(3,3),ReducedFunction(self.domain))
    A_test[2,2]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeWeak_comp0(self):
    x=self.domain.getX()
    u=7
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[0]=x[0]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeWeak_comp1(self):
    x=self.domain.getX()
    u=(-6)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[1]=x[1]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[1]=(-6)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu1_B_Vario_typeWeak_comp2(self):
    x=self.domain.getX()
    u=(-1)
    B_test=Data(0.,(3,),ReducedFunction(self.domain))
    B_test[2]=x[2]
    X_test=Data(0.,(3,),ContinuousFunction(self.domain))
    X_test[2]=(-1)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]+6*x[1]-5*x[0]
    u[1]=(-9)+7*x[2]-3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-6*x[2]+8*x[1]-4*x[0]
    u[1]=2-5*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(16)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+x[2]-2*x[1]+6*x[0]
    u[1]=8-1*x[2]+6*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-3*x[2]+x[1]-6*x[0]
    u[1]=1-8*x[2]+6*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]+2*x[1]-1*x[0]
    u[1]=5-4*x[2]-9*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+4*x[2]-5*x[1]-2*x[0]
    u[1]=(-4)+3*x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+5*x[2]-5*x[1]-3*x[0]
    u[1]=2-3*x[2]+5*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-18))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-3*x[2]+x[1]+8*x[0]
    u[1]=(-7)+4*x[2]-3*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-9*x[2]+7*x[1]-8*x[0]
    u[1]=(-7)+5*x[2]-2*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-72))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+3*x[2]-6*x[1]-7*x[0]
    u[1]=(-1)+2*x[2]+2*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]+4*x[1]-9*x[0]
    u[1]=8+6*x[2]+5*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(10)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]-1*x[1]-1*x[0]
    u[1]=(-7)+7*x[2]+4*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-9*x[2]+2*x[1]-9*x[0]
    u[1]=(-5)-7*x[2]-3*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]+7*x[1]+x[0]
    u[1]=(-7)-5*x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-6*x[2]-1*x[1]+x[0]
    u[1]=6+7*x[2]-8*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+6*x[2]+x[1]+6*x[0]
    u[1]=7-1*x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(10)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-2*x[2]-9*x[1]+x[0]
    u[1]=(-9)+3*x[2]-3*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]+5*x[1]-3*x[0]
    u[1]=1-1*x[2]-4*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-5))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]-8*x[1]+x[0]
    u[1]=(-8)+7*x[2]+2*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(7)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-8*x[2]+x[1]+3*x[0]
    u[1]=(-5)-4*x[2]+2*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-3*x[2]+8*x[1]+3*x[0]
    u[1]=(-2)+7*x[2]-9*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+7*x[2]+3*x[1]-4*x[0]
    u[1]=(-9)-1*x[2]-8*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-1*x[2]+3*x[1]-9*x[0]
    u[1]=1+3*x[2]+5*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(FunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+3*x[2]-2*x[1]+6*x[0]
    u[1]=4+8*x[2]+2*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(64)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-8*x[2]-5*x[1]-1*x[0]
    u[1]=(-9)+2*x[2]-5*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-3))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+2*x[2]-3*x[1]-6*x[0]
    u[1]=7+7*x[2]-6*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+2*x[2]-5*x[1]-1*x[0]
    u[1]=6-2*x[2]+5*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-9*x[2]-5*x[1]-6*x[0]
    u[1]=1+3*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+8*x[2]-9*x[1]-6*x[0]
    u[1]=(-2)-5*x[2]+7*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-9*x[2]+2*x[1]-1*x[0]
    u[1]=4+4*x[2]+8*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,2]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]+6*x[1]+6*x[0]
    u[1]=(-8)-5*x[2]-9*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,0]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]+5*x[1]-8*x[0]
    u[1]=7+5*x[2]-2*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(10)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-1*x[2]+8*x[1]-9*x[0]
    u[1]=4-4*x[2]+x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,2]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-1))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-8*x[2]+7*x[1]+4*x[0]
    u[1]=3-8*x[2]+5*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,0]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(5)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]+3*x[1]+6*x[0]
    u[1]=(-7)+5*x[2]+3*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-3*x[2]-1*x[1]+8*x[0]
    u[1]=2+4*x[2]-7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,2]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=1
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=3
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)
    u[1]=8
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,0]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1
    u[1]=1
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(5)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3
    u[1]=6
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-6)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-42))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-6)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,0]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-2)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=(-6)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,0]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(48)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=5
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,1]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(20)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=1
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,0]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)
    u[1]=3
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+x[2]-5*x[1]+2*x[0]
    u[1]=6+4*x[2]-1*x[1]-3*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+7*x[2]-5*x[1]-4*x[0]
    u[1]=1-9*x[2]+5*x[1]+7*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,1]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-10)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-8*x[1]-7*x[0]
    u[1]=5-5*x[2]-4*x[1]+5*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,2]=6
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-36)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-1*x[2]+6*x[1]-2*x[0]
    u[1]=8+6*x[2]+4*x[1]+8*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,0]=2
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=16
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+3*x[2]-5*x[1]-2*x[0]
    u[1]=(-1)-8*x[2]+3*x[1]+8*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,1]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-5*x[2]+6*x[1]+3*x[0]
    u[1]=(-6)-7*x[2]-6*x[1]-6*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,2]=3
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-21)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+6*x[2]-7*x[1]-1*x[0]
    u[1]=(-3)+2*x[2]+x[1]+4*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,0]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-8*x[2]+x[1]-4*x[0]
    u[1]=(-5)+4*x[2]-9*x[1]-1*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,1]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=7
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]+x[1]+3*x[0]
    u[1]=(-4)+3*x[2]+7*x[1]-8*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,2]=4
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=28
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3+3*x[2]+6*x[1]-5*x[0]
    u[1]=(-2)-2*x[2]+6*x[1]-5*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,0]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-4*x[2]+3*x[1]+x[0]
    u[1]=3+x[2]-5*x[1]+2*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,1]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+7*x[2]+x[1]-2*x[0]
    u[1]=(-1)-1*x[2]-9*x[1]-7*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,2]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+8*x[2]+3*x[1]+7*x[0]
    u[1]=2-2*x[2]-2*x[1]+x[0]
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[0,0]=7
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-35)+56*x[2]+21*x[1]+49*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-7*x[2]-7*x[1]+x[0]
    u[1]=(-6)+5*x[2]-3*x[1]-8*x[0]
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[0,1]=5
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-30)+25*x[2]-15*x[1]-40*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+3*x[2]-8*x[1]-8*x[0]
    u[1]=(-7)+2*x[2]-4*x[1]-9*x[0]
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[1,0]=1
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=4+3*x[2]-8*x[1]-8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+7*x[2]+7*x[1]-8*x[0]
    u[1]=3-9*x[2]-1*x[1]+7*x[0]
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[1,1]=8
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=24-72*x[2]-8*x[1]+56*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+7*x[2]+8*x[1]-3*x[0]
    u[1]=5-3*x[2]-2*x[1]-3*x[0]
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[0,0]=5
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=(-10)+35*x[2]+40*x[1]-15*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-1*x[2]+5*x[1]+x[0]
    u[1]=8+6*x[2]-1*x[1]-4*x[0]
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[0,1]=5
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=40+30*x[2]-5*x[1]-20*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]+3*x[1]+3*x[0]
    u[1]=6-9*x[2]-5*x[1]+8*x[0]
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[1,0]=7
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=14-21*x[2]+21*x[1]+21*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+3*x[1]+3*x[0]
    u[1]=(-8)-9*x[2]+8*x[1]-2*x[0]
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[1,1]=5
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=(-40)-45*x[2]+40*x[1]-10*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]+7*x[1]-6*x[0]
    u[1]=(-4)+7*x[2]-3*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-6)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]-9*x[1]+4*x[0]
    u[1]=5+x[2]+8*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-9)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+3*x[2]+6*x[1]-7*x[0]
    u[1]=3+7*x[2]+7*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-2*x[2]-1*x[1]-2*x[0]
    u[1]=(-9)+3*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-9)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+3*x[2]-8*x[1]-1*x[0]
    u[1]=(-3)-1*x[2]+x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-6*x[2]-3*x[1]+2*x[0]
    u[1]=3+3*x[2]+4*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8+6*x[2]-8*x[1]-4*x[0]
    u[1]=3+8*x[2]-3*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-4)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-3*x[2]+7*x[1]-7*x[0]
    u[1]=(-9)+7*x[2]+6*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-2*x[2]+2*x[1]-5*x[0]
    u[1]=2-5*x[2]+x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-2)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+3*x[2]-9*x[1]+4*x[0]
    u[1]=2+4*x[2]-3*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(3*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]-8*x[1]-2*x[0]
    u[1]=(-5)-7*x[2]+x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+4*x[2]+3*x[1]-5*x[0]
    u[1]=2+x[2]-8*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-3*x[2]+4*x[1]+6*x[0]
    u[1]=7+6*x[2]-5*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(6*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+7*x[1]+7*x[0]
    u[1]=8+4*x[2]-8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-9*x[1]-9*x[0]
    u[1]=(-6)-2*x[2]+2*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=3
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-3)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]-6*x[1]+3*x[0]
    u[1]=(-2)-1*x[2]+8*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-9*x[2]-5*x[1]+x[0]
    u[1]=(-8)+8*x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-3*x[2]-1*x[1]-4*x[0]
    u[1]=(-5)+x[2]-5*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+6*x[2]+2*x[1]+3*x[0]
    u[1]=8+2*x[2]+5*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]-8*x[1]-4*x[0]
    u[1]=(-6)-8*x[2]-6*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+x[2]+7*x[1]+7*x[0]
    u[1]=5+5*x[2]-5*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]-2*x[1]+6*x[0]
    u[1]=2-6*x[2]+3*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(7*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-5*x[2]+5*x[1]-5*x[0]
    u[1]=1+5*x[2]+6*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-2*x[2]+3*x[1]+8*x[0]
    u[1]=(-5)-2*x[2]+8*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]-6*x[1]-1*x[0]
    u[1]=(-5)+x[2]+3*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+3*x[2]+8*x[1]+3*x[0]
    u[1]=2+x[2]-1*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(8*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-8*x[2]+x[1]+5*x[0]
    u[1]=6+2*x[2]+7*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-8)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+3*x[2]-9*x[1]-6*x[0]
    u[1]=4-9*x[2]-6*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-1*x[2]-9*x[1]-9*x[0]
    u[1]=(-4)-5*x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(8*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-5*x[2]-6*x[1]-4*x[0]
    u[1]=6+6*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,2]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(6*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]-2*x[1]+x[0]
    u[1]=(-7)-2*x[2]+2*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-1)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]+2*x[1]+7*x[0]
    u[1]=6+3*x[2]-5*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+7*x[2]+3*x[1]-7*x[0]
    u[1]=6+8*x[2]-3*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+3*x[1]+8*x[0]
    u[1]=(-8)+8*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+5*x[2]-4*x[1]+5*x[0]
    u[1]=1+8*x[2]+5*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(5*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-6*x[2]-7*x[1]+3*x[0]
    u[1]=(-9)+7*x[2]-1*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(7*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=(-1)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=(-4)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-4)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-5)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=(-2)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-2)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-2)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(2*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=(-5)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=5
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-5)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-3)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(2*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=4
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=6
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,0]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-5)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(5*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=(-9)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=1
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,0]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-1)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=8
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,1]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-8)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(2,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(8*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-8*x[2]+2*x[1]+6*x[0]
    u[1]=7-4*x[2]-2*x[1]-1*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)-3*x[2]-2*x[1]+3*x[0]
    u[1]=8+5*x[2]-8*x[1]+7*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-2*x[2]-1*x[1]-9*x[0]
    u[1]=(-6)+4*x[2]-9*x[1]+3*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]+5*x[1]+8*x[0]
    u[1]=8+7*x[2]+4*x[1]+7*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-3*x[2]+3*x[1]-3*x[0]
    u[1]=8+2*x[2]-1*x[1]+2*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-1)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-9*x[2]+5*x[1]+5*x[0]
    u[1]=2-7*x[2]-5*x[1]+5*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[0,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+3*x[2]-7*x[1]-7*x[0]
    u[1]=8+6*x[2]-5*x[1]-6*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+7*x[2]-2*x[1]+5*x[0]
    u[1]=(-4)+7*x[2]+8*x[1]-6*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]+2*x[1]+2*x[0]
    u[1]=(-1)-8*x[2]+7*x[1]+8*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,0,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=7*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)-4*x[2]-3*x[1]+7*x[0]
    u[1]=7+7*x[2]-8*x[1]+4*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]+2*x[1]-5*x[0]
    u[1]=4+6*x[2]-2*x[1]+x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,1]=x[1]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-2)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_C_Vario_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-1*x[2]+x[1]-8*x[0]
    u[1]=(-9)-9*x[2]+6*x[1]+4*x[0]
    C_test=Data(0.,(2,2,3),ReducedFunction(self.domain))
    C_test[1,1,2]=x[2]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=6
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[0,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=(-7)
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[0,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=5
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[1,0]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_D_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=7
    D_test=Data(0.,(2,2),ReducedFunction(self.domain))
    D_test[1,1]=x[0]
    Y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    Y_test[1]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Vario_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)
    u[1]=(-1)
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[0,0]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=(-2)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Vario_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=8
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[0,1]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Vario_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=5
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[1,0]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_d_Vario_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=6
    d_test=Data(0.,(2,2),ReducedFunctionOnBoundary(self.domain))
    d_test[1,1]=x[0]
    y_test=Data(0.,(2,),ContinuousFunction(self.domain))
    y_test[1]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+x[2]+7*x[1]+8*x[0]
    u[1]=8-9*x[2]-9*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=56
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]+3*x[1]-1*x[0]
    u[1]=2+3*x[2]+6*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]+4*x[1]-2*x[0]
    u[1]=6-3*x[2]+x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+3*x[2]+7*x[1]+5*x[0]
    u[1]=(-6)+x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]-7*x[1]-2*x[0]
    u[1]=6+4*x[2]-3*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-21)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+x[2]+7*x[1]+3*x[0]
    u[1]=3-5*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+7*x[2]-8*x[1]-4*x[0]
    u[1]=2+x[2]+3*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=4
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-16)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+3*x[2]-3*x[1]+3*x[0]
    u[1]=(-8)+6*x[2]-8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]-6*x[1]+x[0]
    u[1]=8-6*x[2]-8*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-56)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+5*x[2]+2*x[1]+8*x[0]
    u[1]=(-4)+6*x[2]+5*x[1]+4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=32
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]-9*x[1]+x[0]
    u[1]=3+7*x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=16
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1+7*x[2]-5*x[1]+2*x[0]
    u[1]=(-5)+2*x[2]+4*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=14
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)+5*x[2]-8*x[1]+4*x[0]
    u[1]=(-6)-6*x[2]+6*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=20
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+6*x[2]-8*x[1]+7*x[0]
    u[1]=(-5)+6*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-64)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-5*x[2]+6*x[1]-8*x[0]
    u[1]=(-7)-1*x[2]-5*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-25)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8-2*x[2]-5*x[1]-9*x[0]
    u[1]=7+3*x[2]-3*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-5)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]-6*x[1]-9*x[0]
    u[1]=6-3*x[2]+2*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=4
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=8
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+5*x[2]-8*x[1]+8*x[0]
    u[1]=8+x[2]+7*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-8*x[2]+x[1]+6*x[0]
    u[1]=4+5*x[2]-6*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=18
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-8*x[2]-7*x[1]-4*x[0]
    u[1]=(-6)-9*x[2]+5*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-7)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+7*x[2]+7*x[1]-8*x[0]
    u[1]=4+7*x[2]-5*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=35
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+6*x[1]+7*x[0]
    u[1]=6+x[2]-4*x[1]+x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=1
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]-9*x[1]-2*x[0]
    u[1]=(-1)-7*x[2]+2*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=12
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]-7*x[1]+4*x[0]
    u[1]=5-5*x[2]-4*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+5*x[2]+8*x[1]-1*x[0]
    u[1]=(-8)-7*x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-1)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8+8*x[2]-9*x[1]-4*x[0]
    u[1]=(-5)+7*x[2]+4*x[1]-8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-54)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-2*x[2]+7*x[1]+4*x[0]
    u[1]=(-8)+2*x[2]-6*x[1]-5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-3*x[2]-8*x[1]+7*x[0]
    u[1]=(-4)-7*x[2]+7*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=3
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-1*x[2]-9*x[1]+2*x[0]
    u[1]=(-5)-7*x[2]+3*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=6
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-8*x[2]-5*x[1]+4*x[0]
    u[1]=(-7)-8*x[2]-1*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-8*x[2]-4*x[1]-7*x[0]
    u[1]=(-9)-9*x[2]-4*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+2*x[2]+8*x[1]-6*x[0]
    u[1]=(-4)+x[2]+7*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,1]=4
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=32
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)-3*x[2]-3*x[1]+2*x[0]
    u[1]=1+5*x[2]+4*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+4*x[1]+4*x[0]
    u[1]=(-9)-9*x[2]+5*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,0]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-2*x[2]+2*x[1]+8*x[0]
    u[1]=1+3*x[2]+7*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=7
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Const_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4+8*x[2]+4*x[1]+8*x[0]
    u[1]=(-6)-3*x[2]-7*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,2]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-15)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3
    u[1]=8
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=3
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=5
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,1]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=5
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)
    u[1]=(-9)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,0]=5
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-35)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-3)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-21)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=2
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,0]=1
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=7
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=6
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=42
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=(-9)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,0]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=14
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=(-2)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,1]=7
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-14)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=6
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,0]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=(-4)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,1]=6
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=5
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,0]=2
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Const_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)
    u[1]=(-1)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,1]=8
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-5*x[2]-6*x[1]+x[0]
    u[1]=(-8)+3*x[2]-1*x[1]-4*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-7*x[1]-4*x[0]
    u[1]=7+2*x[2]+5*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-7)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]+5*x[1]-9*x[0]
    u[1]=7-1*x[2]-5*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-3)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]+2*x[1]+2*x[0]
    u[1]=2+2*x[2]-3*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=3*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]+6*x[1]-3*x[0]
    u[1]=(-9)-5*x[2]-5*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-5)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]-6*x[1]-2*x[0]
    u[1]=3+6*x[2]+x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=6*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+2*x[2]+5*x[1]+7*x[0]
    u[1]=(-9)+3*x[2]+3*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+2*x[2]-8*x[1]-7*x[0]
    u[1]=2+7*x[2]+6*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+2*x[1]-3*x[0]
    u[1]=7-8*x[2]-4*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]+5*x[1]-6*x[0]
    u[1]=5-9*x[2]+7*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=7*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7-9*x[2]+4*x[1]+5*x[0]
    u[1]=(-8)+8*x[2]-9*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-9)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-1*x[1]-9*x[0]
    u[1]=(-4)-3*x[2]-5*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-3)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)-7*x[2]-8*x[1]-6*x[0]
    u[1]=(-8)-5*x[2]-7*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-6)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-4)+7*x[2]+6*x[1]-1*x[0]
    u[1]=(-3)-9*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=6*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]-5*x[1]-3*x[0]
    u[1]=1+7*x[2]-1*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-4)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-5*x[2]-4*x[1]+3*x[0]
    u[1]=3-5*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-9)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)-3*x[2]-6*x[1]+7*x[0]
    u[1]=7-2*x[2]+8*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=8*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]-1*x[1]+2*x[0]
    u[1]=6-2*x[2]-1*x[1]+6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]-5*x[1]-6*x[0]
    u[1]=(-5)-1*x[2]-7*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-6)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)+5*x[2]-4*x[1]-7*x[0]
    u[1]=(-4)-2*x[2]+3*x[1]-3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-4*x[2]-1*x[1]-2*x[0]
    u[1]=(-3)-6*x[2]+4*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-4)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-1)+3*x[2]+2*x[1]+7*x[0]
    u[1]=7-2*x[2]-5*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1-4*x[2]-5*x[1]+6*x[0]
    u[1]=4-3*x[2]+8*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-9*x[2]+3*x[1]-2*x[0]
    u[1]=(-6)+7*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=7*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-2)+x[2]-3*x[1]-8*x[0]
    u[1]=5+4*x[2]-9*x[1]+5*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-8)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=5-9*x[2]+3*x[1]+6*x[0]
    u[1]=2+8*x[2]+4*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=3*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+x[2]-4*x[1]-7*x[0]
    u[1]=(-8)+2*x[2]-7*x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7+7*x[2]+8*x[1]+2*x[0]
    u[1]=1-2*x[2]-2*x[1]-1*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-1)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4-6*x[2]+4*x[1]+4*x[0]
    u[1]=(-5)+3*x[2]-6*x[1]+8*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-6)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+6*x[2]-6*x[1]+5*x[0]
    u[1]=4-1*x[2]+4*x[1]-7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,1,1,2]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=(-1)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)-1*x[2]-4*x[1]+3*x[0]
    u[1]=(-3)-3*x[2]+x[1]-2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=3*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-6)+7*x[2]-6*x[1]+4*x[0]
    u[1]=8+8*x[2]-5*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-2*x[2]+8*x[1]-6*x[0]
    u[1]=8-4*x[2]+2*x[1]-6*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,0,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-2)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)+7*x[2]-6*x[1]-9*x[0]
    u[1]=2-9*x[2]+7*x[1]+2*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)-9*x[2]+2*x[1]-9*x[0]
    u[1]=5-7*x[2]+2*x[1]-9*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=2*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_A_Vario_typeWeak_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=6-4*x[2]+4*x[1]+6*x[0]
    u[1]=(-8)-6*x[2]+6*x[1]+7*x[0]
    A_test=Data(0.,(2,3,2,3),ReducedFunction(self.domain))
    A_test[1,2,1,2]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-6)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=7
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=(-9)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=4
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,0]=4*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=5
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-3)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-3)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,1]=(-3)*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=(-6)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=7*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=3
    u[1]=4
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[0,2,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[0,2]=4*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=6
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,0]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=(-8)*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=2
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,0,1]=x[0]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,0]=2*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=2
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,0]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=8*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=2
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,1,1]=x[1]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,1]=2*x[1]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-9)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,0]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-5)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu2_B_Vario_typeWeak_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(2,),ContinuousFunction(self.domain))
    u[0]=1
    u[1]=(-3)
    B_test=Data(0.,(2,3,2),ReducedFunction(self.domain))
    B_test[1,2,1]=x[2]
    X_test=Data(0.,(2, 3),ContinuousFunction(self.domain))
    X_test[1,2]=(-3)*x[2]
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, X_reduced=X_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-3*x[2]+8*x[1]-6*x[0]
    u[1]=(-4)+6*x[2]+x[1]+x[0]
    u[2]=2+8*x[2]-6*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+4*x[2]-7*x[1]+7*x[0]
    u[1]=(-6)+2*x[2]+6*x[1]+6*x[0]
    u[2]=(-2)+3*x[2]-9*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-14))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-7*x[2]-9*x[1]-5*x[0]
    u[1]=(-9)+x[2]-6*x[1]+2*x[0]
    u[2]=6+4*x[2]+5*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-21))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+6*x[2]+4*x[1]-6*x[0]
    u[1]=(-3)-5*x[2]+3*x[1]+2*x[0]
    u[2]=(-7)-1*x[2]+6*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-8*x[2]-1*x[1]-3*x[0]
    u[1]=(-3)+4*x[2]-2*x[1]-9*x[0]
    u[2]=5+6*x[2]-6*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+8*x[2]-3*x[1]+8*x[0]
    u[1]=(-2)-6*x[2]+7*x[1]+8*x[0]
    u[2]=(-3)-8*x[2]-4*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-3*x[2]+8*x[1]-1*x[0]
    u[1]=6-3*x[2]+4*x[1]+2*x[0]
    u[2]=7+4*x[2]+8*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-9))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+5*x[2]-6*x[1]-5*x[0]
    u[1]=(-6)-3*x[2]+4*x[1]+8*x[0]
    u[2]=6-1*x[2]+6*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+x[2]-8*x[1]+4*x[0]
    u[1]=2+2*x[2]+4*x[1]+8*x[0]
    u[2]=(-3)-4*x[2]-2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+8*x[2]-2*x[1]-5*x[0]
    u[1]=3+x[2]-6*x[1]+5*x[0]
    u[2]=(-7)-7*x[2]+2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-10))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+7*x[2]+7*x[1]-4*x[0]
    u[1]=(-1)-7*x[2]-5*x[1]-1*x[0]
    u[2]=(-1)-4*x[2]-2*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(35)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+4*x[2]-2*x[1]+7*x[0]
    u[1]=(-8)-5*x[2]+8*x[1]-9*x[0]
    u[2]=(-1)-7*x[2]-3*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-9*x[2]-6*x[1]-1*x[0]
    u[1]=(-3)-8*x[2]-6*x[1]+3*x[0]
    u[2]=(-8)-7*x[2]+5*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-5*x[2]-4*x[1]+7*x[0]
    u[1]=(-1)+5*x[2]-1*x[1]+4*x[0]
    u[2]=(-2)-1*x[2]+7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)-9*x[2]+7*x[1]-6*x[0]
    u[1]=6-9*x[2]+8*x[1]-1*x[0]
    u[2]=7+8*x[2]+8*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]-1*x[1]+6*x[0]
    u[1]=(-9)-7*x[2]+5*x[1]-3*x[0]
    u[2]=(-4)+5*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-30))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+5*x[2]+x[1]+4*x[0]
    u[1]=4-1*x[2]-6*x[1]-9*x[0]
    u[2]=5+4*x[2]+7*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-2*x[2]+x[1]-6*x[0]
    u[1]=(-7)+5*x[2]-9*x[1]-5*x[0]
    u[2]=4-6*x[2]+6*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-42))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+4*x[2]-7*x[1]-5*x[0]
    u[1]=4-4*x[2]+7*x[1]-4*x[0]
    u[2]=(-6)+5*x[2]-7*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-25))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-1*x[2]-9*x[1]-7*x[0]
    u[1]=(-1)+6*x[2]+x[1]-6*x[0]
    u[2]=(-4)+7*x[2]+x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-36))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]-2*x[1]+5*x[0]
    u[1]=(-4)+8*x[2]+8*x[1]+4*x[0]
    u[2]=(-9)+2*x[2]-9*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-15))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+7*x[2]-1*x[1]-4*x[0]
    u[1]=3-3*x[2]+4*x[1]+4*x[0]
    u[2]=(-1)+3*x[2]+4*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-2*x[2]-3*x[1]+6*x[0]
    u[1]=(-4)-6*x[2]-4*x[1]-4*x[0]
    u[2]=(-4)-7*x[2]-9*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-3*x[2]-9*x[1]+7*x[0]
    u[1]=(-6)+8*x[2]-7*x[1]+7*x[0]
    u[2]=3-4*x[2]-1*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-6*x[2]-1*x[1]+3*x[0]
    u[1]=(-5)-1*x[2]+2*x[1]+4*x[0]
    u[2]=(-3)+6*x[2]-7*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+4*x[2]+x[1]+5*x[0]
    u[1]=(-9)+2*x[2]-7*x[1]-9*x[0]
    u[2]=6-9*x[2]-6*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-42))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+x[2]+6*x[1]+5*x[0]
    u[1]=(-1)-1*x[2]+5*x[1]+5*x[0]
    u[2]=6-9*x[2]+5*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-45))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-3*x[2]-5*x[1]-2*x[0]
    u[1]=(-6)-4*x[2]+4*x[1]+7*x[0]
    u[2]=5-5*x[2]-5*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-5*x[2]-5*x[1]-2*x[0]
    u[1]=(-2)-1*x[2]-7*x[1]-8*x[0]
    u[2]=1-3*x[2]+4*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-10))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+6*x[2]+2*x[1]-6*x[0]
    u[1]=1+7*x[2]+x[1]+3*x[0]
    u[2]=(-3)-8*x[2]-9*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-4*x[2]-3*x[1]-3*x[0]
    u[1]=(-3)+x[2]-6*x[1]-2*x[0]
    u[2]=(-3)-4*x[2]+5*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6-8*x[2]-4*x[1]-4*x[0]
    u[1]=(-4)+2*x[2]-8*x[1]-9*x[0]
    u[2]=(-4)+x[2]-7*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]+3*x[1]-4*x[0]
    u[1]=7-6*x[2]-3*x[1]+7*x[0]
    u[2]=(-8)-8*x[2]-4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-9*x[2]-6*x[1]-5*x[0]
    u[1]=(-6)-1*x[2]+8*x[1]+x[0]
    u[2]=4-1*x[2]+4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+2*x[2]+4*x[1]+4*x[0]
    u[1]=6+3*x[2]+7*x[1]-3*x[0]
    u[2]=(-8)+6*x[2]+4*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-1*x[2]-8*x[1]+2*x[0]
    u[1]=(-9)+3*x[2]-6*x[1]-6*x[0]
    u[2]=1-8*x[2]+4*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+8*x[2]+6*x[1]-3*x[0]
    u[1]=(-5)+x[2]-6*x[1]+2*x[0]
    u[2]=7+6*x[2]+x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-3))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+6*x[2]-9*x[1]+6*x[0]
    u[1]=(-7)-8*x[2]-1*x[1]+3*x[0]
    u[2]=8-2*x[2]-8*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-45))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+6*x[2]-6*x[1]-6*x[0]
    u[1]=2+2*x[2]+5*x[1]-6*x[0]
    u[2]=6-2*x[2]-1*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]+5*x[1]-3*x[0]
    u[1]=8+4*x[2]-5*x[1]+3*x[0]
    u[2]=4-3*x[2]-9*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(9)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-3*x[2]-4*x[1]-5*x[0]
    u[1]=(-9)-6*x[2]+3*x[1]-4*x[0]
    u[2]=(-9)-6*x[2]+5*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-8*x[2]-9*x[1]+3*x[0]
    u[1]=(-8)-8*x[2]-9*x[1]-6*x[0]
    u[2]=1-9*x[2]-7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,1,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-40))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+x[2]-7*x[1]+4*x[0]
    u[1]=(-1)+8*x[2]-8*x[1]+3*x[0]
    u[2]=(-8)+7*x[2]+6*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-8*x[1]+3*x[0]
    u[1]=2-8*x[2]+5*x[1]-3*x[0]
    u[2]=(-3)-2*x[2]-8*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,2,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-4*x[2]+4*x[1]-1*x[0]
    u[1]=(-1)-9*x[2]+6*x[1]+4*x[0]
    u[2]=6+6*x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,2,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-6*x[2]+3*x[1]+7*x[0]
    u[1]=(-9)+6*x[2]-5*x[1]+3*x[0]
    u[2]=(-1)+x[2]-6*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,0,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+2*x[2]+x[1]-5*x[0]
    u[1]=7+4*x[2]+2*x[1]+7*x[0]
    u[2]=(-1)-8*x[2]-1*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(2)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-1*x[2]-5*x[1]-4*x[0]
    u[1]=(-2)+3*x[2]-5*x[1]-4*x[0]
    u[2]=6-9*x[2]-5*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,0,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-6))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-7*x[2]-8*x[1]-2*x[0]
    u[1]=(-4)+4*x[2]+2*x[1]+x[0]
    u[2]=4+7*x[2]+5*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-6*x[2]+2*x[1]-8*x[0]
    u[1]=3+8*x[2]+7*x[1]-4*x[0]
    u[2]=(-8)-8*x[2]-5*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(28)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-7*x[2]-7*x[1]-6*x[0]
    u[1]=(-2)+5*x[2]+5*x[1]-3*x[0]
    u[2]=2+8*x[2]+4*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,1,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(25)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+3*x[2]-5*x[1]-4*x[0]
    u[1]=3+2*x[2]-6*x[1]-4*x[0]
    u[2]=5-8*x[2]+6*x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-3*x[2]+8*x[1]-7*x[0]
    u[1]=(-5)-3*x[2]-2*x[1]-3*x[0]
    u[2]=(-9)+8*x[2]-8*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,2,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp1222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+4*x[2]-6*x[1]-5*x[0]
    u[1]=(-3)+5*x[2]+7*x[1]-1*x[0]
    u[2]=1+2*x[2]+2*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,2,2,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(4)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+5*x[2]-6*x[1]+5*x[0]
    u[1]=4+x[2]-4*x[1]+5*x[0]
    u[2]=8+x[2]+7*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(25)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+5*x[2]-3*x[1]-1*x[0]
    u[1]=7-1*x[2]-2*x[1]-8*x[0]
    u[2]=(-1)+3*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-5*x[2]-9*x[1]+5*x[0]
    u[1]=(-6)-1*x[2]-9*x[1]-3*x[0]
    u[2]=(-8)+4*x[2]+3*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-5))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+x[2]-5*x[1]-9*x[0]
    u[1]=6+x[2]-7*x[1]-9*x[0]
    u[2]=(-1)-7*x[2]-9*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,1,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)+4*x[2]+4*x[1]-5*x[0]
    u[1]=(-6)+3*x[2]+x[1]-9*x[0]
    u[2]=3+5*x[2]+5*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-1*x[2]+6*x[1]-1*x[0]
    u[1]=(-5)-1*x[2]-9*x[1]-5*x[0]
    u[2]=(-6)+3*x[2]+3*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,1,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-7*x[2]-7*x[1]-1*x[0]
    u[1]=(-7)+5*x[2]+5*x[1]-4*x[0]
    u[2]=(-3)-8*x[2]-6*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,2,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+7*x[2]-6*x[1]-2*x[0]
    u[1]=4-9*x[2]+3*x[1]-3*x[0]
    u[2]=(-9)-1*x[2]-2*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,2,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-10))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-1*x[2]-2*x[1]+2*x[0]
    u[1]=(-2)-5*x[2]-6*x[1]-2*x[0]
    u[2]=4-6*x[2]-5*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,0,2,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-18))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-9*x[2]-7*x[1]+x[0]
    u[1]=(-9)-2*x[2]+3*x[1]+4*x[0]
    u[2]=(-7)-3*x[2]-1*x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,0,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(1)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]+6*x[1]-2*x[0]
    u[1]=(-7)-9*x[2]-1*x[1]-8*x[0]
    u[2]=5+x[2]-1*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(6)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+x[2]-1*x[1]-3*x[0]
    u[1]=3+3*x[2]-3*x[1]+3*x[0]
    u[2]=7-6*x[2]+7*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(3)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+3*x[2]-6*x[1]-3*x[0]
    u[1]=(-2)-5*x[2]+6*x[1]-4*x[0]
    u[2]=(-6)+8*x[2]-6*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-32))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]+6*x[1]-8*x[0]
    u[1]=(-5)-2*x[2]+6*x[1]+3*x[0]
    u[2]=(-2)-6*x[2]-4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,1,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-3*x[2]+2*x[1]-2*x[0]
    u[1]=(-9)-1*x[2]+x[1]-7*x[0]
    u[2]=1-6*x[2]-5*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,1,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-2*x[2]-4*x[1]+6*x[0]
    u[1]=(-8)-5*x[2]+4*x[1]+2*x[0]
    u[2]=(-2)-9*x[2]-1*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(16)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3-6*x[2]+2*x[1]-4*x[0]
    u[1]=3-1*x[2]-1*x[1]+7*x[0]
    u[2]=(-3)-7*x[2]-9*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-27))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-6*x[2]+7*x[1]+5*x[0]
    u[1]=(-9)+4*x[2]-8*x[1]+7*x[0]
    u[2]=4-8*x[2]+4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,1,2,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-5*x[2]+x[1]-3*x[0]
    u[1]=8+2*x[2]-8*x[1]-5*x[0]
    u[2]=(-3)-1*x[2]+6*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,0,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-24))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-5*x[2]+x[1]+4*x[0]
    u[1]=1-3*x[2]-2*x[1]+x[0]
    u[2]=6-6*x[2]-1*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(1)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-7*x[2]+2*x[1]+x[0]
    u[1]=(-9)-4*x[2]+4*x[1]-1*x[0]
    u[2]=1+x[2]+6*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-7))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-2*x[2]-2*x[1]-2*x[0]
    u[1]=(-5)-1*x[2]-5*x[1]-9*x[0]
    u[2]=6-6*x[2]+2*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,1,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-63))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+3*x[2]+7*x[1]-4*x[0]
    u[1]=(-7)-5*x[2]-5*x[1]-6*x[0]
    u[2]=7-9*x[2]-8*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,1,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-10))
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+7*x[2]-9*x[1]+x[0]
    u[1]=7+3*x[2]+7*x[1]-2*x[0]
    u[2]=(-7)-9*x[2]-7*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(9)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+2*x[2]-3*x[1]+x[0]
    u[1]=(-4)+8*x[2]-6*x[1]-5*x[0]
    u[2]=8-7*x[2]+2*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(12)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]-6*x[1]+4*x[0]
    u[1]=(-4)-2*x[2]+4*x[1]-8*x[0]
    u[2]=(-7)-6*x[2]+3*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,2,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(21)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Const_typeStrong_comp2222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+4*x[2]+2*x[1]-8*x[0]
    u[1]=7-6*x[2]-1*x[1]+2*x[0]
    u[2]=6+7*x[2]+x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[2,2,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(42)
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-5)
    u[2]=(-9)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,0,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-20))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=4
    u[2]=1
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=(-8)
    u[2]=8
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,0,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(56)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=7
    u[2]=(-4)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-8))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-3)
    u[1]=6
    u[2]=(-8)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,1,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)
    u[1]=(-5)
    u[2]=(-2)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,1,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-16))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)
    u[1]=(-9)
    u[2]=5
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,2,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-20))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=6
    u[2]=(-5)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,2,1]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(48)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7
    u[1]=1
    u[2]=(-2)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[0,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=6
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-40))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8
    u[1]=(-2)
    u[2]=3
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=2
    u[2]=8
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(8)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=(-2)
    u[2]=7
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,1,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-18))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=5
    u[2]=5
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(30)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2
    u[1]=(-3)
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-9))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=(-7)
    u[2]=(-6)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,2,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*(18)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=(-4)
    u[2]=6
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4
    u[1]=3
    u[2]=(-1)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[1,2,2]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[2]*((-2))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)
    u[1]=(-9)
    u[2]=(-1)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,0,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-12))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=7
    u[2]=(-2)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,0,1]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*(14)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5
    u[1]=5
    u[2]=(-5)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,0,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[0]*((-30))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)
    u[1]=8
    u[2]=(-6)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,1,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-42))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-1)
    u[2]=6
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,1,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*((-4))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=8
    u[2]=4
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,1,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[1]*(24)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6
    u[1]=1
    u[2]=(-3)
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,2,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(36)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)
    u[1]=(-9)
    u[2]=8
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,2,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*((-9))
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_B_Const_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)
    u[1]=(-6)
    u[2]=2
    B_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    B_test[2,2,2]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[2]=n[2]*(16)
    pde=LinearPDE(self.domain)
    pde.setValue(B_reduced=B_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+x[2]-8*x[1]-8*x[0]
    u[1]=(-2)-1*x[2]+4*x[1]-1*x[0]
    u[2]=6+2*x[2]-2*x[1]+3*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,0,0]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+8*x[2]+8*x[1]-4*x[0]
    u[1]=5-2*x[2]+8*x[1]-4*x[0]
    u[2]=5+5*x[2]+7*x[1]-5*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,0,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=56
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+7*x[2]-2*x[1]-8*x[0]
    u[1]=(-5)+x[2]-8*x[1]+7*x[0]
    u[2]=(-8)+x[2]-2*x[1]+2*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,0,2]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=49
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-9*x[2]-4*x[1]+2*x[0]
    u[1]=1-5*x[2]-8*x[1]-4*x[0]
    u[2]=2-9*x[2]+6*x[1]-8*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,1,0]=2
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)+2*x[2]+3*x[1]+x[0]
    u[1]=8+3*x[2]-8*x[1]+x[0]
    u[2]=6+2*x[2]-3*x[1]-1*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-48)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+2*x[1]-2*x[0]
    u[1]=(-4)-5*x[2]-7*x[1]+7*x[0]
    u[2]=(-5)-8*x[2]+4*x[1]+x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,1,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-20)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+5*x[2]+8*x[1]+3*x[0]
    u[1]=(-7)-8*x[2]-6*x[1]+3*x[0]
    u[2]=7+5*x[2]-7*x[1]-5*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,2,0]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-30)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-7*x[2]-9*x[1]-8*x[0]
    u[1]=(-3)-2*x[2]-8*x[1]+6*x[0]
    u[2]=(-9)+4*x[2]+6*x[1]-4*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,2,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4+8*x[2]-4*x[1]-6*x[0]
    u[1]=(-7)-1*x[2]+5*x[1]+3*x[0]
    u[2]=7+8*x[2]-4*x[1]+2*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[0,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=48
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-3*x[2]-5*x[1]+2*x[0]
    u[1]=(-7)+x[2]+3*x[1]-3*x[0]
    u[2]=7+7*x[2]-8*x[1]-2*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,0,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=10
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]-6*x[1]+8*x[0]
    u[1]=(-7)+x[2]+x[1]+8*x[0]
    u[2]=(-5)+6*x[2]+4*x[1]-4*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,0,1]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-24)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+3*x[2]+8*x[1]-6*x[0]
    u[1]=6-9*x[2]-6*x[1]+7*x[0]
    u[2]=(-7)+4*x[2]-7*x[1]+3*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,0,2]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=3
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-4*x[2]+7*x[1]+2*x[0]
    u[1]=(-2)-4*x[2]-1*x[1]-8*x[0]
    u[2]=1-2*x[2]+6*x[1]+7*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,1,0]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-40)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+6*x[2]+4*x[1]-4*x[0]
    u[1]=(-4)-4*x[2]+3*x[1]-8*x[0]
    u[2]=1+5*x[2]+6*x[1]+8*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,1,1]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=15
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-2*x[2]-7*x[1]-5*x[0]
    u[1]=6-1*x[2]-6*x[1]+7*x[0]
    u[2]=1-7*x[2]+6*x[1]-3*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,1,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+7*x[2]-4*x[1]-4*x[0]
    u[1]=(-3)+5*x[2]-3*x[1]-5*x[0]
    u[2]=3-8*x[2]-1*x[1]-3*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,2,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-4*x[2]-1*x[1]-4*x[0]
    u[1]=(-1)-7*x[2]-9*x[1]-1*x[0]
    u[2]=(-5)-2*x[2]-2*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,2,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-12)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)-4*x[2]+3*x[1]-9*x[0]
    u[1]=7+5*x[2]+6*x[1]+2*x[0]
    u[2]=8+7*x[2]+8*x[1]-8*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[1,2,2]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=42
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+5*x[2]-7*x[1]-2*x[0]
    u[1]=(-8)-8*x[2]+5*x[1]-3*x[0]
    u[2]=2-8*x[2]-5*x[1]-7*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,0,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-8)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+5*x[2]-9*x[1]+7*x[0]
    u[1]=(-7)-9*x[2]-5*x[1]-7*x[0]
    u[2]=3-1*x[2]-5*x[1]-1*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,0,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-9)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]+4*x[1]+3*x[0]
    u[1]=4+3*x[2]-7*x[1]+6*x[0]
    u[2]=5-9*x[2]+2*x[1]+4*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,0,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-21)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-4*x[2]+3*x[1]+x[0]
    u[1]=8+5*x[2]+x[1]+5*x[0]
    u[2]=4+5*x[2]+x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,1,0]=8
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=40
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-7*x[2]-6*x[1]-7*x[0]
    u[1]=(-7)+5*x[2]+6*x[1]+6*x[0]
    u[2]=2+5*x[2]-5*x[1]-9*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,1,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=36
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-6*x[2]-5*x[1]-7*x[0]
    u[1]=(-3)-3*x[2]-9*x[1]-6*x[0]
    u[2]=(-9)-7*x[2]+x[1]-1*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-9)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+4*x[2]+8*x[1]+4*x[0]
    u[1]=(-3)+7*x[2]+8*x[1]+6*x[0]
    u[2]=7-1*x[2]-9*x[1]-4*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,2,0]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-28)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)+8*x[2]-4*x[1]-3*x[0]
    u[1]=(-4)+6*x[2]+4*x[1]+3*x[0]
    u[2]=(-4)+3*x[2]+4*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,2,1]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=4
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_C_Const_typeStrong_comp222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2+7*x[2]-4*x[1]-4*x[0]
    u[1]=8+4*x[2]-2*x[1]+5*x[0]
    u[2]=(-5)-1*x[2]+8*x[1]+5*x[0]
    C_test=Data(0.,(3,3,3),ReducedFunction(self.domain))
    C_test[2,2,2]=5
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-5)
    pde=LinearPDE(self.domain)
    pde.setValue(C_reduced=C_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+6*x[2]-2*x[1]+5*x[0]
    u[1]=(-1)+4*x[2]-6*x[1]+x[0]
    u[2]=(-1)+7*x[2]+3*x[1]-6*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[0,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)+6*x[2]-2*x[1]+5*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-3*x[2]+6*x[1]-4*x[0]
    u[1]=3-7*x[2]-8*x[1]+3*x[0]
    u[2]=(-9)-6*x[2]-2*x[1]-8*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[0,1]=6
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=18-42*x[2]-48*x[1]+18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-8*x[2]-2*x[1]-2*x[0]
    u[1]=(-4)-5*x[2]+4*x[1]-8*x[0]
    u[2]=7+4*x[2]-7*x[1]+2*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[0,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=28+16*x[2]-28*x[1]+8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+4*x[2]-1*x[1]-7*x[0]
    u[1]=(-8)-4*x[2]+4*x[1]+5*x[0]
    u[2]=(-8)+4*x[2]+6*x[1]-5*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[1,0]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4+16*x[2]-4*x[1]-28*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]-4*x[1]-8*x[0]
    u[1]=(-9)-3*x[2]+6*x[1]+2*x[0]
    u[2]=7+x[2]+6*x[1]-4*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[1,1]=7
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-63)-21*x[2]+42*x[1]+14*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+6*x[2]+2*x[1]+7*x[0]
    u[1]=4+6*x[2]+4*x[1]-5*x[0]
    u[2]=6-8*x[2]+5*x[1]+8*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[1,2]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=18-24*x[2]+15*x[1]+24*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+7*x[2]-6*x[1]+x[0]
    u[1]=6+3*x[2]-6*x[1]-7*x[0]
    u[2]=4+4*x[2]-1*x[1]+3*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[2,0]=1
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=5+7*x[2]-6*x[1]+x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-8*x[2]-3*x[1]+4*x[0]
    u[1]=(-4)+8*x[2]+2*x[1]-3*x[0]
    u[2]=(-3)-8*x[2]+4*x[1]+7*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[2,1]=3
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=(-12)+24*x[2]+6*x[1]-9*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_D_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-6*x[2]+7*x[1]-8*x[0]
    u[1]=(-7)-9*x[2]+3*x[1]+6*x[0]
    u[2]=4-2*x[2]+5*x[1]-9*x[0]
    D_test=Data(0.,(3,3),ReducedFunction(self.domain))
    D_test[2,2]=4
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[2]=16-8*x[2]+20*x[1]-36*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(D_reduced=D_test, Y_reduced=Y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp00(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-1)-9*x[2]-5*x[1]-8*x[0]
    u[1]=6-3*x[2]+3*x[1]-4*x[0]
    u[2]=4+4*x[2]-8*x[1]+7*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[0,0]=3
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=(-3)-27*x[2]-15*x[1]-24*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp01(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]-3*x[1]-3*x[0]
    u[1]=(-5)+2*x[2]-7*x[1]+5*x[0]
    u[2]=6-7*x[2]-7*x[1]+5*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[0,1]=7
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=(-35)+14*x[2]-49*x[1]+35*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp02(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-6)-7*x[2]+7*x[1]-3*x[0]
    u[1]=(-1)+5*x[2]-8*x[1]-4*x[0]
    u[2]=8+3*x[2]-3*x[1]-4*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[0,2]=8
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[0]=64+24*x[2]-24*x[1]-32*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp10(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-3*x[2]+2*x[1]-9*x[0]
    u[1]=8-8*x[2]+6*x[1]-6*x[0]
    u[2]=4+3*x[2]-5*x[1]-2*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[1,0]=2
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=10-6*x[2]+4*x[1]-18*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp11(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=3+8*x[2]+7*x[1]-8*x[0]
    u[1]=(-2)-1*x[2]+7*x[1]+4*x[0]
    u[2]=1+6*x[2]+x[1]-8*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[1,1]=7
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=(-14)-7*x[2]+49*x[1]+28*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp12(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-7*x[2]-7*x[1]-6*x[0]
    u[1]=7-7*x[2]-3*x[1]-7*x[0]
    u[2]=1-1*x[2]+5*x[1]+4*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[1,2]=8
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[1]=8-8*x[2]+40*x[1]+32*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp20(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+2*x[2]-8*x[1]+7*x[0]
    u[1]=(-4)+x[2]-3*x[1]-3*x[0]
    u[2]=(-8)+4*x[2]-1*x[1]+4*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[2,0]=8
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=40+16*x[2]-64*x[1]+56*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp21(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+8*x[2]+6*x[1]-9*x[0]
    u[1]=(-3)-4*x[2]+x[1]-9*x[0]
    u[2]=(-9)+2*x[2]-2*x[1]-5*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[2,1]=1
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=(-3)-4*x[2]+x[1]-9*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_d_Const_typeStrong_comp22(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-8*x[2]-3*x[1]-6*x[0]
    u[1]=(-7)-7*x[2]-4*x[1]-8*x[0]
    u[2]=5-8*x[2]+6*x[1]+8*x[0]
    d_test=Data(0.,(3,3),ReducedFunctionOnBoundary(self.domain))
    d_test[2,2]=1
    y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    y_test[2]=5-8*x[2]+6*x[1]+8*x[0]
    pde=LinearPDE(self.domain)
    pde.setValue(d_reduced=d_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-5*x[2]+3*x[1]-6*x[0]
    u[1]=(-6)+3*x[2]+2*x[1]-8*x[0]
    u[2]=7+x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-6)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]-7*x[1]-2*x[0]
    u[1]=(-9)+7*x[2]+8*x[1]-8*x[0]
    u[2]=(-1)+8*x[2]+4*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-7)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-8*x[2]+4*x[1]+4*x[0]
    u[1]=1-3*x[2]-8*x[1]+5*x[0]
    u[2]=6+4*x[2]-4*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+6*x[2]-1*x[1]+3*x[0]
    u[1]=(-3)+6*x[2]-4*x[1]-8*x[0]
    u[2]=2+2*x[2]-1*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+x[2]-5*x[1]+5*x[0]
    u[1]=4+4*x[2]+3*x[1]+5*x[0]
    u[2]=(-7)+6*x[2]-6*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1-5*x[2]+3*x[1]-5*x[0]
    u[1]=(-9)-8*x[2]-6*x[1]+3*x[0]
    u[2]=(-1)+x[2]-8*x[1]+2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+2*x[2]+4*x[1]+6*x[0]
    u[1]=8-3*x[2]-5*x[1]-9*x[0]
    u[2]=(-3)-7*x[2]-3*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+3*x[2]+8*x[1]-3*x[0]
    u[1]=(-4)-4*x[2]-1*x[1]-8*x[0]
    u[2]=8-6*x[2]-4*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*((-4)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)+x[2]-9*x[1]-6*x[0]
    u[1]=4-1*x[2]-7*x[1]+5*x[0]
    u[2]=4+8*x[2]+4*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,0,2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-8)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[0]*(8*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)-2*x[2]-1*x[1]+5*x[0]
    u[1]=(-7)+4*x[2]+3*x[1]-3*x[0]
    u[2]=1-8*x[2]+2*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-5)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(5*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+6*x[2]+3*x[1]+3*x[0]
    u[1]=(-1)-5*x[2]+x[1]+5*x[0]
    u[2]=(-2)-8*x[2]+7*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(3*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+4*x[2]+x[1]-2*x[0]
    u[1]=(-1)-8*x[2]-6*x[1]+7*x[0]
    u[2]=(-9)-1*x[2]-5*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,0,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(4*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-6*x[2]+5*x[1]-6*x[0]
    u[1]=(-9)+6*x[2]-5*x[1]-1*x[0]
    u[2]=8-9*x[2]-7*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-5)-9*x[2]+4*x[1]+x[0]
    u[1]=(-8)+2*x[2]+4*x[1]+4*x[0]
    u[2]=(-2)+6*x[2]-8*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(4*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]+4*x[1]-9*x[0]
    u[1]=4-1*x[2]-7*x[1]+4*x[0]
    u[2]=(-7)-6*x[2]+x[1]+6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,1,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0120(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+6*x[2]+6*x[1]-7*x[0]
    u[1]=1-4*x[2]+3*x[1]-7*x[0]
    u[2]=(-7)+7*x[2]+x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-2)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0121(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)-4*x[2]-6*x[1]-3*x[0]
    u[1]=(-2)-3*x[2]+2*x[1]+7*x[0]
    u[2]=(-9)-1*x[2]-1*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=1
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*((-1)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0122(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)+7*x[2]-7*x[1]-8*x[0]
    u[1]=3-6*x[2]+7*x[1]-6*x[0]
    u[2]=1+7*x[2]+x[1]-8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,1,2,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0200(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+2*x[2]+2*x[1]-7*x[0]
    u[1]=(-4)-8*x[2]-4*x[1]-5*x[0]
    u[2]=(-5)-9*x[2]-7*x[1]-6*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-7)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0201(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+5*x[2]-7*x[1]+5*x[0]
    u[1]=7-2*x[2]+7*x[1]+7*x[0]
    u[2]=(-1)+3*x[2]-1*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=7
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-7)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0202(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7+6*x[2]+7*x[1]-7*x[0]
    u[1]=4-5*x[2]+5*x[1]-3*x[0]
    u[2]=3-4*x[2]-9*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,0,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(6*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0210(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-6*x[2]-3*x[1]-6*x[0]
    u[1]=2-1*x[2]+x[1]-4*x[0]
    u[2]=(-3)-4*x[2]-6*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=4
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-4)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0211(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+8*x[2]+x[1]+8*x[0]
    u[1]=(-7)-9*x[2]-6*x[1]-7*x[0]
    u[2]=(-7)-2*x[2]+4*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0212(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+8*x[2]+4*x[1]+2*x[0]
    u[1]=(-4)+4*x[2]-6*x[1]-7*x[0]
    u[2]=(-7)-7*x[2]-2*x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,1,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(4*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0220(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=4-4*x[2]-5*x[1]+4*x[0]
    u[1]=2-9*x[2]+6*x[1]+4*x[0]
    u[2]=(-8)+7*x[2]+x[1]-9*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,0]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-9)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0221(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-7)+5*x[2]-4*x[1]+5*x[0]
    u[1]=(-1)-5*x[2]+3*x[1]-3*x[0]
    u[2]=2+3*x[2]+6*x[1]-4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,1]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*(6*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp0222(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=1+4*x[2]+5*x[1]+5*x[0]
    u[1]=(-1)+4*x[2]-7*x[1]-7*x[0]
    u[2]=(-5)-6*x[2]-5*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[0,2,2,2]=x[2]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[0]=6
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[0]=n[2]*((-6)*x[2])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1000(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5+8*x[2]+6*x[1]-2*x[0]
    u[1]=(-4)-6*x[2]+3*x[1]-4*x[0]
    u[2]=(-5)-1*x[2]+4*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1001(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-3*x[2]-8*x[1]-8*x[0]
    u[1]=(-3)+5*x[2]+6*x[1]+6*x[0]
    u[2]=6+8*x[2]+2*x[1]+4*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1002(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=7-4*x[2]+3*x[1]+3*x[0]
    u[1]=1+4*x[2]+6*x[1]-1*x[0]
    u[2]=(-3)+5*x[2]+7*x[1]-3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,0,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=4
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-4)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1010(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=2-8*x[2]+5*x[1]-9*x[0]
    u[1]=(-4)+6*x[2]-6*x[1]-8*x[0]
    u[2]=(-9)+6*x[2]+2*x[1]+8*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-8)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1011(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-4*x[2]-2*x[1]+2*x[0]
    u[1]=5-1*x[2]+6*x[1]-4*x[0]
    u[2]=7-4*x[2]+x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-6)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(6*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1012(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+5*x[2]+3*x[1]+5*x[0]
    u[1]=(-2)-2*x[2]+3*x[1]-1*x[0]
    u[2]=(-4)-3*x[2]+3*x[1]-5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,1,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1020(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)+6*x[2]-8*x[1]+x[0]
    u[1]=2+6*x[2]-5*x[1]-9*x[0]
    u[2]=(-1)+4*x[2]-4*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,0]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*((-2)*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1021(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8-6*x[2]+6*x[1]+5*x[0]
    u[1]=(-2)+5*x[2]-1*x[1]+4*x[0]
    u[2]=7+4*x[2]+3*x[1]-1*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,1]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-3)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(3*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1022(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=6+x[2]+6*x[1]-4*x[0]
    u[1]=(-9)+5*x[2]-6*x[1]+3*x[0]
    u[2]=(-7)+4*x[2]+x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,0,2,2]=x[0]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-4)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[0]*(4*x[0])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1100(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=5-2*x[2]-8*x[1]+7*x[0]
    u[1]=6-9*x[2]+7*x[1]-7*x[0]
    u[2]=5-6*x[2]-5*x[1]-2*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=(-7)
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*(7*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1101(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-2)+2*x[2]-6*x[1]-7*x[0]
    u[1]=1+8*x[2]-8*x[1]+6*x[0]
    u[2]=8+x[2]-8*x[1]+7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=6
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-6)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1102(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-9)-9*x[2]-7*x[1]+7*x[0]
    u[1]=(-5)+x[2]-9*x[1]+4*x[0]
    u[2]=(-9)+2*x[2]-2*x[1]+3*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,0,2]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=9
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-9)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1110(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-8)+6*x[2]-1*x[1]-4*x[0]
    u[1]=(-5)+4*x[2]+2*x[1]-8*x[0]
    u[2]=4+5*x[2]+6*x[1]+x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,1,0]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=8
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-8)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1111(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=(-4)-5*x[2]+2*x[1]-8*x[0]
    u[1]=(-5)-6*x[2]-2*x[1]+5*x[0]
    u[2]=2-6*x[2]-2*x[1]-7*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
    A_test[1,1,1,1]=x[1]
    Y_test=Data(0.,(3,),ContinuousFunction(self.domain))
    Y_test[1]=2
    n=self.setNormal(ReducedFunctionOnBoundary(self.domain))
    y_test=Data(0.,(3,),ReducedFunctionOnBoundary(self.domain))
    y_test[1]=n[1]*((-2)*x[1])
    pde=LinearPDE(self.domain)
    pde.setValue(A_reduced=A_test, Y_reduced=Y_test, y_reduced=y_test)
    r=pde.getResidual(u)
    rhs=pde.getRightHandSide()
    self.assertTrue(Lsup(rhs)>0,"right hand side is zero")
    self.assertTrue(Lsup(r)<=self.RES_TOL*Lsup(rhs),"residual is too big")
  #==================================================
  def test_assemblage_3D_solO1_coeffOReduced_NEqu3_A_Vario_typeStrong_comp1112(self):
    x=self.domain.getX()
    u=Data(0.,(3,),ContinuousFunction(self.domain))
    u[0]=8+3*x[2]-1*x[1]-4*x[0]
    u[1]=4-7*x[2]-9*x[1]-1*x[0]
    u[2]=5-7*x[2]-9*x[1]+5*x[0]
    A_test=Data(0.,(3,3,3,3),ReducedFunction(self.domain))
  