# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING
import warnings

from azure.core.exceptions import HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.paging import ItemPaged
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpRequest, HttpResponse

from .. import models

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Generic, Iterable, Optional, TypeVar

    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

class KeyVaultClientOperationsMixin(object):

    def create_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        parameters,  # type: "models.KeyCreateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """Creates a new key, stores it, then returns key parameters and attributes to the client.

        The create key operation can be used to create any key type in Azure Key Vault. If the named
        key already exists, Azure Key Vault creates a new version of the key. It requires the
        keys/create permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name for the new key. The system will generate the version name for the
         new key.
        :type key_name: str
        :param parameters: The parameters to create a key.
        :type parameters: ~azure.keyvault.v7_1.models.KeyCreateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.create_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str', pattern=r'^[0-9a-zA-Z-]+$'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyCreateParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    create_key.metadata = {'url': '/keys/{key-name}/create'}  # type: ignore

    def import_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        parameters,  # type: "models.KeyImportParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """Imports an externally created key, stores it, and returns key parameters and attributes to the client.

        The import key operation may be used to import any key type into an Azure Key Vault. If the
        named key already exists, Azure Key Vault creates a new version of the key. This operation
        requires the keys/import permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: Name for the imported key.
        :type key_name: str
        :param parameters: The parameters to import a key.
        :type parameters: ~azure.keyvault.v7_1.models.KeyImportParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.import_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str', pattern=r'^[0-9a-zA-Z-]+$'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyImportParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.put(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    import_key.metadata = {'url': '/keys/{key-name}'}  # type: ignore

    def delete_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.DeletedKeyBundle"
        """Deletes a key of any type from storage in Azure Key Vault.

        The delete key operation cannot be used to remove individual versions of a key. This operation
        removes the cryptographic material associated with the key, which means the key is not usable
        for Sign/Verify, Wrap/Unwrap or Encrypt/Decrypt operations. This operation requires the
        keys/delete permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to delete.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.DeletedKeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.DeletedKeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.delete_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('DeletedKeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    delete_key.metadata = {'url': '/keys/{key-name}'}  # type: ignore

    def update_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyUpdateParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """The update key operation changes specified attributes of a stored key and can be applied to any key type and key version stored in Azure Key Vault.

        In order to perform this operation, the key must already exist in the Key Vault. Note: The
        cryptographic material of a key itself cannot be changed. This operation requires the
        keys/update permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of key to update.
        :type key_name: str
        :param key_version: The version of the key to update.
        :type key_version: str
        :param parameters: The parameters of the key to update.
        :type parameters: ~azure.keyvault.v7_1.models.KeyUpdateParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.update_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyUpdateParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.patch(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    update_key.metadata = {'url': '/keys/{key-name}/{key-version}'}  # type: ignore

    def get_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """Gets the public part of a stored key.

        The get key operation is applicable to all key types. If the requested key is symmetric, then
        no key material is released in the response. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key to get.
        :type key_name: str
        :param key_version: Adding the version parameter retrieves a specific version of a key. This
         URI fragment is optional. If not specified, the latest version of the key is returned.
        :type key_version: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.get_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_key.metadata = {'url': '/keys/{key-name}/{key-version}'}  # type: ignore

    def get_key_versions(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.KeyListResult"]
        """Retrieves a list of individual key versions with the same key name.

        The full key identifier, attributes, and tags are provided in the response. This operation
        requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.KeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyListResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_key_versions.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'key-name': self._serialize.url("key_name", key_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                    'key-name': self._serialize.url("key_name", key_name, 'str'),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('KeyListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_key_versions.metadata = {'url': '/keys/{key-name}/versions'}  # type: ignore

    def get_keys(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.KeyListResult"]
        """List keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a stored key. The LIST operation is applicable to all key types, however only
        the base key identifier, attributes, and tags are provided in the response. Individual versions
        of a key are not listed in the response. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either KeyListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.KeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyListResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_keys.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('KeyListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_keys.metadata = {'url': '/keys'}  # type: ignore

    def backup_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.BackupKeyResult"
        """Requests that a backup of the specified key be downloaded to the client.

        The Key Backup operation exports a key from Azure Key Vault in a protected form. Note that this
        operation does NOT return key material in a form that can be used outside the Azure Key Vault
        system, the returned key material is either protected to a Azure Key Vault HSM or to Azure Key
        Vault itself. The intent of this operation is to allow a client to GENERATE a key in one Azure
        Key Vault instance, BACKUP the key, and then RESTORE it into another Azure Key Vault instance.
        The BACKUP operation may be used to export, in protected form, any key type from Azure Key
        Vault. Individual versions of a key cannot be backed up. BACKUP / RESTORE can be performed
        within geographical boundaries only; meaning that a BACKUP from one geographical area cannot be
        restored to another geographical area. For example, a backup from the US geographical area
        cannot be restored in an EU geographical area. This operation requires the key/backup
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: BackupKeyResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.BackupKeyResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.BackupKeyResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.backup_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('BackupKeyResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    backup_key.metadata = {'url': '/keys/{key-name}/backup'}  # type: ignore

    def restore_key(
        self,
        vault_base_url,  # type: str
        parameters,  # type: "models.KeyRestoreParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """Restores a backed up key to a vault.

        Imports a previously backed up key into Azure Key Vault, restoring the key, its key identifier,
        attributes and access control policies. The RESTORE operation may be used to import a
        previously backed up key. Individual versions of a key cannot be restored. The key is restored
        in its entirety with the same key name as it had when it was backed up. If the key name is not
        available in the target Key Vault, the RESTORE operation will be rejected. While the key name
        is retained during restore, the final key identifier will change if the key is restored to a
        different vault. Restore will restore all versions and preserve version identifiers. The
        RESTORE operation is subject to security constraints: The target Key Vault must be owned by the
        same Microsoft Azure Subscription as the source Key Vault The user must have RESTORE permission
        in the target Key Vault. This operation requires the keys/restore permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param parameters: The parameters to restore the key.
        :type parameters: ~azure.keyvault.v7_1.models.KeyRestoreParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.restore_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyRestoreParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    restore_key.metadata = {'url': '/keys/restore'}  # type: ignore

    def encrypt(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyOperationResult"
        """Encrypts an arbitrary sequence of bytes using an encryption key that is stored in a key vault.

        The ENCRYPT operation encrypts an arbitrary sequence of bytes using an encryption key that is
        stored in Azure Key Vault. Note that the ENCRYPT operation only supports a single block of
        data, the size of which is dependent on the target key and the encryption algorithm to be used.
        The ENCRYPT operation is only strictly necessary for symmetric keys stored in Azure Key Vault
        since protection with an asymmetric key can be performed using public portion of the key. This
        operation is supported for asymmetric keys as a convenience for callers that have a key-
        reference but do not have access to the public key material. This operation requires the
        keys/encrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the encryption operation.
        :type parameters: ~azure.keyvault.v7_1.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyOperationResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.encrypt.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    encrypt.metadata = {'url': '/keys/{key-name}/{key-version}/encrypt'}  # type: ignore

    def decrypt(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyOperationResult"
        """Decrypts a single block of encrypted data.

        The DECRYPT operation decrypts a well-formed block of ciphertext using the target encryption
        key and specified algorithm. This operation is the reverse of the ENCRYPT operation; only a
        single block of data may be decrypted, the size of this block is dependent on the target key
        and the algorithm to be used. The DECRYPT operation applies to asymmetric and symmetric keys
        stored in Azure Key Vault since it uses the private portion of the key. This operation requires
        the keys/decrypt permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the decryption operation.
        :type parameters: ~azure.keyvault.v7_1.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyOperationResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.decrypt.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    decrypt.metadata = {'url': '/keys/{key-name}/{key-version}/decrypt'}  # type: ignore

    def sign(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeySignParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyOperationResult"
        """Creates a signature from a digest using the specified key.

        The SIGN operation is applicable to asymmetric and symmetric keys stored in Azure Key Vault
        since this operation uses the private portion of the key. This operation requires the keys/sign
        permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the signing operation.
        :type parameters: ~azure.keyvault.v7_1.models.KeySignParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyOperationResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.sign.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeySignParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    sign.metadata = {'url': '/keys/{key-name}/{key-version}/sign'}  # type: ignore

    def verify(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyVerifyParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyVerifyResult"
        """Verifies a signature using a specified key.

        The VERIFY operation is applicable to symmetric keys stored in Azure Key Vault. VERIFY is not
        strictly necessary for asymmetric keys stored in Azure Key Vault since signature verification
        can be performed using the public portion of the key but this operation is supported as a
        convenience for callers that only have a key-reference and not the public portion of the key.
        This operation requires the keys/verify permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for verify operations.
        :type parameters: ~azure.keyvault.v7_1.models.KeyVerifyParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyVerifyResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyVerifyResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyVerifyResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.verify.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyVerifyParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyVerifyResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    verify.metadata = {'url': '/keys/{key-name}/{key-version}/verify'}  # type: ignore

    def wrap_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyOperationResult"
        """Wraps a symmetric key using a specified key.

        The WRAP operation supports encryption of a symmetric key using a key encryption key that has
        previously been stored in an Azure Key Vault. The WRAP operation is only strictly necessary for
        symmetric keys stored in Azure Key Vault since protection with an asymmetric key can be
        performed using the public portion of the key. This operation is supported for asymmetric keys
        as a convenience for callers that have a key-reference but do not have access to the public key
        material. This operation requires the keys/wrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for wrap operation.
        :type parameters: ~azure.keyvault.v7_1.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyOperationResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.wrap_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    wrap_key.metadata = {'url': '/keys/{key-name}/{key-version}/wrapkey'}  # type: ignore

    def unwrap_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        key_version,  # type: str
        parameters,  # type: "models.KeyOperationsParameters"
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyOperationResult"
        """Unwraps a symmetric key using the specified key that was initially used for wrapping that key.

        The UNWRAP operation supports decryption of a symmetric key using the target key encryption
        key. This operation is the reverse of the WRAP operation. The UNWRAP operation applies to
        asymmetric and symmetric keys stored in Azure Key Vault since it uses the private portion of
        the key. This operation requires the keys/unwrapKey permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :param key_version: The version of the key.
        :type key_version: str
        :param parameters: The parameters for the key operation.
        :type parameters: ~azure.keyvault.v7_1.models.KeyOperationsParameters
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyOperationResult, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyOperationResult
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyOperationResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"
        content_type = kwargs.pop("content_type", "application/json")

        # Construct URL
        url = self.unwrap_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
            'key-version': self._serialize.url("key_version", key_version, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Content-Type'] = self._serialize.header("content_type", content_type, 'str')
        header_parameters['Accept'] = 'application/json'

        body_content_kwargs = {}  # type: Dict[str, Any]
        body_content = self._serialize.body(parameters, 'KeyOperationsParameters')
        body_content_kwargs['content'] = body_content
        request = self._client.post(url, query_parameters, header_parameters, **body_content_kwargs)

        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyOperationResult', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    unwrap_key.metadata = {'url': '/keys/{key-name}/{key-version}/unwrapkey'}  # type: ignore

    def get_deleted_keys(
        self,
        vault_base_url,  # type: str
        maxresults=None,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> Iterable["models.DeletedKeyListResult"]
        """Lists the deleted keys in the specified vault.

        Retrieves a list of the keys in the Key Vault as JSON Web Key structures that contain the
        public part of a deleted key. This operation includes deletion-specific information. The Get
        Deleted Keys operation is applicable for vaults enabled for soft-delete. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/list permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param maxresults: Maximum number of results to return in a page. If not specified the service
         will return up to 25 results.
        :type maxresults: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: An iterator like instance of either DeletedKeyListResult or the result of cls(response)
        :rtype: ~azure.core.paging.ItemPaged[~azure.keyvault.v7_1.models.DeletedKeyListResult]
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.DeletedKeyListResult"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        def prepare_request(next_link=None):
            # Construct headers
            header_parameters = {}  # type: Dict[str, Any]
            header_parameters['Accept'] = 'application/json'

            if not next_link:
                # Construct URL
                url = self.get_deleted_keys.metadata['url']  # type: ignore
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                # Construct parameters
                query_parameters = {}  # type: Dict[str, Any]
                if maxresults is not None:
                    query_parameters['maxresults'] = self._serialize.query("maxresults", maxresults, 'int', maximum=25, minimum=1)
                query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

                request = self._client.get(url, query_parameters, header_parameters)
            else:
                url = next_link
                query_parameters = {}  # type: Dict[str, Any]
                path_format_arguments = {
                    'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
                }
                url = self._client.format_url(url, **path_format_arguments)
                request = self._client.get(url, query_parameters, header_parameters)
            return request

        def extract_data(pipeline_response):
            deserialized = self._deserialize('DeletedKeyListResult', pipeline_response)
            list_of_elem = deserialized.value
            if cls:
                list_of_elem = cls(list_of_elem)
            return deserialized.next_link or None, iter(list_of_elem)

        def get_next(next_link=None):
            request = prepare_request(next_link)

            pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
            response = pipeline_response.http_response

            if response.status_code not in [200]:
                error = self._deserialize(models.KeyVaultError, response)
                map_error(status_code=response.status_code, response=response, error_map=error_map)
                raise HttpResponseError(response=response, model=error)

            return pipeline_response

        return ItemPaged(
            get_next, extract_data
        )
    get_deleted_keys.metadata = {'url': '/deletedkeys'}  # type: ignore

    def get_deleted_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.DeletedKeyBundle"
        """Gets the public part of a deleted key.

        The Get Deleted Key operation is applicable for soft-delete enabled vaults. While the operation
        can be invoked on any vault, it will return an error if invoked on a non soft-delete enabled
        vault. This operation requires the keys/get permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: DeletedKeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.DeletedKeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.DeletedKeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.get_deleted_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.get(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('DeletedKeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    get_deleted_key.metadata = {'url': '/deletedkeys/{key-name}'}  # type: ignore

    def purge_deleted_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        """Permanently deletes the specified key.

        The Purge Deleted Key operation is applicable for soft-delete enabled vaults. While the
        operation can be invoked on any vault, it will return an error if invoked on a non soft-delete
        enabled vault. This operation requires the keys/purge permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: None, or the result of cls(response)
        :rtype: None
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType[None]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.purge_deleted_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]

        request = self._client.delete(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [204]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        if cls:
            return cls(pipeline_response, None, {})

    purge_deleted_key.metadata = {'url': '/deletedkeys/{key-name}'}  # type: ignore

    def recover_deleted_key(
        self,
        vault_base_url,  # type: str
        key_name,  # type: str
        **kwargs  # type: Any
    ):
        # type: (...) -> "models.KeyBundle"
        """Recovers the deleted key to its latest version.

        The Recover Deleted Key operation is applicable for deleted keys in soft-delete enabled vaults.
        It recovers the deleted key back to its latest version under /keys. An attempt to recover an
        non-deleted key will return an error. Consider this the inverse of the delete operation on
        soft-delete enabled vaults. This operation requires the keys/recover permission.

        :param vault_base_url: The vault name, for example https://myvault.vault.azure.net.
        :type vault_base_url: str
        :param key_name: The name of the deleted key.
        :type key_name: str
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: KeyBundle, or the result of cls(response)
        :rtype: ~azure.keyvault.v7_1.models.KeyBundle
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["models.KeyBundle"]
        error_map = {404: ResourceNotFoundError, 409: ResourceExistsError}
        error_map.update(kwargs.pop('error_map', {}))
        api_version = "7.1"

        # Construct URL
        url = self.recover_deleted_key.metadata['url']  # type: ignore
        path_format_arguments = {
            'vaultBaseUrl': self._serialize.url("vault_base_url", vault_base_url, 'str', skip_quote=True),
            'key-name': self._serialize.url("key_name", key_name, 'str'),
        }
        url = self._client.format_url(url, **path_format_arguments)

        # Construct parameters
        query_parameters = {}  # type: Dict[str, Any]
        query_parameters['api-version'] = self._serialize.query("api_version", api_version, 'str')

        # Construct headers
        header_parameters = {}  # type: Dict[str, Any]
        header_parameters['Accept'] = 'application/json'

        request = self._client.post(url, query_parameters, header_parameters)
        pipeline_response = self._client._pipeline.run(request, stream=False, **kwargs)
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize(models.KeyVaultError, response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('KeyBundle', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized
    recover_deleted_key.metadata = {'url': '/deletedkeys/{key-name}/recover'}  # type: ignore
